/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.NewUiValue;
import com.intellij.ui.components.JBFontScaler;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UpdateScaleHelper;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBFont
extends Font {
    private final UpdateScaleHelper myScaleUpdateHelper;
    private final JBFontScaler myFontScaler;
    @NotNull
    private Font myScaledFont;

    JBFont(@NotNull Font font) {
        if (font == null) {
            JBFont.$$$reportNull$$$0(0);
        }
        super(font);
        this.myScaleUpdateHelper = new UpdateScaleHelper(false, (Function0<Float>)((Function0)() -> Float.valueOf(JBFont.labelFont().getSize2D())));
        this.myFontScaler = new JBFontScaler(font);
        this.myScaledFont = font;
    }

    @NotNull
    private Font getScaledFont() {
        this.refreshScaledFont();
        Font font = this.myScaledFont;
        if (font == null) {
            JBFont.$$$reportNull$$$0(1);
        }
        return font;
    }

    private void refreshScaledFont() {
        this.myScaleUpdateHelper.saveScaleAndRunIfChanged(() -> {
            this.myScaledFont = this.myFontScaler.scaledFont();
            this.size = this.myScaledFont.getSize();
            this.pointSize = this.myScaledFont.getSize2D();
        });
    }

    @Override
    public float getSize2D() {
        return this.getScaledFont().getSize2D();
    }

    @Override
    public int getSize() {
        return this.getScaledFont().getSize();
    }

    @Override
    public int hashCode() {
        return this.getScaledFont().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JBFont) {
            return this.getScaledFont().equals(((JBFont)obj).getScaledFont());
        }
        return super.equals(obj);
    }

    public static int labelFontSize() {
        return JBFont.labelFont().getSize();
    }

    @Nullable
    public static Float labelFontSize2D() {
        Font font = JBFont.labelFont();
        if (font != null) {
            return Float.valueOf(font.getSize2D());
        }
        return null;
    }

    private static Font labelFont() {
        return UIManager.getFont("Label.font");
    }

    @NotNull
    public static JBFont label() {
        return JBFont.create(JBFont.labelFont(), false);
    }

    @NotNull
    public static JBFont create(Font font) {
        return JBFont.create(font, true);
    }

    @NotNull
    public static JBFont create(@NotNull Font font, boolean tryToScale) {
        if (font == null) {
            JBFont.$$$reportNull$$$0(2);
        }
        if (font instanceof JBFont) {
            JBFont jBFont = (JBFont)font;
            if (jBFont == null) {
                JBFont.$$$reportNull$$$0(3);
            }
            return jBFont;
        }
        Font scaled = font;
        if (tryToScale) {
            scaled = font.deriveFont((float)font.getSize() * JBUIScale.scale(1.0f));
        }
        return new JBFont(scaled);
    }

    @NotNull
    public JBFont asBold() {
        JBFont jBFont = this.deriveFont(1, this.getSize());
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(4);
        }
        return jBFont;
    }

    @NotNull
    public JBFont asItalic() {
        JBFont jBFont = this.deriveFont(2, this.getSize());
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(5);
        }
        return jBFont;
    }

    @NotNull
    public JBFont asPlain() {
        JBFont jBFont = this.deriveFont(0, this.getSize());
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(6);
        }
        return jBFont;
    }

    @Override
    @NotNull
    public JBFont deriveFont(int style, float size) {
        this.refreshScaledFont();
        return JBFont.create(super.deriveFont(style, size), false);
    }

    @Override
    @NotNull
    public JBFont deriveFont(float size) {
        this.refreshScaledFont();
        JBFont jBFont = this.deriveFont(this.getStyle(), size);
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(7);
        }
        return jBFont;
    }

    @Override
    @NotNull
    public Font deriveFont(int style) {
        this.refreshScaledFont();
        return JBFont.create(super.deriveFont(style, this.pointSize), false);
    }

    @Override
    @NotNull
    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        this.refreshScaledFont();
        return JBFont.create(super.deriveFont(attributes).deriveFont(this.pointSize), false);
    }

    @Override
    @NotNull
    public Font deriveFont(AffineTransform trans) {
        this.refreshScaledFont();
        return JBFont.create(super.deriveFont(trans).deriveFont(this.pointSize), false);
    }

    @Override
    @NotNull
    public Font deriveFont(int style, AffineTransform trans) {
        this.refreshScaledFont();
        return JBFont.create(super.deriveFont(style, trans).deriveFont(this.pointSize), false);
    }

    @NotNull
    public JBFont biggerOn(float size) {
        JBFont jBFont = this.deriveFont((float)this.getSize() + JBUIScale.scale(size));
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(8);
        }
        return jBFont;
    }

    @NotNull
    public JBFont lessOn(float size) {
        JBFont jBFont = this.deriveFont((float)this.getSize() - JBUIScale.scale(size));
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(9);
        }
        return jBFont;
    }

    @NotNull
    public JBFont asUIResource() {
        if (this instanceof UIResource) {
            JBFont jBFont = this;
            if (jBFont == null) {
                JBFont.$$$reportNull$$$0(10);
            }
            return jBFont;
        }
        return new JBFontUIResource(this);
    }

    @NotNull
    public static JBFont h0() {
        JBFont jBFont = JBFont.label().biggerOn(12.0f).asBold();
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(11);
        }
        return jBFont;
    }

    @NotNull
    public static JBFont h1() {
        JBFont jBFont = JBFont.label().biggerOn(9.0f).asBold();
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(12);
        }
        return jBFont;
    }

    @NotNull
    public static JBFont h2() {
        JBFont jBFont = JBFont.label().biggerOn(5.0f);
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(13);
        }
        return jBFont;
    }

    @NotNull
    public static JBFont h3() {
        JBFont jBFont = JBFont.label().biggerOn(3.0f);
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(14);
        }
        return jBFont;
    }

    @NotNull
    public static JBFont h4() {
        JBFont jBFont = JBFont.label().biggerOn(1.0f).asBold();
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(15);
        }
        return jBFont;
    }

    @NotNull
    public static JBFont regular() {
        return JBFont.label();
    }

    @NotNull
    public static JBFont medium() {
        JBFont jBFont = JBFont.mediumAndSmallFontsAsRegular() ? JBFont.label() : JBFont.label().lessOn(1.0f);
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(16);
        }
        return jBFont;
    }

    @NotNull
    public static JBFont small() {
        JBFont jBFont = JBFont.mediumAndSmallFontsAsRegular() ? JBFont.label() : JBFont.label().lessOn(2.0f);
        if (jBFont == null) {
            JBFont.$$$reportNull$$$0(17);
        }
        return jBFont;
    }

    @ApiStatus.Internal
    @NotNull
    public static JBFont smallOrNewUiMedium() {
        return NewUiValue.isEnabled() ? JBFont.medium() : JBFont.small();
    }

    private static boolean mediumAndSmallFontsAsRegular() {
        return SystemInfo.isWindows && !NewUiValue.isEnabled();
    }

    public static float scaleFontSize(float fontSize, float scale) {
        if (scale == 1.0f) {
            return fontSize;
        }
        return Math.round(fontSize * scale);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBFont";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaledFont";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asBold";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asItalic";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asPlain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveFont";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "biggerOn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "lessOn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asUIResource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "h0";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "h1";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "h2";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "h3";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "h4";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "medium";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "small";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    static final class JBFontUIResource
    extends JBFont
    implements UIResource {
        JBFontUIResource(Font font) {
            super(font);
        }
    }
}

