/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import org.jetbrains.annotations.Nullable;

public enum UnixDesktopEnv {
    GNOME,
    KDE;

    @Nullable
    public static UnixDesktopEnv CURRENT;

    @Nullable
    private static UnixDesktopEnv getDesktop() {
        String desktop = System.getenv("XDG_CURRENT_DESKTOP");
        String gdmSession = System.getenv("GDMSESSION");
        if (desktop != null && desktop.contains("GNOME")) {
            return GNOME;
        }
        if (gdmSession != null && gdmSession.contains("gnome")) {
            return GNOME;
        }
        if (desktop != null && desktop.contains("KDE")) {
            return KDE;
        }
        if (System.getenv("KDE_FULL_SESSION") != null) {
            return KDE;
        }
        return null;
    }

    static {
        CURRENT = UnixDesktopEnv.getDesktop();
    }
}

