/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiNavigateUtil {
    public static void navigate(@Nullable PsiElement psiElement) {
        PsiNavigateUtil.navigate(psiElement, true);
    }

    public static void navigate(@Nullable PsiElement psiElement, boolean requestFocus) {
        Navigatable navigatable;
        if (psiElement != null && psiElement.isValid() && (navigatable = PsiNavigateUtil.getNavigatable(psiElement)) != null) {
            navigatable.navigate(requestFocus);
        }
    }

    @Nullable
    public static Navigatable getNavigatable(@NotNull PsiElement psiElement) {
        Navigatable navigatable;
        PsiElement navigationElement;
        if (psiElement == null) {
            PsiNavigateUtil.$$$reportNull$$$0(0);
        }
        int offset = (navigationElement = psiElement.getNavigationElement()) instanceof PsiFile ? -1 : navigationElement.getTextOffset();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)navigationElement);
        if (virtualFile != null && virtualFile.isValid()) {
            navigatable = PsiNavigationSupport.getInstance().createNavigatable(navigationElement.getProject(), virtualFile, offset);
        } else if (navigationElement instanceof Navigatable) {
            navigatable = (Navigatable)navigationElement;
        } else {
            return null;
        }
        return navigatable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/util/PsiNavigateUtil", "getNavigatable"));
    }
}

