/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.concurrency.ThreadContext;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaperKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsSystemEventIdProvider;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001FBi\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014JB\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00042\u001a\u0010)\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,\u0018\u00010+0*2\u0006\u0010-\u001a\u00020\u0007H\u0016J+\u0010.\u001a\u00020/2!\u00100\u001a\u001d\u0012\u0013\u0012\u001102\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00020/01H\u0016J:\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00042\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u0007H\u0016J4\u00107\u001a\u00020/2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u00042\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+H\u0002J\b\u0010=\u001a\u00020/H\u0002J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020/H\u0016J\b\u0010C\u001a\u00020/H\u0016J\b\u0010D\u001a\u00020/H\u0016J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020#0\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "Lcom/intellij/openapi/Disposable;", "recorderId", "", "sessionId", "headless", "", "build", "bucket", "recorderVersion", "writer", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "systemEventIdProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsSystemEventIdProvider;", "mergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "ideMode", "productMode", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;Lcom/intellij/internal/statistic/eventLog/StatisticsSystemEventIdProvider;Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;Ljava/lang/String;Ljava/lang/String;)V", "logExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getLogExecutor", "()Ljava/util/concurrent/ExecutorService;", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger$FusEvent;", "lastEventTime", "", "lastEventCreatedTime", "eventMergeTimeoutMs", "lastEventFlushFuture", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "escapeCharsInData", "logAsync", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "dataProvider", "Lkotlin/Function0;", "", "", "isState", "computeAsync", "", "computation", "Lkotlin/Function1;", "Ljava/util/concurrent/Executor;", "Lkotlin/ParameterName;", "name", "backgroundThreadExecutor", "data", "log", "event", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "createdTime", "rawEventId", "rawData", "logLastEvent", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "cleanup", "rollOver", "dispose", "flush", "FusEvent", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsFileEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsFileEventLogger.kt\ncom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public class StatisticsFileEventLogger
implements StatisticsEventLogger,
Disposable {
    @NotNull
    private final String recorderId;
    @NotNull
    private final String sessionId;
    private final boolean headless;
    @NotNull
    private final String build;
    @NotNull
    private final String bucket;
    @NotNull
    private final String recorderVersion;
    @NotNull
    private final StatisticsEventLogWriter writer;
    @NotNull
    private final StatisticsSystemEventIdProvider systemEventIdProvider;
    @NotNull
    private final StatisticsEventMergeStrategy mergeStrategy;
    @Nullable
    private final String ideMode;
    @Nullable
    private final String productMode;
    @NotNull
    private final ExecutorService logExecutor;
    @Nullable
    private FusEvent lastEvent;
    private long lastEventTime;
    private long lastEventCreatedTime;
    private final long eventMergeTimeoutMs;
    @Nullable
    private ScheduledFuture<CompletableFuture<Void>> lastEventFlushFuture;
    private final boolean escapeCharsInData;

    public StatisticsFileEventLogger(@NotNull String recorderId, @NotNull String sessionId, boolean headless, @NotNull String build, @NotNull String bucket, @NotNull String recorderVersion, @NotNull StatisticsEventLogWriter writer, @NotNull StatisticsSystemEventIdProvider systemEventIdProvider, @NotNull StatisticsEventMergeStrategy mergeStrategy, @Nullable String ideMode, @Nullable String productMode) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)systemEventIdProvider, (String)"systemEventIdProvider");
        Intrinsics.checkNotNullParameter((Object)mergeStrategy, (String)"mergeStrategy");
        this.recorderId = recorderId;
        this.sessionId = sessionId;
        this.headless = headless;
        this.build = build;
        this.bucket = bucket;
        this.recorderVersion = recorderVersion;
        this.writer = writer;
        this.systemEventIdProvider = systemEventIdProvider;
        this.mergeStrategy = mergeStrategy;
        this.ideMode = ideMode;
        this.productMode = productMode;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"StatisticsFileEventLogger", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.logExecutor = executorService;
        this.eventMergeTimeoutMs = StatisticsRecorderUtil.isTestModeEnabled(this.recorderId) ? 500L : 10000L;
        this.escapeCharsInData = StatisticsRecorderUtil.isCharsEscapingRequired(this.recorderId);
    }

    public /* synthetic */ StatisticsFileEventLogger(String string, String string2, boolean bl, String string3, String string4, String string5, StatisticsEventLogWriter statisticsEventLogWriter, StatisticsSystemEventIdProvider statisticsSystemEventIdProvider, StatisticsEventMergeStrategy statisticsEventMergeStrategy, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            statisticsEventMergeStrategy = new FilteredEventMergeStrategy(SetsKt.emptySet());
        }
        if ((n & 0x200) != 0) {
            string6 = null;
        }
        if ((n & 0x400) != 0) {
            string7 = null;
        }
        this(string, string2, bl, string3, string4, string5, statisticsEventLogWriter, statisticsSystemEventIdProvider, statisticsEventMergeStrategy, string6, string7);
    }

    @NotNull
    protected final ExecutorService getLogExecutor() {
        return this.logExecutor;
    }

    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Function0<? extends Map<String, ? extends Object>> dataProvider, boolean isState) {
        CompletableFuture<Void> completableFuture;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(dataProvider, (String)"dataProvider");
        long eventTime = System.currentTimeMillis();
        group.validateEventId$intellij_platform_statistics(eventId);
        try {
            completableFuture = CompletableFuture.runAsync(() -> StatisticsFileEventLogger.logAsync$lambda$0(this, dataProvider, eventTime, group, eventId, isState), this.logExecutor);
            Intrinsics.checkNotNull(completableFuture);
        }
        catch (RejectedExecutionException e) {
            CompletableFuture completableFuture2;
            CompletableFuture it = completableFuture2 = new CompletableFuture();
            boolean bl = false;
            it.completeExceptionally(e);
            completableFuture = completableFuture2;
        }
        return completableFuture;
    }

    @Override
    public void computeAsync(@NotNull Function1<? super Executor, Unit> computation) {
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        computation.invoke((Object)this.logExecutor);
    }

    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.logAsync(group, eventId, (Function0<? extends Map<String, ? extends Object>>)((Function0)() -> StatisticsFileEventLogger.logAsync$lambda$2(data)), isState);
    }

    /*
     * Unable to fully structure code
     */
    private final void log(LogEvent event, long createdTime, String rawEventId, Map<String, ? extends Object> rawData) {
        if (this.lastEvent == null || event.getTime() - this.lastEventTime > this.eventMergeTimeoutMs) ** GOTO lbl-1000
        v0 = this.lastEvent;
        Intrinsics.checkNotNull((Object)v0);
        if (this.mergeStrategy.shouldMerge(v0.getValidatedEvent(), event)) {
            this.lastEventTime = event.getTime();
            v1 = this.lastEvent;
            Intrinsics.checkNotNull((Object)v1);
            v1.getValidatedEvent().getEvent().increment();
        } else lbl-1000:
        // 2 sources

        {
            this.logLastEvent();
            this.lastEvent = StatisticsRecorderUtil.isTestModeEnabled(this.recorderId) != false ? new FusEvent(event, rawEventId, rawData) : new FusEvent(event, null, null);
            this.lastEventTime = event.getTime();
            this.lastEventCreatedTime = createdTime;
        }
        if (StatisticsRecorderUtil.isTestModeEnabled(this.recorderId)) {
            v2 = this.lastEventFlushFuture;
            if (v2 != null) {
                v2.cancel(false);
            }
            ThreadContext.resetThreadContext((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, log$lambda$0(com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger ), ()Lkotlin/Unit;)((StatisticsFileEventLogger)this));
        }
    }

    private final void logLastEvent() {
        FusEvent fusEvent = this.lastEvent;
        if (fusEvent != null) {
            String it;
            FusEvent it2 = fusEvent;
            boolean bl = false;
            LogEventAction event = it2.getValidatedEvent().getEvent();
            if (event.isEventGroup()) {
                event.getData().put("last", this.lastEventTime);
            }
            event.getData().put("created", this.lastEventCreatedTime);
            long systemEventId = this.systemEventIdProvider.getSystemEventId(this.recorderId);
            event.getData().put("system_event_id", systemEventId);
            this.systemEventIdProvider.setSystemEventId(this.recorderId, ++systemEventId);
            if (this.headless) {
                event.getData().put("system_headless", true);
            }
            String string = this.ideMode;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                event.getData().put("ide_mode", this.ideMode);
            }
            String string2 = this.productMode;
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                event.getData().put("product_mode", this.productMode);
            }
            Application application = ApplicationManager.getApplication();
            Character c = (Character)application.getUserData(StatisticsFileEventLoggerKt.getLICENSE_CODE_KEY());
            if (c != null) {
                char it3 = c.charValue();
                boolean bl4 = false;
                event.getData().put("auto_license_type", Character.valueOf(it3));
            }
            this.writer.log(it2.getValidatedEvent());
            ((EventLogListenersManager)application.getService(EventLogListenersManager.class)).notifySubscribers(this.recorderId, it2.getValidatedEvent(), it2.getRawEventId(), it2.getRawData(), false);
        }
        this.lastEvent = null;
    }

    @Override
    @Nullable
    public EventLogFile getActiveLogFile() {
        return this.writer.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.writer.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.writer.cleanup();
    }

    @Override
    public void rollOver() {
        this.writer.rollOver();
    }

    public void dispose() {
        ScheduledFuture<CompletableFuture<Void>> scheduledFuture = this.lastEventFlushFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.flush();
        this.logExecutor.shutdown();
        Disposer.dispose((Disposable)this.writer);
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> StatisticsFileEventLogger.flush$lambda$0(this), this.logExecutor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    private static final void logAsync$lambda$0(StatisticsFileEventLogger this$0, Function0 $dataProvider, long $eventTime, EventLogGroup $group, String $eventId, boolean $isState) {
        LogEvent logEvent;
        IntellijSensitiveDataValidator validator = IntellijSensitiveDataValidator.Companion.getInstance(this$0.recorderId);
        if (((Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(validator, $group, null){
            int label;
            final /* synthetic */ IntellijSensitiveDataValidator $validator;
            final /* synthetic */ EventLogGroup $group;
            {
                this.$validator = $validator;
                this.$group = $group;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$validator.isGroupAllowed(this.$group, (Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return Boxing.boxBoolean(((Boolean)object2 == false ? 1 : 0) != 0);
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Boxing.boxBoolean(((Boolean)object2 == false ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).booleanValue()) {
            return;
        }
        Map map = (Map)$dataProvider.invoke();
        if (map == null) {
            return;
        }
        Map data = map;
        LogEvent it = logEvent = new LogEvent(this$0.sessionId, this$0.build, this$0.bucket, $eventTime, new LogEventGroup($group.getId(), String.valueOf($group.getVersion())), this$0.recorderVersion, new LogEventAction($eventId, $isState, (Map)new HashMap(data), 0, 8, null));
        boolean bl = false;
        LogEvent logEvent2 = this$0.escapeCharsInData ? StatisticsEventEscaperKt.escape((LogEvent)it) : StatisticsEventEscaperKt.escapeExceptData((LogEvent)it);
        LogEvent event = logEvent;
        LogEvent validatedEvent = validator.validateEvent(event);
        if (validatedEvent != null) {
            this$0.log(validatedEvent, System.currentTimeMillis(), $eventId, data);
        }
    }

    private static final Map logAsync$lambda$2(Map $data) {
        return $data;
    }

    private static final Unit log$lambda$0(StatisticsFileEventLogger this$0) {
        this$0.lastEventFlushFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(this$0::flush, this$0.eventMergeTimeoutMs, TimeUnit.MILLISECONDS);
        return Unit.INSTANCE;
    }

    private static final void flush$lambda$0(StatisticsFileEventLogger this$0) {
        this$0.logLastEvent();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger$FusEvent;", "", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "", "rawData", "", "<init>", "(Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;Ljava/lang/String;Ljava/util/Map;)V", "getValidatedEvent", "()Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "getRawEventId", "()Ljava/lang/String;", "getRawData", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    private static final class FusEvent {
        @NotNull
        private final LogEvent validatedEvent;
        @Nullable
        private final String rawEventId;
        @Nullable
        private final Map<String, Object> rawData;

        public FusEvent(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
            this.validatedEvent = validatedEvent;
            this.rawEventId = rawEventId;
            this.rawData = rawData;
        }

        @NotNull
        public final LogEvent getValidatedEvent() {
            return this.validatedEvent;
        }

        @Nullable
        public final String getRawEventId() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> getRawData() {
            return this.rawData;
        }

        @NotNull
        public final LogEvent component1() {
            return this.validatedEvent;
        }

        @Nullable
        public final String component2() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> component3() {
            return this.rawData;
        }

        @NotNull
        public final FusEvent copy(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
            return new FusEvent(validatedEvent, rawEventId, rawData);
        }

        public static /* synthetic */ FusEvent copy$default(FusEvent fusEvent, LogEvent logEvent, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                logEvent = fusEvent.validatedEvent;
            }
            if ((n & 2) != 0) {
                string = fusEvent.rawEventId;
            }
            if ((n & 4) != 0) {
                map = fusEvent.rawData;
            }
            return fusEvent.copy(logEvent, string, map);
        }

        @NotNull
        public String toString() {
            return "FusEvent(validatedEvent=" + this.validatedEvent + ", rawEventId=" + this.rawEventId + ", rawData=" + this.rawData + ")";
        }

        public int hashCode() {
            int result = this.validatedEvent.hashCode();
            result = result * 31 + (this.rawEventId == null ? 0 : this.rawEventId.hashCode());
            result = result * 31 + (this.rawData == null ? 0 : ((Object)this.rawData).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FusEvent)) {
                return false;
            }
            FusEvent fusEvent = (FusEvent)other;
            if (!Intrinsics.areEqual((Object)this.validatedEvent, (Object)fusEvent.validatedEvent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rawEventId, (Object)fusEvent.rawEventId)) {
                return false;
            }
            return Intrinsics.areEqual(this.rawData, fusEvent.rawData);
        }
    }
}

