/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventIdName;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0016J\n\u0010\u0012\u001a\u00020\u0005H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventId;", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "description", "<init>", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;Ljava/lang/String;)V", "log", "", "project", "Lcom/intellij/openapi/project/Project;", "metric", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "toString", "intellij.platform.statistics"})
public final class EventId
extends BaseEventId {
    @NotNull
    private final EventLogGroup group;

    public EventId(@NotNull EventLogGroup group, @EventIdName @NonNls @NotNull String eventId, @NonNls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        super(group.getId(), eventId, group.getRecorder(), description);
        this.group = group;
    }

    public final void log() {
        if (this.group.getGroupData().isEmpty()) {
            this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> EventId.log$lambda$0(this, arg_0)));
        } else {
            FeatureUsageData data = new FeatureUsageData(this.group.getRecorder());
            this.extendFeatureUsageData(this.group, data);
            this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> EventId.log$lambda$1(this, data, arg_0)));
        }
    }

    public final void log(@Nullable Project project) {
        FeatureUsageData data = new FeatureUsageData(this.group.getRecorder());
        this.extendFeatureUsageData(this.group, data);
        this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> EventId.log$lambda$2(this, project, arg_0)));
    }

    @NotNull
    public final MetricEvent metric() {
        MetricEvent metricEvent;
        if (this.group.getGroupData().isEmpty()) {
            metricEvent = new MetricEvent(this.getEventId(), null, this.group.getRecorder());
        } else {
            FeatureUsageData data = new FeatureUsageData(this.group.getRecorder());
            this.extendFeatureUsageData(this.group, data);
            metricEvent = new MetricEvent(this.getEventId(), data, this.group.getRecorder());
        }
        return metricEvent;
    }

    @Override
    @NotNull
    public List<EventField<?>> getFields() {
        return this.extendEventFields(this.group, CollectionsKt.emptyList());
    }

    @NotNull
    public String toString() {
        return "EventId(eventId='" + this.getEventId() + "')";
    }

    private static final Unit log$lambda$0(EventId this$0, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), false);
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$1(EventId this$0, FeatureUsageData $data, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), $data.build(), false);
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$2(EventId this$0, Project $project, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), new FeatureUsageData(this$0.group.getRecorder()).addProject($project).build(), false);
        return Unit.INSTANCE;
    }
}

