/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SystemGetPropertyInspectionKt;
import com.intellij.jvm.analysis.quickFix.ReplaceCallableExpressionQuickFix;
import com.intellij.jvm.analysis.refactoring.CallChainReplacementInfo;
import com.intellij.jvm.analysis.refactoring.CallReplacementInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInspection/SystemGetPropertyInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "SystemGetPropertyVisitor", "intellij.jvm.analysis.impl"})
public final class SystemGetPropertyInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new SystemGetPropertyVisitor(holder), classArray, true);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInspection/SystemGetPropertyInspection$SystemGetPropertyVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "buildReplacementInfo", "Lcom/intellij/jvm/analysis/refactoring/CallChainReplacementInfo;", "keyProperty", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.jvm.analysis.impl"})
    private static final class SystemGetPropertyVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public SystemGetPropertyVisitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!SystemGetPropertyInspectionKt.access$getSYSTEM_GET_PROPERTY$p().uCallMatches(node)) {
                return true;
            }
            UExpression uExpression = node.getArgumentForParameter(0);
            Object[] objectArray = uExpression != null ? uExpression.evaluate() : null;
            String string = objectArray instanceof String ? (String)objectArray : null;
            if (string == null) {
                return true;
            }
            String propertyValue = string;
            objectArray = new Object[]{propertyValue};
            String message = JvmAnalysisBundle.message("jvm.inspections.system.get.property.problem.descriptor", objectArray);
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null || (psiElement = psiElement.getResolveScope()) == null) {
                return true;
            }
            PsiElement scope = psiElement;
            Project project = this.holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            CallChainReplacementInfo callChainReplacementInfo = this.buildReplacementInfo(propertyValue, project, (GlobalSearchScope)scope);
            if (callChainReplacementInfo == null) {
                return true;
            }
            CallChainReplacementInfo qualifiedReference = callChainReplacementInfo;
            Intrinsics.checkNotNull((Object)message);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceCallableExpressionQuickFix(qualifiedReference)};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)node, (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
            return true;
        }

        private final CallChainReplacementInfo buildReplacementInfo(String keyProperty, Project project, GlobalSearchScope scope) {
            return switch (keyProperty) {
                case "file.separator" -> {
                    CallReplacementInfo[] var5_5 = new CallReplacementInfo[]{new CallReplacementInfo("getDefault", (PsiType)PsiType.getTypeByName((String)"java.nio.file.FileSystem", (Project)project, (GlobalSearchScope)scope), new UExpression[0]), new CallReplacementInfo("getSeparator", (PsiType)PsiType.getTypeByName((String)"java.lang.String", (Project)project, (GlobalSearchScope)scope), new UExpression[0])};
                    CallChainReplacementInfo v0 = new CallChainReplacementInfo("java.nio.file.FileSystems", var5_5);
                    yield v0;
                }
                case "path.separator" -> new CallChainReplacementInfo("java.io.File.pathSeparator", new CallReplacementInfo[0]);
                case "line.separator" -> {
                    CallReplacementInfo[] var5_6 = new CallReplacementInfo[]{new CallReplacementInfo("lineSeparator", (PsiType)PsiType.getTypeByName((String)"java.lang.String", (Project)project, (GlobalSearchScope)scope), new UExpression[0])};
                    CallChainReplacementInfo v2 = new CallChainReplacementInfo("java.lang.System", var5_6);
                    yield v2;
                }
                case "file.encoding" -> {
                    CallReplacementInfo[] var5_7 = new CallReplacementInfo[]{new CallReplacementInfo("defaultCharset", (PsiType)PsiType.getTypeByName((String)"java.nio.charset.Charset", (Project)project, (GlobalSearchScope)scope), new UExpression[0]), new CallReplacementInfo("displayName", (PsiType)PsiType.getTypeByName((String)"java.lang.String", (Project)project, (GlobalSearchScope)scope), new UExpression[0])};
                    CallChainReplacementInfo v3 = new CallChainReplacementInfo("java.nio.charset.Charset", var5_7);
                    yield v3;
                }
                default -> null;
            };
        }
    }
}

