/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperEventLogNotification;", "", "<init>", "()V", "Companion", "intellij.maven"})
public final class MavenWrapperEventLogNotification {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void noDistributionUrlEvent(@NotNull Project project, @NotNull String multiModuleDir) {
        Companion.noDistributionUrlEvent(project, multiModuleDir);
    }

    @JvmStatic
    public static final void informationEvent(@NotNull Project project, @Nls @NotNull String content) {
        Companion.informationEvent(project, content);
    }

    @JvmStatic
    public static final void errorDownloading(@NotNull Project project, @NotNull String error) {
        Companion.errorDownloading(project, error);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u000b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperEventLogNotification$Companion;", "", "<init>", "()V", "noDistributionUrlEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "multiModuleDir", "", "informationEvent", "content", "errorDownloading", "error", "wrapperPropertyFileNotFound", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "distributionUrlEmpty", "wrapperPropertyFile", "Ljava/nio/file/Path;", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenWrapperEventLogNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWrapperEventLogNotification.kt\norg/jetbrains/idea/maven/server/MavenWrapperEventLogNotification$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void noDistributionUrlEvent(@NotNull Project project, @NotNull String multiModuleDir) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)multiModuleDir, (String)"multiModuleDir");
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Maven");
            if (notificationGroup == null) {
                return;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            ApplicationManager.getApplication().invokeLater(() -> Companion.noDistributionUrlEvent$lambda$0(multiModuleDir, notificationGroup2, project));
        }

        @JvmStatic
        public final void informationEvent(@NotNull Project project, @Nls @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Maven");
            if (notificationGroup == null) {
                return;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            ApplicationManager.getApplication().invokeLater(() -> Companion.informationEvent$lambda$0(notificationGroup2, content, project));
        }

        @JvmStatic
        public final void errorDownloading(@NotNull Project project, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Maven");
            if (notificationGroup == null) {
                return;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            ApplicationManager.getApplication().invokeLater(() -> Companion.errorDownloading$lambda$0(notificationGroup2, error, project));
        }

        private final void wrapperPropertyFileNotFound(NotificationGroup notificationGroup, Project project) {
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = SyncBundle.message("maven.wrapper.notification.empty.url.content.file.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).setDisplayId("maven.wrapper.file.not.found.notification").addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.empty.url.action.disable", new Object[0]), () -> Companion.wrapperPropertyFileNotFound$lambda$0(project))).notify(project);
        }

        private final void distributionUrlEmpty(NotificationGroup notificationGroup, Project project, Path wrapperPropertyFile) {
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = SyncBundle.message("maven.wrapper.notification.empty.url.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).setDisplayId("maven.wrapper.empty.url.notification").addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.empty.url.action.check", new Object[0]), () -> Companion.distributionUrlEmpty$lambda$0(project, wrapperPropertyFile))).addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.empty.url.action.disable", new Object[0]), () -> Companion.distributionUrlEmpty$lambda$1(project))).notify(project);
        }

        private static final void noDistributionUrlEvent$lambda$0(String $multiModuleDir, NotificationGroup $notificationGroup, Project $project) {
            Path wrapperPropertyFile;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath($multiModuleDir);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                v1 = MavenWrapperSupport.Companion.getWrapperProperties(it.toNioPath());
            } else {
                v1 = wrapperPropertyFile = null;
            }
            if (wrapperPropertyFile == null) {
                Companion.wrapperPropertyFileNotFound($notificationGroup, $project);
            } else {
                Companion.distributionUrlEmpty($notificationGroup, $project, wrapperPropertyFile);
            }
        }

        private static final void informationEvent$lambda$0(NotificationGroup $notificationGroup, String $content, Project $project) {
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $notificationGroup.createNotification(string, $content, NotificationType.INFORMATION).setDisplayId("maven.wrapper.information.notification").notify($project);
        }

        private static final void errorDownloading$lambda$0$0(Project $project) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }

        private static final void errorDownloading$lambda$0(NotificationGroup $notificationGroup, String $error, Project $project) {
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{$error};
            String string2 = SyncBundle.message("maven.wrapper.notification.downloading.error.content", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $notificationGroup.createNotification(string, string2, NotificationType.ERROR).setDisplayId("maven.wrapper.downloading.error.notification").addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.downloading.error.action", new Object[0]), () -> Companion.errorDownloading$lambda$0$0($project))).notify($project);
        }

        private static final void wrapperPropertyFileNotFound$lambda$0(Project $project) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }

        private static final void distributionUrlEmpty$lambda$0(Project $project, Path $wrapperPropertyFile) {
            OpenFileQuickFix.Companion.showFile($project, $wrapperPropertyFile, null);
        }

        private static final void distributionUrlEmpty$lambda$1(Project $project) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

