/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.vcs.FileStatus;
import java.io.File;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.jetbrains.idea.svn.status.StatusType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u0000 M2\u00020\u0001:\u0002LMB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010G\u001a\u00020\u00132\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0I\"\u00020-\u00a2\u0006\u0002\u0010JJ\u001f\u0010K\u001a\u00020\u00132\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0I\"\u00020-\u00a2\u0006\u0002\u0010JR\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u0004\u0018\u00010\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u0013\u00102\u001a\u0004\u0018\u00010-\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0013\u00104\u001a\u0004\u0018\u00010-\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010/R\u0011\u00106\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00107R\u0013\u00109\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010'R\u0011\u0010;\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00107R\u0013\u0010<\u001a\u0004\u0018\u00010=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0013\u0010@\u001a\u0004\u0018\u00010=\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010?R\u0013\u0010B\u001a\u0004\u0018\u00010C\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u00107\u00a8\u0006N"}, d2={"Lorg/jetbrains/idea/svn/status/Status;", "Lorg/jetbrains/idea/svn/api/BaseNodeDescription;", "builder", "Lorg/jetbrains/idea/svn/status/Status$Builder;", "<init>", "(Lorg/jetbrains/idea/svn/status/Status$Builder;)V", "infoProvider", "Ljava/util/function/Supplier;", "Lorg/jetbrains/idea/svn/info/Info;", "info", "getInfo", "()Lorg/jetbrains/idea/svn/info/Info;", "info$delegate", "Lkotlin/Lazy;", "url", "Lorg/jetbrains/idea/svn/api/Url;", "getUrl", "()Lorg/jetbrains/idea/svn/api/Url;", "fileExists", "", "nodeKind", "Lorg/jetbrains/idea/svn/api/NodeKind;", "getNodeKind", "()Lorg/jetbrains/idea/svn/api/NodeKind;", "revision", "Lorg/jetbrains/idea/svn/api/Revision;", "getRevision", "()Lorg/jetbrains/idea/svn/api/Revision;", "copyFromUrl", "getCopyFromUrl", "treeConflict", "Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription;", "getTreeConflict", "()Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription;", "repositoryRootUrl", "getRepositoryRootUrl", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "commitInfo", "Lorg/jetbrains/idea/svn/checkin/CommitInfo;", "getCommitInfo", "()Lorg/jetbrains/idea/svn/checkin/CommitInfo;", "itemStatus", "Lorg/jetbrains/idea/svn/status/StatusType;", "getItemStatus", "()Lorg/jetbrains/idea/svn/status/StatusType;", "propertyStatus", "getPropertyStatus", "remoteItemStatus", "getRemoteItemStatus", "remotePropertyStatus", "getRemotePropertyStatus", "isWorkingCopyLocked", "()Z", "isCopied", "movedFrom", "getMovedFrom", "isSwitched", "remoteLock", "Lorg/jetbrains/idea/svn/lock/Lock;", "getRemoteLock", "()Lorg/jetbrains/idea/svn/lock/Lock;", "localLock", "getLocalLock", "changeListName", "", "getChangeListName", "()Ljava/lang/String;", "isTreeConflicted", "is", "types", "", "([Lorg/jetbrains/idea/svn/status/StatusType;)Z", "isProperty", "Builder", "Companion", "intellij.vcs.svn"})
public final class Status
extends BaseNodeDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<Info> infoProvider;
    @NotNull
    private final Lazy info$delegate;
    @Nullable
    private final Url url;
    private final boolean fileExists;
    @NotNull
    private final Revision revision;
    @NotNull
    private final File file;
    @NotNull
    private final CommitInfo commitInfo;
    @NotNull
    private final StatusType itemStatus;
    @NotNull
    private final StatusType propertyStatus;
    @Nullable
    private final StatusType remoteItemStatus;
    @Nullable
    private final StatusType remotePropertyStatus;
    private final boolean isWorkingCopyLocked;
    private final boolean isCopied;
    @Nullable
    private final File movedFrom;
    private final boolean isSwitched;
    @Nullable
    private final Lock remoteLock;
    @Nullable
    private final Lock localLock;
    @Nullable
    private final String changeListName;
    private final boolean isTreeConflicted;

    private Status(Builder builder) {
        super(builder.getNodeKind());
        this.infoProvider = builder.getInfoProvider();
        this.info$delegate = LazyKt.lazy(() -> Status.info_delegate$lambda$0(this));
        this.url = builder.getUrl();
        this.fileExists = builder.getFileExists();
        this.revision = builder.getRevision();
        this.file = builder.getFile();
        Object object = builder.getCommitInfo();
        if (object == null || (object = ((CommitInfo.Builder)object).build()) == null) {
            CommitInfo commitInfo = CommitInfo.EMPTY;
            object = commitInfo;
            Intrinsics.checkNotNullExpressionValue((Object)commitInfo, (String)"EMPTY");
        }
        this.commitInfo = object;
        this.itemStatus = builder.getItemStatus();
        this.propertyStatus = builder.getPropertyStatus();
        this.remoteItemStatus = builder.getRemoteItemStatus();
        this.remotePropertyStatus = builder.getRemotePropertyStatus();
        this.isWorkingCopyLocked = builder.isWorkingCopyLocked();
        this.isCopied = builder.isCopied();
        this.movedFrom = builder.getMovedFrom();
        this.isSwitched = builder.isSwitched();
        Lock.Builder builder2 = builder.getRemoteLock();
        this.remoteLock = builder2 != null ? builder2.build() : null;
        Lock.Builder builder3 = builder.getLocalLock();
        this.localLock = builder3 != null ? builder3.build() : null;
        this.changeListName = builder.getChangeListName();
        this.isTreeConflicted = builder.isTreeConflicted();
    }

    @Nullable
    public final Info getInfo() {
        Lazy lazy = this.info$delegate;
        return (Info)lazy.getValue();
    }

    @Nullable
    public final Url getUrl() {
        Url url = this.url;
        if (url == null) {
            Info info = this.getInfo();
            url = info != null ? info.getUrl() : null;
        }
        return url;
    }

    @Override
    @NotNull
    public NodeKind getNodeKind() {
        Object object;
        if (this.fileExists) {
            object = super.getNodeKind();
        } else {
            object = this.getInfo();
            if (object == null || (object = ((BaseNodeDescription)object).getNodeKind()) == null) {
                object = super.getNodeKind();
            }
        }
        return object;
    }

    @NotNull
    public final Revision getRevision() {
        Object object;
        StatusType[] statusTypeArray;
        if (this.revision.isValid() || this.is(statusTypeArray = new StatusType[]{StatusType.STATUS_NONE, StatusType.STATUS_UNVERSIONED, StatusType.STATUS_ADDED})) {
            object = this.revision;
        } else {
            object = this.getInfo();
            if (object == null || (object = ((Info)object).getRevision()) == null) {
                object = this.revision;
            }
        }
        return object;
    }

    @Nullable
    public final Url getCopyFromUrl() {
        Url url;
        if (this.isCopied) {
            Info info = this.getInfo();
            url = info != null ? info.getCopyFromUrl() : null;
        } else {
            url = null;
        }
        return url;
    }

    @Nullable
    public final TreeConflictDescription getTreeConflict() {
        TreeConflictDescription treeConflictDescription;
        if (this.isTreeConflicted) {
            Info info = this.getInfo();
            treeConflictDescription = info != null ? info.getTreeConflict() : null;
        } else {
            treeConflictDescription = null;
        }
        return treeConflictDescription;
    }

    @Nullable
    public final Url getRepositoryRootUrl() {
        Info info = this.getInfo();
        return info != null ? info.getRepositoryRootUrl() : null;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final CommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    @NotNull
    public final StatusType getItemStatus() {
        return this.itemStatus;
    }

    @NotNull
    public final StatusType getPropertyStatus() {
        return this.propertyStatus;
    }

    @Nullable
    public final StatusType getRemoteItemStatus() {
        return this.remoteItemStatus;
    }

    @Nullable
    public final StatusType getRemotePropertyStatus() {
        return this.remotePropertyStatus;
    }

    public final boolean isWorkingCopyLocked() {
        return this.isWorkingCopyLocked;
    }

    public final boolean isCopied() {
        return this.isCopied;
    }

    @Nullable
    public final File getMovedFrom() {
        return this.movedFrom;
    }

    public final boolean isSwitched() {
        return this.isSwitched;
    }

    @Nullable
    public final Lock getRemoteLock() {
        return this.remoteLock;
    }

    @Nullable
    public final Lock getLocalLock() {
        return this.localLock;
    }

    @Nullable
    public final String getChangeListName() {
        return this.changeListName;
    }

    public final boolean isTreeConflicted() {
        return this.isTreeConflicted;
    }

    public final boolean is(StatusType ... types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        return ArraysKt.contains((Object[])types, (Object)((Object)this.itemStatus));
    }

    public final boolean isProperty(StatusType ... types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        return ArraysKt.contains((Object[])types, (Object)((Object)this.propertyStatus));
    }

    private static final Info info_delegate$lambda$0(Status this$0) {
        return this$0.itemStatus != StatusType.STATUS_NONE ? this$0.infoProvider.get() : null;
    }

    @JvmStatic
    @NotNull
    public static final FileStatus convertStatus(@NotNull Status status) {
        return Companion.convertStatus(status);
    }

    @JvmStatic
    @NotNull
    public static final FileStatus convertStatus(@Nullable StatusType itemStatus, @Nullable StatusType propertyStatus, boolean isSwitched, boolean isCopied) {
        return Companion.convertStatus(itemStatus, propertyStatus, isSwitched, isCopied);
    }

    @JvmStatic
    @NotNull
    public static final FileStatus convertPropertyStatus(@Nullable StatusType status) {
        return Companion.convertPropertyStatus(status);
    }

    public /* synthetic */ Status(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010W\u001a\u00020XR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\"\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u001c\u00107\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00101\"\u0004\b9\u00103R\u001c\u0010:\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00101\"\u0004\b<\u00103R\u001a\u0010=\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0019\"\u0004\b>\u0010\u001bR\u001a\u0010?\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0019\"\u0004\b@\u0010\u001bR\u001c\u0010A\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0007\"\u0004\bC\u0010\u0005R\u001a\u0010D\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0019\"\u0004\bE\u0010\u001bR\u001c\u0010F\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001c\u0010L\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010I\"\u0004\bN\u0010KR\u001c\u0010O\u001a\u0004\u0018\u00010PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001a\u0010U\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010\u0019\"\u0004\bV\u0010\u001b\u00a8\u0006Y"}, d2={"Lorg/jetbrains/idea/svn/status/Status$Builder;", "", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "setFile", "infoProvider", "Ljava/util/function/Supplier;", "Lorg/jetbrains/idea/svn/info/Info;", "getInfoProvider", "()Ljava/util/function/Supplier;", "setInfoProvider", "(Ljava/util/function/Supplier;)V", "url", "Lorg/jetbrains/idea/svn/api/Url;", "getUrl", "()Lorg/jetbrains/idea/svn/api/Url;", "setUrl", "(Lorg/jetbrains/idea/svn/api/Url;)V", "fileExists", "", "getFileExists", "()Z", "setFileExists", "(Z)V", "nodeKind", "Lorg/jetbrains/idea/svn/api/NodeKind;", "getNodeKind", "()Lorg/jetbrains/idea/svn/api/NodeKind;", "setNodeKind", "(Lorg/jetbrains/idea/svn/api/NodeKind;)V", "revision", "Lorg/jetbrains/idea/svn/api/Revision;", "getRevision", "()Lorg/jetbrains/idea/svn/api/Revision;", "setRevision", "(Lorg/jetbrains/idea/svn/api/Revision;)V", "commitInfo", "Lorg/jetbrains/idea/svn/checkin/CommitInfo$Builder;", "getCommitInfo", "()Lorg/jetbrains/idea/svn/checkin/CommitInfo$Builder;", "setCommitInfo", "(Lorg/jetbrains/idea/svn/checkin/CommitInfo$Builder;)V", "itemStatus", "Lorg/jetbrains/idea/svn/status/StatusType;", "getItemStatus", "()Lorg/jetbrains/idea/svn/status/StatusType;", "setItemStatus", "(Lorg/jetbrains/idea/svn/status/StatusType;)V", "propertyStatus", "getPropertyStatus", "setPropertyStatus", "remoteItemStatus", "getRemoteItemStatus", "setRemoteItemStatus", "remotePropertyStatus", "getRemotePropertyStatus", "setRemotePropertyStatus", "isWorkingCopyLocked", "setWorkingCopyLocked", "isCopied", "setCopied", "movedFrom", "getMovedFrom", "setMovedFrom", "isSwitched", "setSwitched", "remoteLock", "Lorg/jetbrains/idea/svn/lock/Lock$Builder;", "getRemoteLock", "()Lorg/jetbrains/idea/svn/lock/Lock$Builder;", "setRemoteLock", "(Lorg/jetbrains/idea/svn/lock/Lock$Builder;)V", "localLock", "getLocalLock", "setLocalLock", "changeListName", "", "getChangeListName", "()Ljava/lang/String;", "setChangeListName", "(Ljava/lang/String;)V", "isTreeConflicted", "setTreeConflicted", "build", "Lorg/jetbrains/idea/svn/status/Status;", "intellij.vcs.svn"})
    public static final class Builder {
        @NotNull
        private File file;
        @NotNull
        private Supplier<Info> infoProvider;
        @Nullable
        private Url url;
        private boolean fileExists;
        @NotNull
        private NodeKind nodeKind;
        @NotNull
        private Revision revision;
        @Nullable
        private CommitInfo.Builder commitInfo;
        @NotNull
        private StatusType itemStatus;
        @NotNull
        private StatusType propertyStatus;
        @Nullable
        private StatusType remoteItemStatus;
        @Nullable
        private StatusType remotePropertyStatus;
        private boolean isWorkingCopyLocked;
        private boolean isCopied;
        @Nullable
        private File movedFrom;
        private boolean isSwitched;
        @Nullable
        private Lock.Builder remoteLock;
        @Nullable
        private Lock.Builder localLock;
        @Nullable
        private String changeListName;
        private boolean isTreeConflicted;

        public Builder(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.infoProvider = Builder::infoProvider$lambda$0;
            this.nodeKind = NodeKind.UNKNOWN;
            this.revision = Revision.UNDEFINED;
            this.itemStatus = StatusType.STATUS_NONE;
            this.propertyStatus = StatusType.STATUS_NONE;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final void setFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
            this.file = file;
        }

        @NotNull
        public final Supplier<Info> getInfoProvider() {
            return this.infoProvider;
        }

        public final void setInfoProvider(@NotNull Supplier<Info> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
            this.infoProvider = supplier;
        }

        @Nullable
        public final Url getUrl() {
            return this.url;
        }

        public final void setUrl(@Nullable Url url) {
            this.url = url;
        }

        public final boolean getFileExists() {
            return this.fileExists;
        }

        public final void setFileExists(boolean bl) {
            this.fileExists = bl;
        }

        @NotNull
        public final NodeKind getNodeKind() {
            return this.nodeKind;
        }

        public final void setNodeKind(@NotNull NodeKind nodeKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)nodeKind), (String)"<set-?>");
            this.nodeKind = nodeKind;
        }

        @NotNull
        public final Revision getRevision() {
            return this.revision;
        }

        public final void setRevision(@NotNull Revision revision) {
            Intrinsics.checkNotNullParameter((Object)revision, (String)"<set-?>");
            this.revision = revision;
        }

        @Nullable
        public final CommitInfo.Builder getCommitInfo() {
            return this.commitInfo;
        }

        public final void setCommitInfo(@Nullable CommitInfo.Builder builder) {
            this.commitInfo = builder;
        }

        @NotNull
        public final StatusType getItemStatus() {
            return this.itemStatus;
        }

        public final void setItemStatus(@NotNull StatusType statusType) {
            Intrinsics.checkNotNullParameter((Object)((Object)statusType), (String)"<set-?>");
            this.itemStatus = statusType;
        }

        @NotNull
        public final StatusType getPropertyStatus() {
            return this.propertyStatus;
        }

        public final void setPropertyStatus(@NotNull StatusType statusType) {
            Intrinsics.checkNotNullParameter((Object)((Object)statusType), (String)"<set-?>");
            this.propertyStatus = statusType;
        }

        @Nullable
        public final StatusType getRemoteItemStatus() {
            return this.remoteItemStatus;
        }

        public final void setRemoteItemStatus(@Nullable StatusType statusType) {
            this.remoteItemStatus = statusType;
        }

        @Nullable
        public final StatusType getRemotePropertyStatus() {
            return this.remotePropertyStatus;
        }

        public final void setRemotePropertyStatus(@Nullable StatusType statusType) {
            this.remotePropertyStatus = statusType;
        }

        public final boolean isWorkingCopyLocked() {
            return this.isWorkingCopyLocked;
        }

        public final void setWorkingCopyLocked(boolean bl) {
            this.isWorkingCopyLocked = bl;
        }

        public final boolean isCopied() {
            return this.isCopied;
        }

        public final void setCopied(boolean bl) {
            this.isCopied = bl;
        }

        @Nullable
        public final File getMovedFrom() {
            return this.movedFrom;
        }

        public final void setMovedFrom(@Nullable File file) {
            this.movedFrom = file;
        }

        public final boolean isSwitched() {
            return this.isSwitched;
        }

        public final void setSwitched(boolean bl) {
            this.isSwitched = bl;
        }

        @Nullable
        public final Lock.Builder getRemoteLock() {
            return this.remoteLock;
        }

        public final void setRemoteLock(@Nullable Lock.Builder builder) {
            this.remoteLock = builder;
        }

        @Nullable
        public final Lock.Builder getLocalLock() {
            return this.localLock;
        }

        public final void setLocalLock(@Nullable Lock.Builder builder) {
            this.localLock = builder;
        }

        @Nullable
        public final String getChangeListName() {
            return this.changeListName;
        }

        public final void setChangeListName(@Nullable String string) {
            this.changeListName = string;
        }

        public final boolean isTreeConflicted() {
            return this.isTreeConflicted;
        }

        public final void setTreeConflicted(boolean bl) {
            this.isTreeConflicted = bl;
        }

        @NotNull
        public final Status build() {
            return new Status(this, null);
        }

        private static final Info infoProvider$lambda$0() {
            return null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/svn/status/Status$Companion;", "", "<init>", "()V", "convertStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "status", "Lorg/jetbrains/idea/svn/status/Status;", "itemStatus", "Lorg/jetbrains/idea/svn/status/StatusType;", "propertyStatus", "isSwitched", "", "isCopied", "convertPropertyStatus", "intellij.vcs.svn"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FileStatus convertStatus(@NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return this.convertStatus(status.getItemStatus(), status.getPropertyStatus(), status.isSwitched(), status.isCopied());
        }

        @JvmStatic
        @NotNull
        public final FileStatus convertStatus(@Nullable StatusType itemStatus, @Nullable StatusType propertyStatus, boolean isSwitched, boolean isCopied) {
            FileStatus fileStatus;
            if (itemStatus == null) {
                FileStatus fileStatus2 = FileStatus.UNKNOWN;
                fileStatus = fileStatus2;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"UNKNOWN");
            } else if (StatusType.STATUS_UNVERSIONED == itemStatus) {
                FileStatus fileStatus3 = FileStatus.UNKNOWN;
                fileStatus = fileStatus3;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus3, (String)"UNKNOWN");
            } else if (StatusType.STATUS_MISSING == itemStatus) {
                FileStatus fileStatus4 = FileStatus.DELETED_FROM_FS;
                fileStatus = fileStatus4;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus4, (String)"DELETED_FROM_FS");
            } else if (StatusType.STATUS_EXTERNAL == itemStatus) {
                FileStatus fileStatus5 = SvnFileStatus.EXTERNAL;
                fileStatus = fileStatus5;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus5, (String)"EXTERNAL");
            } else if (StatusType.STATUS_OBSTRUCTED == itemStatus) {
                FileStatus fileStatus6 = SvnFileStatus.OBSTRUCTED;
                fileStatus = fileStatus6;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus6, (String)"OBSTRUCTED");
            } else if (StatusType.STATUS_IGNORED == itemStatus) {
                FileStatus fileStatus7 = FileStatus.IGNORED;
                fileStatus = fileStatus7;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus7, (String)"IGNORED");
            } else if (StatusType.STATUS_ADDED == itemStatus) {
                FileStatus fileStatus8 = FileStatus.ADDED;
                fileStatus = fileStatus8;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus8, (String)"ADDED");
            } else if (StatusType.STATUS_DELETED == itemStatus) {
                FileStatus fileStatus9 = FileStatus.DELETED;
                fileStatus = fileStatus9;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus9, (String)"DELETED");
            } else if (StatusType.STATUS_REPLACED == itemStatus) {
                FileStatus fileStatus10 = SvnFileStatus.REPLACED;
                fileStatus = fileStatus10;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus10, (String)"REPLACED");
            } else if (StatusType.STATUS_CONFLICTED == itemStatus || StatusType.STATUS_CONFLICTED == propertyStatus) {
                FileStatus fileStatus11 = StatusType.STATUS_CONFLICTED == itemStatus && StatusType.STATUS_CONFLICTED == propertyStatus ? FileStatus.MERGED_WITH_BOTH_CONFLICTS : (StatusType.STATUS_CONFLICTED == itemStatus ? FileStatus.MERGED_WITH_CONFLICTS : FileStatus.MERGED_WITH_PROPERTY_CONFLICTS);
                Intrinsics.checkNotNull((Object)fileStatus11);
                fileStatus = fileStatus11;
            } else if (StatusType.STATUS_MODIFIED == itemStatus || StatusType.STATUS_MODIFIED == propertyStatus) {
                FileStatus fileStatus12 = FileStatus.MODIFIED;
                fileStatus = fileStatus12;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus12, (String)"MODIFIED");
            } else if (isSwitched) {
                FileStatus fileStatus13 = FileStatus.SWITCHED;
                fileStatus = fileStatus13;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus13, (String)"SWITCHED");
            } else if (isCopied) {
                FileStatus fileStatus14 = FileStatus.ADDED;
                fileStatus = fileStatus14;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus14, (String)"ADDED");
            } else {
                FileStatus fileStatus15 = FileStatus.NOT_CHANGED;
                fileStatus = fileStatus15;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus15, (String)"NOT_CHANGED");
            }
            return fileStatus;
        }

        @JvmStatic
        @NotNull
        public final FileStatus convertPropertyStatus(@Nullable StatusType status) {
            FileStatus fileStatus;
            StatusType statusType = status;
            switch (statusType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusType.ordinal()]) {
                case -1: {
                    FileStatus fileStatus2 = FileStatus.UNKNOWN;
                    fileStatus = fileStatus2;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"UNKNOWN");
                    break;
                }
                case 1: {
                    FileStatus fileStatus3 = FileStatus.UNKNOWN;
                    fileStatus = fileStatus3;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus3, (String)"UNKNOWN");
                    break;
                }
                case 2: {
                    FileStatus fileStatus4 = FileStatus.DELETED_FROM_FS;
                    fileStatus = fileStatus4;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus4, (String)"DELETED_FROM_FS");
                    break;
                }
                case 3: {
                    FileStatus fileStatus5 = SvnFileStatus.EXTERNAL;
                    fileStatus = fileStatus5;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus5, (String)"EXTERNAL");
                    break;
                }
                case 4: {
                    FileStatus fileStatus6 = SvnFileStatus.OBSTRUCTED;
                    fileStatus = fileStatus6;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus6, (String)"OBSTRUCTED");
                    break;
                }
                case 5: {
                    FileStatus fileStatus7 = FileStatus.IGNORED;
                    fileStatus = fileStatus7;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus7, (String)"IGNORED");
                    break;
                }
                case 6: {
                    FileStatus fileStatus8 = FileStatus.ADDED;
                    fileStatus = fileStatus8;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus8, (String)"ADDED");
                    break;
                }
                case 7: {
                    FileStatus fileStatus9 = FileStatus.DELETED;
                    fileStatus = fileStatus9;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus9, (String)"DELETED");
                    break;
                }
                case 8: {
                    FileStatus fileStatus10 = SvnFileStatus.REPLACED;
                    fileStatus = fileStatus10;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus10, (String)"REPLACED");
                    break;
                }
                case 9: {
                    FileStatus fileStatus11 = FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
                    fileStatus = fileStatus11;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus11, (String)"MERGED_WITH_PROPERTY_CONFLICTS");
                    break;
                }
                case 10: {
                    FileStatus fileStatus12 = FileStatus.MODIFIED;
                    fileStatus = fileStatus12;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus12, (String)"MODIFIED");
                    break;
                }
                default: {
                    FileStatus fileStatus13 = FileStatus.NOT_CHANGED;
                    fileStatus = fileStatus13;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus13, (String)"NOT_CHANGED");
                }
            }
            return fileStatus;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StatusType.values().length];
                try {
                    nArray[StatusType.STATUS_UNVERSIONED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_MISSING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_EXTERNAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_OBSTRUCTED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_IGNORED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_ADDED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_DELETED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_REPLACED.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_CONFLICTED.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusType.STATUS_MODIFIED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

