/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorKt;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.ui.GHCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUiKt;
import org.jetbrains.plugins.github.authentication.ui.LoginNotUniqueException;
import org.jetbrains.plugins.github.authentication.util.GHSecurityUtil;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012:\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001ej\u0002` H\u0016J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0!2\u0006\u0010\r\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u000eH\u0016J\u0010\u0010(\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013RB\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHTokenCredentialsUi;", "Lorg/jetbrains/plugins/github/authentication/ui/GHCredentialsUi;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "factory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "<init>", "(Lcom/intellij/ui/components/fields/ExtendableTextField;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;)V", "getFactory", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "tokenTextField", "Lcom/intellij/ui/components/JBPasswordField;", "fixedLogin", "centerPanel", "", "Lcom/intellij/ui/dsl/builder/Panel;", "browseNewTokenUrl", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "Lkotlin/Pair;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleAcquireError", "error", "", "setBusy", "busy", "setFixedLogin", "Companion", "intellij.vcs.github"})
public final class GHTokenCredentialsUi
extends GHCredentialsUi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtendableTextField serverTextField;
    @NotNull
    private final GithubApiRequestExecutor.Factory factory;
    @NotNull
    private final Function2<String, GithubServerPath, Boolean> isAccountUnique;
    @NotNull
    private final JBPasswordField tokenTextField;
    @Nullable
    private String fixedLogin;

    public GHTokenCredentialsUi(@NotNull ExtendableTextField serverTextField, @NotNull GithubApiRequestExecutor.Factory factory, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        Intrinsics.checkNotNullParameter((Object)serverTextField, (String)"serverTextField");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(isAccountUnique, (String)"isAccountUnique");
        this.serverTextField = serverTextField;
        this.factory = factory;
        this.isAccountUnique = isAccountUnique;
        this.tokenTextField = new JBPasswordField();
    }

    @NotNull
    public final GithubApiRequestExecutor.Factory getFactory() {
        return this.factory;
    }

    @Override
    protected void centerPanel(@NotNull Panel $this$centerPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$centerPanel, (String)"<this>");
        String string = GithubBundle.message("credentials.server.field", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$centerPanel.row(string, arg_0 -> GHTokenCredentialsUi.centerPanel$lambda$0(this, arg_0));
        String string2 = GithubBundle.message("credentials.token.field", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$centerPanel.row(string2, arg_0 -> GHTokenCredentialsUi.centerPanel$lambda$1(this, arg_0));
    }

    private final void browseNewTokenUrl() {
        GithubServerPath githubServerPath = GHTokenCredentialsUiKt.access$tryParseServer((JTextField)this.serverTextField);
        Intrinsics.checkNotNull((Object)githubServerPath);
        BrowserUtil.browse((String)GHSecurityUtil.INSTANCE.buildNewTokenUrl$intellij_vcs_github(githubServerPath));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return (JComponent)this.tokenTextField;
    }

    @Override
    @NotNull
    public Function0<ValidationInfo> getValidator() {
        return () -> GHTokenCredentialsUi.getValidator$lambda$0(this);
    }

    @Override
    @Nullable
    public Object login(@NotNull GithubServerPath server, @NotNull Continuation<? super Pair<String, String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain().getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends String, ? extends String>>, Object>(this, server, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ GHTokenCredentialsUi this$0;
            final /* synthetic */ GithubServerPath $server;
            {
                this.this$0 = $receiver;
                this.$server = $server;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        token = GHTokenCredentialsUi.access$getTokenTextField$p(this.this$0).getText();
                        v0 = this.this$0.getFactory();
                        Intrinsics.checkNotNull((Object)token);
                        executor = v0.create(this.$server, token);
                        this.L$0 = token;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)executor);
                        this.label = 1;
                        v1 = GHTokenCredentialsUi.Companion.acquireLogin(this.$server, executor, (Function2<? super String, ? super GithubServerPath, Boolean>)GHTokenCredentialsUi.access$isAccountUnique$p(this.this$0), GHTokenCredentialsUi.access$getFixedLogin$p(this.this$0), (Continuation<? super String>)((Continuation)this));
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        executor = (GithubApiRequestExecutor)this.L$1;
                        token = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        login = (String)v1;
                        return TuplesKt.to((Object)login, (Object)token);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @NotNull
    public ValidationInfo handleAcquireError(@NotNull Throwable error) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof GithubParseException) {
            String string = error.getMessage();
            if (string == null) {
                String string2 = GithubBundle.message("credentials.invalid.server.path", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            validationInfo = new ValidationInfo(string, (JComponent)this.serverTextField);
        } else {
            validationInfo = Companion.handleError(error);
        }
        return validationInfo;
    }

    @Override
    public void setBusy(boolean busy) {
        this.tokenTextField.setEnabled(!busy);
    }

    public final void setFixedLogin(@Nullable String fixedLogin) {
        this.fixedLogin = fixedLogin;
    }

    private static final Unit centerPanel$lambda$1$0(GHTokenCredentialsUi this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.browseNewTokenUrl();
        return Unit.INSTANCE;
    }

    private static final Unit centerPanel$lambda$0(GHTokenCredentialsUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.serverTextField).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit centerPanel$lambda$1(GHTokenCredentialsUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{GHSecurityUtil.INSTANCE.getMASTER_SCOPES()};
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.tokenTextField), (String)CollaborationToolsBundle.message((String)"clone.dialog.insufficient.scopes", (Object[])objectArray), (int)-1, null, (int)4, null).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
        String string = GithubBundle.message("credentials.button.generate", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> GHTokenCredentialsUi.centerPanel$lambda$1$0(this$0, arg_0)).enabledIf(GHTokenCredentialsUiKt.access$getServerValid((JTextField)this$0.serverTextField));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo getValidator$lambda$0(GHTokenCredentialsUi this$0) {
        JTextField jTextField = (JTextField)this$0.tokenTextField;
        String string = GithubBundle.message("login.token.cannot.be.empty", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
    }

    public static final /* synthetic */ JBPasswordField access$getTokenTextField$p(GHTokenCredentialsUi $this) {
        return $this.tokenTextField;
    }

    public static final /* synthetic */ Function2 access$isAccountUnique$p(GHTokenCredentialsUi $this) {
        return $this.isAccountUnique;
    }

    public static final /* synthetic */ String access$getFixedLogin$p(GHTokenCredentialsUi $this) {
        return $this.fixedLogin;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jd\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2:\u0010\n\u001a6\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u000f0\u000bj\u0002`\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHTokenCredentialsUi$Companion;", "", "<init>", "()V", "acquireLogin", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "isAccountUnique", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "login", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "fixedLogin", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lkotlin/jvm/functions/Function2;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleError", "Lcom/intellij/openapi/ui/ValidationInfo;", "error", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object acquireLogin(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @Nullable String fixedLogin, @NotNull Continuation<? super String> $completion) {
            if (!($completion instanceof acquireLogin.1)) ** GOTO lbl-1000
            var9_6 = $completion;
            if ((var9_6.label & -2147483648) != 0) {
                var9_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.acquireLogin(null, null, null, null, (Continuation<? super String>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = server;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)executor);
                    $continuation.L$2 = isAccountUnique;
                    $continuation.L$3 = fixedLogin;
                    $continuation.label = 1;
                    v0 = GithubApiRequestExecutorKt.executeSuspend(executor, GithubApiRequests.CurrentUser.get(server), $continuation);
                    if (v0 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    fixedLogin = (String)$continuation.L$3;
                    isAccountUnique = (Function2)$continuation.L$2;
                    executor = (GithubApiRequestExecutor)$continuation.L$1;
                    server = (GithubServerPath)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    details = (GithubAuthenticatedUser)v0;
                    v1 = details.getLogin();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getLogin(...)");
                    login = v1;
                    if (fixedLogin != null && !Intrinsics.areEqual((Object)fixedLogin, (Object)login)) {
                        throw new GithubAuthenticationException("Token should match username \"" + fixedLogin + "\"");
                    }
                    if (!((Boolean)isAccountUnique.invoke((Object)login, (Object)server)).booleanValue()) {
                        throw new LoginNotUniqueException(login);
                    }
                    return login;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final ValidationInfo handleError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                Object[] objectArray = new Object[]{((LoginNotUniqueException)error).getLogin()};
                ValidationInfo validationInfo2 = new ValidationInfo(GithubBundle.message("login.account.already.added", objectArray)).withOKEnabled();
                validationInfo = validationInfo2;
                Intrinsics.checkNotNullExpressionValue((Object)validationInfo2, (String)"withOKEnabled(...)");
            } else if (throwable instanceof UnknownHostException) {
                ValidationInfo validationInfo3 = new ValidationInfo(GithubBundle.message("server.unreachable", new Object[0])).withOKEnabled();
                validationInfo = validationInfo3;
                Intrinsics.checkNotNullExpressionValue((Object)validationInfo3, (String)"withOKEnabled(...)");
            } else if (throwable instanceof GithubAuthenticationException) {
                Object[] objectArray = new Object[1];
                String string = error.getMessage();
                if (string == null) {
                    string = "";
                }
                objectArray[0] = string;
                ValidationInfo validationInfo4 = new ValidationInfo(GithubBundle.message("credentials.incorrect", objectArray)).withOKEnabled();
                validationInfo = validationInfo4;
                Intrinsics.checkNotNullExpressionValue((Object)validationInfo4, (String)"withOKEnabled(...)");
            } else {
                Object[] objectArray = new Object[1];
                String string = error.getMessage();
                if (string == null) {
                    string = "";
                }
                objectArray[0] = string;
                ValidationInfo validationInfo5 = new ValidationInfo(GithubBundle.message("credentials.invalid.auth.data", objectArray)).withOKEnabled();
                validationInfo = validationInfo5;
                Intrinsics.checkNotNullExpressionValue((Object)validationInfo5, (String)"withOKEnabled(...)");
            }
            return validationInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

