/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.RootTypeBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0011\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/bookmark/providers/RootTypeNode;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "Lcom/intellij/ide/bookmark/providers/RootTypeBookmark;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/providers/RootTypeBookmark;)V", "canRepresent", "", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.bookmarks"})
public final class RootTypeNode
extends BookmarkNode<RootTypeBookmark> {
    public RootTypeNode(@NotNull Project project, @NotNull RootTypeBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        super(project, (Bookmark)bookmark);
    }

    @Override
    public boolean canRepresent(@Nullable Object element) {
        VirtualFile virtualFile = this.getVirtualFile();
        return virtualFile != null ? virtualFile.equals(element) : false;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RootTypeBookmark rootTypeBookmark = (RootTypeBookmark)this.getValue();
        return rootTypeBookmark != null && (rootTypeBookmark = rootTypeBookmark.getType()) != null ? rootTypeBookmark.containsFile(file) : false;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        RootTypeBookmark rootTypeBookmark = (RootTypeBookmark)this.getValue();
        return rootTypeBookmark != null ? rootTypeBookmark.getFile() : null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return ExtensionsKt.computeDirectoryChildren(this);
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setIcon(this.wrapIcon(AllIcons.Nodes.Folder));
        BookmarkNode bookmarkNode = this;
        Object object = (RootTypeBookmark)this.getValue();
        if (object == null || (object = ((RootTypeBookmark)object).getType()) == null || (object = object.getDisplayName()) == null) {
            object = "";
        }
        BookmarkNode.addTextTo$default(bookmarkNode, presentation, (String)object, IdeBundle.message((String)"scratches.and.consoles", (Object[])new Object[0]), 0, 8, null);
    }
}

