/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionTreeElement
implements StructureViewTreeElement {
    private final PsiElement myStartElement;
    private int myEndOffset;
    private final Collection<StructureViewTreeElement> myChildElements;
    private final CustomFoldingProvider myProvider;
    private final CustomRegionTreeElement myParent;
    private List<CustomRegionTreeElement> mySubRegions;

    @ApiStatus.Internal
    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider, @Nullable CustomRegionTreeElement parent) {
        if (startElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(1);
        }
        this.myEndOffset = Integer.MAX_VALUE;
        this.myChildElements = new ArrayList<StructureViewTreeElement>();
        this.myStartElement = startElement;
        this.myProvider = provider;
        this.myParent = parent;
    }

    @ApiStatus.Internal
    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider) {
        if (startElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(3);
        }
        this(startElement, provider, null);
    }

    @Override
    public Object getValue() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myStartElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myStartElement instanceof Navigatable && ((Navigatable)this.myStartElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return CustomRegionTreeElement.this.myProvider.getPlaceholderText(CustomRegionTreeElement.this.myStartElement.getText());
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Nodes.CustomRegion;
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement$1", "getIcon"));
            }
        };
    }

    @ApiStatus.Internal
    public void addChild(@NotNull StructureViewTreeElement childElement) {
        if (childElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(4);
        }
        if (this.mySubRegions != null) {
            for (CustomRegionTreeElement subRegion : this.mySubRegions) {
                if (!subRegion.containsElement(childElement)) continue;
                subRegion.addChild(childElement);
                return;
            }
        }
        this.myChildElements.add(childElement);
    }

    @Override
    public TreeElement @NotNull [] getChildren() {
        if (this.mySubRegions == null || this.mySubRegions.isEmpty()) {
            TreeElement[] treeElementArray = this.myChildElements.toArray(StructureViewTreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                CustomRegionTreeElement.$$$reportNull$$$0(5);
            }
            return treeElementArray;
        }
        TreeElement[] allElements = new StructureViewTreeElement[this.myChildElements.size() + this.mySubRegions.size()];
        int index = 0;
        for (StructureViewTreeElement structureViewTreeElement : this.myChildElements) {
            allElements[index++] = structureViewTreeElement;
        }
        for (StructureViewTreeElement structureViewTreeElement : this.mySubRegions) {
            allElements[index++] = structureViewTreeElement;
        }
        if (allElements == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(6);
        }
        return allElements;
    }

    @ApiStatus.Internal
    public boolean containsElement(StructureViewTreeElement element) {
        TextRange elementRange;
        Object o = element.getValue();
        return o instanceof PsiElement && (elementRange = ((PsiElement)o).getTextRange()).getStartOffset() >= this.myStartElement.getTextRange().getStartOffset() && elementRange.getEndOffset() <= this.myEndOffset;
    }

    @ApiStatus.Internal
    public boolean containsOffset(int offset) {
        return offset >= this.myStartElement.getTextRange().getStartOffset() && offset <= this.myEndOffset;
    }

    @ApiStatus.Internal
    public CustomRegionTreeElement createNestedRegion(@NotNull PsiElement element) {
        if (element == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(7);
        }
        if (this.mySubRegions == null) {
            this.mySubRegions = new ArrayList<CustomRegionTreeElement>();
        }
        CustomRegionTreeElement currSubRegion = new CustomRegionTreeElement(element, this.myProvider, this);
        this.mySubRegions.add(currSubRegion);
        return currSubRegion;
    }

    @ApiStatus.Internal
    public CustomRegionTreeElement endRegion(@NotNull PsiElement element) {
        if (element == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(8);
        }
        this.myEndOffset = element.getTextRange().getEndOffset();
        return this.myParent;
    }

    public String toString() {
        return "Region '" + this.myProvider.getPlaceholderText(this.myStartElement.getText()) + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNestedRegion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "endRegion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

