/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ToDoSummary;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.todo.nodes.ModuleToDoNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SummaryNode
extends BaseToDoNode<ToDoSummary> {
    public SummaryNode(Project project, @NotNull ToDoSummary value, TodoTreeBuilder builder) {
        if (value == null) {
            SummaryNode.$$$reportNull$$$0(0);
        }
        super(project, value, builder);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList<TodoFileNode> children = new ArrayList<TodoFileNode>();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (this.myToDoSettings.isModulesShown()) {
            Iterator<PsiFile> i = this.myBuilder.getAllFiles();
            while (i.hasNext()) {
                PsiFile psiFile = i.next();
                if (psiFile == null) continue;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                this.createModuleTodoNodeForFile(children, projectFileIndex, virtualFile);
            }
        } else if (this.myToDoSettings.getIsPackagesShown()) {
            if (this.myBuilder instanceof CurrentFileTodosTreeBuilder) {
                Iterator<PsiFile> allFiles = this.myBuilder.getAllFiles();
                if (allFiles.hasNext()) {
                    children.add(new TodoFileNode(this.myProject, allFiles.next(), this.myBuilder, false));
                }
            } else {
                TodoTreeHelper.getInstance(this.getProject()).addPackagesToChildren(children, null, this.myBuilder);
            }
        } else {
            Iterator<PsiFile> i = this.myBuilder.getAllFiles();
            while (i.hasNext()) {
                PsiFile psiFile = i.next();
                if (psiFile == null) continue;
                TodoFileNode fileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (!this.getTreeStructure().accept(psiFile) || children.contains((Object)fileNode)) continue;
                children.add(fileNode);
            }
        }
        children.sort(TodoFileDirAndModuleComparator.INSTANCE);
        ArrayList<TodoFileNode> arrayList = children;
        if (arrayList == null) {
            SummaryNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected void createModuleTodoNodeForFile(ArrayList<? super AbstractTreeNode<?>> children, ProjectFileIndex projectFileIndex, VirtualFile virtualFile) {
        ModuleToDoNode moduleToDoNode;
        Module module = projectFileIndex.getModuleForFile(virtualFile);
        if (module != null && !children.contains((Object)(moduleToDoNode = new ModuleToDoNode(this.getProject(), module, this.myBuilder)))) {
            children.add(moduleToDoNode);
        }
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            SummaryNode.$$$reportNull$$$0(2);
        }
        int todoItemCount = this.getTodoItemCount((ToDoSummary)this.getValue());
        int fileCount = this.getFileCount((ToDoSummary)this.getValue());
        presentation.setPresentableText(IdeBundle.message((String)"node.todo.summary", (Object[])new Object[]{todoItemCount, fileCount}));
    }

    public String getTestPresentation() {
        return "Summary";
    }

    @Override
    public int getFileCount(ToDoSummary summary) {
        int count = 0;
        Iterator<PsiFile> i = this.myBuilder.getAllFiles();
        while (i.hasNext()) {
            PsiFile psiFile = i.next();
            if (psiFile == null || !this.getTreeStructure().accept(psiFile)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getTodoItemCount(ToDoSummary val) {
        int count = 0;
        Iterator<PsiFile> i = this.myBuilder.getAllFiles();
        while (i.hasNext()) {
            count += ((Integer)ReadAction.compute(() -> this.getTreeStructure().getTodoItemCount((PsiFile)i.next()))).intValue();
        }
        return count;
    }

    public int getWeight() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/SummaryNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/SummaryNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

