/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.embedding;

import com.intellij.html.embedding.BaseHtmlEmbeddedContentProvider;
import com.intellij.html.embedding.HtmlEmbedment;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.HtmlEmbeddedContentSupportHelperKt;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0007H$J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007H$J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0014J\u0012\u0010'\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020\u000bH\u0016J\n\u0010+\u001a\u0004\u0018\u00010)H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lcom/intellij/html/embedding/HtmlTagEmbeddedContentProvider;", "Lcom/intellij/html/embedding/BaseHtmlEmbeddedContentProvider;", "lexer", "Lcom/intellij/lexer/BaseHtmlLexer;", "<init>", "(Lcom/intellij/lexer/BaseHtmlLexer;)V", "myAttributeValue", "", "myAttributeName", "myTagName", "myTagNameRead", "", "myWithinTag", "myReadAttributeValue", "attributeValue", "getAttributeValue", "()Ljava/lang/CharSequence;", "attributeName", "getAttributeName", "tagName", "getTagName", "withinTag", "getWithinTag", "()Z", "isInterestedInTag", "isInterestedInAttribute", "handleToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "range", "Lcom/intellij/openapi/util/TextRange;", "createEmbedment", "Lcom/intellij/html/embedding/HtmlEmbedment;", "isStartOfEmbedment", "isTagEmbedmentStartToken", "findTheEndOfEmbedment", "Lkotlin/Pair;", "", "restoreState", "state", "", "hasState", "getState", "TagState", "intellij.xml.parser"})
@SourceDebugExtension(value={"SMAP\nHtmlTagEmbeddedContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlTagEmbeddedContentProvider.kt\ncom/intellij/html/embedding/HtmlTagEmbeddedContentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public abstract class HtmlTagEmbeddedContentProvider
extends BaseHtmlEmbeddedContentProvider {
    @Nullable
    private CharSequence myAttributeValue;
    @Nullable
    private CharSequence myAttributeName;
    @Nullable
    private CharSequence myTagName;
    private boolean myTagNameRead;
    private boolean myWithinTag;
    private boolean myReadAttributeValue;

    public HtmlTagEmbeddedContentProvider(@NotNull BaseHtmlLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)((Object)lexer), (String)"lexer");
        super(lexer);
    }

    @Nullable
    protected final CharSequence getAttributeValue() {
        return this.myAttributeValue;
    }

    @Nullable
    protected final CharSequence getAttributeName() {
        return this.myAttributeName;
    }

    @Nullable
    protected final CharSequence getTagName() {
        return this.myTagName;
    }

    protected final boolean getWithinTag() {
        return this.myWithinTag;
    }

    protected abstract boolean isInterestedInTag(@NotNull CharSequence var1);

    protected abstract boolean isInterestedInAttribute(@NotNull CharSequence var1);

    @Override
    public void handleToken(@NotNull IElementType tokenType, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_START_TAG_START)) {
            this.myTagNameRead = false;
            this.myReadAttributeValue = false;
            this.myWithinTag = false;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_NAME)) {
            Lexer baseLexer = this.getLexer().getDelegate();
            if (!this.myTagNameRead) {
                CharSequence charSequence = baseLexer.getBufferSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
                CharSequenceSubSequence tagName = new CharSequenceSubSequence(charSequence, range.getStartOffset(), range.getEndOffset());
                this.myWithinTag = this.isInterestedInTag((CharSequence)tagName);
                this.myTagName = this.myWithinTag ? (CharSequence)tagName : null;
                this.myTagNameRead = true;
                this.myAttributeName = null;
                this.myAttributeValue = null;
            } else if (this.myWithinTag) {
                CharSequence charSequence = baseLexer.getBufferSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
                CharSequenceSubSequence attributeName = new CharSequenceSubSequence(charSequence, range.getStartOffset(), range.getEndOffset());
                this.myReadAttributeValue = this.isInterestedInAttribute((CharSequence)attributeName);
                if (this.myReadAttributeValue) {
                    this.myAttributeName = (CharSequence)attributeName;
                    this.myAttributeValue = (CharSequence)attributeName;
                }
            }
            this.embedment = false;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN)) {
            if (this.myReadAttributeValue) {
                CharSequence charSequence = this.getLexer().getDelegate().getBufferSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
                this.myAttributeValue = (CharSequence)new CharSequenceSubSequence(charSequence, range.getStartOffset(), range.getEndOffset());
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_TAG_END) || Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_EMPTY_ELEMENT_END)) {
            this.embedment = Intrinsics.areEqual((Object)tokenType, (Object)XmlTokenType.XML_TAG_END) && this.myWithinTag;
            this.myWithinTag = false;
            this.myTagNameRead = false;
            this.myReadAttributeValue = false;
            if (!this.embedment) {
                this.myTagName = null;
                this.myAttributeName = null;
                this.myAttributeValue = null;
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_END_TAG_START)) {
            this.myTagNameRead = true;
            this.myReadAttributeValue = false;
            this.myWithinTag = false;
        }
    }

    @Override
    @Nullable
    public HtmlEmbedment createEmbedment(@NotNull IElementType tokenType) {
        HtmlEmbedment htmlEmbedment;
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        HtmlEmbedment htmlEmbedment2 = super.createEmbedment(tokenType);
        if (htmlEmbedment2 != null) {
            HtmlEmbedment htmlEmbedment3;
            HtmlEmbedment it = htmlEmbedment3 = htmlEmbedment2;
            boolean bl = false;
            htmlEmbedment = !it.getRange().isEmpty() ? htmlEmbedment3 : null;
        } else {
            htmlEmbedment = null;
        }
        return htmlEmbedment;
    }

    @Override
    protected boolean isStartOfEmbedment(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return this.myTagName != null && this.isTagEmbedmentStartToken(tokenType);
    }

    protected boolean isTagEmbedmentStartToken(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        CharSequence charSequence = this.myTagName;
        Intrinsics.checkNotNull((Object)charSequence);
        return HtmlEmbeddedContentSupportHelperKt.isTagEmbedmentStartToken(baseHtmlLexer, tokenType, charSequence);
    }

    @Override
    @NotNull
    protected Pair<Integer, Integer> findTheEndOfEmbedment() {
        Intrinsics.checkNotNull((Object)this.getTagName());
        Lexer baseLexer = this.getLexer().getDelegate();
        LexerPosition lexerPosition = baseLexer.getCurrentPosition();
        Intrinsics.checkNotNullExpressionValue((Object)lexerPosition, (String)"getCurrentPosition(...)");
        LexerPosition position = lexerPosition;
        int bufferEnd = baseLexer.getBufferEnd();
        int lastState = 0;
        int lastStart = 0;
        CharSequence charSequence = baseLexer.getBufferSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
        CharSequence buf = charSequence;
        char[] bufArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buf);
        while (true) {
            IElementType it = baseLexer.getTokenType();
            boolean bl = false;
            if (it != null && it != XmlTokenType.XML_END_TAG_START) {
                if (baseLexer.getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
                    int end = baseLexer.getTokenEnd();
                    for (int i = baseLexer.getTokenStart(); i < end; ++i) {
                        if (i + 1 >= end || (bufArray != null ? bufArray[i] : buf.charAt(i)) != '<' || (bufArray != null ? bufArray[i + 1] : buf.charAt(i + 1)) != '/') continue;
                        baseLexer.start(buf, i, bufferEnd, this.getLexer().getStateForRestartDuringEmbedmentScan());
                        baseLexer.getTokenType();
                        break;
                    }
                } else {
                    baseLexer.advance();
                    continue;
                }
            }
            lastState = baseLexer.getState();
            lastStart = baseLexer.getTokenStart();
            if (baseLexer.getTokenType() == null) break;
            baseLexer.advance();
            while (XmlTokenType.WHITESPACES.contains(baseLexer.getTokenType())) {
                baseLexer.advance();
            }
            if (baseLexer.getTokenType() == null) break;
            if (baseLexer.getTokenType() != XmlTokenType.XML_NAME) continue;
            CharSequenceSubSequence tokenText = new CharSequenceSubSequence(buf, baseLexer.getTokenStart(), baseLexer.getTokenEnd());
            if (baseLexer.getTokenEnd() < buf.length()) {
                char it2 = buf.charAt(baseLexer.getTokenEnd());
                boolean bl2 = false;
                if ((it2 == '>' || it2 == '/' || CharsKt.isWhitespace((char)it2)) && this.namesEqual(this.getTagName(), (CharSequence)tokenText)) break;
            }
            if (this.namesEqual("IntellijIdeaRulezzz", (CharSequence)tokenText)) break;
        }
        baseLexer.restore(position);
        return new Pair((Object)lastStart, (Object)lastState);
    }

    @Override
    public void restoreState(@Nullable Object state) {
        if (state == null) {
            this.myTagNameRead = false;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
            this.myReadAttributeValue = false;
            this.myAttributeValue = null;
            this.embedment = false;
            return;
        }
        if (!(state instanceof TagState)) {
            return;
        }
        this.myTagNameRead = ((TagState)state).getTagNameRead();
        this.myWithinTag = ((TagState)state).getWithinTag();
        this.myTagName = ((TagState)state).getTagName();
        this.myAttributeName = ((TagState)state).getAttributeName();
        this.myReadAttributeValue = ((TagState)state).getReadAttributeValue();
        this.myAttributeValue = ((TagState)state).getAttributeValue();
        this.embedment = ((TagState)state).getEmbedment();
    }

    @Override
    public boolean hasState() {
        return this.myTagNameRead || this.myWithinTag || this.myTagName != null || this.myAttributeName != null || this.embedment;
    }

    @Override
    @Nullable
    public Object getState() {
        return this.hasState() ? new TagState(this.myTagNameRead, this.myWithinTag, this.myTagName, this.myAttributeName, this.myReadAttributeValue, this.myAttributeValue, this.embedment) : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/intellij/html/embedding/HtmlTagEmbeddedContentProvider$TagState;", "Lcom/intellij/html/embedding/BaseHtmlEmbeddedContentProvider$BaseState;", "tagNameRead", "", "withinTag", "tagName", "", "attributeName", "readAttributeValue", "attributeValue", "embedment", "<init>", "(ZZLjava/lang/CharSequence;Ljava/lang/CharSequence;ZLjava/lang/CharSequence;Z)V", "getTagNameRead", "()Z", "getWithinTag", "getTagName", "()Ljava/lang/CharSequence;", "getAttributeName", "getReadAttributeValue", "getAttributeValue", "intellij.xml.parser"})
    public static class TagState
    extends BaseHtmlEmbeddedContentProvider.BaseState {
        private final boolean tagNameRead;
        private final boolean withinTag;
        @Nullable
        private final CharSequence tagName;
        @Nullable
        private final CharSequence attributeName;
        private final boolean readAttributeValue;
        @Nullable
        private final CharSequence attributeValue;

        public TagState(boolean tagNameRead, boolean withinTag, @Nullable CharSequence tagName, @Nullable CharSequence attributeName, boolean readAttributeValue, @Nullable CharSequence attributeValue, boolean embedment) {
            super(embedment);
            this.tagNameRead = tagNameRead;
            this.withinTag = withinTag;
            this.tagName = tagName;
            this.attributeName = attributeName;
            this.readAttributeValue = readAttributeValue;
            this.attributeValue = attributeValue;
        }

        public final boolean getTagNameRead() {
            return this.tagNameRead;
        }

        public final boolean getWithinTag() {
            return this.withinTag;
        }

        @Nullable
        public final CharSequence getTagName() {
            return this.tagName;
        }

        @Nullable
        public final CharSequence getAttributeName() {
            return this.attributeName;
        }

        public final boolean getReadAttributeValue() {
            return this.readAttributeValue;
        }

        @Nullable
        public final CharSequence getAttributeValue() {
            return this.attributeValue;
        }
    }
}

