/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GroupedComboBoxRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesCombo<T extends Scheme>
extends ComboBox<MySchemeListItem<T>> {
    private static final @NotNull Supplier<@Nls String> PROJECT_LEVEL = IdeBundle.messagePointer((String)"scheme.project", (Object[])new Object[0]);
    private static final @NotNull Supplier<@Nls String> IDE_LEVEL = IdeBundle.messagePointer((String)"scheme.ide", (Object[])new Object[0]);
    private final ArrayList<SeparatorInfo> mySeparatorInfos = new ArrayList();

    public SchemesCombo() {
        super(new DefaultComboBoxModel());
        this.setRenderer(new GroupedComboBoxRenderer<MySchemeListItem<T>>((JComponent)((Object)this)){

            @Override
            public void customize(@NotNull SimpleColoredComponent item, MySchemeListItem<T> value, int index, boolean isSelected, boolean hasFocus) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                SchemesCombo.this.customizeComponent(item, value, index);
            }

            @Override
            @Nullable
            public ListSeparator separatorFor(MySchemeListItem<T> value) {
                for (SeparatorInfo info : SchemesCombo.this.mySeparatorInfos) {
                    Object scheme = info.myListItem.myScheme;
                    if (scheme == null || !scheme.equals(value.getScheme())) continue;
                    return new ListSeparator(info.title);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/application/options/schemes/SchemesCombo$1", "customize"));
            }
        });
        this.setSwingPopup(false);
    }

    public void resetSchemes(@NotNull Collection<? extends T> schemes) {
        if (schemes == null) {
            SchemesCombo.$$$reportNull$$$0(0);
        }
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.getModel();
        model2.removeAllElements();
        this.mySeparatorInfos.clear();
        if (this.supportsProjectSchemes()) {
            this.addItems(schemes, scheme -> scheme != null && this.isProjectScheme(scheme), IdeBundle.message((String)"separator.scheme.stored.in", (Object[])new Object[]{PROJECT_LEVEL.get()}));
            this.addItems(schemes, scheme -> scheme != null && !this.isProjectScheme(scheme), IdeBundle.message((String)"separator.scheme.stored.in", (Object[])new Object[]{IDE_LEVEL.get()}));
        } else {
            this.addItems(schemes, scheme -> scheme != null, "");
        }
    }

    public void resetGroupedSchemes(@NotNull Groups<? extends T> schemeGroups) {
        if (schemeGroups == null) {
            SchemesCombo.$$$reportNull$$$0(1);
        }
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.getModel();
        model2.removeAllElements();
        this.mySeparatorInfos.clear();
        for (Groups.GroupInfo schemeGroup : schemeGroups.getInfos()) {
            List schemes = schemeGroup.getItems();
            this.addItems(schemes, scheme -> scheme != null, schemeGroup.getTitle());
        }
    }

    public void selectScheme(@Nullable T scheme) {
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            if (((MySchemeListItem)this.getItemAt(i2)).getScheme() != scheme) continue;
            this.setSelectedIndex(i2);
            break;
        }
    }

    @Nullable
    public T getSelectedScheme() {
        Object item = this.getSelectedItem();
        return item != null ? (T)((MySchemeListItem)item).getScheme() : null;
    }

    @Nullable
    public MySchemeListItem<T> getSelectedItem() {
        int i2 = this.getSelectedIndex();
        return i2 >= 0 ? (MySchemeListItem)this.getItemAt(i2) : null;
    }

    protected abstract boolean supportsProjectSchemes();

    protected boolean isProjectScheme(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    protected boolean isDefaultScheme(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(3);
        }
        return false;
    }

    protected int getIndent(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(4);
        }
        return 0;
    }

    @NotNull
    protected abstract SimpleTextAttributes getSchemeAttributes(T var1);

    private void addItems(@NotNull Collection<? extends T> schemes, Predicate<? super T> filter2, @Nls String separatorTitle) {
        if (schemes == null) {
            SchemesCombo.$$$reportNull$$$0(5);
        }
        SeparatorInfo separatorInfo = null;
        for (Scheme scheme : schemes) {
            if (!filter2.test(scheme)) continue;
            MySchemeListItem<Scheme> item = new MySchemeListItem<Scheme>(scheme);
            ((DefaultComboBoxModel)this.getModel()).addElement(item);
            if (separatorInfo != null) continue;
            separatorInfo = new SeparatorInfo(this, item, separatorTitle);
        }
        if (separatorInfo != null) {
            this.mySeparatorInfos.add(separatorInfo);
        }
    }

    private void customizeComponent(@NotNull SimpleColoredComponent item, MySchemeListItem<T> value, int index) {
        T scheme;
        if (item == null) {
            SchemesCombo.$$$reportNull$$$0(6);
        }
        if ((scheme = value.getScheme()) != null) {
            item.append(StringUtil.shortenTextWithEllipsis((String)value.getPresentableText(), (int)100, (int)20), this.getSchemeAttributes(scheme));
            if (this.isDefaultScheme(scheme)) {
                item.append(" " + IdeBundle.message((String)"scheme.theme.default", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            if (this.supportsProjectSchemes() && index == -1) {
                item.append("  " + (this.isProjectScheme(scheme) ? PROJECT_LEVEL.get() : IDE_LEVEL.get()), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        int indent = index < 0 || scheme == null ? 0 : this.getIndent(scheme);
        item.setIpad((Insets)JBUI.insetsLeft((int)(indent > 0 ? indent * 10 : 0)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeGroups";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/schemes/SchemesCombo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSchemes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetGroupedSchemes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultScheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class MySchemeListItem<T extends Scheme> {
        @Nullable
        private final T myScheme;

        MySchemeListItem(@Nullable T scheme) {
            this.myScheme = scheme;
        }

        @Nullable
        public String getSchemeName() {
            return this.myScheme != null ? this.myScheme.getName() : null;
        }

        @Nullable
        public T getScheme() {
            return this.myScheme;
        }

        @NlsContexts.ListItem
        @NotNull
        public String getPresentableText() {
            return this.myScheme != null ? this.myScheme.getDisplayName() : "";
        }
    }

    private final class SeparatorInfo {
        @NotNull
        private final MySchemeListItem<T> myListItem;
        @Nls
        private final String title;

        SeparatorInfo(@NotNull SchemesCombo schemesCombo, @Nullable @Nls MySchemeListItem<T> listItem, String title2) {
            if (listItem == null) {
                SeparatorInfo.$$$reportNull$$$0(0);
            }
            this.myListItem = listItem;
            this.title = title2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listItem", "com/intellij/application/options/schemes/SchemesCombo$SeparatorInfo", "<init>"));
        }
    }
}

