/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdeErrorsIcon;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ClickListener;
import com.intellij.util.LazyInitializer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IdeMessagePanel
implements MessagePoolListener,
IconLikeCustomStatusBarWidget {
    public static final String FATAL_ERROR = "FatalError";
    private static final String GROUP_ID = "IDE-errors";
    private final LazyInitializer.LazyValue<JPanel> component;
    @Nullable
    private final IdeFrame frame;
    @Nullable
    private final Project project;
    private final MessagePool messagePool;
    private final AtomicBoolean ijProject;
    private IdeErrorsIcon icon;
    private Balloon balloon;
    private IdeErrorsDialog dialog;
    private boolean isOpeningInProgress;
    private final IdeMessageAction action;
    private final ClickListener onClick;

    public IdeMessagePanel(@Nullable IdeFrame frame, @NotNull MessagePool messagePool) {
        if (messagePool == null) {
            IdeMessagePanel.$$$reportNull$$$0(0);
        }
        this.ijProject = new AtomicBoolean(false);
        this.action = new IdeMessageAction();
        this.onClick = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeMessagePanel.this.openErrorsDialog(null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/IdeMessagePanel$1", "onClick"));
            }
        };
        this.component = LazyInitializer.create(() -> {
            JPanel result2 = new JPanel(new BorderLayout());
            result2.setOpaque(false);
            this.onClick.installOn((Component)result2);
            return result2;
        });
        this.frame = frame;
        this.project = frame == null ? null : frame.getProject();
        this.messagePool = messagePool;
        if (this.project != null) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.ijProject.set(IntelliJProjectUtil.isIntelliJPlatformProject((Project)this.project) || IntelliJProjectUtil.isIntelliJPluginProject((Project)this.project)));
        }
        messagePool.addListener(this);
        this.updateIconAndNotify();
    }

    @NotNull
    public String ID() {
        return FATAL_ERROR;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void dispose() {
        this.messagePool.removeListener(this);
    }

    public JComponent getComponent() {
        return (JComponent)this.component.get();
    }

    public AnAction getAction() {
        return this.action;
    }

    public void openErrorsDialog(final @Nullable LogMessage message) {
        if (this.dialog != null || this.isOpeningInProgress) {
            return;
        }
        this.isOpeningInProgress = true;
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    if (!IdeMessagePanel.this.isOtherModalWindowActive()) {
                        try (AccessToken ignored = ClientId.withClientId((ClientId)ClientId.getLocalId());){
                            IdeMessagePanel.this.doOpenErrorsDialog(message);
                            break block11;
                        }
                        finally {
                            IdeMessagePanel.this.isOpeningInProgress = false;
                        }
                    }
                    if (IdeMessagePanel.this.dialog == null) {
                        EdtExecutorService.getScheduledExecutorInstance().schedule(this, 300L, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }.run();
    }

    private void doOpenErrorsDialog(@Nullable LogMessage message) {
        this.dialog = new IdeErrorsDialog(this.messagePool, this.project, this.ijProject.get(), message){

            @Override
            protected void dispose() {
                super.dispose();
                IdeMessagePanel.this.dialog = null;
                IdeMessagePanel.this.updateIconAndNotify();
            }

            @Override
            protected void updateOnSubmit() {
                super.updateOnSubmit();
                IdeMessagePanel.this.updateIcon(IdeMessagePanel.this.messagePool.getState());
            }
        };
        this.dialog.show();
    }

    private void updateIcon(MessagePool.State state2) {
        UIUtil.invokeLaterIfNeeded(() -> {
            IdeErrorsIcon icon2 = this.icon;
            if (icon2 == null) {
                icon2 = new IdeErrorsIcon(this.frame != null);
                icon2.setVerticalAlignment(0);
                this.onClick.installOn((Component)icon2);
                this.icon = icon2;
                ((JPanel)this.component.get()).add((Component)icon2, "Center");
            }
            icon2.setState(state2);
            ((JPanel)this.component.get()).setVisible(state2 != MessagePool.State.NoErrors);
            this.action.icon = icon2.getIcon();
            this.action.state = state2;
        });
    }

    @Override
    public void newEntryAdded() {
        this.updateIconAndNotify();
    }

    @Override
    public void poolCleared() {
        this.updateIconAndNotify();
    }

    @Override
    public void entryWasRead() {
        this.updateIconAndNotify();
    }

    private boolean isOtherModalWindowActive() {
        JDialog d;
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return activeWindow instanceof JDialog && (d = (JDialog)activeWindow).isModal() && (this.dialog == null || this.dialog.getWindow() != activeWindow);
    }

    private void updateIconAndNotify() {
        MessagePool.State state2 = this.messagePool.getState();
        this.updateIcon(state2);
        if (state2 == MessagePool.State.NoErrors && this.balloon != null) {
            Disposer.dispose((Disposable)this.balloon);
        } else if (state2 == MessagePool.State.UnreadErrors && this.balloon == null && IdeMessagePanel.isActive(this.frame) && this.project != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.showErrorNotification(this.project, this.frame), this.project.getDisposed());
        }
    }

    @Contract(value="null -> false")
    private static boolean isActive(@Nullable IdeFrame frame) {
        Window w;
        IdeFrame ideFrame;
        if (frame instanceof ProjectFrameHelper) {
            ProjectFrameHelper pfh = (ProjectFrameHelper)frame;
            ideFrame = pfh.getFrame();
        } else {
            ideFrame = frame;
        }
        IdeFrame ideFrame2 = ideFrame;
        return ideFrame2 instanceof Window && (w = (Window)ideFrame2).isActive();
    }

    @RequiresEdt
    private void showErrorNotification(@NotNull Project project2, @NotNull IdeFrame frame) {
        if (project2 == null) {
            IdeMessagePanel.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            IdeMessagePanel.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.balloon != null) {
            return;
        }
        NotificationDisplayType displayType = NotificationsConfiguration.getNotificationsConfiguration().getDisplayType(GROUP_ID);
        if (displayType == NotificationDisplayType.NONE) {
            return;
        }
        BalloonLayout layout2 = frame.getBalloonLayout();
        if (layout2 == null) {
            Logger.getInstance(IdeMessagePanel.class).error("frame=" + String.valueOf(frame) + " (" + String.valueOf(frame.getClass()) + ")");
            return;
        }
        Notification notification2 = new Notification(GROUP_ID, DiagnosticBundle.message("error.new.notification.title", new Object[0]), NotificationType.ERROR).setIcon(AllIcons.Ide.FatalError).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DiagnosticBundle.message("error.new.notification.link", new Object[0]), () -> this.openErrorsDialog(null)));
        BalloonLayoutData layoutData = BalloonLayoutData.createEmpty();
        layoutData.fadeoutTime = displayType == NotificationDisplayType.STICKY_BALLOON ? 300000L : 10000L;
        layoutData.textColor = JBUI.CurrentTheme.Notification.Error.FOREGROUND;
        layoutData.fillColor = JBUI.CurrentTheme.Notification.Error.BACKGROUND;
        layoutData.borderColor = JBUI.CurrentTheme.Notification.Error.BORDER_COLOR;
        layoutData.closeAll = () -> layout2.closeAll();
        layoutData.showSettingButton = true;
        this.balloon = NotificationsManagerImpl.createBalloon(frame, notification2, false, false, (Ref<BalloonLayoutData>)new Ref((Object)layoutData), (Disposable)project2);
        Disposer.register((Disposable)this.balloon, () -> {
            this.balloon = null;
        });
        layout2.add(this.balloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/IdeMessagePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class IdeMessageAction
    extends AnAction
    implements DumbAware {
        private MessagePool.State state = MessagePool.State.NoErrors;
        private Icon icon;

        private IdeMessageAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                IdeMessageAction.$$$reportNull$$$0(0);
            }
            IdeMessagePanel.this.openErrorsDialog(null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                IdeMessageAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                IdeMessageAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(this.state != MessagePool.State.NoErrors);
            e.getPresentation().setIcon(this.icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/IdeMessagePanel$IdeMessageAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/IdeMessagePanel$IdeMessageAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

