/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.ThreadInfo;
import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.util.IDMapper;
import com.intellij.diagnostic.hprof.visitors.CollectRootReasonsVisitor;
import com.intellij.diagnostic.hprof.visitors.CollectStringValuesVisitor;
import com.intellij.diagnostic.hprof.visitors.CollectThreadInfoVisitor;
import com.intellij.diagnostic.hprof.visitors.CompositeVisitor;
import com.intellij.diagnostic.hprof.visitors.CreateClassStoreVisitor;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0010\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata;", "", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "threads", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/diagnostic/hprof/classstore/ThreadInfo;", "roots", "Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "getClassStore", "()Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "setClassStore", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "getThreads", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "getRoots", "setRoots", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "remapIds", "", "idMapper", "Lcom/intellij/diagnostic/hprof/util/IDMapper;", "RemapException", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class HProfMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ClassStore classStore;
    @NotNull
    private final Long2ObjectMap<ThreadInfo> threads;
    @NotNull
    private Long2ObjectMap<RootReason> roots;

    public HProfMetadata(@NotNull ClassStore classStore, @NotNull Long2ObjectMap<ThreadInfo> threads, @NotNull Long2ObjectMap<RootReason> roots) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        this.classStore = classStore;
        this.threads = threads;
        this.roots = roots;
    }

    @NotNull
    public final ClassStore getClassStore() {
        return this.classStore;
    }

    public final void setClassStore(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"<set-?>");
        this.classStore = classStore;
    }

    @NotNull
    public final Long2ObjectMap<ThreadInfo> getThreads() {
        return this.threads;
    }

    @NotNull
    public final Long2ObjectMap<RootReason> getRoots() {
        return this.roots;
    }

    public final void setRoots(@NotNull Long2ObjectMap<RootReason> long2ObjectMap) {
        Intrinsics.checkNotNullParameter(long2ObjectMap, (String)"<set-?>");
        this.roots = long2ObjectMap;
    }

    public final void remapIds(@NotNull IDMapper idMapper) {
        Intrinsics.checkNotNullParameter((Object)idMapper, (String)"idMapper");
        this.classStore = this.classStore.createStoreWithRemappedIDs(idMapper);
        Long2ObjectOpenHashMap newRoots = new Long2ObjectOpenHashMap();
        ObjectIterator objectIterator = Long2ObjectMaps.fastIterable(this.roots).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator2.next();
            try {
                boolean bl;
                long newKey = idMapper.getID(entry.getLongKey());
                if (newKey == 0L) continue;
                boolean bl2 = bl = !newRoots.containsKey(newKey);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                newRoots.put(newKey, entry.getValue());
            }
            catch (RemapException remapException) {}
        }
        this.roots = (Long2ObjectMap)newRoots;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HProfMetadata create(@NotNull HProfEventBasedParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Long2ObjectOpenHashMap stringIdMap = new Long2ObjectOpenHashMap();
            Long2ObjectOpenHashMap threadsMap = new Long2ObjectOpenHashMap();
            CreateClassStoreVisitor classStoreVisitor = new CreateClassStoreVisitor((Long2ObjectMap<String>)((Long2ObjectMap)stringIdMap));
            CollectThreadInfoVisitor threadInfoVisitor = new CollectThreadInfoVisitor((Long2ObjectMap<ThreadInfo>)((Long2ObjectMap)threadsMap), (Long2ObjectMap<String>)((Long2ObjectMap)stringIdMap));
            CollectRootReasonsVisitor rootReasonsVisitor = new CollectRootReasonsVisitor((Long2ObjectMap<ThreadInfo>)((Long2ObjectMap)threadsMap));
            HProfVisitor[] hProfVisitorArray = new HProfVisitor[]{new CollectStringValuesVisitor((Long2ObjectMap<String>)((Long2ObjectMap)stringIdMap)), classStoreVisitor, threadInfoVisitor, rootReasonsVisitor};
            CompositeVisitor visitor = new CompositeVisitor(hProfVisitorArray);
            parser.accept(visitor, "create hprof metadata");
            return new HProfMetadata(classStoreVisitor.getClassStore(), (Long2ObjectMap<ThreadInfo>)((Long2ObjectMap)threadsMap), (Long2ObjectMap<RootReason>)((Long2ObjectMap)rootReasonsVisitor.getRoots()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/HProfMetadata$RemapException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class RemapException
    extends Exception {
    }
}

