/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionAndVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.LazyInitializer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class WslDistributionManager
implements Disposable {
    static final Logger LOG = Logger.getInstance(WslDistributionManager.class);
    private static final Object LOCK = new Object();
    private volatile CachedDistributions myInstalledDistributions;
    private volatile List<WSLDistribution> myLastInstalledDistributions;
    private final Map<String, WSLDistribution> myMsIdToDistributionCache = CollectionFactory.createConcurrentWeakCaseInsensitiveMap();
    private final List<@NotNull BiConsumer<@NotNull Set<@NotNull WSLDistribution>, @NotNull Set<@NotNull WSLDistribution>>> myWslDistributionsChangeListeners = new CopyOnWriteArrayList<BiConsumer<Set<WSLDistribution>, Set<WSLDistribution>>>();
    private final LazyInitializer.LazyValue<WSLDistributionWatcher> myDistributionWatcher = LazyInitializer.create(() -> new WSLDistributionWatcher(this));

    @NotNull
    public static WslDistributionManager getInstance() {
        WslDistributionManager wslDistributionManager = (WslDistributionManager)ApplicationManager.getApplication().getService(WslDistributionManager.class);
        if (wslDistributionManager == null) {
            WslDistributionManager.$$$reportNull$$$0(0);
        }
        return wslDistributionManager;
    }

    public void dispose() {
        this.myMsIdToDistributionCache.clear();
        this.myInstalledDistributions = null;
    }

    @Nullable
    public List<WSLDistribution> getCachedInstalledDistributions() {
        return this.getInstalledDistributionsFuture().getNow(null);
    }

    @Nullable
    public List<WSLDistribution> getLastInstalledDistributions() {
        return this.myLastInstalledDistributions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public List<WSLDistribution> getInstalledDistributions() {
        SmartHashSet distributionsAfter;
        if (!this.isAvailable()) {
            List<WSLDistribution> list2 = List.of();
            if (list2 == null) {
                WslDistributionManager.$$$reportNull$$$0(1);
            }
            return list2;
        }
        CachedDistributions cachedDistributions = this.myInstalledDistributions;
        if (cachedDistributions != null && cachedDistributions.isUpToDate()) {
            List<WSLDistribution> list3 = cachedDistributions.myInstalledDistributions;
            if (list3 == null) {
                WslDistributionManager.$$$reportNull$$$0(2);
            }
            return list3;
        }
        @NotNull @NotNull SmartHashSet distributionsBefore = cachedDistributions != null ? new SmartHashSet(cachedDistributions.myInstalledDistributions) : Collections.emptySet();
        this.myInstalledDistributions = null;
        Iterator<BiConsumer<Set<WSLDistribution>, Set<WSLDistribution>>> iterator2 = LOCK;
        synchronized (iterator2) {
            cachedDistributions = this.myInstalledDistributions;
            if (cachedDistributions == null) {
                this.myInstalledDistributions = cachedDistributions = new CachedDistributions(this.loadInstalledDistributions());
                this.myLastInstalledDistributions = cachedDistributions.myInstalledDistributions;
            }
            distributionsAfter = new SmartHashSet(cachedDistributions.myInstalledDistributions);
        }
        if (!distributionsBefore.equals(distributionsAfter)) {
            for (BiConsumer<Set<WSLDistribution>, Set<WSLDistribution>> listener2 : this.myWslDistributionsChangeListeners) {
                listener2.accept((Set<WSLDistribution>)distributionsBefore, (Set<WSLDistribution>)distributionsAfter);
            }
        }
        List<WSLDistribution> list4 = cachedDistributions.myInstalledDistributions;
        if (list4 == null) {
            WslDistributionManager.$$$reportNull$$$0(3);
        }
        return list4;
    }

    @ApiStatus.Internal
    public void addWslDistributionsChangeListener(@NotNull @NotNull BiConsumer<@NotNull Set<@NotNull WSLDistribution>, @NotNull Set<@NotNull WSLDistribution>> listener2) {
        if (listener2 == null) {
            WslDistributionManager.$$$reportNull$$$0(4);
        }
        this.myWslDistributionsChangeListeners.add(listener2);
    }

    @ApiStatus.Internal
    public void removeWslDistributionsChangeListener(@NotNull @NotNull BiConsumer<@NotNull Set<@NotNull WSLDistribution>, @NotNull Set<@NotNull WSLDistribution>> listener2) {
        if (listener2 == null) {
            WslDistributionManager.$$$reportNull$$$0(5);
        }
        if (!this.myWslDistributionsChangeListeners.remove(listener2)) {
            throw new IllegalArgumentException("The listener hasn't been registered: " + String.valueOf(listener2));
        }
    }

    @NotNull
    public CompletableFuture<List<WSLDistribution>> getInstalledDistributionsFuture() {
        if (!this.isAvailable()) {
            CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.completedFuture(List.of());
            if (completableFuture == null) {
                WslDistributionManager.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        CachedDistributions cachedDistributions = this.myInstalledDistributions;
        if (cachedDistributions != null && cachedDistributions.isUpToDate()) {
            CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.completedFuture(cachedDistributions.myInstalledDistributions);
            if (completableFuture == null) {
                WslDistributionManager.$$$reportNull$$$0(7);
            }
            return completableFuture;
        }
        CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.supplyAsync(this::getInstalledDistributions, AppExecutorUtil.getAppExecutorService());
        if (completableFuture == null) {
            WslDistributionManager.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    protected boolean isAvailable() {
        return WSLUtil.isSystemCompatible();
    }

    @NotNull
    public WSLDistribution getOrCreateDistributionByMsId(@NonNls @NotNull String msId) {
        if (msId == null) {
            WslDistributionManager.$$$reportNull$$$0(9);
        }
        return this.getOrCreateDistributionByMsId(msId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private WSLDistribution getOrCreateDistributionByMsId(@NonNls @NotNull String msId, boolean overrideCaseInsensitively) {
        if (msId == null) {
            WslDistributionManager.$$$reportNull$$$0(10);
        }
        if (msId.isEmpty()) {
            throw new IllegalArgumentException("WSL msId is empty");
        }
        WSLDistribution d = this.myMsIdToDistributionCache.get(msId);
        if (d == null || overrideCaseInsensitively && !d.getMsId().equals(msId)) {
            Map<String, WSLDistribution> map2 = this.myMsIdToDistributionCache;
            synchronized (map2) {
                d = this.myMsIdToDistributionCache.get(msId);
                if (d == null || overrideCaseInsensitively && !d.getMsId().equals(msId)) {
                    d = new WSLDistribution(msId);
                    this.myMsIdToDistributionCache.put(msId, d);
                }
            }
        }
        WSLDistribution wSLDistribution = d;
        if (wSLDistribution == null) {
            WslDistributionManager.$$$reportNull$$$0(11);
        }
        return wSLDistribution;
    }

    private @Unmodifiable @NotNull List<WSLDistribution> loadInstalledDistributions() {
        if (!this.isWslExeSupported()) {
            List<WSLDistribution> list2 = WSLUtil.getAvailableDistributions();
            if (list2 == null) {
                WslDistributionManager.$$$reportNull$$$0(12);
            }
            return list2;
        }
        if (Registry.is((String)"wsl.list.prefer.verbose.output", (boolean)true)) {
            List list3;
            try {
                List<WslDistributionAndVersion> result2 = this.loadInstalledDistributionsWithVersions();
                list3 = ContainerUtil.map(result2, data2 -> {
                    WSLDistribution distribution = this.getOrCreateDistributionByMsId(data2.getDistributionName(), true);
                    distribution.setVersion(data2.getVersion());
                    return distribution;
                });
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.error((Throwable)e);
            }
            if (list3 == null) {
                WslDistributionManager.$$$reportNull$$$0(13);
            }
            return list3;
        }
        List list4 = ContainerUtil.map(this.loadInstalledDistributionMsIds(), msId -> this.getOrCreateDistributionByMsId((String)msId, true));
        if (list4 == null) {
            WslDistributionManager.$$$reportNull$$$0(14);
        }
        return list4;
    }

    protected boolean isWslExeSupported() {
        Long windowsBuild = SystemInfo.getWinBuildNumber();
        if (windowsBuild != null && windowsBuild > 0L && windowsBuild < 19041L) {
            WSLUtil.WSLToolFlags wslTool = WSLUtil.getWSLToolFlags();
            return wslTool != null && (wslTool.isVerboseFlagAvailable || wslTool.isQuietFlagAvailable);
        }
        return true;
    }

    @NotNull
    protected abstract List<String> loadInstalledDistributionMsIds();

    @NotNull
    public abstract List<WslDistributionAndVersion> loadInstalledDistributionsWithVersions() throws IOException, IllegalStateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionManager";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributionsFuture";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDistributionByMsId";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstalledDistributions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addWslDistributionsChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeWslDistributionsChangeListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDistributionByMsId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private final class CachedDistributions {
        @NotNull
        private final List<WSLDistribution> myInstalledDistributions;
        private final long myExternalChangesCount;

        private CachedDistributions(List<WSLDistribution> installedDistributions) {
            if (installedDistributions == null) {
                CachedDistributions.$$$reportNull$$$0(0);
            }
            this.myInstalledDistributions = List.copyOf(installedDistributions);
            this.myExternalChangesCount = this.getCurrentExternalChangesCount();
        }

        public boolean isUpToDate() {
            ((WSLDistributionWatcher)((Object)WslDistributionManager.this.myDistributionWatcher.get())).scheduleUpdate();
            return this.getCurrentExternalChangesCount() == this.myExternalChangesCount;
        }

        private long getCurrentExternalChangesCount() {
            return ((WSLDistributionWatcher)((Object)WslDistributionManager.this.myDistributionWatcher.get())).getModificationCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedDistributions", "com/intellij/execution/wsl/WslDistributionManager$CachedDistributions", "<init>"));
        }
    }

    private static class WSLDistributionWatcher
    extends SimpleModificationTracker {
        private static final String DISTRO_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Lxss";
        private final Set<String> myCurrentGuids;
        private final Object LOCK;
        private final AtomicBoolean myIsActiveRequest;
        @NotNull
        private final Disposable myDisposable;

        private WSLDistributionWatcher(@NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                WSLDistributionWatcher.$$$reportNull$$$0(0);
            }
            this.myCurrentGuids = new HashSet<String>();
            this.LOCK = new Object();
            this.myIsActiveRequest = new AtomicBoolean();
            this.myDisposable = parentDisposable;
            this.updateDistroInfo();
        }

        public void scheduleUpdate() {
            if (this.myIsActiveRequest.compareAndSet(false, true)) {
                Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
                alarm.addRequest(() -> {
                    this.updateDistroInfo();
                    this.myIsActiveRequest.set(false);
                }, 500L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateDistroInfo() {
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)DISTRO_KEY)) {
                Set<String> guids = Set.of(Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)DISTRO_KEY));
                Object object = this.LOCK;
                synchronized (object) {
                    if (!this.myCurrentGuids.equals(guids)) {
                        this.incModificationCount();
                        this.myCurrentGuids.clear();
                        this.myCurrentGuids.addAll(guids);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/execution/wsl/WslDistributionManager$WSLDistributionWatcher", "<init>"));
        }
    }
}

