/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.project;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.actions.project.LoadModuleRenamingSchemeAction;
import com.intellij.ide.actions.project.LoadSaveModuleRenameMappingKt;
import com.intellij.ide.actions.project.ModuleNamesListInspection;
import com.intellij.ide.actions.project.SaveModuleRenamingSchemeAction;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModulePointerManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.JBColor;
import com.intellij.ui.MonospaceEditorCustomization;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020\u00162\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'J\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'J\b\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020\u0016H\u0014J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0014\u00a2\u0006\u0002\u0010/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "editorArea", "Lcom/intellij/ui/EditorTextField;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "modules", "", "Lcom/intellij/openapi/module/Module;", "recordPreviousNamesCheckBox", "Ljavax/swing/JCheckBox;", "modified", "", "show", "", "setupHighlighting", "editor", "Lcom/intellij/openapi/editor/Editor;", "customize", "Lcom/intellij/codeInspection/ex/InspectionProfileWrapper;", "createCenterPanel", "Ljavax/swing/JPanel;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "generateLineExtension", "", "Lcom/intellij/openapi/editor/LineExtensionInfo;", "line", "", "importRenamingScheme", "renamingScheme", "", "", "getRenamingScheme", "doCancelAction", "doOKAction", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nconvertModuleGroupsToQualifiedNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 convertModuleGroupsToQualifiedNames.kt\ncom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ModuleNamesListInspection.kt\ncom/intellij/ide/actions/project/ModuleNamesListInspection$Companion\n+ 6 storeUtil.kt\ncom/intellij/configurationStore/StoreUtilKt\n*L\n1#1,222:1\n9232#2,2:223\n9512#2,2:225\n9515#2:228\n1#3:227\n777#4:229\n873#4,2:230\n1266#4,4:232\n1849#4,3:238\n1924#4,2:242\n1926#4:254\n1220#4,2:259\n1249#4,4:261\n1915#4,2:265\n48#5,2:236\n50#5:241\n51#5,10:244\n61#5,4:255\n234#6,14:267\n*S KotlinDebug\n*F\n+ 1 convertModuleGroupsToQualifiedNames.kt\ncom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog\n*L\n133#1:223,2\n133#1:225,2\n133#1:228\n144#1:229\n144#1:230,2\n144#1:232,4\n168#1:238,3\n168#1:242,2\n168#1:254\n178#1:259,2\n178#1:261,4\n182#1:265,2\n168#1:236,2\n168#1:241\n168#1:244,10\n168#1:255,4\n186#1:267,14\n*E\n"})
public final class ConvertModuleGroupsToQualifiedNamesDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorTextField editorArea;
    private List<? extends Module> modules;
    @NotNull
    private final JCheckBox recordPreviousNamesCheckBox;
    private boolean modified;

    public ConvertModuleGroupsToQualifiedNamesDialog(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
        this.setTitle(ProjectBundle.message((String)"convert.module.groups.dialog.title", (Object[])new Object[0]));
        this.setModal(false);
        this.setOKButtonText(ProjectBundle.message((String)"convert.module.groups.button.text", (Object[])new Object[0]));
        EditorTextFieldProvider editorTextFieldProvider = EditorTextFieldProvider.getInstance();
        Language language = (Language)PlainTextLanguage.INSTANCE;
        Object[] objectArray = new EditorCustomization[2];
        objectArray[0] = arg_0 -> ConvertModuleGroupsToQualifiedNamesDialog._init_$lambda$0(this, arg_0);
        Intrinsics.checkNotNullExpressionValue((Object)MonospaceEditorCustomization.getInstance(), (String)"getInstance(...)");
        EditorTextField editorTextField = editorTextFieldProvider.getEditorField(language, this.project, CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
        this.editorArea = editorTextField;
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                modified = true;
            }
        }, this.getDisposable());
        this.recordPreviousNamesCheckBox = new JCheckBox(ProjectBundle.message((String)"convert.module.groups.record.previous.names.text", (Object[])new Object[0]), true);
        this.importRenamingScheme(MapsKt.emptyMap());
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final Document getDocument() {
        Document document2 = this.editorArea.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        return document2;
    }

    public void show() {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.getDocument());
        Intrinsics.checkNotNull((Object)psiFile2);
        InspectionProfileWrapper.runWithCustomInspectionWrapper((PsiFile)psiFile2, arg_0 -> ConvertModuleGroupsToQualifiedNamesDialog.show$lambda$1(arg_0 -> ConvertModuleGroupsToQualifiedNamesDialog.show$lambda$0(this, arg_0), arg_0), () -> ConvertModuleGroupsToQualifiedNamesDialog.show$lambda$2(this));
    }

    private final void setupHighlighting(Editor editor2) {
        editor2.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
    }

    private final InspectionProfileWrapper customize() {
        InspectionToolsSupplier.Simple inspections = new InspectionToolsSupplier.Simple(CollectionsKt.listOf((Object)new LocalInspectionToolWrapper((LocalInspectionTool)new ModuleNamesListInspection())));
        InspectionProfileImpl profile = new InspectionProfileImpl("Module names", (InspectionToolsSupplier)inspections, null);
        for (String spellCheckingToolName : SpellCheckingEditorCustomizationProvider.getInstance().getSpellCheckingToolNames()) {
            ToolsImpl toolsImpl = profile.getToolsOrNull(spellCheckingToolName, this.project);
            if (toolsImpl == null) continue;
            toolsImpl.setEnabled(false);
        }
        return new InspectionProfileWrapper(profile);
    }

    @NotNull
    protected JPanel createCenterPanel() {
        String string = XmlStringUtil.wrapInHtml((CharSequence)ProjectBundle.message((String)"convert.module.groups.description.text", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(...)");
        String text2 = string;
        ComponentPanelBuilder componentPanelBuilder = UI.PanelFactory.panel((JComponent)this.recordPreviousNamesCheckBox);
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
        String string2 = ProjectBundle.message((String)"convert.module.groups.record.previous.names.tooltip", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        JPanel recordPreviousNames = componentPanelBuilder.withTooltip(string2).createPanel();
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((int)0, (int)4).addToCenter((Component)((Object)this.editorArea)).addToTop((Component)new JBLabel(text2)).addToBottom((Component)recordPreviousNames);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToBottom(...)");
        return (JPanel)borderLayoutPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editorArea.getFocusTarget();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getFocusTarget(...)");
        return jComponent;
    }

    private final Collection<LineExtensionInfo> generateLineExtension(int line) {
        Object[] groupPath;
        block11: {
            block10: {
                boolean bl;
                String lineText = ((Object)this.getDocument().getCharsSequence().subSequence(this.getDocument().getLineStartOffset(line), this.getDocument().getLineEndOffset(line))).toString();
                if (0 <= line) {
                    List<? extends Module> list2 = this.modules;
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                        list2 = null;
                    }
                    bl = line < ((Collection)list2).size();
                } else {
                    bl = false;
                }
                if (!bl) break block10;
                List<? extends Module> list3 = this.modules;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                    list3 = null;
                }
                if (!Intrinsics.areEqual((Object)list3.get(line).getName(), (Object)lineText)) break block11;
            }
            return CollectionsKt.emptyList();
        }
        List<? extends Module> list4 = this.modules;
        if (list4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            list4 = null;
        }
        LineExtensionInfo name2 = new LineExtensionInfo(" <- " + list4.get(line).getName(), (Color)JBColor.GRAY, null, null, 0);
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
        List<? extends Module> list5 = this.modules;
        if (list5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            list5 = null;
        }
        if ((groupPath = moduleManager.getModuleGroupPath(list5.get(line))) == null) {
            return CollectionsKt.listOf((Object)name2);
        }
        String pathString = ArraysKt.joinToString$default((Object[])groupPath, (CharSequence)"/", (CharSequence)" (", (CharSequence)")", (int)0, null, null, (int)56, null);
        LineExtensionInfo group2 = new LineExtensionInfo(pathString, Color.GRAY, null, null, 0);
        Object[] objectArray = new LineExtensionInfo[]{name2, group2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void importRenamingScheme(@NotNull Map<String, String> renamingScheme) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(renamingScheme, (String)"renamingScheme");
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
        Module[] $this$associateBy$iv = moduleManager.getModules();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Module[] moduleArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void element$iv$iv;
            void var13_12 = element$iv$iv = $this$associateByTo$iv$iv[j];
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void var18_17 = it = element$iv$iv;
            boolean bl2 = false;
            Map<String, String> map3 = renamingScheme;
            String string = map3.get(it.getName());
            if (string == null) {
                boolean bl3 = false;
                string = ConvertModuleGroupsToQualifiedNamesDialog.importRenamingScheme$getDefaultName(moduleManager, (Module)it);
            }
            String string2 = string;
            map2.put(var18_17, string2);
        }
        Map names = destination$iv$iv;
        Comparator comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        this.modules = ArraysKt.sortedWith((Object[])moduleManager.getModules(), (Comparator)new Comparator(comparator, names){
            final /* synthetic */ Comparator $comparator;
            final /* synthetic */ Map $names$inlined;
            {
                this.$comparator = $comparator;
                this.$names$inlined = map2;
            }

            public final int compare(T a, T b) {
                Module it;
                Module module = (Module)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                V v = this.$names$inlined.get(it);
                Intrinsics.checkNotNull(v);
                it = (Module)b;
                String string = (String)v;
                bl = false;
                V v2 = this.$names$inlined.get(it);
                Intrinsics.checkNotNull(v2);
                String string2 = (String)v2;
                return comparator.compare(string, string2);
            }
        });
        ActionsKt.runWriteAction(() -> ConvertModuleGroupsToQualifiedNamesDialog.importRenamingScheme$lambda$4(this, names));
        this.modified = false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getRenamingScheme() {
        void var3_4;
        void $this$associateByTo$iv;
        void $this$filterTo$iv$iv;
        CharSequence charSequence = this.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        char[] cArray = new char[]{'\n'};
        List lines = StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        List<? extends Module> list2 = this.modules;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            list2 = null;
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((Iterable)list2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(lines.get(it.getIndex()), (Object)((Module)it.getValue()).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map destination$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            String string;
            IndexedValue indexedValue = (IndexedValue)element$iv;
            Map map2 = destination$iv;
            boolean bl = false;
            IndexedValue it = (IndexedValue)element$iv;
            String string2 = ((Module)it.getValue()).getName();
            boolean bl2 = false;
            int n = ((Collection)lines).size();
            int n2 = it.getIndex();
            boolean bl3 = 0 <= n2 ? n2 < n : false;
            if (bl3) {
                string = (String)lines.get(it.getIndex());
            } else {
                String string3 = ((Module)it.getValue()).getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            }
            String string4 = string;
            map2.put(string2, string4);
        }
        return var3_4;
    }

    public void doCancelAction() {
        if (this.modified) {
            int answer2 = Messages.showYesNoCancelDialog((Project)this.project, (String)ProjectBundle.message((String)"convert.module.groups.do.you.want.to.save.scheme", (Object[])new Object[0]), (String)ProjectBundle.message((String)"convert.module.groups.dialog.title", (Object[])new Object[0]), null);
            switch (answer2) {
                case 2: {
                    return;
                }
                case 0: {
                    if (LoadSaveModuleRenameMappingKt.saveModuleRenamingScheme(this)) break;
                    return;
                }
            }
        }
        super.doCancelAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doOKAction() {
        String s$iv;
        boolean bl;
        void $this$fold$iv$iv;
        void lines$iv;
        ModuleNamesListInspection.Companion companion = ModuleNamesListInspection.Companion;
        CharSequence charSequence = this.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        List list2 = StringsKt.lines((CharSequence)charSequence);
        Project project$iv = this.project;
        boolean $i$f$checkModuleNames = false;
        int n = ModuleManager.Companion.getInstance(project$iv).getModules().length;
        Iterable iterable = (Iterable)lines$iv;
        HashMap initial$iv$iv = new HashMap();
        boolean $i$f$fold = false;
        HashMap accumulator$iv$iv = initial$iv$iv;
        for (Object element$iv$iv : $this$fold$iv$iv) {
            String string = (String)element$iv$iv;
            HashMap map$iv = accumulator$iv$iv;
            bl = false;
            ((Map)map$iv).put(s$iv, ((Number)map$iv.getOrDefault(s$iv, 0)).intValue() + 1);
            accumulator$iv$iv = map$iv;
        }
        HashMap counts$iv = accumulator$iv$iv;
        Iterable $this$forEachIndexed$iv$iv = (Iterable)lines$iv;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            int element$iv$iv;
            if ((element$iv$iv = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            s$iv = (String)item$iv$iv;
            int line$iv = element$iv$iv;
            bl = false;
            if (((CharSequence)s$iv).length() == 0) {
                void message;
                String string = ProjectBundle.message((String)"module.name.inspection.empty.name.is.not.allowed", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                int line = line$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{line + 1, StringUtil.decapitalize((String)message)};
                Messages.showErrorDialog((Project)this.project, (String)ProjectBundle.message((String)"convert.module.groups.error.at.text", (Object[])objectArray), (String)CommonBundle.getErrorTitle());
                return;
            }
            Object v = counts$iv.get(s$iv);
            Intrinsics.checkNotNull(v);
            if (((Number)v).intValue() > 1) {
                Object[] objectArray = new Object[]{s$iv};
                String string = ProjectBundle.message((String)"module.name.inspection.duplicate.module.name", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                int line = line$iv;
                boolean bl3 = false;
                Object[] objectArray2 = new Object[]{line + 1, StringUtil.decapitalize((String)message)};
                Messages.showErrorDialog((Project)this.project, (String)ProjectBundle.message((String)"convert.module.groups.error.at.text", (Object[])objectArray2), (String)CommonBundle.getErrorTitle());
                return;
            }
            if (line$iv < n) continue;
            Object[] objectArray = new Object[]{n, line$iv + 1};
            String string = ProjectBundle.message((String)"module.name.inspection.too.many.lines", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            int line = line$iv;
            boolean bl4 = false;
            Object[] objectArray3 = new Object[]{line + 1, StringUtil.decapitalize((String)message)};
            Messages.showErrorDialog((Project)this.project, (String)ProjectBundle.message((String)"convert.module.groups.error.at.text", (Object[])objectArray3), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (lines$iv.size() < n) {
            int n2 = lines$iv.size();
            Object[] $i$f$forEachIndexed22 = new Object[]{n, lines$iv.size()};
            String string = ProjectBundle.message((String)"module.name.inspection.too.few.lines", (Object[])$i$f$forEachIndexed22);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            int line = n2;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{line + 1, StringUtil.decapitalize((String)message)};
            Messages.showErrorDialog((Project)this.project, (String)ProjectBundle.message((String)"convert.module.groups.error.at.text", (Object[])objectArray), (String)CommonBundle.getErrorTitle());
            return;
        }
        Map<String, String> renamingScheme = this.getRenamingScheme();
        if (!renamingScheme.isEmpty()) {
            void $this$associateByTo$iv$iv;
            ModifiableModuleModel model2 = ModuleManager.Companion.getInstance(this.project).getModifiableModel();
            List<? extends Module> list3 = this.modules;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                list3 = null;
            }
            Iterable $this$associateBy$iv = list3;
            boolean bl3 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$forEachIndexed22 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                s$iv = (Module)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl4 = false;
                map2.put(it.getName(), element$iv$iv);
            }
            Map byName = destination$iv$iv;
            for (Map.Entry entry : renamingScheme.entrySet()) {
                Object v = byName.get(entry.getKey());
                Intrinsics.checkNotNull(v);
                model2.renameModule((Module)v, (String)entry.getValue());
            }
            List<? extends Module> list4 = this.modules;
            if (list4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                list4 = null;
            }
            Iterable $this$forEach$iv = list4;
            boolean bl5 = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl6 = false;
                model2.setModuleGroupPath(it, null);
            }
            boolean isSaveAllowed$iv = false;
            boolean bl7 = false;
            ApplicationEx app$iv = ApplicationManagerEx.getApplicationEx();
            if (isSaveAllowed$iv == app$iv.isSaveAllowed()) {
                boolean bl8 = false;
                ActionsKt.runWriteAction(() -> ConvertModuleGroupsToQualifiedNamesDialog.doOKAction$lambda$3$0(model2));
                if (this.recordPreviousNamesCheckBox.isSelected()) {
                    ModulePointerManager modulePointerManager = ModulePointerManager.getInstance((Project)this.project);
                    Intrinsics.checkNotNull((Object)modulePointerManager, (String)"null cannot be cast to non-null type com.intellij.openapi.module.impl.ModulePointerManagerImpl");
                    ((ModulePointerManagerImpl)modulePointerManager).setRenamingScheme(renamingScheme);
                }
            } else {
                app$iv.setSaveAllowed(isSaveAllowed$iv);
                try {
                    boolean bl9 = false;
                    ActionsKt.runWriteAction(() -> ConvertModuleGroupsToQualifiedNamesDialog.doOKAction$lambda$3$0(model2));
                    if (this.recordPreviousNamesCheckBox.isSelected()) {
                        ModulePointerManager modulePointerManager = ModulePointerManager.getInstance((Project)this.project);
                        Intrinsics.checkNotNull((Object)modulePointerManager, (String)"null cannot be cast to non-null type com.intellij.openapi.module.impl.ModulePointerManagerImpl");
                        ((ModulePointerManagerImpl)modulePointerManager).setRenamingScheme(renamingScheme);
                    }
                }
                finally {
                    app$iv.setSaveAllowed(true);
                }
            }
            this.project.save();
        }
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[4];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
        actionArray[1] = new SaveModuleRenamingSchemeAction(this, (Function0<Unit>)((Function0)() -> ConvertModuleGroupsToQualifiedNamesDialog.createActions$lambda$0(this)));
        actionArray[2] = new LoadModuleRenamingSchemeAction(this);
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        return actionArray;
    }

    private static final void _init_$lambda$0(ConvertModuleGroupsToQualifiedNamesDialog this$0, EditorEx it) {
        EditorSettings editorSettings;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorSettings $this$lambda_u240_u240 = editorSettings = it.getSettings();
        boolean bl = false;
        $this$lambda_u240_u240.setLineNumbersShown(false);
        $this$lambda_u240_u240.setLineMarkerAreaShown(false);
        $this$lambda_u240_u240.setFoldingOutlineShown(false);
        $this$lambda_u240_u240.setRightMarginShown(false);
        $this$lambda_u240_u240.setAdditionalLinesCount(0);
        $this$lambda_u240_u240.setAdditionalColumnsCount(0);
        $this$lambda_u240_u240.setAdditionalPageAtBottom(false);
        $this$lambda_u240_u240.setShowIntentionBulb(false);
        EditorImpl editorImpl = it instanceof EditorImpl ? (EditorImpl)it : null;
        if (editorImpl != null) {
            editorImpl.registerLineExtensionPainter(this$0::generateLineExtension);
        }
        this$0.setupHighlighting(it);
    }

    private static final InspectionProfileWrapper show$lambda$0(ConvertModuleGroupsToQualifiedNamesDialog this$0, InspectionProfile it) {
        return this$0.customize();
    }

    private static final InspectionProfileWrapper show$lambda$1(Function1 $tmp0, Object p0) {
        return (InspectionProfileWrapper)$tmp0.invoke(p0);
    }

    private static final void show$lambda$2(ConvertModuleGroupsToQualifiedNamesDialog this$0) {
        super.show();
    }

    private static final CharSequence importRenamingScheme$lambda$4$0(Map $names, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = $names.get(it);
        Intrinsics.checkNotNull(v);
        return (CharSequence)v;
    }

    private static final String importRenamingScheme$getDefaultName(ModuleManager moduleManager, Module module) {
        Object object;
        block3: {
            block2: {
                object = moduleManager.getModuleGroupPath(module);
                if (object == null) break block2;
                Object[] it = object;
                boolean bl = false;
                String string = ArraysKt.joinToString$default((Object[])it, (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + ".";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return (String)object + module.getName();
    }

    private static final Unit importRenamingScheme$lambda$4(ConvertModuleGroupsToQualifiedNamesDialog this$0, Map $names) {
        Document document2 = this$0.getDocument();
        List<? extends Module> list2 = this$0.modules;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            list2 = null;
        }
        document2.setText((CharSequence)CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ConvertModuleGroupsToQualifiedNamesDialog.importRenamingScheme$lambda$4$0($names, arg_0), (int)30, null));
        return Unit.INSTANCE;
    }

    private static final Unit doOKAction$lambda$3$0(ModifiableModuleModel $model) {
        $model.commit();
        return Unit.INSTANCE;
    }

    private static final Unit createActions$lambda$0(ConvertModuleGroupsToQualifiedNamesDialog this$0) {
        this$0.modified = false;
        return Unit.INSTANCE;
    }
}

