/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Url;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a8\u0006\u000b"}, d2={"createRequest", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "isForceFileUrlIfNoUrlProvider", "", "chooseUrl", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/util/Url;", "urls", "", "intellij.platform.ide.impl"})
public final class BaseOpenInBrowserActionKt {
    private static final OpenInBrowserRequest createRequest(DataContext context2, boolean isForceFileUrlIfNoUrlProvider) {
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context2);
        if (editor2 == null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context2);
            VirtualFile virtualFile2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context2);
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
            if (virtualFile2 != null && !virtualFile2.isDirectory() && virtualFile2.isValid() && project2 != null && project2.isInitialized()) {
                psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile2);
            }
            if (psiFile != null) {
                return OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)((PsiElement)psiFile), (boolean)isForceFileUrlIfNoUrlProvider);
            }
        } else {
            Project project3 = editor2.getProject();
            if (project3 != null && project3.isInitialized()) {
                PsiFile psiFile;
                PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context2);
                if (psiFile2 == null) {
                    psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile(editor2.getDocument());
                }
                if ((psiFile = psiFile2) != null) {
                    return new OpenInBrowserRequest(psiFile, isForceFileUrlIfNoUrlProvider, editor2){
                        private final Lazy lazyElement$delegate;
                        {
                            this.lazyElement$delegate = LazyKt.lazy(() -> createRequest.1.lazyElement_delegate$lambda$0(this, $editor));
                        }

                        private final PsiElement getLazyElement() {
                            Lazy lazy = this.lazyElement$delegate;
                            return (PsiElement)lazy.getValue();
                        }

                        public PsiElement getElement() {
                            PsiElement psiElement = this.getLazyElement();
                            if (psiElement == null) {
                                psiElement = (PsiElement)this.getFile();
                            }
                            return psiElement;
                        }

                        private static final PsiElement lazyElement_delegate$lambda$0(createRequest.1 this$0, Editor $editor) {
                            return this$0.getFile().findElementAt($editor.getCaretModel().getOffset());
                        }
                    };
                }
            }
        }
        return null;
    }

    @NotNull
    public static final Promise<Url> chooseUrl(@NotNull Collection<? extends Url> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        if (urls.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)urls));
        }
        AsyncPromise result2 = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.toMutableList(urls)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> BaseOpenInBrowserActionKt.chooseUrl$lambda$1(BaseOpenInBrowserActionKt::chooseUrl$lambda$0, arg_0, arg_1, arg_2))).setTitle(IdeBundle.message((String)"browser.url.popup", (Object[])new Object[0])).setItemChosenCallback(arg_0 -> BaseOpenInBrowserActionKt.chooseUrl$lambda$3(arg_0 -> BaseOpenInBrowserActionKt.chooseUrl$lambda$2(result2, arg_0), arg_0)).createPopup().showInFocusCenter();
        return (Promise)result2;
    }

    private static final Unit chooseUrl$lambda$0(JBLabel label2, Url value, int n) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        label2.setIcon(AllIcons.Nodes.Servlet);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.util.Url");
        label2.setText(value.toDecodedForm());
        return Unit.INSTANCE;
    }

    private static final void chooseUrl$lambda$1(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final Unit chooseUrl$lambda$2(AsyncPromise $result, Url value) {
        $result.setResult((Object)value);
        return Unit.INSTANCE;
    }

    private static final void chooseUrl$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ OpenInBrowserRequest access$createRequest(DataContext context2, boolean isForceFileUrlIfNoUrlProvider) {
        return BaseOpenInBrowserActionKt.createRequest(context2, isForceFileUrlIfNoUrlProvider);
    }
}

