/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LinuxDragAndDropSupport {
    public static final DataFlavor uriListFlavor = FileCopyPasteUtil.createDataFlavor("text/uri-list", String.class);
    public static final DataFlavor gnomeFileListFlavor = FileCopyPasteUtil.createDataFlavor("x-special/gnome-copied-files", null, true);
    public static final DataFlavor kdeCutMarkFlavor = FileCopyPasteUtil.createDataFlavor("application/x-kde-cutselection", null, true);

    private LinuxDragAndDropSupport() {
    }

    @Nullable
    public static List<Path> getFiles(@NotNull Transferable transferable) throws IOException, UnsupportedFlavorException {
        if (transferable == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(0);
        }
        if (transferable.isDataFlavorSupported(uriListFlavor)) {
            Object transferData = transferable.getTransferData(uriListFlavor);
            return LinuxDragAndDropSupport.getFiles(transferData.toString());
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            Object transferData = transferable.getTransferData(gnomeFileListFlavor);
            String content2 = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
            return LinuxDragAndDropSupport.getFiles(content2);
        }
        return null;
    }

    @NotNull
    private static List<Path> getFiles(@Nullable String transferData) {
        if (transferData == null) {
            List<Path> list2 = Collections.emptyList();
            if (list2 == null) {
                LinuxDragAndDropSupport.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<Path> fileList = new ArrayList<Path>();
        for (String uriString : StringUtil.convertLineSeparators((String)transferData).split("\n")) {
            if (Strings.isEmptyOrSpaces((CharSequence)uriString) || uriString.startsWith("#") || !uriString.startsWith("file:/")) continue;
            try {
                URI uri = new URI(uriString);
                fileList.add(new File(uri).toPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        ArrayList<Path> arrayList = fileList;
        if (arrayList == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static String toUriList(@NotNull List<? extends File> files2) {
        if (files2 == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(3);
        }
        String string = StringUtil.join(files2, file2 -> file2.toURI().toString(), (String)"\n");
        if (string == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isMoveOperation(@NotNull Transferable transferable) {
        if (transferable == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(5);
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            try {
                Object transferData = transferable.getTransferData(gnomeFileListFlavor);
                String content2 = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
                return content2.startsWith("cut\n");
            }
            catch (Exception exception) {}
        } else if (transferable.isDataFlavorSupported(kdeCutMarkFlavor)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/LinuxDragAndDropSupport";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/LinuxDragAndDropSupport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toUriList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toUriList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMoveOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

