/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.laf.darcula.ui.AbstractToolbarComboUI;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.AbstractToolbarCombo;
import com.intellij.openapi.wm.impl.ToolbarComboButton;
import com.intellij.ui.ClickListener;
import com.intellij.ui.hover.HoverListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI;", "Lcom/intellij/ide/ui/laf/darcula/ui/AbstractToolbarComboUI;", "<init>", "()V", "clickListener", "Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$MyClickListener;", "hoverListener", "Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$MyHoverListener;", "setUIDefaults", "", "c", "Lcom/intellij/openapi/wm/impl/AbstractToolbarCombo;", "installUI", "Ljavax/swing/JComponent;", "uninstallUI", "paint", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "calcMaxTextWidth", "", "Lcom/intellij/openapi/wm/impl/ToolbarComboButton;", "paintRect", "Ljava/awt/Rectangle;", "paintBackground", "combo", "Companion", "MyClickListener", "MyHoverListener", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolbarComboButtonUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolbarComboButtonUI.kt\ncom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class ToolbarComboButtonUI
extends AbstractToolbarComboUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MyClickListener clickListener = new MyClickListener();
    @NotNull
    private final MyHoverListener hoverListener = new MyHoverListener();

    @Override
    protected void setUIDefaults(@NotNull AbstractToolbarCombo c) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.setUIDefaults(c);
            ToolbarComboButton toolbarComboButton = c instanceof ToolbarComboButton ? (ToolbarComboButton)c : null;
            if (toolbarComboButton == null) break block0;
            Insets insets = JBUI.CurrentTheme.MainToolbar.Dropdown.margin();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"margin(...)");
            toolbarComboButton.setMargin(insets);
        }
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarComboButton widget2 = (ToolbarComboButton)c;
        this.setUIDefaults(widget2);
        widget2.addPropertyChangeListener(this);
        this.tryUpdateHtmlRenderer(widget2, widget2.getText());
        this.hoverListener.addTo(widget2);
        this.clickListener.installOn(widget2);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarComboButton widget2 = (ToolbarComboButton)c;
        widget2.removePropertyChangeListener(this);
        this.tryUpdateHtmlRenderer(widget2, "");
        this.hoverListener.removeFrom(widget2);
        this.clickListener.uninstall(widget2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarComboButton toolbarComboButton = c instanceof ToolbarComboButton ? (ToolbarComboButton)c : null;
        if (toolbarComboButton == null) {
            return;
        }
        ToolbarComboButton combo2 = toolbarComboButton;
        this.paintBackground(g, combo2);
        List<Icon> leftIcons = combo2.getLeftIcons();
        List<Icon> rightIcons = combo2.getRightIcons();
        String text2 = combo2.getText();
        boolean bl2 = bl = !StringUtil.isEmpty((String)text2) || rightIcons.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ToolbarComboButtonUI$paint$22 = false;
            String $i$a$-assert-ToolbarComboButtonUI$paint$22 = "Right icons are only allowed when text is not empty";
            throw new AssertionError((Object)$i$a$-assert-ToolbarComboButtonUI$paint$22);
        }
        Rectangle innerRect = SwingUtilities.calculateInnerArea(c, null);
        Rectangle paintRect = new Rectangle(innerRect);
        JBInsets.removeFrom((Rectangle)paintRect, (Insets)((ToolbarComboButton)c).getMargin());
        int maxTextWidth = this.calcMaxTextWidth(combo2, paintRect);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            Object iconsRect;
            g2.clip(paintRect);
            GraphicsUtil.setupAAPainting((Graphics)g2);
            if (!leftIcons.isEmpty()) {
                iconsRect = this.paintIcons(leftIcons, combo2, g2, paintRect);
                this.cutLeft(paintRect, ((Rectangle)iconsRect).width);
            }
            if (!((iconsRect = (CharSequence)text2) == null || iconsRect.length() == 0) && maxTextWidth > 0) {
                if (!leftIcons.isEmpty()) {
                    this.cutLeft(paintRect, combo2.getIconTextGap());
                }
                Rectangle textRect = new Rectangle(paintRect.x, paintRect.y, maxTextWidth, paintRect.height);
                this.drawText((AbstractToolbarCombo)c, text2, g2, textRect);
                this.cutLeft(paintRect, maxTextWidth);
            }
            if (!rightIcons.isEmpty()) {
                this.cutLeft(paintRect, combo2.getIconTextGap());
                iconsRect = this.paintIcons(rightIcons, combo2, g2, paintRect);
                this.cutLeft(paintRect, ((Rectangle)iconsRect).width);
            }
            this.cutLeft(paintRect, 2);
            this.paintIcons(CollectionsKt.listOf((Object)AllIcons.General.ChevronDown), combo2, g2, paintRect);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        CharSequence charSequence;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarComboButton combo2 = (ToolbarComboButton)c;
        Dimension result2 = new Dimension();
        List<Icon> leftIcons = combo2.getLeftIcons();
        List<Icon> rightIcons = combo2.getRightIcons();
        String text2 = combo2.getText();
        CharSequence charSequence2 = text2;
        boolean bl2 = bl = !(charSequence2 == null || charSequence2.length() == 0) || rightIcons.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ToolbarComboButtonUI$getPreferredSize$22 = false;
            String $i$a$-assert-ToolbarComboButtonUI$getPreferredSize$22 = "Right icons are only allowed when text is not empty";
            throw new AssertionError((Object)$i$a$-assert-ToolbarComboButtonUI$getPreferredSize$22);
        }
        if (!leftIcons.isEmpty()) {
            result2.width += this.calcIconsWidth(leftIcons, combo2.getBetweenIconsGap());
            result2.height = leftIcons.stream().mapToInt(arg_0 -> ToolbarComboButtonUI.getPreferredSize$lambda$2(ToolbarComboButtonUI::getPreferredSize$lambda$1, arg_0)).max().orElse(0);
        }
        if (!((charSequence = (CharSequence)combo2.getText()) == null || charSequence.length() == 0)) {
            if (!leftIcons.isEmpty()) {
                result2.width += combo2.getIconTextGap();
            }
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            String text3 = this.getText(combo2);
            result2.width += UIUtil.computeStringWidth((JComponent)c, (FontMetrics)metrics, (String)text3);
            result2.height = Math.max(result2.height, metrics.getHeight());
        }
        if (!rightIcons.isEmpty()) {
            result2.width += combo2.getIconTextGap();
            result2.width += this.calcIconsWidth(rightIcons, combo2.getBetweenIconsGap());
            int metrics = result2.height;
            int text3 = rightIcons.stream().mapToInt(arg_0 -> ToolbarComboButtonUI.getPreferredSize$lambda$4(ToolbarComboButtonUI::getPreferredSize$lambda$3, arg_0)).max().orElse(0);
            result2.height = Math.max(metrics, text3);
        }
        result2.width += 2 + AllIcons.General.ChevronDown.getIconWidth();
        result2.height = Math.max(result2.height, AllIcons.General.ChevronDown.getIconHeight());
        Insets insets = c.getInsets();
        Insets margin = ((ToolbarComboButton)c).getMargin();
        Function0<Integer> heightSupplier = combo2.getPreferredHeightSupplier$intellij_platform_ide_impl();
        if (heightSupplier != null) {
            result2.height = RangesKt.coerceAtLeast((int)result2.height, (int)(((Number)heightSupplier.invoke()).intValue() - margin.top - margin.bottom));
        }
        result2.height += insets.top + insets.bottom + margin.top + margin.bottom;
        result2.width += insets.left + insets.right + margin.left + margin.right;
        return result2;
    }

    private final int calcMaxTextWidth(ToolbarComboButton c, Rectangle paintRect) {
        int otherElementsWidth = 0;
        int left = this.calcIconsWidth(c.getLeftIcons(), c.getBetweenIconsGap());
        if (left > 0) {
            left += c.getIconTextGap();
        }
        otherElementsWidth += left;
        int right = this.calcIconsWidth(c.getRightIcons(), c.getBetweenIconsGap());
        if (right > 0) {
            right += c.getIconTextGap();
        }
        otherElementsWidth += right;
        return paintRect.width - (otherElementsWidth += 2 + AllIcons.General.ChevronDown.getIconWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintBackground(Graphics g, ToolbarComboButton combo2) {
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        try {
            if (combo2.isOpaque()) {
                g2.setColor(combo2.getBackground());
                Rectangle bounds = g2.getClipBounds();
                g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            Rectangle innerRect = SwingUtilities.calculateInnerArea(combo2, null);
            int arc = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc().get();
            Function1 innerRectPainter = arg_0 -> ToolbarComboButtonUI.paintBackground$lambda$0(g2, innerRect, arc, arg_0);
            Color color = combo2.getHighlightBackground();
            if (color != null) {
                innerRectPainter.invoke((Object)color);
            }
            if (combo2.isEnabled() && combo2.getModel().isSelected()) {
                Color hoverBackground;
                Color color2 = hoverBackground = ProjectWindowCustomizerService.Companion.getInstance().isActive() ? combo2.getTransparentHoverBackground() : combo2.getHoverBackground();
                if (color2 != null) {
                    innerRectPainter.invoke((Object)color2);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private static final int getPreferredSize$lambda$1(Icon it) {
        return it.getIconHeight();
    }

    private static final int getPreferredSize$lambda$2(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int getPreferredSize$lambda$3(Icon it) {
        return it.getIconHeight();
    }

    private static final int getPreferredSize$lambda$4(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final Unit paintBackground$lambda$0(Graphics2D $g2, Rectangle $innerRect, int $arc, Color bg) {
        Intrinsics.checkNotNullParameter((Object)bg, (String)"bg");
        $g2.setColor(bg);
        $g2.fillRoundRect($innerRect.x, $innerRect.y, $innerRect.width, $innerRect.height, $arc, $arc);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final ToolbarComboButtonUI createUI(@NotNull JComponent ignored) {
        return Companion.createUI(ignored);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$Companion;", "", "<init>", "()V", "createUI", "Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI;", "ignored", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ToolbarComboButtonUI createUI(@NotNull JComponent ignored) {
            Intrinsics.checkNotNullParameter((Object)ignored, (String)"ignored");
            return new ToolbarComboButtonUI();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$MyClickListener;", "Lcom/intellij/ui/ClickListener;", "<init>", "()V", "onClick", "", "e", "Ljava/awt/event/MouseEvent;", "clickCount", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nToolbarComboButtonUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolbarComboButtonUI.kt\ncom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$MyClickListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1915#2,2:225\n*S KotlinDebug\n*F\n+ 1 ToolbarComboButtonUI.kt\ncom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$MyClickListener\n*L\n204#1:225,2\n*E\n"})
    private static final class MyClickListener
    extends ClickListener {
        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Component component2 = e.getComponent();
            ToolbarComboButton toolbarComboButton = component2 instanceof ToolbarComboButton ? (ToolbarComboButton)component2 : null;
            if (toolbarComboButton != null) {
                ToolbarComboButton combo2 = toolbarComboButton;
                boolean bl = false;
                if (combo2.isEnabled()) {
                    ActionEvent ae = new ActionEvent(combo2, 0, null, System.currentTimeMillis(), e.getModifiersEx());
                    Iterable $this$forEach$iv = combo2.getModel().getActionListeners();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ActionListener listener2 = (ActionListener)element$iv;
                        boolean bl2 = false;
                        listener2.actionPerformed(ae);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarComboButtonUI$MyHoverListener;", "Lcom/intellij/ui/hover/HoverListener;", "<init>", "()V", "mouseEntered", "", "c", "Ljava/awt/Component;", "x", "", "y", "mouseExited", "mouseMoved", "intellij.platform.ide.impl"})
    private static final class MyHoverListener
    extends HoverListener {
        public void mouseEntered(@NotNull Component c, int x, int y) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Object object = c instanceof ToolbarComboButton ? (ToolbarComboButton)c : null;
                if (object == null || (object = ((ToolbarComboButton)object).getModel()) == null) break block0;
                object.setSelected(true);
            }
        }

        public void mouseExited(@NotNull Component c) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Object object = c instanceof ToolbarComboButton ? (ToolbarComboButton)c : null;
                if (object == null || (object = ((ToolbarComboButton)object).getModel()) == null) break block0;
                object.setSelected(false);
            }
        }

        public void mouseMoved(@NotNull Component c, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        }
    }
}

