/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.impl.ApplicationNotificationsModel;
import com.intellij.notification.impl.ApplicationNotificationsModelKt;
import com.intellij.notification.impl.ProjectNotificationsModelListener;
import com.intellij.notification.impl.StatusMessage;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u001a\u0010\u0014\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0006J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\n\u0010\u001b\u001a\u00060\rj\u0002`\u000eJ\u001a\u0010\u001c\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0006J$\u0010\u001d\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0013\u0012\b\u0012\u00060\rj\u0002`\u000e0\u001e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u001f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010 \u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010!\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010$\u001a\u00020#H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/notification/impl/ProjectNotificationsModel;", "", "<init>", "()V", "myNotifications", "", "Lcom/intellij/notification/Notification;", "unreadNotifications", "listener", "Lcom/intellij/notification/impl/ProjectNotificationsModelListener;", "statusMessage", "Lcom/intellij/notification/impl/StatusMessage;", "register", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "newListener", "appInitNotifications", "", "addNotification", "notification", "getUnreadNotifications", "isEmptyContent", "", "getNotifications", "appNotifications", "markAllRead", "remove", "expireAll", "Lkotlin/Pair;", "clearTimeline", "clearAll", "getStatusMessage", "setStatusMessage", "", "fireStateChanged", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nApplicationNotificationsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationNotificationsModel.kt\ncom/intellij/notification/impl/ProjectNotificationsModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
final class ProjectNotificationsModel {
    @NotNull
    private final List<Notification> myNotifications = new ArrayList();
    @NotNull
    private final List<Notification> unreadNotifications = new ArrayList();
    @Nullable
    private ProjectNotificationsModelListener listener;
    @Nullable
    private StatusMessage statusMessage;

    @NotNull
    public final Runnable register(@NotNull Project project2, @NotNull ProjectNotificationsModelListener newListener, @NotNull List<? extends Notification> appInitNotifications) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newListener, (String)"newListener");
        Intrinsics.checkNotNullParameter(appInitNotifications, (String)"appInitNotifications");
        List $this$register_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$register_u24lambda_u240.addAll((Collection)appInitNotifications);
        $this$register_u24lambda_u240.addAll((Collection)this.myNotifications);
        List initNotifications = CollectionsKt.build((List)list2);
        this.myNotifications.clear();
        this.listener = newListener;
        return () -> ProjectNotificationsModel.register$lambda$1(newListener, initNotifications, this, project2);
    }

    @NotNull
    public final Runnable addNotification(@NotNull Project project2, @NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        this.myNotifications.add(notification2);
        this.unreadNotifications.add(notification2);
        ProjectNotificationsModelListener listener2 = this.listener;
        return () -> ProjectNotificationsModel.addNotification$lambda$0(listener2, notification2, this, project2);
    }

    @NotNull
    public final List<Notification> getUnreadNotifications() {
        return CollectionsKt.toList((Iterable)this.unreadNotifications);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmptyContent() {
        if (this.listener == null) return true;
        ProjectNotificationsModelListener projectNotificationsModelListener = this.listener;
        Intrinsics.checkNotNull((Object)projectNotificationsModelListener);
        if (!projectNotificationsModelListener.isEmpty()) return false;
        return true;
    }

    @NotNull
    public final List<Notification> getNotifications(@NotNull List<? extends Notification> appNotifications) {
        Intrinsics.checkNotNullParameter(appNotifications, (String)"appNotifications");
        if (this.listener == null) {
            ArrayList notifications = new ArrayList(appNotifications);
            notifications.addAll(this.myNotifications);
            return notifications;
        }
        ProjectNotificationsModelListener projectNotificationsModelListener = this.listener;
        Intrinsics.checkNotNull((Object)projectNotificationsModelListener);
        return projectNotificationsModelListener.getNotifications();
    }

    @NotNull
    public final Runnable markAllRead() {
        this.unreadNotifications.clear();
        ProjectNotificationsModelListener listener2 = this.listener;
        return () -> ProjectNotificationsModel.markAllRead$lambda$0(listener2, this);
    }

    @NotNull
    public final Runnable remove(@NotNull Project project2, @NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        this.myNotifications.remove(notification2);
        this.unreadNotifications.remove(notification2);
        ProjectNotificationsModelListener listener2 = this.listener;
        return () -> ProjectNotificationsModel.remove$lambda$0(listener2, notification2, this, project2);
    }

    @NotNull
    public final Pair<List<Notification>, Runnable> expireAll(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List notifications = CollectionsKt.toList((Iterable)this.myNotifications);
        this.myNotifications.clear();
        this.unreadNotifications.clear();
        ProjectNotificationsModelListener listener2 = this.listener;
        return TuplesKt.to((Object)notifications, () -> ProjectNotificationsModel.expireAll$lambda$0(listener2, this, project2));
    }

    @NotNull
    public final Runnable clearTimeline(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CollectionsKt.removeAll(this.myNotifications, ProjectNotificationsModel::clearTimeline$lambda$0);
        CollectionsKt.removeAll(this.unreadNotifications, ProjectNotificationsModel::clearTimeline$lambda$1);
        ProjectNotificationsModelListener listener2 = this.listener;
        return () -> ProjectNotificationsModel.clearTimeline$lambda$2(project2, listener2, this);
    }

    @NotNull
    public final Runnable clearAll(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.myNotifications.clear();
        this.unreadNotifications.clear();
        ProjectNotificationsModelListener listener2 = this.listener;
        return () -> ProjectNotificationsModel.clearAll$lambda$0(project2, listener2, this);
    }

    @Nullable
    public final StatusMessage getStatusMessage() {
        return this.statusMessage;
    }

    private final void setStatusMessage(Project project2, Notification notification2) {
        StatusMessage statusMessage;
        block6: {
            block5: {
                if (this.statusMessage == null && notification2 == null) break block5;
                if (this.statusMessage == null) break block6;
                StatusMessage statusMessage2 = this.statusMessage;
                Intrinsics.checkNotNull((Object)statusMessage2);
                if (statusMessage2.notification() != notification2) break block6;
            }
            return;
        }
        if (notification2 == null) {
            statusMessage = null;
        } else {
            String string = NotificationsUtil.buildStatusMessage(notification2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildStatusMessage(...)");
            statusMessage = new StatusMessage(notification2, string, notification2.getTimestamp());
        }
        this.statusMessage = statusMessage;
        StatusBar.Info.set((String)"", (Project)project2, (String)"Internal notification event requestor");
    }

    private final void fireStateChanged() {
        ((ApplicationNotificationsModel.StateEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ApplicationNotificationsModel.STATE_CHANGED)).stateChanged();
    }

    private static final void register$lambda$1(ProjectNotificationsModelListener $newListener, List $initNotifications, ProjectNotificationsModel this$0, Project $project) {
        $newListener.add($initNotifications);
        this$0.setStatusMessage($project, (Notification)CollectionsKt.lastOrNull((List)$initNotifications));
        this$0.fireStateChanged();
    }

    private static final void addNotification$lambda$0(ProjectNotificationsModelListener $listener, Notification $notification, ProjectNotificationsModel this$0, Project $project) {
        ProjectNotificationsModelListener projectNotificationsModelListener = $listener;
        if (projectNotificationsModelListener != null) {
            projectNotificationsModelListener.add($notification);
        }
        this$0.setStatusMessage($project, $notification);
        this$0.fireStateChanged();
    }

    private static final void markAllRead$lambda$0(ProjectNotificationsModelListener $listener, ProjectNotificationsModel this$0) {
        ProjectNotificationsModelListener projectNotificationsModelListener = $listener;
        if (projectNotificationsModelListener != null) {
            projectNotificationsModelListener.clearUnreadStates();
        }
        this$0.fireStateChanged();
    }

    private static final void remove$lambda$0(ProjectNotificationsModelListener $listener, Notification $notification, ProjectNotificationsModel this$0, Project $project) {
        Object v3;
        block3: {
            List leftOverNotifications;
            ProjectNotificationsModelListener projectNotificationsModelListener = $listener;
            if (projectNotificationsModelListener != null) {
                projectNotificationsModelListener.remove($notification);
            }
            ProjectNotificationsModelListener projectNotificationsModelListener2 = $listener;
            List list2 = projectNotificationsModelListener2 != null ? projectNotificationsModelListener2.getNotifications() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List list3 = leftOverNotifications = list2;
            ListIterator listIterator = list3.listIterator(list3.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                Notification it = (Notification)e;
                boolean bl = false;
                if (!(it.isImportant() || it.isImportantSuggestion())) continue;
                v3 = e;
                break block3;
            }
            v3 = null;
        }
        Notification newStatus = v3;
        this$0.setStatusMessage($project, newStatus);
        this$0.fireStateChanged();
    }

    private static final void expireAll$lambda$0(ProjectNotificationsModelListener $listener, ProjectNotificationsModel this$0, Project $project) {
        ProjectNotificationsModelListener projectNotificationsModelListener = $listener;
        if (projectNotificationsModelListener != null) {
            projectNotificationsModelListener.expireAll();
        }
        this$0.setStatusMessage($project, null);
        this$0.fireStateChanged();
    }

    private static final boolean clearTimeline$lambda$0(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSuggestionType();
    }

    private static final boolean clearTimeline$lambda$1(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSuggestionType();
    }

    private static final void clearTimeline$lambda$2(Project $project, ProjectNotificationsModelListener $listener, ProjectNotificationsModel this$0) {
        ApplicationNotificationsModelKt.access$closeAllBalloons($project);
        ProjectNotificationsModelListener projectNotificationsModelListener = $listener;
        if (projectNotificationsModelListener != null) {
            projectNotificationsModelListener.clearTimeline();
        }
        this$0.setStatusMessage($project, null);
        this$0.fireStateChanged();
    }

    private static final void clearAll$lambda$0(Project $project, ProjectNotificationsModelListener $listener, ProjectNotificationsModel this$0) {
        ApplicationNotificationsModelKt.access$closeAllBalloons($project);
        ProjectNotificationsModelListener projectNotificationsModelListener = $listener;
        if (projectNotificationsModelListener != null) {
            projectNotificationsModelListener.clearAll();
        }
        this$0.setStatusMessage($project, null);
        this$0.fireStateChanged();
    }
}

