/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PresentationFactory {
    private static final Key<Boolean> NEED_UPDATE_PRESENTATION = Key.create((String)"NEED_UPDATE_PRESENTATION");
    private final Map<AnAction, Presentation> myPresentations = CollectionFactory.createConcurrentWeakMap();
    private volatile boolean myNeedRebuild;
    private static final Collection<PresentationFactory> ourAllFactories = new WeakList();

    public PresentationFactory() {
        ourAllFactories.add(this);
    }

    @NotNull
    public final Presentation getPresentation(@NotNull AnAction action2) {
        boolean needUpdate;
        Presentation presentation2;
        if (action2 == null) {
            PresentationFactory.$$$reportNull$$$0(0);
        }
        if ((presentation2 = this.myPresentations.get(action2)) == null && action2 instanceof TransparentWrapper && action2 instanceof ActionWithDelegate) {
            ActionWithDelegate wrapper2 = (ActionWithDelegate)action2;
            presentation2 = this.myPresentations.get(wrapper2.getDelegate());
        }
        boolean bl = needUpdate = presentation2 != null && Boolean.TRUE.equals(presentation2.getClientProperty(NEED_UPDATE_PRESENTATION));
        if (presentation2 == null || needUpdate) {
            Presentation templatePresentation = action2.getTemplatePresentation();
            if (presentation2 == null) {
                presentation2 = templatePresentation.clone();
                presentation2 = Objects.requireNonNullElse(this.myPresentations.putIfAbsent(action2, presentation2), presentation2);
            }
            if (needUpdate) {
                presentation2.setIcon(templatePresentation.getIcon());
                presentation2.setDisabledIcon(templatePresentation.getDisabledIcon());
                presentation2.putClientProperty(NEED_UPDATE_PRESENTATION, null);
            }
            this.processPresentation(action2, presentation2);
        }
        Presentation presentation3 = presentation2;
        if (presentation3 == null) {
            PresentationFactory.$$$reportNull$$$0(1);
        }
        return presentation3;
    }

    @ApiStatus.Internal
    @NotNull
    public final Collection<AnAction> getActions() {
        Set<AnAction> set = Collections.unmodifiableSet(this.myPresentations.keySet());
        if (set == null) {
            PresentationFactory.$$$reportNull$$$0(2);
        }
        return set;
    }

    protected void processPresentation(@NotNull AnAction action2, @NotNull Presentation presentation2) {
        if (action2 == null) {
            PresentationFactory.$$$reportNull$$$0(3);
        }
        if (presentation2 == null) {
            PresentationFactory.$$$reportNull$$$0(4);
        }
        this.processPresentation(presentation2);
    }

    public void postProcessPresentation(@NotNull AnAction action2, @NotNull Presentation presentation2) {
        if (action2 == null) {
            PresentationFactory.$$$reportNull$$$0(5);
        }
        if (presentation2 == null) {
            PresentationFactory.$$$reportNull$$$0(6);
        }
    }

    @Deprecated(forRemoval=true)
    protected void processPresentation(@NotNull Presentation presentation2) {
        if (presentation2 == null) {
            PresentationFactory.$$$reportNull$$$0(7);
        }
    }

    public void reset() {
        this.myPresentations.clear();
        this.myNeedRebuild = true;
    }

    public boolean isNeedRebuild() {
        return this.myNeedRebuild;
    }

    public void resetNeedRebuild() {
        this.myNeedRebuild = false;
    }

    public static void clearPresentationCaches() {
        for (PresentationFactory factory2 : ourAllFactories) {
            factory2.reset();
        }
    }

    public static void updatePresentation(@NotNull AnAction action2) {
        if (action2 == null) {
            PresentationFactory.$$$reportNull$$$0(8);
        }
        for (PresentationFactory factory2 : ourAllFactories) {
            Presentation presentation2 = factory2.myPresentations.get(action2);
            if (presentation2 == null) continue;
            presentation2.putClientProperty(NEED_UPDATE_PRESENTATION, (Object)true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/PresentationFactory";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PresentationFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "postProcessPresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static interface TransparentWrapper {
    }
}

