/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.stickyLines.StickyLine;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.breadcrumbs.StickyLineInfo;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "forceCollectPass", "", "collectLines", "", "Lcom/intellij/ui/components/breadcrumbs/StickyLineInfo;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "applyLines", "psiFile", "Lcom/intellij/psi/PsiFile;", "lines", "stickyLinesModel", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;", "mergeWithExistingLines", "", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLine;", "stickyModel", "linesToAdd", "", "fileName", "", "ModStamp", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStickyLinesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StickyLinesCollector.kt\ncom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n60#2,5:205\n60#2,5:210\n13#2:216\n1#3:215\n*S KotlinDebug\n*F\n+ 1 StickyLinesCollector.kt\ncom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector\n*L\n110#1:205,5\n128#1:210,5\n178#1:216\n*E\n"})
public final class StickyLinesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private static final Logger LOG;

    public StickyLinesCollector(@NotNull Project project2, @NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        this.project = project2;
        this.document = document2;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    public final void forceCollectPass() {
        ThreadingAssertions.assertReadAccess();
        ThreadingAssertions.assertBackgroundThread();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getCachedPsiFile(this.document);
        if (psiFile != null) {
            ModStamp.INSTANCE.reset$intellij_platform_ide_impl(psiFile);
        } else if (LOG.isDebugEnabled()) {
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(this.document);
            String fileName = virtualFile2 != null ? virtualFile2.getName() : null;
            String string = fileName;
            if (string == null) {
                string = "UNKNOWN";
            }
            LOG.debug("cannot find psi file for " + string);
        }
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final Collection<StickyLineInfo> collectLines(@NotNull VirtualFile vFile, @NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        ThreadingAssertions.assertReadAccess();
        ThreadingAssertions.assertBackgroundThread();
        FileBreadcrumbsCollector collector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)this.project, (VirtualFile)vFile);
        Set infos = new HashSet();
        int lineCount = this.document.getLineCount();
        for (int line = 0; line < lineCount; ++line) {
            List stickyLineInfos;
            progress.checkCanceled();
            int endOffset = this.document.getLineEndOffset(line);
            Intrinsics.checkNotNullExpressionValue((Object)collector.computeStickyLineInfos(vFile, this.document, endOffset), (String)"computeStickyLineInfos(...)");
            infos.addAll(stickyLineInfos);
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("total lines collected: " + infos.size() + " for " + this.fileName(vFile), t$iv);
        }
        return infos;
    }

    @RequiresEdt
    public final void applyLines(@NotNull PsiFile psiFile, @NotNull Collection<StickyLineInfo> lines) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        ThreadingAssertions.assertEventDispatchThread();
        ModStamp.INSTANCE.update$intellij_platform_ide_impl(psiFile);
        StickyLinesModel stickyLinesModel = this.stickyLinesModel(psiFile);
        if (stickyLinesModel == null) {
            return;
        }
        StickyLinesModel stickyModel = stickyLinesModel;
        Set linesToAdd = new HashSet<StickyLineInfo>(lines);
        List<StickyLine> outdatedLines = this.mergeWithExistingLines(stickyModel, linesToAdd);
        for (StickyLine toRemove : outdatedLines) {
            stickyModel.removeStickyLine(toRemove);
        }
        for (StickyLineInfo toAdd : linesToAdd) {
            stickyModel.addStickyLine(toAdd.textOffset(), toAdd.endOffset(), toAdd.debugText());
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("total lines applied: " + lines.size() + ", new added: " + linesToAdd.size() + ", old removed: " + outdatedLines.size() + ", " + StickyLinesCollector.Companion.debugPsiFile(psiFile), t$iv);
        }
        stickyModel.notifyLinesUpdate();
    }

    private final StickyLinesModel stickyLinesModel(PsiFile psiFile) {
        StickyLinesModel stickyModel = StickyLinesModel.getModel(this.project, this.document);
        if (stickyModel == null) {
            ModStamp.INSTANCE.reset$intellij_platform_ide_impl(psiFile);
            LOG.error("sticky lines model does not exist while applying collected lines for " + StickyLinesCollector.Companion.debugPsiFile(psiFile));
            return null;
        }
        return stickyModel;
    }

    private final List<StickyLine> mergeWithExistingLines(StickyLinesModel stickyModel, Set<StickyLineInfo> linesToAdd) {
        List outdatedLines = new ArrayList();
        stickyModel.processStickyLines(StickyLinesModel.SourceID.IJ, (Processor<? super StickyLine>)((Processor)arg_0 -> StickyLinesCollector.mergeWithExistingLines$lambda$1(arg_0 -> StickyLinesCollector.mergeWithExistingLines$lambda$0(linesToAdd, outdatedLines, arg_0), arg_0)));
        return outdatedLines;
    }

    private final String fileName(VirtualFile vFile) {
        Object object;
        block3: {
            block2: {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.document);
                object = psiFile;
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                String string = StickyLinesCollector.Companion.debugPsiFile(it);
                object = string;
                if (string != null) break block3;
            }
            String string = vFile.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    private static final boolean mergeWithExistingLines$lambda$0(Set $linesToAdd, List $outdatedLines, StickyLine existingLine) {
        boolean keepExisting;
        Intrinsics.checkNotNullParameter((Object)existingLine, (String)"existingLine");
        TextRange existingRange = existingLine.textRange();
        boolean bl = keepExisting = existingRange.getLength() > 0 ? $linesToAdd.remove(new StickyLineInfo(existingRange)) : false;
        if (!keepExisting) {
            $outdatedLines.add(existingLine);
        }
        return true;
    }

    private static final boolean mergeWithExistingLines$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(StickyLinesCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "traceStampChanged", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "prevModStamp", "", "currModStamp", "(Lcom/intellij/psi/PsiFile;Ljava/lang/Long;J)Ljava/lang/String;", "debugPsiFile", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String traceStampChanged(PsiFile psiFile, Long prevModStamp, long currModStamp) {
            Long l = prevModStamp;
            long l2 = currModStamp;
            boolean isChanged = l == null || l != l2;
            String stamp = isChanged ? "prevStamp=" + prevModStamp + ", currStamp=" + currModStamp : "stamp=" + currModStamp;
            return "isChange=" + isChanged + ", " + stamp + ", " + this.debugPsiFile(psiFile);
        }

        private final String debugPsiFile(PsiFile psiFile) {
            String string = psiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            String psiFileId = Integer.toHexString(System.identityHashCode(psiFile));
            String documentId = Integer.toHexString(System.identityHashCode(psiFile.getFileDocument()));
            long psiFileStamp = psiFile.getModificationStamp();
            long documentStamp = psiFile.getFileDocument().getModificationStamp();
            return fileName + "[psiId=@" + psiFileId + ", psiStamp=" + psiFileStamp + ", docId=@" + documentId + ", docStamp=" + documentStamp + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector$ModStamp;", "", "<init>", "()V", "STICKY_LINES_MOD_STAMP_KEY", "Lcom/intellij/openapi/util/Key;", "", "STICKY_LINES_FIRST_PASS_FOR_EDITOR", "", "isChanged", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "update", "", "update$intellij_platform_ide_impl", "reset", "reset$intellij_platform_ide_impl", "modStamp", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nStickyLinesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StickyLinesCollector.kt\ncom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector$ModStamp\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n67#2,4:205\n67#2,4:209\n67#2,4:213\n67#2,4:217\n*S KotlinDebug\n*F\n+ 1 StickyLinesCollector.kt\ncom/intellij/openapi/editor/impl/stickyLines/StickyLinesCollector$ModStamp\n*L\n40#1:205,4\n49#1:209,4\n56#1:213,4\n61#1:217,4\n*E\n"})
    public static final class ModStamp {
        @NotNull
        public static final ModStamp INSTANCE = new ModStamp();
        @NotNull
        private static final Key<Long> STICKY_LINES_MOD_STAMP_KEY;
        @NotNull
        private static final Key<Boolean> STICKY_LINES_FIRST_PASS_FOR_EDITOR;

        private ModStamp() {
        }

        public final boolean isChanged(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
            boolean isFirstPass;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            boolean bl = isFirstPass = editor2.getUserData(STICKY_LINES_FIRST_PASS_FOR_EDITOR) == null;
            if (isFirstPass) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv;
                    boolean bl2 = false;
                    logger2.trace("first pass for editor " + Companion.debugPsiFile(psiFile));
                }
                editor2.putUserData(STICKY_LINES_FIRST_PASS_FOR_EDITOR, (Object)false);
                if (psiFile.getUserData(STICKY_LINES_MOD_STAMP_KEY) != null) {
                    this.reset$intellij_platform_ide_impl(psiFile);
                }
                return true;
            }
            Long prevModStamp = (Long)psiFile.getUserData(STICKY_LINES_MOD_STAMP_KEY);
            long currModStamp = this.modStamp(psiFile);
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger3 = $this$trace$iv;
                boolean bl3 = false;
                logger3.trace("checking modStamp: " + Companion.traceStampChanged(psiFile, prevModStamp, currModStamp));
            }
            Long l = prevModStamp;
            long l2 = currModStamp;
            return l == null || l != l2;
        }

        public final void update$intellij_platform_ide_impl(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            long modStamp = this.modStamp(psiFile);
            psiFile.putUserData(STICKY_LINES_MOD_STAMP_KEY, (Object)modStamp);
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("updating modStamp=" + modStamp + " for " + Companion.debugPsiFile(psiFile));
            }
        }

        public final void reset$intellij_platform_ide_impl(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            psiFile.putUserData(STICKY_LINES_MOD_STAMP_KEY, null);
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("resetting modStamp for " + Companion.debugPsiFile(psiFile));
            }
        }

        private final long modStamp(PsiFile psiFile) {
            return psiFile.getModificationStamp() + psiFile.getFileDocument().getModificationStamp();
        }

        static {
            Key key = Key.create((String)"editor.sticky.lines.mod.stamp");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            STICKY_LINES_MOD_STAMP_KEY = key;
            Key key2 = Key.create((String)"editor.sticky.lines.first.pass");
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
            STICKY_LINES_FIRST_PASS_FOR_EDITOR = key2;
        }
    }
}

