/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.ThreadContext;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.InternalThreading;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentManagerListenerBackgroundable;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFsConnectionListener;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeActionUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.TransferredWriteActionService;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FileDocumentManagerImpl
extends FileDocumentManagerBase
implements SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance(FileDocumentManagerImpl.class);
    public static final Key<Object> NOT_RELOADABLE_DOCUMENT_KEY = new Key("NOT_RELOADABLE_DOCUMENT_KEY");
    private static final Key<Boolean> FORCE_SAVE_DOCUMENT_KEY = new Key("FORCE_SAVE_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private final Set<Document> myUnsavedDocuments = ConcurrentCollectionFactory.createConcurrentSet();
    private final FileDocumentManagerListenerBackgroundableBridge bridge = new FileDocumentManagerListenerBackgroundableBridge();
    private final TrailingSpacesStripper myTrailingSpacesStripper;
    private boolean myOnClose;
    private volatile MemoryDiskConflictResolver myConflictResolver;
    private final PrioritizedDocumentListener myPhysicalDocumentChangeTracker;
    @Deprecated(forRemoval=true)
    public static boolean ourConflictsSolverEnabled = true;

    public FileDocumentManagerImpl() {
        this.myTrailingSpacesStripper = this.bridge.myTrailingSpacesStripper;
        this.myConflictResolver = new MemoryDiskConflictResolver();
        this.myPhysicalDocumentChangeTracker = new PrioritizedDocumentListener(){

            public int getPriority() {
                return Integer.MIN_VALUE;
            }

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document2 = e.getDocument();
                FileDocumentManagerImpl.this.markDocumentUnsaved(document2, false);
                if (PsiDocumentManagerBase.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                    FileDocumentManagerImpl.this.saveAllDocumentsLater();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$1", "documentChanged"));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(FileDocumentManagerListenerBackgroundable.TOPIC, (Object)this.bridge);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(this){

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                DocumentImpl.processQueue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$2", "pluginUnloaded"));
            }
        });
    }

    private static void unwrapAndRethrow(@NotNull Exception e) {
        if (e == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        Exception unwrapped = e;
        if (e instanceof InvocationTargetException) {
            unwrapped = e.getCause() == null ? e : e.getCause();
        }
        ExceptionUtil.rethrowUnchecked((Throwable)unwrapped);
        LOG.error((Throwable)unwrapped);
    }

    @ApiStatus.Internal
    public void markDocumentUnsaved(Document document2, boolean force) {
        if (!ExternalChangeActionUtil.isExternalDocumentChangeInProgress()) {
            this.myUnsavedDocuments.add(document2);
            if (force) {
                document2.putUserData(FORCE_SAVE_DOCUMENT_KEY, (Object)Boolean.TRUE);
            }
        }
    }

    @NotNull
    protected DocumentEx createDocument(@NotNull CharSequence text2, @NotNull VirtualFile file2) {
        if (text2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text2, (char)'\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(AbstractFileViewProvider.FREE_THREADED));
        DocumentImpl document2 = (DocumentImpl)EditorFactory.getInstance().createDocument(text2, acceptSlashR, freeThreaded);
        Project project2 = ProjectUtil.guessProjectForFile((VirtualFile)file2);
        int tabSize2 = project2 == null ? CodeStyle.getDefaultSettings().getTabSize(file2.getFileType()) : CodeStyle.getFacade((Project)project2, (Document)document2, (FileType)file2.getFileType()).getTabSize();
        document2.documentCreatedFrom(file2, tabSize2);
        DocumentImpl documentImpl = document2;
        if (documentImpl == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        return documentImpl;
    }

    @TestOnly
    @RequiresWriteLock
    public void dropAllUnsavedDocuments() {
        ThreadingAssertions.assertWriteAccess();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            for (Document document2 : this.myUnsavedDocuments) {
                VirtualFile file2 = this.getFile(document2);
                if (file2 == null) continue;
                this.unbindFileFromDocument(file2, document2);
                document2.putUserData(FORCE_SAVE_DOCUMENT_KEY, null);
            }
            this.myUnsavedDocuments.clear();
            ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).unsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> this.saveAllDocuments(false), ModalityState.nonModal());
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        this.saveDocuments(null, isExplicit);
    }

    public void saveDocuments(@NotNull Predicate<? super Document> filter2) {
        if (filter2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(4);
        }
        this.saveDocuments(filter2, true);
    }

    private void saveDocuments(@Nullable Predicate<? super Document> filter2, boolean isExplicit) {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        if (EDT.isCurrentThreadEdt()) {
            this.saveDocumentsOnEdt(isExplicit, filter2);
        } else {
            FileDocumentManagerImpl.runWithBackgroundWriteActionAllowed(() -> this.doSave(null, isExplicit, filter2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private void saveDocumentsOnEdt(boolean bl, @Nullable Predicate<? super Document> predicate) {
        PotemkinProgress p;
        ThreadingAssertions.assertEventDispatchThread();
        ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
        PotemkinProgress myProgress = current instanceof PotemkinProgress ? (p = (PotemkinProgress)current) : new PotemkinProgress("", null, null, null);
        myProgress.pushState();
        myProgress.setTitle(UIBundle.message((String)"file.save.all.document.dialog.title", (Object[])new Object[0]));
        try {
            if (current instanceof PotemkinProgress) {
                this.doSave(myProgress, (boolean)isExplicit, (Predicate<? super Document>)filter);
            } else {
                myProgress.runInSwingThread(() -> this.lambda$saveDocumentsOnEdt$2(myProgress, (boolean)isExplicit, (Predicate)filter));
            }
        }
        finally {
            myProgress.popState();
        }
    }

    @RequiresBackgroundThread
    private static void runWithBackgroundWriteActionAllowed(Runnable runnable2) {
        Runnable runnable3;
        ThreadingAssertions.assertBackgroundThread();
        ThreadContext.installThreadContext((CoroutineContext)ThreadContext.currentThreadContext().plus((CoroutineContext)InternalThreading.RunInBackgroundWriteActionMarker.INSTANCE), (boolean)true, () -> {
            runnable3.run();
            return Unit.INSTANCE;
        });
    }

    private void doSave(@Nullable PotemkinProgress myProgress, boolean isExplicit, @Nullable Predicate<? super Document> filter2) {
        int count;
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            if (myProgress != null) {
                myProgress.setIndeterminate(false);
            }
            int size2 = this.myUnsavedDocuments.size();
            for (Document document2 : this.myUnsavedDocuments) {
                VirtualFile virtualFile2;
                if (myProgress != null) {
                    myProgress.setFraction(1.0 * (double)count / (double)size2);
                }
                if ((virtualFile2 = this.getFile(document2)) != null && myProgress != null) {
                    myProgress.setText2(virtualFile2.getPresentableUrl());
                }
                if (filter2 != null && !filter2.test((Document)document2) || failedToSave.containsKey(document2) || vetoed.contains(document2)) continue;
                try {
                    this.doSaveDocument(document2, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document2, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document2);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        this.saveDocument(document2, true);
    }

    public void saveDocument(@NotNull Document document2, boolean explicit) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).beforeAnyDocumentSaving(document2, explicit);
        if (!this.myUnsavedDocuments.contains(document2)) {
            return;
        }
        if (EDT.isCurrentThreadEdt()) {
            this.saveDocumentInWriteSafeEnvironment(document2, explicit);
        } else {
            FileDocumentManagerImpl.runWithBackgroundWriteActionAllowed(() -> this.saveDocumentInWriteSafeEnvironment(document2, explicit));
        }
    }

    private void saveDocumentInWriteSafeEnvironment(@NotNull Document document2, boolean explicit) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        try {
            this.doSaveDocument(document2, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document2, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        VirtualFile file2 = this.getFile(document2);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document2);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    private void doSaveDocument(@NotNull Document document2, boolean isExplicit) throws IOException, SaveVetoException {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        VirtualFile file2 = this.getFile(document2);
        if (LOG.isTraceEnabled()) {
            LOG.trace("saving: " + String.valueOf(file2));
        }
        if (file2 == null || !FileDocumentManagerImpl.isTrackable((VirtualFile)file2) || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document2);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            LOG.trace("  refreshing...");
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document2)) {
                return;
            }
        }
        if (!this.maySaveDocument(file2, document2, isExplicit)) {
            throw new SaveVetoException();
        }
        LOG.trace("  writing...");
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.doSaveDocumentInWriteAction(document2, file2);
            return null;
        });
        LOG.trace("  done");
        ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).afterDocumentSaved(document2);
    }

    private boolean maySaveDocument(@NotNull VirtualFile file2, @NotNull Document document2, boolean isExplicit) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(10);
        }
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        if (this.myConflictResolver.hasConflict(file2)) {
            return false;
        }
        for (FileDocumentSynchronizationVetoer vetoer : FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList()) {
            if (vetoer.maySaveDocument(document2, isExplicit)) continue;
            return false;
        }
        return true;
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document2, @NotNull VirtualFile file2) throws IOException {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(13);
        }
        if (!file2.isValid()) {
            this.removeFromUnsaved(document2);
            return;
        }
        if (!file2.equals(this.getFile(document2))) {
            FileDocumentManagerImpl.registerDocument((Document)document2, (VirtualFile)file2);
        }
        boolean saveNeeded = false;
        Exception ioException = null;
        try {
            saveNeeded = FileDocumentManagerImpl.isSaveNeeded(document2, file2);
        }
        catch (IOException | RuntimeException e) {
            ioException = e;
        }
        if (!saveNeeded) {
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> {
                if (document2 instanceof DocumentEx) {
                    DocumentEx docEx = (DocumentEx)document2;
                    docEx.setModificationStamp(file2.getModificationStamp());
                }
            });
            this.removeFromUnsaved(document2);
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> FileDocumentManagerImpl.updateModifiedProperty(file2));
            if (ioException instanceof IOException) {
                IOException ioe = (IOException)ioException;
                throw ioe;
            }
            if (ioException != null) {
                throw (RuntimeException)ioException;
            }
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).beforeDocumentSaving(document2);
            LOG.assertTrue(file2.isValid());
            String text2 = document2.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document2, file2);
            if (!lineSeparator.equals("\n")) {
                text2 = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
            }
            Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write((Project)project2, (VirtualFile)file2, (Object)((Object)this), (String)text2, (long)document2.getModificationStamp());
            this.myUnsavedDocuments.remove(document2);
            document2.putUserData(FORCE_SAVE_DOCUMENT_KEY, null);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document2));
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.bridge.myTrailingSpacesStripper.clearLineModificationFlags(document2));
        });
    }

    public static void updateModifiedProperty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(14);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            for (FileEditor editor2 : fileEditorManager.getAllEditorList(file2)) {
                if (!(editor2 instanceof TextEditorImpl)) continue;
                TextEditorImpl textImpl = (TextEditorImpl)editor2;
                textImpl.updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(15);
        }
        this.myUnsavedDocuments.remove(document2);
        document2.putUserData(FORCE_SAVE_DOCUMENT_KEY, null);
        ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).unsavedDocumentDropped(document2);
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document2));
    }

    private static boolean isSaveNeeded(@NotNull Document document2, @NotNull VirtualFile file2) throws IOException {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(17);
        }
        if (document2.getUserData(FORCE_SAVE_DOCUMENT_KEY) == Boolean.TRUE) {
            return true;
        }
        if (file2.getFileType().isBinary() || document2.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (VirtualFile)file2, (boolean)false, (boolean)false);
        return !Comparing.equal((CharSequence)document2.getCharsSequence(), (CharSequence)loaded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean needsRefresh(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(18);
        }
        if (!((fs = file2.getFileSystem()) instanceof NewVirtualFileSystem)) return false;
        NewVirtualFileSystem newFs = (NewVirtualFileSystem)fs;
        if (file2.getTimeStamp() == newFs.getTimeStamp(file2)) return false;
        return true;
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document2, @NotNull VirtualFile virtualFile2) {
        String lineSeparator;
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(19);
        }
        if (virtualFile2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(20);
        }
        if ((lineSeparator = virtualFile2.getDetectedLineSeparator()) == null) {
            lineSeparator = (String)document2.getUserData(LINE_SEPARATOR_KEY);
            if (lineSeparator == null) {
                Project project2;
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                Project project3 = project2 = commandProcessor.isCommandInProgress() ? commandProcessor.getCurrentCommandProject() : null;
                if (project2 == null) {
                    project2 = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile2);
                }
                CodeStyleSettings settings = project2 == null ? CodeStyle.getDefaultSettings() : CodeStyle.getSettings((Project)project2, (VirtualFile)virtualFile2);
                lineSeparator = settings.getLineSeparator();
                document2.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
            }
            assert (lineSeparator != null) : document2;
        }
        String string = lineSeparator;
        if (string == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project2) {
        String lineSeparator;
        String string = lineSeparator = file2 == null ? null : file2.getDetectedLineSeparator();
        if (lineSeparator == null) {
            CodeStyleSettings settings = project2 != null && file2 != null ? CodeStyle.getSettings((Project)project2, (VirtualFile)file2) : CodeStyle.getProjectOrDefaultSettings((Project)project2);
            lineSeparator = settings.getLineSeparator();
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(22);
        }
        return string2;
    }

    public boolean requestWriting(@NotNull Document document2, Project project2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(23);
        }
        return this.requestWritingStatus(document2, project2).hasWriteAccess();
    }

    @NotNull
    public FileDocumentManager.WriteAccessStatus requestWritingStatus(@NotNull Document document2, @Nullable Project project2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(24);
        }
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document2);
        if (project2 != null && file2 != null && file2.isValid()) {
            if (file2.getFileType().isBinary()) {
                FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
                if (writeAccessStatus == null) {
                    FileDocumentManagerImpl.$$$reportNull$$$0(25);
                }
                return writeAccessStatus;
            }
            ReadonlyStatusHandler.OperationStatus writableStatus = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(Collections.singletonList(file2));
            if (writableStatus.hasReadonlyFiles()) {
                return new FileDocumentManager.WriteAccessStatus(writableStatus.getReadonlyFilesMessage(), writableStatus.getHyperlinkListener());
            }
            assert (file2.isWritable()) : file2;
        }
        if (document2.isWritable()) {
            FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.WRITABLE;
            if (writeAccessStatus == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(26);
            }
            return writeAccessStatus;
        }
        document2.fireReadOnlyModificationAttempt();
        FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
        if (writeAccessStatus == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(27);
        }
        return writeAccessStatus;
    }

    public void reloadFiles(VirtualFile ... files2) {
        if (files2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(28);
        }
        for (VirtualFile file2 : files2) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    public Document @NotNull [] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(29);
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list2 = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list2.toArray(Document.EMPTY_ARRAY);
        if (documentArray == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(30);
        }
        return documentArray;
    }

    public boolean processUnsavedDocuments(Processor<? super Document> processor2) {
        for (Document doc : this.myUnsavedDocuments) {
            if (processor2.process((Object)doc)) continue;
            return false;
        }
        return true;
    }

    public boolean isDocumentUnsaved(@NotNull Document document2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(31);
        }
        return this.myUnsavedDocuments.contains(document2);
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        Document doc;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(32);
        }
        return (doc = this.getCachedDocument(file2)) != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(33);
        }
        if ("writable".equals(event.getPropertyName())) {
            VirtualFile file2 = event.getFile();
            Document document2 = this.getCachedDocument(file2);
            if (document2 != null) {
                ApplicationManager.getApplication().runWriteAction(ExternalChangeActionUtil.externalChangeAction(() -> document2.setReadOnly(!file2.isWritable())));
            }
        } else if ("name".equals(event.getPropertyName())) {
            VirtualFile file3 = event.getFile();
            Document document3 = this.getCachedDocument(file3);
            if (document3 == null) {
                return;
            }
            if (FileDocumentManagerImpl.isBinaryWithoutDecompiler((VirtualFile)file3)) {
                this.unbindFileFromDocument(file3, document3);
                FileDocumentManagerImpl.closeAllEditorsFor(file3);
                ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).afterDocumentUnbound(file3, document3);
            } else if ("FileContentUtilCore.saveOrReload".equals(event.getRequestor()) && FileDocumentManagerImpl.isBinaryWithDecompiler(file3)) {
                this.reloadFromDisk(document3);
            }
        }
    }

    private static void closeAllEditorsFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(34);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager.getInstance((Project)project2).closeFile(file2);
        }
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(35);
        }
        return (type = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(type) != null;
    }

    public void contentsChanged(@NotNull VFileContentChangeEvent event) {
        VirtualFile virtualFile2;
        Document document2;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(36);
        }
        boolean shouldTraceEvent = (document2 = this.getCachedDocument(virtualFile2 = event.getFile())) != null && LOG.isTraceEnabled();
        String eventMessage = null;
        if (shouldTraceEvent) {
            eventMessage = "content changed for " + String.valueOf(event.getFile()) + " with document stamp =  " + document2.getModificationStamp();
        }
        if (event.isFromSave()) {
            if (shouldTraceEvent) {
                eventMessage = eventMessage + " , dispatched from save";
                LOG.trace(eventMessage);
            }
            return;
        }
        if (document2 == null || FileDocumentManagerImpl.isBinaryWithDecompiler(virtualFile2)) {
            ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).fileWithNoDocumentChanged(virtualFile2);
        }
        if (document2 != null) {
            if (shouldTraceEvent) {
                eventMessage = eventMessage + " event old modification stamp = " + event.getOldModificationStamp() + ", is unsaved = " + this.isDocumentUnsaved(document2);
                LOG.trace(eventMessage);
            }
            if (document2.getModificationStamp() == event.getOldModificationStamp() || !this.isDocumentUnsaved(document2)) {
                this.reloadFromDisk(document2);
            }
        }
    }

    public void reloadFromDisk(@NotNull Document document2, @Nullable Project project2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(37);
        }
        ThreadContext.resetThreadContext(() -> {
            ThreadingAssertions.assertEventDispatchThread();
            VirtualFile file2 = this.getFile(document2);
            assert (file2 != null);
            if (!file2.isValid()) {
                return null;
            }
            if (!this.fireBeforeFileContentReload(file2, document2)) {
                return null;
            }
            boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document2, project2)};
            if (isReloadable[0]) {
                if (FileDocumentManagerImpl.isBinaryWithDecompiler(file2)) {
                    this.reloadFromDiskWithDecompiler(document2, project2, file2);
                } else {
                    CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(ExternalChangeActionUtil.externalDocumentChangeAction(() -> {
                        if (!FileDocumentManagerImpl.isBinaryWithoutDecompiler((VirtualFile)file2)) {
                            FileDocumentManagerImpl.setNewText(document2, project2, file2, vFile -> {
                                boolean tooLarge = FileUtilRt.isTooLarge((long)vFile.getLength());
                                CharSequence reloaded2 = tooLarge ? LoadTextUtil.loadText((VirtualFile)vFile, (int)FileDocumentManagerImpl.getPreviewCharCount((VirtualFile)vFile)) : LoadTextUtil.loadText((VirtualFile)vFile);
                                return reloaded2;
                            });
                        }
                    })), UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
                }
            }
            if (isReloadable[0]) {
                ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).fileContentReloaded(file2, document2);
            } else {
                this.unbindFileFromDocument(file2, document2);
                ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).fileWithNoDocumentChanged(file2);
                ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).afterDocumentUnbound(file2, document2);
            }
            this.myUnsavedDocuments.remove(document2);
            document2.putUserData(FORCE_SAVE_DOCUMENT_KEY, null);
            return null;
        });
    }

    private static void setNewText(@NotNull Document document2, @Nullable Project project2, @NotNull VirtualFile file2, @NotNull @NotNull Function<@NotNull VirtualFile, @NotNull CharSequence> loader) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(39);
        }
        if (loader == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(40);
        }
        LoadTextUtil.clearCharsetAutoDetectionReason((VirtualFile)file2);
        file2.setBOM(null);
        file2.setCharset(null, null, false);
        boolean wasWritable = document2.isWritable();
        document2.setReadOnly(false);
        boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document2, project2)};
        if (isReloadable[0]) {
            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
            CharSequence reloaded2 = loader.apply(file2);
            ((DocumentEx)document2).replaceText(reloaded2, file2.getModificationStamp());
            FileDocumentManagerImpl.setDocumentTooLarge((Document)document2, (boolean)tooLarge);
        }
        document2.setReadOnly(!wasWritable);
    }

    private void reloadFromDiskWithDecompiler(@NotNull Document document2, @Nullable Project project2, @NotNull VirtualFile file2) {
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(41);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(42);
        }
        CharSequence[] decompiledText = new CharSequence[]{null};
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        boolean finished = app.runWriteActionWithCancellableProgressInDispatchThread(UIBundle.message((String)"progress.decompiling.file", (Object[])new Object[]{file2.getName()}), project2, null, indicator2 -> {
            decompiledText[0] = LoadTextUtil.loadText((VirtualFile)file2);
        });
        if (!finished || decompiledText[0] == null) {
            this.unbindFileFromDocument(file2, document2);
            FileDocumentManagerImpl.closeAllEditorsFor(file2);
            ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).afterDocumentUnbound(file2, document2);
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(ExternalChangeActionUtil.externalDocumentChangeAction(() -> FileDocumentManagerImpl.setNewText(document2, project2, file2, vFile -> decompiledText[0]))), UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
    }

    private static boolean isReloadable(@NotNull VirtualFile file2, @NotNull Document document2, @Nullable Project project2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(43);
        }
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(44);
        }
        PsiFile cachedPsiFile = project2 == null ? null : PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(document2);
        return !(FileUtilRt.isTooLarge((long)file2.getLength()) && file2.getFileType().isBinary() || cachedPsiFile != null && !(cachedPsiFile instanceof PsiFileImpl) && !FileDocumentManagerImpl.isBinaryWithDecompiler(file2) || document2.getUserData(NOT_RELOADABLE_DOCUMENT_KEY) != null);
    }

    @TestOnly
    @ApiStatus.Internal
    public void setAskReloadFromDisk(@NotNull Disposable disposable, @NotNull MemoryDiskConflictResolver newProcessor) {
        if (disposable == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(45);
        }
        if (newProcessor == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(46);
        }
        MemoryDiskConflictResolver old = this.myConflictResolver;
        this.myConflictResolver = newProcessor;
        Disposer.register((Disposable)disposable, () -> {
            this.myConflictResolver = old;
        });
    }

    private void fileDeleted(@NotNull VirtualFile virtualFile2) {
        Document doc;
        if (virtualFile2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(47);
        }
        if ((doc = this.getCachedDocument(virtualFile2)) != null) {
            this.bridge.myTrailingSpacesStripper.documentDeleted(doc);
            this.unbindFileFromDocument(virtualFile2, doc);
            if (doc instanceof DocumentImpl) {
                DocumentImpl docImpl = (DocumentImpl)doc;
                docImpl.incrementModificationSequence();
                docImpl.setModificationStamp(LocalTimeCounter.currentTime());
            }
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(48);
        }
        if (virtualFile2.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile2.getFileType();
            virtualFile2.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    private boolean fireBeforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(49);
        }
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(50);
        }
        for (FileDocumentSynchronizationVetoer vetoer : FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList()) {
            try {
                if (vetoer.mayReloadFileContent(file2, document2)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).beforeFileContentReload(file2, document2);
        return true;
    }

    @NotNull
    private static List<FileDocumentManagerListener> getListeners() {
        List list2 = FileDocumentManagerListener.EP_NAME.getExtensionList();
        if (list2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(51);
        }
        return list2;
    }

    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(52);
        }
        ProjectManagerEx manager2 = ProjectManagerEx.getInstanceEx();
        for (Project project2 : manager2.getOpenProjects()) {
            FileViewProvider vp = PsiManagerEx.getInstanceEx((Project)project2).getFileManager().findCachedViewProvider(file2);
            if (vp == null) continue;
            return vp;
        }
        if (manager2.isDefaultProjectInitialized()) {
            return PsiManagerEx.getInstanceEx((Project)manager2.getDefaultProject()).getFileManager().findCachedViewProvider(file2);
        }
        return null;
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(53);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = (IOException)ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (Map.Entry<Document, IOException> entry : failures.entrySet()) {
            LOG.warn("file: " + String.valueOf(this.getFile(entry.getKey())), (Throwable)entry.getValue());
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            final String text2 = StringUtil.join(failures.values(), Throwable::getMessage, (String)"\n");
            DialogWrapper dialog2 = new DialogWrapper(null){
                {
                    super(arg0);
                    this.init();
                    this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
                }

                protected void createDefaultActions() {
                    super.createDefaultActions();
                    this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                    this.myOKAction.putValue("DefaultAction", null);
                    if (!FileDocumentManagerImpl.this.myOnClose) {
                        this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                    }
                }

                protected JComponent createCenterPanel() {
                    JPanel panel2 = new JPanel(new BorderLayout(0, 5));
                    panel2.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                    JTextPane area = new JTextPane();
                    area.setText(text2);
                    area.setEditable(false);
                    area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                    panel2.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                    return panel2;
                }
            };
            if (dialog2.showAndGet()) {
                for (Document document2 : failures.keySet()) {
                    this.reloadFromDisk(document2);
                }
            }
        });
    }

    protected void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(54);
        }
        if (document2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(55);
        }
        ((FileDocumentManagerListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListenerBackgroundable.TOPIC)).fileContentLoaded(file2, document2);
    }

    @NotNull
    protected DocumentListener getDocumentListener() {
        PrioritizedDocumentListener prioritizedDocumentListener = this.myPhysicalDocumentChangeTracker;
        if (prioritizedDocumentListener == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(56);
        }
        return prioritizedDocumentListener;
    }

    @TestOnly
    @ApiStatus.Internal
    @RequiresWriteLock
    public void prepareForNextTest() {
        ThreadingAssertions.assertWriteAccess();
        this.dropAllUnsavedDocuments();
        this.clearDocumentCache();
    }

    private /* synthetic */ void lambda$saveDocumentsOnEdt$2(PotemkinProgress myProgress, boolean isExplicit, Predicate filter2) {
        this.doSave(myProgress, isExplicit, filter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 21, 22, 25, 26, 27, 29, 30, 51, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 43: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 24: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProcessor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAndRethrow";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 3: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 51: 
            case 56: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveDocuments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentInWriteSafeEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "maySaveDocument";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocumentInWriteAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateModifiedProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeFromUnsaved";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSaveNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "needsRefresh";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparator";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "closeAllEditorsFor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithDecompiler";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setNewText";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDiskWithDecompiler";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isReloadable";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setAskReloadFromDisk";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "recomputeFileTypeIfNecessary";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeFileContentReload";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorsOnSave";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fileContentLoaded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 21, 22, 25, 26, 27, 29, 30, 51, 56 -> new IllegalStateException(string);
        };
    }

    static class FileDocumentManagerListenerBackgroundableBridge
    implements FileDocumentManagerListenerBackgroundable {
        private final FileDocumentManagerListener myMultiCaster;
        private final TrailingSpacesStripper myTrailingSpacesStripper = new TrailingSpacesStripper();

        private void multiCast(@NotNull Method method, Object[] args) {
            if (method == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(0);
            }
            try {
                method.invoke(ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentManagerListener.TOPIC), args);
            }
            catch (ClassCastException e) {
                LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
            for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
                try {
                    method.invoke((Object)listener2, args);
                }
                catch (Exception e) {
                    FileDocumentManagerImpl.unwrapAndRethrow(e);
                }
            }
            try {
                method.invoke((Object)this.myTrailingSpacesStripper, args);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
        }

        private static void invokeOnEdt(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(1);
            }
            if (EDT.isCurrentThreadEdt()) {
                runnable2.run();
            } else {
                ((TransferredWriteActionService)ApplicationManager.getApplication().getService(TransferredWriteActionService.class)).runOnEdtWithTransferredWriteActionAndWait(runnable2);
            }
        }

        FileDocumentManagerListenerBackgroundableBridge() {
            InvocationHandler handler2 = (__, method, args) -> {
                if (method.getDeclaringClass() != FileDocumentManagerListener.class) {
                    throw new UnsupportedOperationException(method.toString());
                }
                this.multiCast(method, args);
                return null;
            };
            this.myMultiCaster = (FileDocumentManagerListener)ReflectionUtil.proxy(FileDocumentManagerListener.class, (InvocationHandler)handler2);
        }

        public void beforeAllDocumentsSaving() {
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.beforeAllDocumentsSaving());
        }

        public void beforeAnyDocumentSaving(@NotNull Document document2, boolean explicit) {
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(2);
            }
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.beforeAnyDocumentSaving(document2, explicit));
        }

        public void beforeDocumentSaving(@NotNull Document document2) {
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(3);
            }
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.beforeDocumentSaving(document2));
        }

        public void beforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document2) {
            if (file2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(4);
            }
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(5);
            }
            this.myMultiCaster.beforeFileContentReload(file2, document2);
        }

        public void fileWithNoDocumentChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(6);
            }
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.fileWithNoDocumentChanged(file2));
        }

        public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document2) {
            if (file2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(7);
            }
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(8);
            }
            this.myMultiCaster.fileContentReloaded(file2, document2);
        }

        public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document2) {
            if (file2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(9);
            }
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(10);
            }
            this.myMultiCaster.fileContentLoaded(file2, document2);
        }

        public void unsavedDocumentDropped(@NotNull Document document2) {
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(11);
            }
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.unsavedDocumentDropped(document2));
        }

        public void unsavedDocumentsDropped() {
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.unsavedDocumentsDropped());
        }

        public void afterDocumentUnbound(@NotNull VirtualFile file2, @NotNull Document document2) {
            if (file2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(12);
            }
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(13);
            }
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.afterDocumentUnbound(file2, document2));
        }

        public void afterDocumentSaved(@NotNull Document document2) {
            if (document2 == null) {
                FileDocumentManagerListenerBackgroundableBridge.$$$reportNull$$$0(14);
            }
            FileDocumentManagerListenerBackgroundableBridge.invokeOnEdt(() -> this.myMultiCaster.afterDocumentSaved(document2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$FileDocumentManagerListenerBackgroundableBridge";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "multiCast";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeOnEdt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeAnyDocumentSaving";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentSaving";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileContentReload";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileWithNoDocumentChanged";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentReloaded";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentLoaded";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unsavedDocumentDropped";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterDocumentUnbound";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterDocumentSaved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }

    @ApiStatus.Internal
    static final class MyPersistentFsConnectionListener
    implements PersistentFsConnectionListener {
        MyPersistentFsConnectionListener() {
        }

        public void connectionOpen() {
            FileDocumentManager fileDocumentManager = (FileDocumentManager)ApplicationManager.getApplication().getServiceIfCreated(FileDocumentManager.class);
            if (fileDocumentManager instanceof FileDocumentManagerImpl) {
                FileDocumentManagerImpl impl = (FileDocumentManagerImpl)fileDocumentManager;
                impl.clearDocumentCache();
            }
        }
    }

    static final class MyAsyncFileListener
    implements AsyncFileListener {
        private final FileDocumentManagerImpl myFileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();

        MyAsyncFileListener() {
        }

        public AsyncFileListener.ChangeApplier prepareChange(final @NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyAsyncFileListener.$$$reportNull$$$0(0);
            }
            final ArrayList<VirtualFile> toRecompute = new ArrayList<VirtualFile>();
            final HashMap strongRefsToDocuments = new HashMap();
            final List contentChanges = ContainerUtil.findAll(events, VFileContentChangeEvent.class);
            for (VFileContentChangeEvent event : contentChanges) {
                long lastRecordedLength;
                ProgressManager.checkCanceled();
                VirtualFile virtualFile2 = event.getFile();
                if (virtualFile2 instanceof VirtualFileWithId && (lastRecordedLength = PersistentFS.getInstance().getLastRecordedLength(virtualFile2)) == 0L && FileTypeRegistry.getInstance().isFileOfType(virtualFile2, UnknownFileType.INSTANCE)) {
                    toRecompute.add(virtualFile2);
                }
                this.prepareForRangeMarkerUpdate(strongRefsToDocuments, virtualFile2);
            }
            return new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    for (VFileContentChangeEvent event : contentChanges) {
                        this.prepareForRangeMarkerUpdate(strongRefsToDocuments, event.getFile());
                        if (!ourConflictsSolverEnabled) continue;
                        myFileDocumentManager.myConflictResolver.beforeContentChange(event);
                    }
                    for (VirtualFile file2 : toRecompute) {
                        file2.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
                    }
                }

                public void afterVfsChange() {
                    block5: for (VFileEvent event : events) {
                        Objects.requireNonNull(event);
                        int n = 0;
                        block6: while (true) {
                            VFileEvent vFileEvent;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VFileContentChangeEvent.class, VFileDeleteEvent.class, VFilePropertyChangeEvent.class}, (Object)vFileEvent, n)) {
                                case 0: {
                                    VFileContentChangeEvent changeEvent = (VFileContentChangeEvent)vFileEvent;
                                    if (!changeEvent.getFile().isValid()) {
                                        n = 1;
                                        continue block6;
                                    }
                                    myFileDocumentManager.contentsChanged(changeEvent);
                                    continue block5;
                                }
                                case 1: {
                                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                                    myFileDocumentManager.fileDeleted(deleteEvent.getFile());
                                    continue block5;
                                }
                                case 2: {
                                    VFilePropertyChangeEvent propEvent = (VFilePropertyChangeEvent)vFileEvent;
                                    if (!propEvent.getFile().isValid()) {
                                        n = 3;
                                        continue block6;
                                    }
                                    myFileDocumentManager.propertyChanged(propEvent);
                                    continue block5;
                                }
                            }
                            break;
                        }
                    }
                    Reference.reachabilityFence(strongRefsToDocuments);
                }
            };
        }

        private void prepareForRangeMarkerUpdate(@NotNull Map<? super VirtualFile, ? super Document> strongRefsToDocuments, @NotNull VirtualFile virtualFile2) {
            Document document2;
            if (strongRefsToDocuments == null) {
                MyAsyncFileListener.$$$reportNull$$$0(1);
            }
            if (virtualFile2 == null) {
                MyAsyncFileListener.$$$reportNull$$$0(2);
            }
            if ((document2 = this.myFileDocumentManager.getCachedDocument(virtualFile2)) == null && DocumentImpl.areRangeMarkersRetainedFor((VirtualFile)virtualFile2)) {
                document2 = this.myFileDocumentManager.getDocument(virtualFile2);
            }
            if (document2 != null) {
                strongRefsToDocuments.put((VirtualFile)virtualFile2, (Document)document2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strongRefsToDocuments";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$MyAsyncFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareForRangeMarkerUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyProjectCloseHandler
    implements ProjectCloseHandler {
        MyProjectCloseHandler() {
        }

        public boolean canClose(@NotNull Project project2) {
            if (project2 == null) {
                MyProjectCloseHandler.$$$reportNull$$$0(0);
            }
            FileDocumentManagerImpl manager2 = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
            if (!manager2.myUnsavedDocuments.isEmpty()) {
                manager2.myOnClose = true;
                try {
                    manager2.saveAllDocuments();
                }
                finally {
                    manager2.myOnClose = false;
                }
            }
            return manager2.myUnsavedDocuments.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$MyProjectCloseHandler", "canClose"));
        }
    }
}

