/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.JetBrainsPermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.UpdateRequestParametersProvider;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.system.OS;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DefaultUpdateRequestParametersProvider
implements UpdateRequestParametersProvider {
    private static final NullableLazyValue<String> ourMachineId = NullableLazyValue.lazyNullable(() -> MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrainsUpdates"));

    @Override
    public void amendUpdateRequest(@NotNull Map<String, String> parameters) {
        LicensingFacade facade2;
        String machineId;
        if (parameters == null) {
            DefaultUpdateRequestParametersProvider.$$$reportNull$$$0(0);
        }
        parameters.put("build", ApplicationInfo.getInstance().getBuild().asString());
        OS os = OS.CURRENT;
        parameters.put("os", (os == OS.macOS ? "Mac OS X" : os.name()) + " " + os.version());
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            parameters.put("eap", "");
        }
        parameters.put("uid", JetBrainsPermanentInstallationID.get());
        if (!PropertiesComponent.getInstance().getBoolean("machine.id.disabled", false) && (machineId = (String)ourMachineId.getValue()) != null) {
            parameters.put("mid", machineId);
        }
        if (ExternalUpdateManager.ACTUAL != null) {
            String name2 = ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX ? "Toolbox" : ExternalUpdateManager.ACTUAL.toolName;
            parameters.put("manager", name2);
        }
        if ((facade2 = LicensingFacade.getInstance()) != null) {
            String userBucket;
            String metadata;
            String subType = facade2.subType;
            if (subType != null) {
                parameters.put("license", subType);
            }
            if ((metadata = facade2.metadata) != null) {
                parameters.put("metadata", metadata);
            }
            if ((userBucket = facade2.userBucket) != null) {
                parameters.put("userBucket", userBucket);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/openapi/updateSettings/impl/DefaultUpdateRequestParametersProvider", "amendUpdateRequest"));
    }
}

