/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponentKt;
import com.intellij.ide.plugins.newui.PluginNodeModelBuilderFactory;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InstallAndEnableTask
extends Task.Modal {
    private final Set<PluginId> myPluginIds;
    private final boolean myShowDialog;
    private final boolean mySelectAllInDialog;
    @Nullable
    private final ModalityState myModalityState;
    private final Runnable myOnSuccess;
    private final Set<PluginDownloader> myPlugins;
    @Nullable
    private List<PluginNode> myCustomPlugins;

    InstallAndEnableTask(@Nullable Project project2, @NotNull Set<PluginId> pluginIds, boolean showDialog, boolean selectAllInDialog, @Nullable ModalityState modalityState, @NotNull Runnable onSuccess) {
        if (pluginIds == null) {
            InstallAndEnableTask.$$$reportNull$$$0(0);
        }
        if (onSuccess == null) {
            InstallAndEnableTask.$$$reportNull$$$0(1);
        }
        super(project2, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true);
        this.myPlugins = new HashSet<PluginDownloader>();
        this.myPluginIds = pluginIds;
        this.myShowDialog = showDialog;
        this.mySelectAllInDialog = selectAllInDialog;
        this.myModalityState = modalityState;
        this.myOnSuccess = onSuccess;
    }

    public void run(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            InstallAndEnableTask.$$$reportNull$$$0(2);
        }
        try {
            List<PluginNode> marketplacePlugins = MarketplaceRequests.loadLastCompatiblePluginDescriptors(this.myPluginIds);
            this.myCustomPlugins = RepositoryHelper.loadPluginsFromCustomRepositories(indicator2, PluginNodeModelBuilderFactory.INSTANCE);
            ArrayList<PluginNode> descriptors2 = new ArrayList<PluginNode>(RepositoryHelper.mergePluginsFromRepositories(marketplacePlugins, this.myCustomPlugins, true));
            descriptors2.removeIf(descriptor2 -> !this.myPluginIds.contains(descriptor2.getPluginId()));
            if (this.myShowDialog) {
                MarketplaceRequests marketplace = MarketplaceRequests.getInstance();
                Set set = ContainerUtil.map2Set(descriptors2, descriptor2 -> descriptor2.getPluginId());
                for (IdeCompatibleUpdate update2 : MarketplaceRequests.getLastCompatiblePluginUpdate(set)) {
                    IdeaPluginDescriptor descriptor3;
                    int index = ContainerUtil.indexOf(descriptors2, d -> d.getPluginId().getIdString().equals(update2.getPluginId()));
                    if (index == -1 || !((descriptor3 = (IdeaPluginDescriptor)descriptors2.get(index)) instanceof PluginNode)) continue;
                    PluginNode node = (PluginNode)descriptor3;
                    node.setExternalPluginId(update2.getExternalPluginId());
                    node.setExternalUpdateId(update2.getExternalUpdateId());
                    node.setDescription(null);
                    PluginUiModelAdapter marketplaceModel = new PluginUiModelAdapter(node);
                    PluginUiModel pluginNode = marketplace.loadPluginDetails(marketplaceModel);
                    if (pluginNode == null) continue;
                    PluginDetailsPageComponentKt.loadAllPluginDetailsSync(marketplaceModel, pluginNode);
                    descriptors2.set(index, (PluginNode)pluginNode.getDescriptor());
                }
            }
            for (IdeaPluginDescriptor descriptor4 : PluginManagerCore.getPlugins()) {
                if (descriptor4.isEnabled() || !PluginManagerCore.isCompatible((IdeaPluginDescriptor)descriptor4) || !PluginManagementPolicy.getInstance().canInstallPlugin(descriptor4)) continue;
                descriptors2.add((PluginNode)descriptor4);
            }
            for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
                if (!this.myPluginIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                this.myPlugins.add(PluginDownloader.createDownloader(ideaPluginDescriptor));
            }
        }
        catch (Exception e) {
            Logger.getInstance(InstallAndEnableTask.class).info((Throwable)e);
        }
    }

    public void onSuccess() {
        if (this.myCustomPlugins == null) {
            return;
        }
        new PluginsAdvertiserDialog(this.myProject, this.myPlugins, this.myCustomPlugins, this.mySelectAllInDialog, this::runOnSuccess).doInstallPlugins(this.myShowDialog, this.myModalityState);
    }

    private void runOnSuccess(boolean onSuccess) {
        if (onSuccess) {
            this.myOnSuccess.run();
        }
    }

    public Set<PluginDownloader> getPlugins() {
        return this.myPlugins;
    }

    @Nullable
    public List<PluginNode> getCustomPlugins() {
        return this.myCustomPlugins;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/InstallAndEnableTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

