/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.IPersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.io.CleanableStorage;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface PersistentFSRecordsStorage
extends IPersistentFSRecordsStorage,
CleanableStorage,
AutoCloseable {
    public static final int NULL_ID = 0;
    public static final int MIN_VALID_ID = 1;

    public int allocateRecord() throws IOException;

    public void setAttributeRecordId(int var1, int var2) throws IOException;

    public int getAttributeRecordId(int var1) throws IOException;

    public int getParent(int var1) throws IOException;

    public void setParent(int var1, int var2) throws IOException;

    public int getNameId(int var1) throws IOException;

    public int updateNameId(int var1, int var2) throws IOException;

    public boolean setFlags(int var1, int var2) throws IOException;

    public long getLength(int var1) throws IOException;

    public boolean setLength(int var1, long var2) throws IOException;

    public long getTimestamp(int var1) throws IOException;

    public boolean setTimestamp(int var1, long var2) throws IOException;

    public int getModCount(int var1) throws IOException;

    public void markRecordAsModified(int var1) throws IOException;

    public int getContentRecordId(int var1) throws IOException;

    public boolean setContentRecordId(int var1, int var2) throws IOException;

    public @PersistentFS.Attributes int getFlags(int var1) throws IOException;

    public void cleanRecord(int var1) throws IOException;

    public long getTimestamp() throws IOException;

    public boolean wasClosedProperly() throws IOException;

    default public boolean wasAlwaysClosedProperly() throws IOException {
        return !this.getFlag(2);
    }

    public int getErrorsAccumulated() throws IOException;

    public void setErrorsAccumulated(int var1) throws IOException;

    public void setVersion(int var1) throws IOException;

    public int getVersion() throws IOException;

    public int getFlags() throws IOException;

    default public boolean getFlag(int flagMask) throws IOException {
        return (this.getFlags() & flagMask) != 0;
    }

    public boolean updateFlags(int var1, int var2) throws IOException;

    public int getGlobalModCount();

    @Override
    public int recordsCount();

    public int maxAllocatedID();

    public boolean isValidFileId(int var1);

    public boolean isDirty();

    public boolean processAllRecords(@NotNull FsRecordProcessor var1) throws IOException;

    public void force() throws IOException;

    @Override
    public void close() throws IOException;

    public void closeAndClean() throws IOException;

    @FunctionalInterface
    public static interface FsRecordProcessor {
        public void process(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);
    }
}

