/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.WindowManagerImplKt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FrameBoundsConverter {
    static final int MIN_WIDTH = 350;
    static final int MIN_HEIGHT = 150;

    @Nullable
    public static Rectangle convertFromDeviceSpaceAndFitToScreen(@NotNull Rectangle bounds) {
        if (bounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(0);
        }
        int tolerance = Registry.intValue((String)"ide.project.frame.screen.bounds.tolerance", (int)10);
        Rectangle b = bounds.getBounds();
        if (b.width < 350) {
            b.width = 350;
        }
        if (b.height < 150) {
            b.height = 150;
        }
        int centerX = b.x + b.width / 2;
        int centerY = b.y + b.height / 2;
        boolean scaleNeeded = FrameBoundsConverter.shouldConvert();
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle devBounds = gc.getBounds();
            if (scaleNeeded) {
                FrameBoundsConverter.scaleUp(devBounds, gc);
            }
            if (!devBounds.contains(centerX, centerY)) continue;
            if (scaleNeeded) {
                FrameBoundsConverter.scaleDown(b, gc);
            }
            Rectangle screen = ScreenUtil.getScreenRectangle((GraphicsConfiguration)gc);
            screen.x -= tolerance;
            screen.y -= tolerance;
            screen.width += tolerance;
            screen.height += tolerance;
            if (b.x < screen.x) {
                b.x = screen.x;
            }
            if (b.y < screen.y) {
                b.y = screen.y;
            }
            if (b.width > screen.width) {
                b.width = screen.width;
            }
            if (b.height > screen.height) {
                b.height = screen.height;
            }
            if (WindowManagerImplKt.IDE_FRAME_EVENT_LOG.isDebugEnabled()) {
                WindowManagerImplKt.IDE_FRAME_EVENT_LOG.debug("Found the screen " + String.valueOf(screen) + " for the loaded bounds " + String.valueOf(bounds));
            }
            return b;
        }
        if (WindowManagerImplKt.IDE_FRAME_EVENT_LOG.isDebugEnabled()) {
            WindowManagerImplKt.IDE_FRAME_EVENT_LOG.debug("Found no screen for the loaded bounds " + String.valueOf(bounds));
        }
        return null;
    }

    public static Rectangle convertToDeviceSpace(GraphicsConfiguration gc, @NotNull Rectangle bounds) {
        if (bounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(1);
        }
        Rectangle b = bounds.getBounds();
        if (FrameBoundsConverter.shouldConvert()) {
            try {
                FrameBoundsConverter.scaleUp(b, gc);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        return b;
    }

    private static boolean shouldConvert() {
        if (SystemInfoRt.isLinux || SystemInfoRt.isMac) {
            return false;
        }
        return JreHiDpiUtil.isJreHiDPIEnabled();
    }

    private static void scaleUp(@NotNull Rectangle bounds, @NotNull GraphicsConfiguration gc) {
        if (bounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(2);
        }
        if (gc == null) {
            FrameBoundsConverter.$$$reportNull$$$0(3);
        }
        FrameBoundsConverter.scale(bounds, gc.getBounds(), JBUIScale.sysScale((GraphicsConfiguration)gc));
    }

    static void scaleDown(@NotNull Rectangle bounds, @NotNull GraphicsConfiguration gc) {
        if (bounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(4);
        }
        if (gc == null) {
            FrameBoundsConverter.$$$reportNull$$$0(5);
        }
        float scale = JBUIScale.sysScale((GraphicsConfiguration)gc);
        assert (scale != 0.0f);
        FrameBoundsConverter.scale(bounds, gc.getBounds(), 1.0f / scale);
    }

    private static void scale(@NotNull Rectangle bounds, @NotNull Rectangle deviceBounds, float scale) {
        if (bounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(6);
        }
        if (deviceBounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(7);
        }
        int x = (int)Math.floor((float)deviceBounds.x + (float)(bounds.x - deviceBounds.x) * scale);
        int y = (int)Math.floor((float)deviceBounds.y + (float)(bounds.y - deviceBounds.y) * scale);
        bounds.setBounds(x, y, (int)Math.ceil((float)bounds.width * scale), (int)Math.ceil((float)bounds.height * scale));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceBounds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/FrameBoundsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convertFromDeviceSpaceAndFitToScreen";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToDeviceSpace";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "scaleUp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "scaleDown";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "scale";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

