/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ComponentUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

final class WindowShadowPainter
extends AbstractPainter {
    private static final ShadowPainter PAINTER = new ShadowPainter(AllIcons.Ide.Shadow.Top, AllIcons.Ide.Shadow.TopRight, AllIcons.Ide.Shadow.Right, AllIcons.Ide.Shadow.BottomRight, AllIcons.Ide.Shadow.Bottom, AllIcons.Ide.Shadow.BottomLeft, AllIcons.Ide.Shadow.Left, AllIcons.Ide.Shadow.TopLeft);
    private static final long MASK = 262209L;
    private static final AtomicReference<AWTEventListener> WINDOW_LISTENER = new AtomicReference<1>(new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            Object source;
            Object object = source = event == null ? null : event.getSource();
            if (source instanceof Window) {
                Container c = (Window)source;
                while (c instanceof Window && c instanceof RootPaneContainer) {
                    WindowShadowPainter painter;
                    Component pane2;
                    JRootPane root = ((RootPaneContainer)((Object)c)).getRootPane();
                    if (root != null && (pane2 = root.getGlassPane()) instanceof IdeGlassPaneImpl && (painter = (WindowShadowPainter)((IdeGlassPaneImpl)pane2).windowShadowPainter) != null && pane2 == painter.myComponent) {
                        List<Rectangle> shadows = painter.myShadows;
                        painter.myShadows = WindowShadowPainter.getShadows(pane2, c);
                        if (!Objects.equals(painter.myShadows, shadows)) {
                            pane2.repaint();
                        }
                    }
                    c = c.getParent();
                }
            }
        }
    });
    private List<Rectangle> myShadows;
    private Component myComponent;

    WindowShadowPainter() {
        AWTEventListener listener2 = WINDOW_LISTENER.getAndSet(null);
        if (listener2 != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 262209L);
        }
    }

    public boolean needsRepaint() {
        return true;
    }

    public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
        Window window;
        if (component2 == null) {
            WindowShadowPainter.$$$reportNull$$$0(0);
        }
        if (g == null) {
            WindowShadowPainter.$$$reportNull$$$0(1);
        }
        if ((window = ComponentUtil.getWindow((Component)component2)) != null) {
            List<Rectangle> shadows;
            if (this.myComponent != component2) {
                this.myComponent = component2;
                this.myShadows = WindowShadowPainter.getShadows(component2, window);
            }
            if ((shadows = this.myShadows) != null) {
                for (Rectangle bounds : shadows) {
                    PAINTER.paintShadow(component2, g, bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        }
    }

    private static List<Rectangle> getShadows(Component component2, Window window) {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, component2);
        return WindowShadowPainter.getShadows(null, point, window.getOwnedWindows());
    }

    private static List<Rectangle> getShadows(List<Rectangle> list2, Point point, Window ... windows) {
        if (windows != null) {
            for (Window window : windows) {
                Rectangle bounds = WindowShadowPainter.getShadowBounds(point, window);
                if (bounds != null) {
                    if (list2 == null) {
                        list2 = new ArrayList<Rectangle>();
                    }
                    list2.add(bounds);
                }
                list2 = WindowShadowPainter.getShadows(list2, point, window.getOwnedWindows());
            }
        }
        return list2;
    }

    private static Rectangle getShadowBounds(Point point, Window window) {
        Object property;
        RootPaneContainer container;
        JRootPane root;
        Dialog dialog2;
        Frame frame;
        if (!window.isShowing()) {
            return null;
        }
        if (!window.isDisplayable()) {
            return null;
        }
        if (window instanceof Frame && !(frame = (Frame)window).isUndecorated()) {
            return null;
        }
        if (window instanceof Dialog && !(dialog2 = (Dialog)window).isUndecorated()) {
            return null;
        }
        if (window instanceof RootPaneContainer && (root = (container = (RootPaneContainer)((Object)window)).getRootPane()) != null && (property = root.getClientProperty("Window.shadow")) instanceof Boolean && !((Boolean)property).booleanValue()) {
            return null;
        }
        Rectangle bounds = window.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        bounds.x -= AllIcons.Ide.Shadow.Left.getIconWidth() + point.x;
        bounds.y -= AllIcons.Ide.Shadow.Top.getIconHeight() + point.y;
        bounds.width += AllIcons.Ide.Shadow.Left.getIconWidth() + AllIcons.Ide.Shadow.Right.getIconWidth();
        bounds.height += AllIcons.Ide.Shadow.Top.getIconHeight() + AllIcons.Ide.Shadow.Bottom.getIconHeight();
        return bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "g";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/wm/impl/WindowShadowPainter";
        objectArray[2] = "executePaint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

