/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionGroupPanelWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentListener;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWelcomeScreen
extends JPanel
implements WelcomeScreen {
    @NonNls
    private static final String ROOT_ID = "root";
    protected final JBSlidingPanel slidingPanel = new JBSlidingPanel();

    protected AbstractWelcomeScreen() {
        super(new BorderLayout());
        this.slidingPanel.add(ROOT_ID, (Component)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WelcomeScreenComponentListener.COMPONENT_CHANGED, (Object)new MyWelcomeScreenComponentListener(this.slidingPanel));
    }

    public void dispose() {
    }

    public JComponent getWelcomePanel() {
        return this.slidingPanel;
    }

    private static final class MyWelcomeScreenComponentListener
    implements WelcomeScreenComponentListener {
        JBSlidingPanel slidingPanel;

        MyWelcomeScreenComponentListener(JBSlidingPanel slidingPanel) {
            this.slidingPanel = slidingPanel;
        }

        @Override
        public void attachComponent(@NotNull Component componentToShow, @Nullable Runnable onDone) {
            if (componentToShow == null) {
                MyWelcomeScreenComponentListener.$$$reportNull$$$0(0);
            }
            String name2 = MyWelcomeScreenComponentListener.generateOrGetName(componentToShow, this.slidingPanel);
            this.slidingPanel.add(name2, componentToShow);
            this.slidingPanel.getLayout().swipe((Container)this.slidingPanel, name2, JBCardLayout.SwipeDirection.FORWARD, onDone);
        }

        @Override
        public void detachComponent(@NotNull Component componentToDetach, @Nullable Runnable onDone) {
            if (componentToDetach == null) {
                MyWelcomeScreenComponentListener.$$$reportNull$$$0(1);
            }
            this.slidingPanel.swipe(AbstractWelcomeScreen.ROOT_ID, JBCardLayout.SwipeDirection.BACKWARD).doWhenDone(() -> {
                if (onDone != null) {
                    onDone.run();
                }
                this.slidingPanel.getLayout().removeLayoutComponent(componentToDetach);
                ActionGroupPanelWrapper.setTitle(WelcomeScreenComponentFactory.getApplicationTitle());
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.slidingPanel, true));
            });
        }

        private static String generateOrGetName(@NotNull Component show2, @NotNull JBSlidingPanel slidingPanel) {
            String componentName;
            if (show2 == null) {
                MyWelcomeScreenComponentListener.$$$reportNull$$$0(2);
            }
            if (slidingPanel == null) {
                MyWelcomeScreenComponentListener.$$$reportNull$$$0(3);
            }
            if (!Strings.isEmptyOrSpaces((CharSequence)(componentName = show2.getName()))) {
                return componentName;
            }
            return UniqueNameGenerator.generateUniqueName((String)"welcomeScreenSlidingPanel", s -> slidingPanel.getLayout().findComponentById(s) == null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentToShow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentToDetach";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "show";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slidingPanel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/AbstractWelcomeScreen$MyWelcomeScreenComponentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "attachComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "detachComponent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateOrGetName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

