/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MemTester {
    private static final Supplier<Boolean> ourMemTesterSupported = new SynchronizedClearableLazy(() -> {
        Object problem = SystemInfo.isWindows ? "Windows is not supported" : (SystemInfo.isMac ? MemTester.checkMemTester("memtester") : (SystemInfo.isUnix ? MemTester.checkMemTester("memtester") : "Platform unsupported: " + SystemInfo.OS_NAME));
        if (problem == null) {
            return true;
        }
        Logger.getInstance(MemTester.class).info("not supported: " + (String)problem);
        return false;
    });
    private static Boolean isRunning = false;

    private MemTester() {
    }

    public static boolean isSupported() {
        return ourMemTesterSupported.get();
    }

    private static String checkMemTester(String memtesterName) {
        Path memtester = PathManager.findBinFile((String)memtesterName);
        return memtester != null && Files.isExecutable(memtester) ? null : "not an executable file: " + String.valueOf(memtester);
    }

    public static void scheduleMemTester(String memSize, String iterations, String outputFilePath) throws IOException {
        if (isRunning.booleanValue()) {
            Logger.getInstance(MemTester.class).info("Memtester is running already, can't run twice");
            throw new IOException("Cannot start memtester application: already running.");
        }
        if (!SystemInfo.isMac && !SystemInfo.isUnix) {
            Logger.getInstance(MemTester.class).info("not supported on this system");
            throw new IOException("Cannot start memtester application: not supported.");
        }
        MemTester.startMemTesterOnMacAndUnix(memSize, iterations, outputFilePath);
    }

    private static void startMemTesterOnMacAndUnix(String memSize, String iterations, String outputFilePath) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(memSize);
        args.add(iterations);
        Collections.addAll(args, new String[0]);
        MemTester.runMemTester(new File(PathManager.getBinPath(), "memtester"), args, new File(outputFilePath));
    }

    private static void runMemTester(File memtesterFile, List<String> memtesterArgs, File outputFile) throws IOException {
        String memtester = memtesterFile.getPath();
        memtesterArgs.add(0, memtester);
        Logger.getInstance(MemTester.class).info("run memtester: " + String.valueOf(memtesterArgs));
        ProcessBuilder processBuilder = new ProcessBuilder(memtesterArgs);
        processBuilder.redirectOutput(outputFile);
        processBuilder.start();
        isRunning = true;
    }
}

