/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.EncryptionSupport;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0012\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/AesEncryptionSupport;", "Lcom/intellij/credentialStore/EncryptionSupport;", "key", "Ljava/security/Key;", "<init>", "(Ljava/security/Key;)V", "encrypt", "", "data", "decrypt", "Companion", "intellij.platform.credentialStore.impl"})
class AesEncryptionSupport
implements EncryptionSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key key;

    public AesEncryptionSupport(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AesEncryptionSupport.Companion.encrypt(data, this.key);
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AesEncryptionSupport.Companion.decrypt(data, this.key);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/AesEncryptionSupport$Companion;", "", "<init>", "()V", "encrypt", "", "message", "key", "Ljava/security/Key;", "decrypt", "data", "intellij.platform.credentialStore.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] encrypt(byte[] message, Key key) {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, key);
            byte[] body = cipher.doFinal(message, 0, message.length);
            byte[] iv = cipher.getIV();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4 + iv.length + body.length]);
            byteBuffer.putInt(iv.length);
            byteBuffer.put(iv);
            byteBuffer.put(body);
            byte[] byArray = byteBuffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            return byArray;
        }

        private final byte[] decrypt(byte[] data, Key key) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            int ivLength = byteBuffer.getInt();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, key, new IvParameterSpec(data, byteBuffer.position(), ivLength));
            int dataOffset = byteBuffer.position() + ivLength;
            byte[] byArray = cipher.doFinal(data, dataOffset, data.length - dataOffset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

