/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractExternalSystemLocalSettings<S extends State> {
    protected S state;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;

    protected AbstractExternalSystemLocalSettings(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull S state) {
        if (externalSystemId == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(1);
        }
        if (state == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(2);
        }
        this.myExternalSystemId = externalSystemId;
        this.myProject = project;
        this.state = state;
    }

    protected AbstractExternalSystemLocalSettings(@NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        if (externalSystemId == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(4);
        }
        this(externalSystemId, project, new State());
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        Map.Entry entry;
        if (linkedProjectPathsToForget == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(5);
        }
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects = ((State)this.state).availableProjects;
        Iterator<Object> it = projects.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey().getPath())) continue;
            it.remove();
        }
        if (!ContainerUtil.isEmpty(((State)this.state).recentTasks)) {
            it = ((State)this.state).recentTasks.iterator();
            while (it.hasNext()) {
                ExternalTaskExecutionInfo taskInfo = (ExternalTaskExecutionInfo)it.next();
                String path = taskInfo.getSettings().getExternalProjectPath();
                if (!linkedProjectPathsToForget.contains(path) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath(path, this.myExternalSystemId, this.myProject))) continue;
                it.remove();
            }
        }
        it = ((State)this.state).projectSyncType.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        Map<String, Long> modificationStamps = ((State)this.state).modificationStamps;
        for (String path : linkedProjectPathsToForget) {
            modificationStamps.remove(path);
        }
    }

    @NotNull
    public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> getAvailableProjects() {
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> map = ((State)this.state).availableProjects;
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(6);
        }
        return map;
    }

    public void setAvailableProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects) {
        if (projects == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(7);
        }
        ((State)this.state).availableProjects = projects;
    }

    @NotNull
    public @Unmodifiable List<ExternalTaskExecutionInfo> getRecentTasks() {
        List list = ContainerUtil.notNullize(((State)this.state).recentTasks);
        if (list == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Map<String, Long> getExternalConfigModificationStamps() {
        Map<String, Long> map = ((State)this.state).modificationStamps;
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public Map<String, SyncType> getProjectSyncType() {
        Map<String, SyncType> map = ((State)this.state).projectSyncType;
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(10);
        }
        return map;
    }

    @Nullable
    public S getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(11);
        }
        this.state = state;
        this.pruneOutdatedEntries();
    }

    public void invalidateCaches() {
        ((State)this.state).recentTasks.clear();
        ((State)this.state).availableProjects.clear();
        ((State)this.state).modificationStamps.clear();
        ((State)this.state).projectSyncType.clear();
    }

    private void pruneOutdatedEntries() {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(this.myExternalSystemId);
        assert (manager != null);
        HashSet<String> pathsToForget = new HashSet<String>();
        for (ExternalProjectPojo pojo : ((State)this.state).availableProjects.keySet()) {
            pathsToForget.add(pojo.getPath());
        }
        for (ExternalTaskExecutionInfo taskInfo : ContainerUtil.notNullize(((State)this.state).recentTasks)) {
            pathsToForget.add(taskInfo.getSettings().getExternalProjectPath());
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject);
        for (ExternalProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            pathsToForget.remove(projectSettings.getExternalProjectPath());
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule(this.myExternalSystemId, module)) continue;
            pathsToForget.remove(ExternalSystemApiUtil.getExternalProjectPath(module));
        }
        if (!pathsToForget.isEmpty()) {
            this.forgetExternalProjects(pathsToForget);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPathsToForget";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentTasks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalConfigModificationStamps";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSyncType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjects";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableProjects";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static class State {
        public final List<ExternalTaskExecutionInfo> recentTasks = new SmartList();
        public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> availableProjects = CollectionFactory.createSmallMemoryFootprintMap();
        public Map<String, Long> modificationStamps = CollectionFactory.createSmallMemoryFootprintMap();
        public Map<String, SyncType> projectSyncType = CollectionFactory.createSmallMemoryFootprintMap();
    }

    public static enum SyncType {
        PREVIEW,
        IMPORT,
        RE_IMPORT;

    }
}

