/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.MacKeymapUtil;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005H\u0002J'\u0010\u0011\u001a\u0019\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\tJ'\u0010\u0017\u001a\u0019\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J%\u0010\u001a\u001a\u0019\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0005J*\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00122\b\b\u0001\u0010\n\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000fJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0018\u0010\"\u001a\n #*\u0004\u0018\u00010\u00050\u00052\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0018\u0010$\u001a\n #*\u0004\u0018\u00010\u00050\u00052\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002J\f\u0010)\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/intellij/ide/ui/text/ShortcutsRenderingUtil;", "", "<init>", "()V", "SHORTCUT_PART_SEPARATOR", "", "getSHORTCUT_PART_SEPARATOR", "()Ljava/lang/String;", "getShortcutByActionId", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "actionId", "findCustomShortcut", "activeKeymap", "Lcom/intellij/openapi/keymap/Keymap;", "isNumpadKey", "", "(Lcom/intellij/openapi/actionSystem/KeyboardShortcut;)Z", "getKeyboardShortcutData", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/NlsSafe;", "", "Lkotlin/ranges/IntRange;", "shortcut", "getKeyStrokeData", "keyStroke", "Ljavax/swing/KeyStroke;", "getRawShortcutData", "getGotoActionData", "needLogIncorrectInput", "getModifiersText", "modifiers", "", "getKeyString", "code", "getLinuxWinKeyString", "kotlin.jvm.PlatformType", "getMacKeyString", "getPresentableModifier", "rawModifier", "getSimplifiedMacModifier", "modifier", "replaceSpacesWithNonBreakSpaces", "intellij.platform.ide"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nShortcutsRenderingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutsRenderingUtil.kt\ncom/intellij/ide/ui/text/ShortcutsRenderingUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,181:1\n4253#2,12:182\n1#3:194\n812#4,12:195\n1586#4:207\n1661#4,3:208\n1586#4:211\n1661#4,3:212\n742#4,9:216\n1586#4:225\n1661#4,3:226\n23#5:215\n*S KotlinDebug\n*F\n+ 1 ShortcutsRenderingUtil.kt\ncom/intellij/ide/ui/text/ShortcutsRenderingUtil\n*L\n37#1:182,12\n50#1:195,12\n64#1:207\n64#1:208,3\n97#1:211\n97#1:212,3\n138#1:216,9\n139#1:225\n139#1:226,3\n118#1:215\n*E\n"})
public final class ShortcutsRenderingUtil {
    @NotNull
    public static final ShortcutsRenderingUtil INSTANCE = new ShortcutsRenderingUtil();
    @NotNull
    private static final String SHORTCUT_PART_SEPARATOR = StringsKt.repeat((CharSequence)"\u00a0", (int)3);

    private ShortcutsRenderingUtil() {
    }

    @NotNull
    public final String getSHORTCUT_PART_SEPARATOR() {
        return SHORTCUT_PART_SEPARATOR;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KeyboardShortcut getShortcutByActionId(@Nullable String actionId) {
        KeyboardShortcut keyboardShortcut;
        Object v2;
        List kbShortcuts;
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            Shortcut[] shortcuts;
            if (actionId == null) {
                return null;
            }
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
            Keymap activeKeymap = keymap;
            KeyboardShortcut keyboardShortcut2 = this.findCustomShortcut(activeKeymap, actionId);
            if (keyboardShortcut2 != null) {
                KeyboardShortcut it = keyboardShortcut2;
                boolean bl = false;
                return it;
            }
            Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Shortcut[] $this$filterIsInstance$iv = shortcuts = shortcutArray;
            boolean $i$f$filterIsInstance = false;
            Shortcut[] shortcutArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            kbShortcuts = (List)destination$iv$iv;
            boolean bl = false;
            Iterable iterable = kbShortcuts;
            for (Object t : iterable) {
                KeyboardShortcut it = (KeyboardShortcut)t;
                boolean bl2 = false;
                if (!(!INSTANCE.isNumpadKey(it))) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        if ((keyboardShortcut = (KeyboardShortcut)v2) == null) {
            keyboardShortcut = (KeyboardShortcut)CollectionsKt.firstOrNull((List)kbShortcuts);
        }
        KeyboardShortcut bestShortcut = keyboardShortcut;
        return bestShortcut;
    }

    /*
     * WARNING - void declaration
     */
    private final KeyboardShortcut findCustomShortcut(Keymap activeKeymap, String actionId) {
        void $this$filterIsInstanceTo$iv$iv;
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        List currentShortcuts = ArraysKt.toList((Object[])shortcutArray);
        if (!activeKeymap.canModify()) {
            return null;
        }
        Object object = activeKeymap.getParent();
        if (object == null || (object = object.getShortcuts(actionId)) == null || (object = ArraysKt.toList((Object[])object)) == null) {
            return null;
        }
        Object parentShortcuts = object;
        List shortcuts = CollectionsKt.minus((Iterable)currentShortcuts, (Iterable)((Iterable)parentShortcuts));
        if (shortcuts.isEmpty()) {
            return null;
        }
        Iterable $this$filterIsInstance$iv = CollectionsKt.reversed((Iterable)shortcuts);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (KeyboardShortcut)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private final boolean isNumpadKey(KeyboardShortcut $this$isNumpadKey) {
        int n = $this$isNumpadKey.getFirstKeyStroke().getKeyCode();
        return (96 <= n ? n < 112 : false) || $this$isNumpadKey.getFirstKeyStroke().getKeyCode() == 144;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, List<IntRange>> getKeyboardShortcutData(@Nullable KeyboardShortcut shortcut) {
        void $this$mapTo$iv$iv;
        if (shortcut == null) {
            return new Pair((Object)"", (Object)CollectionsKt.emptyList());
        }
        Pair<String, List<IntRange>> firstKeyStrokeData = this.getKeyStrokeData(shortcut.getFirstKeyStroke());
        KeyStroke keyStroke = shortcut.getSecondKeyStroke();
        if (keyStroke == null) {
            return firstKeyStrokeData;
        }
        KeyStroke secondKeyStroke = keyStroke;
        Pair<String, List<IntRange>> secondKeyStrokeData = this.getKeyStrokeData(secondKeyStroke);
        String firstPartString = firstKeyStrokeData.getFirst() + SHORTCUT_PART_SEPARATOR + "," + SHORTCUT_PART_SEPARATOR;
        int firstPartLength = firstPartString.length();
        Iterable $this$map$iv = (Iterable)secondKeyStrokeData.getSecond();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntRange intRange = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IntRange(it.getFirst() + firstPartLength, it.getLast() + firstPartLength));
        }
        List shiftedList = (List)destination$iv$iv;
        return TuplesKt.to((Object)(firstPartString + secondKeyStrokeData.getFirst()), (Object)CollectionsKt.plus((Collection)((Collection)firstKeyStrokeData.getSecond()), (Iterable)shiftedList));
    }

    @NotNull
    public final Pair<String, List<IntRange>> getKeyStrokeData(@Nullable KeyStroke keyStroke) {
        if (keyStroke == null) {
            return new Pair((Object)"", (Object)CollectionsKt.emptyList());
        }
        List<String> modifiers = this.getModifiersText(keyStroke.getModifiers());
        String keyString = this.getKeyString(keyStroke.getKeyCode());
        List intervals = new ArrayList();
        StringBuilder builder = new StringBuilder();
        for (String m : modifiers) {
            ShortcutsRenderingUtil.getKeyStrokeData$addPart(builder, intervals, m);
            builder.append(SHORTCUT_PART_SEPARATOR);
        }
        ShortcutsRenderingUtil.getKeyStrokeData$addPart(builder, intervals, keyString);
        return new Pair((Object)builder.toString(), (Object)intervals);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, List<IntRange>> getRawShortcutData(@NotNull String shortcut) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        CharSequence charSequence = shortcut;
        Regex regex = new Regex(" *\\+ *");
        int n = 0;
        Iterable $this$map$iv = regex.split(charSequence, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPresentableModifier((String)p0));
        }
        List parts = (List)destination$iv$iv;
        StringBuilder builder = new StringBuilder();
        List ranges = new ArrayList();
        int curInd = 0;
        Iterator iterator = ((Iterable)parts).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int ind = n2++;
            String part = (String)iterator.next();
            builder.append(this.replaceSpacesWithNonBreakSpaces(part));
            ranges.add(RangesKt.until((int)curInd, (int)builder.length()));
            if (ind != CollectionsKt.getLastIndex((List)parts)) {
                builder.append(SHORTCUT_PART_SEPARATOR);
            }
            curInd = builder.length();
        }
        return TuplesKt.to((Object)builder.toString(), (Object)ranges);
    }

    @NotNull
    public final Pair<String, List<IntRange>> getGotoActionData(@NonNls @NotNull String actionId, boolean needLogIncorrectInput) {
        String string;
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            String string2 = action.getTemplatePresentation().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            string = this.replaceSpacesWithNonBreakSpaces(string2);
        } else {
            if (needLogIncorrectInput) {
                ShortcutsRenderingUtil $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ShortcutsRenderingUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to find action with id: " + actionId);
            }
            string = actionId;
        }
        String actionName = string;
        KeyboardShortcut gotoActionShortcut = this.getShortcutByActionId("GotoAction");
        Pair<String, List<IntRange>> gotoAction = this.getKeyboardShortcutData(gotoActionShortcut);
        ArrayList<IntRange> updated = new ArrayList<IntRange>((Collection)gotoAction.getSecond());
        int start2 = ((String)gotoAction.getFirst()).length() + 5;
        updated.add(new IntRange(start2, start2 + actionName.length() - 1));
        return new Pair((Object)(gotoAction.getFirst() + "  \u2192  " + actionName), updated);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getModifiersText(int modifiers) {
        void $this$mapTo$iv$iv;
        List list;
        String modifiersString = ClientSystemInfo.Companion.isMac() ? MacKeymapUtil.getModifiersText(modifiers, "+") : KeyEvent.getKeyModifiersText(modifiers);
        Intrinsics.checkNotNull((Object)modifiersString);
        CharSequence charSequence = modifiersString;
        Regex regex = new Regex("[ +]+");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPresentableModifier((String)p0));
        }
        return (List)destination$iv$iv;
    }

    private final String getKeyString(int code) {
        String string = switch (code) {
            case 37 -> "\u2190";
            case 39 -> "\u2192";
            case 38 -> "\u2191";
            case 40 -> "\u2193";
            case 92 -> "\\";
            default -> ClientSystemInfo.Companion.isMac() ? this.getMacKeyString(code) : this.getLinuxWinKeyString(code);
        };
        Intrinsics.checkNotNull((Object)string);
        return this.replaceSpacesWithNonBreakSpaces(string);
    }

    private final String getLinuxWinKeyString(int code) {
        return switch (code) {
            case 10 -> "Enter";
            case 8 -> "Backspace";
            default -> KeyEvent.getKeyText(code);
        };
    }

    private final String getMacKeyString(int code) {
        return switch (code) {
            case 10 -> "\u21a9 Return";
            case 8 -> "\u232b Del";
            case 27 -> "\u238b Esc";
            case 9 -> "\u21e5 Tab";
            case 16 -> "\u21e7 Shift";
            default -> KeyEvent.getKeyText(code);
        };
    }

    private final String getPresentableModifier(String rawModifier) {
        String modifier = KeymapUtil.isSimplifiedMacShortcuts() ? this.getSimplifiedMacModifier(rawModifier) : rawModifier;
        return this.replaceSpacesWithNonBreakSpaces(modifier);
    }

    private final String getSimplifiedMacModifier(String modifier) {
        return switch (modifier) {
            case "Ctrl" -> "\u2303 Ctrl";
            case "Alt" -> "\u2325 Opt";
            case "Shift" -> "\u21e7 Shift";
            case "Cmd" -> "\u2318 Cmd";
            default -> modifier;
        };
    }

    private final String replaceSpacesWithNonBreakSpaces(String $this$replaceSpacesWithNonBreakSpaces) {
        return StringsKt.replace$default((String)$this$replaceSpacesWithNonBreakSpaces, (String)" ", (String)"\u00a0", (boolean)false, (int)4, null);
    }

    private static final void getKeyStrokeData$addPart(StringBuilder builder, List<IntRange> intervals, String part) {
        int start2 = builder.length();
        builder.append(part);
        intervals.add(new IntRange(start2, builder.length() - 1));
    }
}

