/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001>B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0016J\r\u0010 \u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0017\u0010!\u001a\u00020\u00182\r\u0010\"\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0012\u0010#\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u00101\u001a\u00020\u0018J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u000207H\u0014J\u0010\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0014J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020=H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006?"}, d2={"Lcom/intellij/ui/components/JBHtmlPane;", "Ljavax/swing/JEditorPane;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$ScaledHtmlJEditorPane;", "styleConfiguration", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;", "paneConfiguration", "Lcom/intellij/ui/components/JBHtmlPaneConfiguration;", "<init>", "(Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;Lcom/intellij/ui/components/JBHtmlPaneConfiguration;)V", "()V", "service", "Lcom/intellij/ui/components/JBHtmlPane$ImplService;", "myText", "", "Lorg/jetbrains/annotations/Nls;", "myCurrentDefaultStyleSheet", "Ljavax/swing/text/html/StyleSheet;", "mutableBackgroundFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Ljava/awt/Color;", "myStyleConfiguration", "myPaneConfiguration", "initializePaneConfiguration", "", "builder", "Lcom/intellij/ui/components/JBHtmlPaneConfiguration$Builder;", "initializeStyleConfiguration", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration$Builder;", "init", "dispose", "getSelectedText", "getText", "setText", "t", "setFont", "font", "Ljava/awt/Font;", "setEditorKit", "kit", "Ljavax/swing/text/EditorKit;", "backgroundFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getBackgroundFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "contentsScaleFactor", "", "getContentsScaleFactor", "()F", "reloadCssStylesheets", "updateDocumentationPaneDefaultCssRules", "editorKit", "Ljavax/swing/text/html/HTMLEditorKit;", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "paintComponent", "g", "Ljava/awt/Graphics;", "setDocument", "doc", "Ljavax/swing/text/Document;", "ImplService", "intellij.platform.ide"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJBHtmlPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBHtmlPane.kt\ncom/intellij/ui/components/JBHtmlPane\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n30#2,2:347\n1#3:349\n37#4,2:350\n23#5:352\n23#5:353\n19#6:354\n1915#7,2:355\n*S KotlinDebug\n*F\n+ 1 JBHtmlPane.kt\ncom/intellij/ui/components/JBHtmlPane\n*L\n124#1:347,2\n199#1:350,2\n237#1:352\n243#1:353\n249#1:354\n292#1:355,2\n*E\n"})
public class JBHtmlPane
extends JEditorPane
implements Disposable,
ExtendableHTMLViewFactory.ScaledHtmlJEditorPane {
    @NotNull
    private final ImplService service;
    @NotNull
    private String myText;
    @Nullable
    private StyleSheet myCurrentDefaultStyleSheet;
    @NotNull
    private final MutableStateFlow<Color> mutableBackgroundFlow;
    @NotNull
    private final JBHtmlPaneStyleConfiguration myStyleConfiguration;
    @NotNull
    private final JBHtmlPaneConfiguration myPaneConfiguration;

    public JBHtmlPane(@NotNull JBHtmlPaneStyleConfiguration styleConfiguration, @NotNull JBHtmlPaneConfiguration paneConfiguration) {
        Intrinsics.checkNotNullParameter((Object)styleConfiguration, (String)"styleConfiguration");
        Intrinsics.checkNotNullParameter((Object)paneConfiguration, (String)"paneConfiguration");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<ImplService> serviceClass$iv = ImplService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.service = (ImplService)object;
        this.myText = "";
        this.mutableBackgroundFlow = StateFlowKt.MutableStateFlow((Object)this.getBackground());
        this.myStyleConfiguration = styleConfiguration;
        this.myPaneConfiguration = paneConfiguration;
        this.init();
    }

    public JBHtmlPane() {
        Object it;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service22 = false;
        Class<ImplService> serviceClass$iv = ImplService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.service = (ImplService)object;
        this.myText = "";
        this.mutableBackgroundFlow = StateFlowKt.MutableStateFlow((Object)this.getBackground());
        Object object2 = JBHtmlPaneStyleConfiguration.Companion.builder();
        JBHtmlPaneStyleConfiguration.Builder $i$f$service22 = object2;
        JBHtmlPane jBHtmlPane = this;
        boolean bl = false;
        this.initializeStyleConfiguration((JBHtmlPaneStyleConfiguration.Builder)it);
        jBHtmlPane.myStyleConfiguration = ((JBHtmlPaneStyleConfiguration.Builder)object2).build();
        it = object2 = JBHtmlPaneConfiguration.Companion.builder();
        jBHtmlPane = this;
        boolean bl2 = false;
        this.initializePaneConfiguration((JBHtmlPaneConfiguration.Builder)it);
        jBHtmlPane.myPaneConfiguration = ((JBHtmlPaneConfiguration.Builder)object2).build();
        this.init();
    }

    protected void initializePaneConfiguration(@NotNull JBHtmlPaneConfiguration.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    protected void initializeStyleConfiguration(@NotNull JBHtmlPaneStyleConfiguration.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    private final void init() {
        ExtendableHTMLViewFactory.Extension[] extensionArray;
        this.enableEvents(8L);
        this.setEditable(false);
        if (ScreenReader.isActive()) {
            this.getCaret().setVisible(true);
        } else {
            this.putClientProperty("caretWidth", 0);
            UIUtil.doNotScrollToCaret((JTextComponent)this);
        }
        ArrayList extensions = new ArrayList(this.myPaneConfiguration.getExtensions$intellij_platform_ide());
        Object[] objectArray = new ExtendableHTMLViewFactory.Extension[10];
        objectArray[0] = ExtendableHTMLViewFactory.Extensions.icons(arg_0 -> JBHtmlPane.init$lambda$0(this, arg_0));
        objectArray[1] = ExtendableHTMLViewFactory.Extensions.INLINE_VIEW_EX;
        objectArray[2] = ExtendableHTMLViewFactory.Extensions.PARAGRAPH_VIEW_EX;
        objectArray[3] = ExtendableHTMLViewFactory.Extensions.LINE_VIEW_EX;
        objectArray[4] = ExtendableHTMLViewFactory.Extensions.BLOCK_VIEW_EX;
        objectArray[5] = ExtendableHTMLViewFactory.Extensions.FORM_VIEW_EX;
        objectArray[6] = ExtendableHTMLViewFactory.Extensions.WBR_SUPPORT;
        ExtendableHTMLViewFactory.Extension[] extensionArray2 = extensionArray = ExtendableHTMLViewFactory.Extensions.HIDPI_IMAGES;
        int n = 7;
        Object[] objectArray2 = objectArray;
        List list = extensions;
        boolean bl = false;
        boolean bl2 = !this.myPaneConfiguration.getExtensions$intellij_platform_ide().contains(ExtendableHTMLViewFactory.Extensions.FIT_TO_WIDTH_IMAGES);
        objectArray2[n] = bl2 ? extensionArray : null;
        objectArray[8] = ExtendableHTMLViewFactory.Extensions.BLOCK_HR_SUPPORT;
        objectArray[9] = ExtendableHTMLViewFactory.Extensions.DETAILS_SUMMARY_SUPPORT;
        UtilKt.addAllIfNotNull((List)list, (Object[])objectArray);
        Collection $this$toTypedArray$iv = extensions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        extensionArray = thisCollection$iv.toArray(new ExtendableHTMLViewFactory.Extension[0]);
        HTMLEditorKitBuilder hTMLEditorKitBuilder = new HTMLEditorKitBuilder().replaceViewFactoryExtensions((Function2[])Arrays.copyOf(extensionArray, extensionArray.length));
        CSSFontResolver cSSFontResolver = this.myPaneConfiguration.getFontResolver$intellij_platform_ide();
        if (cSSFontResolver == null) {
            cSSFontResolver = this.service.defaultEditorCssFontResolver();
        }
        HTMLEditorKit editorKit = hTMLEditorKitBuilder.withFontResolver(cSSFontResolver).withUnderlinedHoveredHyperlink(this.myPaneConfiguration.getUnderlinedHoveredHyperlink$intellij_platform_ide()).build();
        this.updateDocumentationPaneDefaultCssRules(editorKit);
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        this.mutableBackgroundFlow.setValue((Object)color);
        this.addPropertyChangeListener(arg_0 -> JBHtmlPane.init$lambda$2(this, editorKit, arg_0));
        super.setEditorKit(editorKit);
        this.setBorder((Border)JBUI.Borders.empty());
    }

    public void dispose() {
        this.getCaret().setVisible(false);
    }

    @Override
    @Nullable
    public String getSelectedText() {
        String string = super.getSelectedText();
        return string != null ? StringsKt.replace$default((String)string, (String)"\u200b", (String)"", (boolean)false, (int)4, null) : null;
    }

    @Override
    @NotNull
    public String getText() {
        return this.myText;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setText(@Nullable String t) {
        String string;
        block7: {
            block6: {
                void it;
                if (t != null && t.length() > 50000) {
                    JBHtmlPane $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(JBHtmlPane.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("HTML pane text is very long (" + t.length() + "): " + StringUtil.shortenTextWithEllipsis((String)t, (int)1000, (int)250, (String)"<TRUNCATED>"));
                }
                JBHtmlPane jBHtmlPane = this;
                string = t;
                if (string == null) break block6;
                String string2 = string;
                JBHtmlPane jBHtmlPane2 = jBHtmlPane;
                boolean bl = false;
                String string3 = this.service.transpileHtmlPaneInput((String)it);
                jBHtmlPane = jBHtmlPane2;
                string = string3;
                if (string3 != null) break block7;
            }
            string = "";
        }
        jBHtmlPane.myText = string;
        try {
            super.setText(this.myText);
        }
        catch (Throwable e) {
            JBHtmlPane $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JBHtmlPane.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to set contents of the HTML pane", e);
        }
    }

    @Override
    public void setFont(@Nullable Font font) {
        block1: {
            super.setFont(font);
            EditorKit $this$asSafely$iv = this.getEditorKit();
            boolean $i$f$asSafely = false;
            EditorKit editorKit = $this$asSafely$iv;
            if (!(editorKit instanceof HTMLEditorKit)) {
                editorKit = null;
            }
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)editorKit;
            if (hTMLEditorKit == null) break block1;
            HTMLEditorKit it = hTMLEditorKit;
            boolean bl = false;
            this.updateDocumentationPaneDefaultCssRules(it);
        }
    }

    @Override
    public void setEditorKit(@NotNull EditorKit kit) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        throw new UnsupportedOperationException("Cannot change EditorKit for JBHtmlPane");
    }

    @NotNull
    public final StateFlow<Color> getBackgroundFlow() {
        return (StateFlow)this.mutableBackgroundFlow;
    }

    public float getContentsScaleFactor() {
        return JBUIScale.scale((float)1.0f);
    }

    public final void reloadCssStylesheets() {
        EditorKit editorKit = this.getEditorKit();
        Intrinsics.checkNotNull((Object)editorKit, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLEditorKit");
        this.updateDocumentationPaneDefaultCssRules((HTMLEditorKit)editorKit);
    }

    private final void updateDocumentationPaneDefaultCssRules(HTMLEditorKit editorKit) {
        StyleSheet styleSheet;
        StyleSheet it;
        StyleSheet editorStyleSheet = editorKit.getStyleSheet();
        StyleSheet styleSheet2 = this.myCurrentDefaultStyleSheet;
        if (styleSheet2 != null) {
            it = styleSheet2;
            boolean bl = false;
            editorStyleSheet.removeStyleSheet(it);
        }
        it = styleSheet = new StyleSheet();
        boolean bl = false;
        this.myCurrentDefaultStyleSheet = it;
        StyleSheet newStyleSheet = styleSheet;
        float contentsScaleFactor = this.getContentsScaleFactor();
        int baseFontSize = MathKt.roundToInt((float)((float)this.getFont().getSize() / contentsScaleFactor));
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        newStyleSheet.addStyleSheet(this.service.getDefaultStyleSheet(color, contentsScaleFactor, baseFontSize, this.myStyleConfiguration));
        newStyleSheet.addStyleSheet(this.service.getEditorColorsSchemeStyleSheet((EditorColorsScheme)this.myStyleConfiguration.getColorSchemeProvider().invoke()));
        Iterable $this$forEach$iv = this.myPaneConfiguration.getCustomStyleSheetProviders$intellij_platform_ide();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it2 = (Function1)element$iv;
            boolean bl2 = false;
            newStyleSheet.addStyleSheet((StyleSheet)it2.invoke((Object)this));
        }
        editorStyleSheet.addStyleSheet(newStyleSheet);
        this.service.applyCssToView(this);
    }

    @Override
    protected void processKeyEvent(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        ActionListener listener2 = this.myPaneConfiguration.getKeyboardActions$intellij_platform_ide().get(keyStroke);
        if (listener2 != null) {
            listener2.actionPerformed(new ActionEvent(this, 0, ""));
            e.consume();
            return;
        }
        super.processKeyEvent(e);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paintComponent(g);
        this.service.ensureEditableViewsAreNotFocusable(this);
    }

    @Override
    public void setDocument(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        super.setDocument(doc);
        doc.putProperty("IgnoreCharsetDirective", true);
        if (doc instanceof StyledDocument) {
            Dictionary<URL, Image> dictionary = (Dictionary<URL, Image>)this.myPaneConfiguration.getImageResolverFactory$intellij_platform_ide().invoke((Object)this);
            if (dictionary == null) {
                dictionary = this.service.createDefaultImageResolver(this);
            }
            doc.putProperty("imageCache", dictionary);
        }
    }

    private static final Icon init$lambda$0(JBHtmlPane this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Icon)this$0.myPaneConfiguration.getIconResolver$intellij_platform_ide().invoke((Object)key);
    }

    private static final void init$lambda$2(JBHtmlPane this$0, HTMLEditorKit $editorKit, PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        String propertyName = evt.getPropertyName();
        if (Intrinsics.areEqual((Object)"background", (Object)propertyName) || Intrinsics.areEqual((Object)"UI", (Object)propertyName)) {
            this$0.updateDocumentationPaneDefaultCssRules($editorKit);
            MutableStateFlow<Color> mutableStateFlow = this$0.mutableBackgroundFlow;
            Color color = this$0.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            mutableStateFlow.setValue((Object)color);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\bg\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H&J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH&R\u0012\u0010\u001e\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ui/components/JBHtmlPane$ImplService;", "", "transpileHtmlPaneInput", "", "Lorg/jetbrains/annotations/Nls;", "text", "defaultEditorCssFontResolver", "Lcom/intellij/util/ui/CSSFontResolver;", "getDefaultStyleSheet", "Ljavax/swing/text/html/StyleSheet;", "paneBackgroundColor", "Ljava/awt/Color;", "scaleFactor", "", "baseFontSize", "", "configuration", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;", "getEditorColorsSchemeStyleSheet", "editorColorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "createDefaultImageResolver", "Ljava/util/Dictionary;", "Ljava/net/URL;", "Ljava/awt/Image;", "pane", "Lcom/intellij/ui/components/JBHtmlPane;", "applyCssToView", "", "ensureEditableViewsAreNotFocusable", "jsoupCustomTagSet", "getJsoupCustomTagSet", "()Ljava/lang/Object;", "intellij.platform.ide"})
    @ApiStatus.Internal
    public static interface ImplService {
        @NotNull
        public String transpileHtmlPaneInput(@NotNull String var1);

        @NotNull
        public CSSFontResolver defaultEditorCssFontResolver();

        @NotNull
        public StyleSheet getDefaultStyleSheet(@NotNull Color var1, float var2, int var3, @NotNull JBHtmlPaneStyleConfiguration var4);

        @NotNull
        public StyleSheet getEditorColorsSchemeStyleSheet(@NotNull EditorColorsScheme var1);

        @NotNull
        public Dictionary<URL, Image> createDefaultImageResolver(@NotNull JBHtmlPane var1);

        public void applyCssToView(@NotNull JBHtmlPane var1);

        public void ensureEditableViewsAreNotFocusable(@NotNull JBHtmlPane var1);

        @NotNull
        public Object getJsoupCustomTagSet();
    }
}

