/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.view.impl.CopyOnSelectionHandlerKt;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/terminal/frontend/view/impl/CopyOnSelectionHandler;", "", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "<init>", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "copy", "text", "", "copyToSystemSelectionClipboard", "", "copyToRegularClipboard", "MySelectionListener", "Companion", "intellij.terminal.frontend"})
public final class CopyOnSelectionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;

    private CopyOnSelectionHandler(JBTerminalSystemSettingsProviderBase settings) {
        this.settings = settings;
    }

    private final void install(Editor editor) {
        editor.getSelectionModel().addSelectionListener((SelectionListener)new MySelectionListener());
    }

    private final void copy(String text) {
        if (!this.copyToSystemSelectionClipboard(text)) {
            this.copyToRegularClipboard(text);
        }
    }

    private final boolean copyToSystemSelectionClipboard(String text) {
        boolean bl;
        try {
            boolean bl2;
            CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
            if (copyPasteManager.isSystemSelectionSupported()) {
                copyPasteManager.setSystemSelectionContents((Transferable)new StringSelection(text));
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            CopyOnSelectionHandlerKt.access$getLOG$p().warn("Failed to copy to the system selection clipboard, falling back to the regular one", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final void copyToRegularClipboard(String text) {
        CopyPasteManager.copyTextToClipboard((String)text);
    }

    public /* synthetic */ CopyOnSelectionHandler(JBTerminalSystemSettingsProviderBase settings, DefaultConstructorMarker $constructor_marker) {
        this(settings);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/view/impl/CopyOnSelectionHandler$Companion;", "", "<init>", "()V", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Editor editor, @NotNull JBTerminalSystemSettingsProviderBase settings) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            new CopyOnSelectionHandler(settings, null).install(editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/frontend/view/impl/CopyOnSelectionHandler$MySelectionListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "<init>", "(Lcom/intellij/terminal/frontend/view/impl/CopyOnSelectionHandler;)V", "selectionChanged", "", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "intellij.terminal.frontend"})
    private final class MySelectionListener
    implements SelectionListener {
        public void selectionChanged(@NotNull SelectionEvent e) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!CopyOnSelectionHandler.this.settings.copyOnSelect()) break block4;
                    Object object = e.getEditor();
                    if (object != null && (object = object.getContentComponent()) != null ? ((Component)object).isFocusOwner() : false) break block5;
                }
                return;
            }
            String string = e.getEditor().getSelectionModel().getSelectedText();
            if (string == null) {
                return;
            }
            String text = string;
            CopyOnSelectionHandler.this.copy(text);
        }
    }
}

