/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorInputMethodSupport;
import com.intellij.openapi.editor.impl.InputMethodInlayRenderer;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupport;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupportKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001d\u001eBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCaretPosition", "Lkotlin/Function0;", "Lcom/intellij/openapi/editor/LogicalPosition;", "cursorOffsetFlow", "Lkotlinx/coroutines/flow/Flow;", "", "sendInputString", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function0;Lkotlinx/coroutines/flow/Flow;Lkotlin/jvm/functions/Function1;)V", "inputMethodRequests", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$MyInputMethodRequests;", "composedTextInlayTracker", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$ComposedTextInlayTracker;", "handleInputMethodTextChanged", "event", "Ljava/awt/event/InputMethodEvent;", "collectString", "text", "Ljava/text/AttributedCharacterIterator;", "count", "MyInputMethodRequests", "ComposedTextInlayTracker", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalOutputEditorInputMethodSupport {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Function0<LogicalPosition> getCaretPosition;
    @Nullable
    private final Flow<Integer> cursorOffsetFlow;
    @NotNull
    private final Function1<String, Unit> sendInputString;
    @NotNull
    private final MyInputMethodRequests inputMethodRequests;
    @Nullable
    private ComposedTextInlayTracker composedTextInlayTracker;

    public TerminalOutputEditorInputMethodSupport(@NotNull EditorEx editor, @NotNull CoroutineScope coroutineScope, @NotNull Function0<? extends LogicalPosition> getCaretPosition, @Nullable Flow<Integer> cursorOffsetFlow2, @NotNull Function1<? super String, Unit> sendInputString) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(getCaretPosition, (String)"getCaretPosition");
        Intrinsics.checkNotNullParameter(sendInputString, (String)"sendInputString");
        this.editor = editor;
        this.coroutineScope = coroutineScope;
        this.getCaretPosition = getCaretPosition;
        this.cursorOffsetFlow = cursorOffsetFlow2;
        this.sendInputString = sendInputString;
        this.inputMethodRequests = new MyInputMethodRequests();
        if (!this.editor.isViewer()) {
            throw new IllegalStateException("Check failed.");
        }
        MouseAdapter mouseListener2 = new MouseAdapter(this){
            final /* synthetic */ TerminalOutputEditorInputMethodSupport this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                if (TerminalOutputEditorInputMethodSupport.access$getComposedTextInlayTracker$p(this.this$0) != null && !TerminalOutputEditorInputMethodSupport.access$getEditor$p(this.this$0).isDisposed()) {
                    InputContext inputContext = TerminalOutputEditorInputMethodSupport.access$getEditor$p(this.this$0).getContentComponent().getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                    ComposedTextInlayTracker composedTextInlayTracker = TerminalOutputEditorInputMethodSupport.access$getComposedTextInlayTracker$p(this.this$0);
                    if (composedTextInlayTracker != null) {
                        composedTextInlayTracker.cancel();
                    }
                    TerminalOutputEditorInputMethodSupport.access$setComposedTextInlayTracker$p(this.this$0, null);
                }
            }
        };
        this.editor.getContentComponent().addMouseListener(mouseListener2);
        InputMethodListener inputMethodListener2 = new InputMethodListener(this){
            final /* synthetic */ TerminalOutputEditorInputMethodSupport this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputMethodTextChanged(InputMethodEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!TerminalOutputEditorInputMethodSupport.access$getEditor$p(this.this$0).isDisposed()) {
                    TerminalOutputEditorInputMethodSupport.access$handleInputMethodTextChanged(this.this$0, event);
                }
                event.consume();
            }

            public void caretPositionChanged(InputMethodEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                event.consume();
            }
        };
        EditorEx editorEx = this.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editorEx).setInputMethodSupport(new EditorInputMethodSupport((InputMethodRequests)this.inputMethodRequests, inputMethodListener2));
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> TerminalOutputEditorInputMethodSupport._init_$lambda$0(this, mouseListener2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInputMethodTextChanged(InputMethodEvent event) {
        ComposedTextInlayTracker composedTextInlayTracker = this.composedTextInlayTracker;
        if (composedTextInlayTracker != null) {
            composedTextInlayTracker.cancel();
        }
        this.composedTextInlayTracker = null;
        AttributedCharacterIterator text = event.getText();
        if (text != null) {
            String composedString;
            text.first();
            String committedString = this.collectString(text, event.getCommittedCharacterCount());
            if (((CharSequence)committedString).length() > 0) {
                this.sendInputString.invoke((Object)committedString);
            }
            if (((CharSequence)(composedString = TerminalOutputEditorInputMethodSupport.collectString$default(this, text, 0, 2, null))).length() > 0) {
                void it;
                ComposedTextInlayTracker composedTextInlayTracker2;
                ComposedTextInlayTracker composedTextInlayTracker3 = composedTextInlayTracker2 = new ComposedTextInlayTracker(composedString);
                TerminalOutputEditorInputMethodSupport terminalOutputEditorInputMethodSupport = this;
                boolean bl = false;
                it.start();
                terminalOutputEditorInputMethodSupport.composedTextInlayTracker = composedTextInlayTracker2;
            }
        }
    }

    private final String collectString(AttributedCharacterIterator text, int count) {
        StringBuilder result2 = new StringBuilder();
        char c = text.current();
        for (int processedChars = 0; c != '\uffff' && processedChars < count; ++processedChars) {
            if (c >= ' ' && c != '\u007f') {
                result2.append(c);
            }
            c = text.next();
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String collectString$default(TerminalOutputEditorInputMethodSupport terminalOutputEditorInputMethodSupport, AttributedCharacterIterator attributedCharacterIterator, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return terminalOutputEditorInputMethodSupport.collectString(attributedCharacterIterator, n);
    }

    private static final Unit lambda$0$0(TerminalOutputEditorInputMethodSupport this$0, mouseListener.1 $mouseListener) {
        ((EditorImpl)this$0.editor).getContentComponent().removeMouseListener((MouseListener)$mouseListener);
        ((EditorImpl)this$0.editor).setInputMethodSupport(null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(TerminalOutputEditorInputMethodSupport this$0, mouseListener.1 $mouseListener, Throwable it) {
        ActionsKt.runInEdt((ModalityState)ModalityState.any(), () -> TerminalOutputEditorInputMethodSupport.lambda$0$0(this$0, $mouseListener));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ComposedTextInlayTracker access$getComposedTextInlayTracker$p(TerminalOutputEditorInputMethodSupport $this) {
        return $this.composedTextInlayTracker;
    }

    public static final /* synthetic */ void access$setComposedTextInlayTracker$p(TerminalOutputEditorInputMethodSupport $this, ComposedTextInlayTracker composedTextInlayTracker) {
        $this.composedTextInlayTracker = composedTextInlayTracker;
    }

    public static final /* synthetic */ void access$handleInputMethodTextChanged(TerminalOutputEditorInputMethodSupport $this, InputMethodEvent event) {
        $this.handleInputMethodTextChanged(event);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$ComposedTextInlayTracker;", "", "composedText", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport;Ljava/lang/String;)V", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "cursorOffset", "", "job", "Lkotlinx/coroutines/Job;", "start", "", "showInlayAt", "newCursorOffset", "hideInlay", "cancel", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOutputEditorInputMethodSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputEditorInputMethodSupport.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$ComposedTextInlayTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,227:1\n60#2,5:228\n*S KotlinDebug\n*F\n+ 1 TerminalOutputEditorInputMethodSupport.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$ComposedTextInlayTracker\n*L\n180#1:228,5\n*E\n"})
    private final class ComposedTextInlayTracker {
        @NotNull
        private final String composedText;
        @Nullable
        private Inlay<?> inlay;
        private int cursorOffset;
        @Nullable
        private Job job;

        public ComposedTextInlayTracker(String composedText) {
            Intrinsics.checkNotNullParameter((Object)composedText, (String)"composedText");
            this.composedText = composedText;
            this.cursorOffset = -1;
        }

        @RequiresEdt
        public final void start() {
            LogicalPosition logicalPosition = (LogicalPosition)TerminalOutputEditorInputMethodSupport.this.getCaretPosition.invoke();
            if (logicalPosition == null) {
                return;
            }
            LogicalPosition initialCaretPosition = logicalPosition;
            this.showInlayAt(TerminalOutputEditorInputMethodSupport.this.editor.logicalPositionToOffset(initialCaretPosition));
            if (TerminalOutputEditorInputMethodSupport.this.cursorOffsetFlow != null) {
                CoroutineScope coroutineScope = TerminalOutputEditorInputMethodSupport.this.coroutineScope;
                CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                this.job = BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(TerminalOutputEditorInputMethodSupport.this, this, null){
                    int label;
                    final /* synthetic */ TerminalOutputEditorInputMethodSupport this$0;
                    final /* synthetic */ ComposedTextInlayTracker this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = TerminalOutputEditorInputMethodSupport.access$getCursorOffsetFlow$p(this.this$0).collect(new FlowCollector(this.this$1){
                                    final /* synthetic */ ComposedTextInlayTracker this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public final Object emit(int newCursorOffset, Continuation<? super Unit> $completion) {
                                        if (newCursorOffset != ComposedTextInlayTracker.access$getCursorOffset$p(this.this$0)) {
                                            ComposedTextInlayTracker.access$showInlayAt(this.this$0, newCursorOffset);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }

        private final void showInlayAt(int newCursorOffset) {
            this.hideInlay();
            this.inlay = TerminalOutputEditorInputMethodSupport.this.editor.getInlayModel().addInlineElement(newCursorOffset, true, -1000000, (EditorCustomElementRenderer)new InputMethodInlayRenderer(this.composedText));
            Logger $this$debug_u24default$iv = TerminalOutputEditorInputMethodSupportKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                String msg = this.cursorOffset == -1 ? "Initialized composed text inlay, offset: " + newCursorOffset + ", composed text: " + this.composedText : "Repositioned composed text inlay, new offset: " + newCursorOffset;
                logger.debug(this.inlay != null ? msg : msg + " (INLAY NOT SHOWN)", t$iv);
            }
            this.cursorOffset = newCursorOffset;
        }

        private final void hideInlay() {
            Inlay<?> inlay = this.inlay;
            if (inlay != null) {
                Inlay<?> it = inlay;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            this.inlay = null;
        }

        @RequiresEdt
        public final void cancel() {
            Job job2 = this.job;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.hideInlay();
        }

        public static final /* synthetic */ int access$getCursorOffset$p(ComposedTextInlayTracker $this) {
            return $this.cursorOffset;
        }

        public static final /* synthetic */ void access$showInlayAt(ComposedTextInlayTracker $this, int newCursorOffset) {
            $this.showInlayAt(newCursorOffset);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J!\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$MyInputMethodRequests;", "Ljava/awt/im/InputMethodRequests;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport;)V", "getTextLocation", "Ljava/awt/Rectangle;", "offset", "Ljava/awt/font/TextHitInfo;", "getLocationOffset", "x", "", "y", "getInsertPositionOffset", "getCommittedText", "Ljava/text/AttributedCharacterIterator;", "beginIndex", "endIndex", "attributes", "", "Ljava/text/AttributedCharacterIterator$Attribute;", "(II[Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getCommittedTextLength", "cancelLatestCommittedText", "([Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getSelectedText", "intellij.terminal"})
    private final class MyInputMethodRequests
    implements InputMethodRequests {
        @Override
        @NotNull
        public Rectangle getTextLocation(@Nullable TextHitInfo offset) {
            if (TerminalOutputEditorInputMethodSupport.this.editor.isDisposed()) {
                return new Rectangle();
            }
            LogicalPosition logicalPosition = (LogicalPosition)TerminalOutputEditorInputMethodSupport.this.getCaretPosition.invoke();
            if (logicalPosition == null) {
                return new Rectangle();
            }
            LogicalPosition cursorPosition = logicalPosition;
            Point point = TerminalOutputEditorInputMethodSupport.this.editor.logicalPositionToXY(cursorPosition);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"logicalPositionToXY(...)");
            Point caret = point;
            Rectangle r = new Rectangle(caret, new Dimension(1, TerminalOutputEditorInputMethodSupport.this.editor.getLineHeight()));
            JComponent jComponent = TerminalOutputEditorInputMethodSupport.this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            Point p = TerminalOutputEditorInputMethodSupportKt.access$getLocationOnScreen(jComponent);
            r.translate(p.x, p.y);
            return r;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            LogicalPosition logicalPosition = (LogicalPosition)TerminalOutputEditorInputMethodSupport.this.getCaretPosition.invoke();
            if (logicalPosition == null) {
                return 0;
            }
            LogicalPosition cursorLogicalPosition = logicalPosition;
            return TerminalOutputEditorInputMethodSupport.this.editor.logicalPositionToOffset(cursorLogicalPosition);
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
            String committed = TerminalOutputEditorInputMethodSupportKt.access$getText((Editor)TerminalOutputEditorInputMethodSupport.this.editor, beginIndex, endIndex);
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
            Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            return TerminalOutputEditorInputMethodSupport.this.editor.getDocument().getTextLength();
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }
}

