/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config.nativeBinaryOptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.nativeBinaryOptions.BinaryOption;
import org.jetbrains.kotlin.config.nativeBinaryOptions.BinaryOptionWithValue;
import org.jetbrains.kotlin.config.nativeBinaryOptions.BinaryOptions;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001aM\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\n\u001aD\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u0002\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a?\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"parseBinaryOptions", "", "Lorg/jetbrains/kotlin/config/nativeBinaryOptions/BinaryOptionWithValue;", "argumentValue", "", "", "reportWarning", "Lkotlin/Function1;", "", "reportError", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "parseBinaryOption", "T", "", "option", "Lorg/jetbrains/kotlin/config/nativeBinaryOptions/BinaryOption;", "valueName", "parseKeyValuePairs", "", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "binary-options"})
@SourceDebugExtension(value={"SMAP\nparsing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 parsing.kt\norg/jetbrains/kotlin/config/nativeBinaryOptions/ParsingKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,61:1\n139#2,10:62\n221#2:72\n222#2:74\n149#2:75\n1#3:73\n1#3:87\n12021#4,10:76\n14048#4:86\n14049#4:88\n12031#4:89\n*S KotlinDebug\n*F\n+ 1 parsing.kt\norg/jetbrains/kotlin/config/nativeBinaryOptions/ParsingKt\n*L\n22#1:62,10\n22#1:72\n22#1:74\n22#1:75\n22#1:73\n51#1:87\n51#1:76,10\n51#1:86\n51#1:88\n51#1:89\n*E\n"})
public final class ParsingKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BinaryOptionWithValue<?>> parseBinaryOptions(@Nullable String[] argumentValue, @NotNull Function1<? super String, Unit> reportWarning, @NotNull Function1<? super String, Unit> reportError) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, String> keyValuePairs;
        Intrinsics.checkNotNullParameter(reportWarning, (String)"reportWarning");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        Map<String, String> map = ParsingKt.parseKeyValuePairs(argumentValue, reportError);
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<String, String> $this$mapNotNull$iv = keyValuePairs = map;
        boolean $i$f$mapNotNull = false;
        Map<String, String> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            BinaryOptionWithValue<?> binaryOptionWithValue;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            BinaryOption<?> option2 = BinaryOptions.INSTANCE.getByName(key);
            if (option2 == null) {
                reportWarning.invoke((Object)("Unknown binary option '" + key + '\''));
                binaryOptionWithValue = null;
            } else {
                binaryOptionWithValue = ParsingKt.parseBinaryOption(option2, value2, reportWarning);
            }
            if (binaryOptionWithValue == null) continue;
            BinaryOptionWithValue<?> it$iv$iv = binaryOptionWithValue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final <T> BinaryOptionWithValue<T> parseBinaryOption(BinaryOption<T> option2, String valueName, Function1<? super String, Unit> reportWarning) {
        BinaryOptionWithValue<T> binaryOptionWithValue;
        T value2 = option2.getValueParser().parse(valueName);
        if (value2 == null) {
            reportWarning.invoke((Object)("Unknown value '" + valueName + "' of binary option '" + option2.getName() + "'. Possible values are: " + option2.getValueParser().getValidValuesHint()));
            binaryOptionWithValue = null;
        } else {
            binaryOptionWithValue = new BinaryOptionWithValue<T>(option2.getCompilerConfigurationKey(), value2, valueName);
        }
        return binaryOptionWithValue;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> parseKeyValuePairs(String[] argumentValue, Function1<? super String, Unit> reportError) {
        Map map;
        if (argumentValue != null) {
            void $this$mapNotNullTo$iv$iv;
            String[] $this$mapNotNull$iv = argumentValue;
            boolean $i$f$mapNotNull = false;
            String[] stringArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Pair pair;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                    pair = null;
                } else {
                    int keyValueSeparatorIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (char)'=', (int)0, (boolean)false, (int)6, null);
                    if (keyValueSeparatorIndex > 0) {
                        pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null));
                    } else {
                        reportError.invoke((Object)("incorrect property format: expected '<key>=<value>', got '" + (String)it + '\''));
                        pair = null;
                    }
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            map = null;
        }
        return map;
    }
}

