/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util;

import com.jetbrains.rd.util.BitHacksKt;
import com.jetbrains.rd.util.BitSliceKt;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/util/BitSlice;", "", "lowBit", "", "bitCount", "(II)V", "getBitCount", "()I", "highBit", "getHighBit", "getLowBit", "mask", "getMask", "getRaw", "host", "requireSliceFitsIntType", "", "requireValueFitsSlice", "value", "toString", "", "updatedRaw", "Companion", "IntBitSlice", "TypedBitSlice", "rd-core"})
@SourceDebugExtension(value={"SMAP\nBitSlice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitSlice.kt\ncom/jetbrains/rd/util/BitSlice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public class BitSlice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int lowBit;
    private final int bitCount;

    public BitSlice(int lowBit, int bitCount) {
        this.lowBit = lowBit;
        this.bitCount = bitCount;
        if (!(this.lowBit >= 0)) {
            boolean $i$a$-require-BitSlice$32 = false;
            String $i$a$-require-BitSlice$32 = "[lowBit] must be >= 0, actual: '" + this.lowBit + "'";
            throw new IllegalArgumentException($i$a$-require-BitSlice$32.toString());
        }
        if (!(this.bitCount > 0)) {
            boolean bl = false;
            String string = "[bitCount] must be > 0, actual '" + this.bitCount + "'";
            throw new IllegalArgumentException(string.toString());
        }
        this.requireSliceFitsIntType();
    }

    public final int getLowBit() {
        return this.lowBit;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public final int getHighBit() {
        return this.lowBit + this.bitCount - 1;
    }

    private final int getMask() {
        return (1 << this.bitCount) - 1;
    }

    private final void requireSliceFitsIntType() {
        int maxBit = 31;
        if (!(this.getHighBit() <= maxBit)) {
            boolean bl = false;
            String string = this + " doesn't fit into host type 'Int'; must be inside [0, " + maxBit + "]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void requireValueFitsSlice(int value2) {
        if (!(value2 >= 0)) {
            boolean $i$a$-require-BitSlice$requireValueFitsSlice$32 = false;
            String $i$a$-require-BitSlice$requireValueFitsSlice$32 = "[value] must be >= 0; actual: '" + value2 + "'";
            throw new IllegalArgumentException($i$a$-require-BitSlice$requireValueFitsSlice$32.toString());
        }
        if (!(value2 <= this.getMask())) {
            boolean bl = false;
            String string = "[value] must be <= " + this.getMask() + " to fit " + this + "; actual '" + value2 + "'";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getRaw(int host) {
        return host >>> this.lowBit & this.getMask();
    }

    public final int updatedRaw(int host, int value2) {
        this.requireValueFitsSlice(value2);
        return host & ~(this.getMask() << this.lowBit) | value2 << this.lowBit;
    }

    @NotNull
    public String toString() {
        return "BitSlice[" + this.lowBit + ", " + this.getHighBit() + "]";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J-\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0004\"\u0010\b\u0000\u0010\t\u0018\u0001*\b\u0012\u0004\u0012\u0002H\t0\n2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0086\bJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/util/BitSlice$Companion;", "", "()V", "bool", "Lcom/jetbrains/rd/util/BitSlice$TypedBitSlice;", "", "prev", "Lcom/jetbrains/rd/util/BitSlice;", "enum", "T", "", "int", "", "bitCount", "rd-core"})
    @SourceDebugExtension(value={"SMAP\nBitSlice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitSlice.kt\ncom/jetbrains/rd/util/BitSlice$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TypedBitSlice<Integer> int(int bitCount, @Nullable BitSlice prev) {
            return new IntBitSlice(BitSliceKt.nextSliceLow(prev), bitCount);
        }

        public static /* synthetic */ TypedBitSlice int$default(Companion companion, int n, BitSlice bitSlice, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bitSlice = null;
            }
            return companion.int(n, bitSlice);
        }

        @NotNull
        public final TypedBitSlice<Boolean> bool(@Nullable BitSlice prev) {
            int n = BitSliceKt.nextSliceLow(prev);
            return new TypedBitSlice<Boolean>(n){

                @NotNull
                public Boolean get(int host) {
                    return this.getRaw(host) != 0;
                }

                public int updated(int host, boolean value2) {
                    return this.updatedRaw(host, value2 ? 1 : 0);
                }
            };
        }

        public static /* synthetic */ TypedBitSlice bool$default(Companion companion, BitSlice bitSlice, int n, Object object) {
            if ((n & 1) != 0) {
                bitSlice = null;
            }
            return companion.bool(bitSlice);
        }

        public final /* synthetic */ <T extends Enum<T>> TypedBitSlice<T> enum(BitSlice prev) {
            boolean $i$f$enum = false;
            Intrinsics.reifiedOperationMarker((int)5, (String)"T");
            Enum[] values = new Enum[]{};
            if (!(values.length >= 2)) {
                boolean bl = false;
                String string = "Bit slice for enums with " + values + " values is meaningless";
                throw new IllegalArgumentException(string.toString());
            }
            int n = BitSliceKt.nextSliceLow(prev);
            int n2 = BitHacksKt.log2ceil(values.length);
            Intrinsics.needClassReification();
            return new TypedBitSlice<T>(values, n, n2){
                final /* synthetic */ T[] $values;
                {
                    this.$values = $values;
                    super($super_call_param$1, $super_call_param$2);
                }

                @NotNull
                public T get(int host) {
                    return this.$values[this.getRaw(host)];
                }

                public int updated(int host, @NotNull T value2) {
                    Intrinsics.checkNotNullParameter(value2, (String)"value");
                    return this.updatedRaw(host, ((Enum)value2).ordinal());
                }
            };
        }

        public static /* synthetic */ TypedBitSlice enum$default(Companion $this, BitSlice prev, int n, Object object) {
            if ((n & 1) != 0) {
                prev = null;
            }
            boolean $i$f$enum = false;
            Intrinsics.reifiedOperationMarker((int)5, (String)"T");
            Enum[] values = new Enum[]{};
            if (!(values.length >= 2)) {
                boolean bl = false;
                String string = "Bit slice for enums with " + values + " values is meaningless";
                throw new IllegalArgumentException(string.toString());
            }
            int n2 = BitSliceKt.nextSliceLow(prev);
            int n3 = BitHacksKt.log2ceil(values.length);
            Intrinsics.needClassReification();
            return new /* invalid duplicate definition of identical inner class */;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/util/BitSlice$IntBitSlice;", "Lcom/jetbrains/rd/util/BitSlice$TypedBitSlice;", "", "lowBit", "bitCount", "(II)V", "get", "host", "(I)Ljava/lang/Integer;", "updated", "value", "rd-core"})
    private static final class IntBitSlice
    extends TypedBitSlice<Integer> {
        public IntBitSlice(int lowBit, int bitCount) {
            super(lowBit, bitCount);
        }

        @Override
        @NotNull
        public Integer get(int host) {
            return this.getRaw(host);
        }

        @Override
        public int updated(int host, int value2) {
            return this.updatedRaw(host, value2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0004H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/util/BitSlice$TypedBitSlice;", "T", "Lcom/jetbrains/rd/util/BitSlice;", "lowBit", "", "bitCount", "(II)V", "atomicUpdate", "", "atomicInteger", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/jetbrains/rd/util/AtomicInteger;", "value", "(Ljava/util/concurrent/atomic/AtomicInteger;Ljava/lang/Object;)V", "get", "host", "(I)Ljava/lang/Object;", "updated", "(ILjava/lang/Object;)I", "rd-core"})
    public static abstract class TypedBitSlice<T>
    extends BitSlice {
        public TypedBitSlice(int lowBit, int bitCount) {
            super(lowBit, bitCount);
        }

        public abstract T get(int var1);

        public abstract int updated(int var1, T var2);

        public final void atomicUpdate(@NotNull AtomicInteger atomicInteger, T value2) {
            int s;
            Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"atomicInteger");
            while (!atomicInteger.compareAndSet(s = atomicInteger.get(), this.updated(s, value2))) {
            }
        }
    }
}

