/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.log.GitExternalLogService;
import git4idea.log.GitShowExternalLogAction;
import git4idea.log.MyContentComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\rH\u0007\u001ac\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u000e0\u0011\u00a2\u0006\u0002\b\u00132\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\rH\u0007\u001ac\u0010\u0014\u001a\u00020\u0001\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u000e0\u0011\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\rH\u0002\u001a\u001e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a>\u0010\u0015\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a*\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\b\b\u0001\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0016\u0010\u001e\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u001e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0003\u001a\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u001e\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020!2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002\u001a&\u0010'\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010)H\u0002\"\u000e\u0010\u001d\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"showExternalGitLogInToolwindow", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "tabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "tabDescription", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "T", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "uiFactory", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "Lkotlin/ExtensionFunctionType;", "showExternalGitLogInWindow", "addLogContent", "component", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "showLogContentWindow", "content", "title", "EXTERNAL", "calcLogId", "calcTabName", "cm", "Lcom/intellij/ui/content/ContentManager;", "getGitRootsFromUser", "selectProjectLog", "", "selectAlreadyOpened", "", "doOnProviderRemoval", "closeTab", "Lkotlin/Function0;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitShowExternalLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitShowExternalLogAction.kt\ngit4idea/log/GitShowExternalLogActionKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,306:1\n30#2,2:307\n30#2,2:309\n13225#3,2:311\n3938#3:313\n4474#3,2:314\n1401#3,2:316\n*S KotlinDebug\n*F\n+ 1 GitShowExternalLogAction.kt\ngit4idea/log/GitShowExternalLogActionKt\n*L\n130#1:307,2\n142#1:309,2\n260#1:311,2\n270#1:313\n270#1:314,2\n284#1:316,2\n*E\n"})
public final class GitShowExternalLogActionKt {
    @NotNull
    private static final String EXTERNAL = "EXTERNAL";

    @ApiStatus.Internal
    public static final void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        GitShowExternalLogActionKt.showExternalGitLogInToolwindow(project, toolWindow, arg_0 -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$0(roots, arg_0), roots, tabTitle, tabDescription);
    }

    @ApiStatus.Internal
    public static final <T extends VcsLogUiEx> void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Function1<? super VcsLogManager, ? extends T> uiFactory, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        Function0 showContent = () -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$1(project, roots, toolWindow, uiFactory, tabTitle, tabDescription);
        if (!toolWindow.isVisible()) {
            toolWindow.activate(() -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$2(showContent), true);
        } else {
            showContent.invoke();
        }
    }

    private static final <T extends VcsLogUiEx> void showExternalGitLogInWindow(Project project, List<? extends VirtualFile> roots, Function1<? super VcsLogManager, ? extends T> uiFactory, ToolWindow toolWindow, String tabTitle, String tabDescription) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitExternalLogService> serviceClass$iv = GitExternalLogService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GitExternalLogService)object).showLog(roots, false, (Function1<? super VcsLogManager, ? extends VcsLogUiEx>)((Function1)arg_0 -> GitShowExternalLogActionKt.showExternalGitLogInWindow$lambda$0(uiFactory, roots, toolWindow, project, tabTitle, tabDescription, arg_0)));
    }

    private static final void showExternalGitLogInWindow(Project project, List<? extends VirtualFile> roots) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitExternalLogService> serviceClass$iv = GitExternalLogService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GitExternalLogService)object).showLog(roots, true, (Function1<? super VcsLogManager, ? extends VcsLogUiEx>)((Function1)arg_0 -> GitShowExternalLogActionKt.showExternalGitLogInWindow$lambda$1(roots, project, arg_0)));
    }

    private static final void addLogContent(ToolWindow $this$addLogContent, Project project, JComponent component2, String tabTitle, String tabDescription, Disposable disposable) {
        Content content = ContentFactory.getInstance().createContent(component2, tabTitle, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setDisposer(disposable);
        content2.setDescription(tabDescription);
        content2.setCloseable(true);
        ContentManager contentManager = $this$addLogContent.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager cm = contentManager;
        cm.addContent(content2);
        cm.setSelectedContent(content2);
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)((Function0)() -> GitShowExternalLogActionKt.addLogContent$lambda$0(cm, content2)));
    }

    private static final void showLogContentWindow(Project project, JComponent content, @NlsContexts.DialogTitle String title, Disposable disposable) {
        WindowWrapper windowWrapper = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, content).setProject(project).setTitle(title).setPreferredFocusedComponent(content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
        Intrinsics.checkNotNullExpressionValue((Object)windowWrapper, (String)"build(...)");
        WindowWrapper window = windowWrapper;
        Disposer.register((Disposable)((Disposable)window), (Disposable)disposable);
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)((Function0)() -> GitShowExternalLogActionKt.showLogContentWindow$lambda$0(window)));
        window.show();
    }

    private static final String calcLogId(List<? extends VirtualFile> roots) {
        Iterable iterable = roots;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return "EXTERNAL " + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, GitShowExternalLogActionKt::calcLogId$lambda$0, (int)30, null);
    }

    @Nls
    private static final String calcTabName(ContentManager cm, List<? extends VirtualFile> roots) {
        String name = VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]) + " (" + ((VirtualFile)CollectionsKt.first(roots)).getName() + (roots.size() > 1 ? "+" : "") + ")";
        String candidate = null;
        candidate = name;
        int cnt = 1;
        while (true) {
            boolean bl;
            block2: {
                Content[] contentArray = cm.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                Object[] $this$any$iv = contentArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Content content = (Content)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)content.getDisplayName(), (Object)candidate)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) break;
            candidate = name + "-" + cnt;
            ++cnt;
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getGitRootsFromUser(Project project) {
        void $this$filterTo$iv$iv;
        VirtualFile[] virtualFiles;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        VirtualFile[] $this$filter$iv = virtualFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!GitUtil.isGitRoot(it.toNioPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean selectProjectLog(Project project, List<? extends VirtualFile> roots) {
        GitVcs gitVcs = GitVcs.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        GitVcs vcs = gitVcs;
        VirtualFile[] virtualFileArray = ProjectLevelVcsManager.Companion.getInstance(project).getRootsUnderVcs((AbstractVcs)vcs);
        List projectRoots = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        if (!projectRoots.containsAll((Collection)roots)) {
            return false;
        }
        if (roots.containsAll(projectRoots)) {
            return VcsLogContentUtil.INSTANCE.selectMainLog(project);
        }
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{VcsLogFilterObject.fromRoots((Collection)roots)};
        VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray);
        return VcsProjectLog.Companion.getInstance(project).openLogTab(filters) != null;
    }

    private static final boolean selectAlreadyOpened(ContentManager cm, Collection<? extends VirtualFile> roots) {
        Object object;
        block2: {
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JComponent component2;
                Content content = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"getComponent(...)");
                boolean bl2 = component2 instanceof MyContentComponent ? Comparing.haveEqualElements(roots, ((MyContentComponent)component2).getRoots()) : false;
                if (!bl2) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Content content = (Content)object;
        if (content == null) {
            return false;
        }
        Content content2 = content;
        cm.setSelectedContent(content2);
        return true;
    }

    private static final void doOnProviderRemoval(Project project, Disposable disposable, Function0<Unit> closeTab) {
        VcsLogProvider.LOG_PROVIDER_EP.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<VcsLogProvider>(closeTab){
            final /* synthetic */ Function0<Unit> $closeTab;
            {
                this.$closeTab = $closeTab;
            }

            public void extensionRemoved(VcsLogProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)extension.getSupportedVcs(), (Object)GitVcs.getKey())) {
                    this.$closeTab.invoke();
                }
            }
        }, false, disposable);
    }

    private static final MainVcsLogUi showExternalGitLogInToolwindow$lambda$0(List $roots, VcsLogManager $this$showExternalGitLogInToolwindow) {
        Intrinsics.checkNotNullParameter((Object)$this$showExternalGitLogInToolwindow, (String)"$this$showExternalGitLogInToolwindow");
        return $this$showExternalGitLogInToolwindow.createLogUi(GitShowExternalLogActionKt.calcLogId($roots), null);
    }

    private static final Unit showExternalGitLogInToolwindow$lambda$1(Project $project, List $roots, ToolWindow $toolWindow, Function1 $uiFactory, String $tabTitle, String $tabDescription) {
        if (!GitShowExternalLogActionKt.selectProjectLog($project, $roots)) {
            ContentManager contentManager = $toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            if (!GitShowExternalLogActionKt.selectAlreadyOpened(contentManager, $roots)) {
                GitShowExternalLogActionKt.showExternalGitLogInWindow($project, $roots, $uiFactory, $toolWindow, $tabTitle, $tabDescription);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void showExternalGitLogInToolwindow$lambda$2(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final VcsLogUiEx showExternalGitLogInWindow$lambda$0(Function1 $uiFactory, List $roots, ToolWindow $toolWindow, Project $project, String $tabTitle, String $tabDescription, VcsLogManager $this$showLog) {
        Intrinsics.checkNotNullParameter((Object)$this$showLog, (String)"$this$showLog");
        VcsLogUiEx ui2 = (VcsLogUiEx)$uiFactory.invoke((Object)$this$showLog);
        MyContentComponent component2 = new MyContentComponent((JComponent)new VcsLogPanel($this$showLog, ui2), $roots);
        GitShowExternalLogActionKt.addLogContent($toolWindow, $project, component2, $tabTitle, $tabDescription, (Disposable)ui2);
        return ui2;
    }

    private static final VcsLogUiEx showExternalGitLogInWindow$lambda$1(List $roots, Project $project, VcsLogManager $this$showLog) {
        Intrinsics.checkNotNullParameter((Object)$this$showLog, (String)"$this$showLog");
        MainVcsLogUi ui2 = $this$showLog.createLogUi(GitShowExternalLogActionKt.calcLogId($roots), null);
        MyContentComponent content = new MyContentComponent((JComponent)new VcsLogPanel($this$showLog, (VcsLogUiEx)ui2), $roots);
        JComponent jComponent = content;
        String string = GitBundle.message("git.log.external.window.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GitShowExternalLogActionKt.showLogContentWindow($project, jComponent, string, (Disposable)ui2);
        return (VcsLogUiEx)ui2;
    }

    private static final Unit addLogContent$lambda$0(ContentManager $cm, Content $content) {
        $cm.removeContent($content, true);
        return Unit.INSTANCE;
    }

    private static final Unit showLogContentWindow$lambda$0(WindowWrapper $window) {
        $window.close();
        return Unit.INSTANCE;
    }

    private static final CharSequence calcLogId$lambda$0(VirtualFile obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = obj.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public static final /* synthetic */ List access$getGitRootsFromUser(Project project) {
        return GitShowExternalLogActionKt.getGitRootsFromUser(project);
    }

    public static final /* synthetic */ void access$showExternalGitLogInWindow(Project project, List roots) {
        GitShowExternalLogActionKt.showExternalGitLogInWindow(project, roots);
    }

    public static final /* synthetic */ String access$calcTabName(ContentManager cm, List roots) {
        return GitShowExternalLogActionKt.calcTabName(cm, roots);
    }
}

