/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.CallbackNotReadyException;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.ide.BrowserUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016J \u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00120\u0011H\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00120\u0011H\u0017J2\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00102\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00120\u0011H\u0016J2\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00120\u0011H\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0014J\u001a\u0010\u001d\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\"\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "Lcom/intellij/collaboration/auth/services/OAuthService;", "<init>", "()V", "currentRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase$OAuthRequestWithResult;", "getCurrentRequest", "()Ljava/util/concurrent/atomic/AtomicReference;", "authorize", "Ljava/util/concurrent/CompletableFuture;", "request", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "getAuthorizationCode", "", "", "", "handleServerCallback", "", "path", "parameters", "handleOAuthServerCallback", "Lcom/intellij/collaboration/auth/services/OAuthService$OAuthResult;", "handleOAuthServerCredentialsCallback", "Lcom/intellij/collaboration/auth/services/OAuthService$OAuthResultCredentials;", "startAuthorization", "", "processCode", "code", "OAuthRequestWithResult", "intellij.platform.collaborationTools.auth.base"})
public abstract class OAuthServiceBase<T extends Credentials>
implements OAuthService<T> {
    @NotNull
    private final AtomicReference<OAuthRequestWithResult<T>> currentRequest = new AtomicReference();

    @NotNull
    protected final AtomicReference<OAuthRequestWithResult<T>> getCurrentRequest() {
        return this.currentRequest;
    }

    @Override
    @NotNull
    public CompletableFuture<T> authorize(@NotNull OAuthRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (!this.currentRequest.compareAndSet(null, new OAuthRequestWithResult<T>(request, new CompletableFuture()))) {
            OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
            Intrinsics.checkNotNull(oAuthRequestWithResult);
            return oAuthRequestWithResult.getResult();
        }
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        Intrinsics.checkNotNull(oAuthRequestWithResult);
        CompletableFuture<T> result = oAuthRequestWithResult.getResult();
        result.whenComplete((arg_0, arg_1) -> OAuthServiceBase.authorize$lambda$1((arg_0, arg_1) -> OAuthServiceBase.authorize$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
        this.startAuthorization(request);
        return result;
    }

    private final String getAuthorizationCode(Map<String, ? extends List<String>> $this$getAuthorizationCode) {
        List<String> list = $this$getAuthorizationCode.get("code");
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    @Override
    @Deprecated(message="Use handleOAuthServerCallback instead", replaceWith=@ReplaceWith(expression="handleOAuthServerCallback", imports={}))
    public boolean handleServerCallback(@NotNull String path, @NotNull Map<String, ? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        if (oAuthRequestWithResult == null) {
            return false;
        }
        OAuthRequestWithResult<T> request = oAuthRequestWithResult;
        if (!Intrinsics.areEqual((Object)path, (Object)request.getRequest().getAuthorizationCodeUrl().getPath())) {
            return false;
        }
        String code = this.getAuthorizationCode(parameters);
        if (code == null) {
            List<String> list = parameters.get("error");
            String error = list != null ? (String)CollectionsKt.firstOrNull(list) : null;
            List<String> list2 = parameters.get("error_description");
            String error_description = list2 != null ? (String)CollectionsKt.firstOrNull(list2) : null;
            CompletableFuture<T> completableFuture = request.getResult();
            String string = error_description;
            if (string == null && (string = error) == null) {
                string = "Unknown error";
            }
            completableFuture.completeExceptionally(new RuntimeException(string));
            return false;
        }
        this.processCode(request, code);
        CompletableFuture<T> result = request.getResult();
        return result.isDone() && !result.isCancelled() && !result.isCompletedExceptionally();
    }

    @Override
    @Nullable
    public OAuthService.OAuthResult<T> handleOAuthServerCallback(@NotNull String path, @NotNull Map<String, ? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        if (oAuthRequestWithResult == null || (oAuthRequestWithResult = oAuthRequestWithResult.getRequest()) == null) {
            return null;
        }
        OAuthRequestWithResult<T> request = oAuthRequestWithResult;
        boolean isAccepted = this.handleServerCallback(path, parameters);
        return new OAuthService.OAuthResult(request, isAccepted);
    }

    @Override
    @Nullable
    public OAuthService.OAuthResultCredentials<T> handleOAuthServerCredentialsCallback(@NotNull String path, @NotNull Map<String, ? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        OAuthRequestWithResult<T> currentRequest = this.currentRequest.get();
        OAuthRequestWithResult<T> oAuthRequestWithResult = currentRequest;
        if (oAuthRequestWithResult == null || (oAuthRequestWithResult = oAuthRequestWithResult.getRequest()) == null) {
            return null;
        }
        OAuthRequestWithResult<T> request = oAuthRequestWithResult;
        boolean isAccepted = this.handleServerCallback(path, parameters);
        return new OAuthService.OAuthResultCredentials(request, isAccepted ? Result.constructor-impl(currentRequest.getResult().get()) : Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CallbackNotReadyException("Server callback is not ready or completed exceptionally"))));
    }

    protected void startAuthorization(@NotNull OAuthRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String string = request.getAuthUrlWithParameters().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        String authUrl = string;
        BrowserUtil.browse((String)authUrl);
    }

    private final void processCode(OAuthRequestWithResult<T> $this$processCode, String code) {
        block4: {
            try {
                boolean bl;
                OAuthCredentialsAcquirer.AcquireCredentialsResult<T> acquireResult = $this$processCode.getRequest().getCredentialsAcquirer().acquireCredentials(code);
                if (acquireResult instanceof OAuthCredentialsAcquirer.AcquireCredentialsResult.Success) {
                    bl = $this$processCode.getResult().complete(((OAuthCredentialsAcquirer.AcquireCredentialsResult.Success)acquireResult).getCredentials());
                    break block4;
                }
                if (acquireResult instanceof OAuthCredentialsAcquirer.AcquireCredentialsResult.Error) {
                    bl = $this$processCode.getResult().completeExceptionally(new RuntimeException(((OAuthCredentialsAcquirer.AcquireCredentialsResult.Error)acquireResult).getDescription()));
                    break block4;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (Exception e) {
                $this$processCode.getResult().completeExceptionally(e);
            }
        }
    }

    private static final Unit authorize$lambda$0(OAuthServiceBase this$0, Credentials credentials, Throwable throwable) {
        this$0.currentRequest.set(null);
        return Unit.INSTANCE;
    }

    private static final void authorize$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0003J/\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase$OAuthRequestWithResult;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "", "request", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "result", "Ljava/util/concurrent/CompletableFuture;", "<init>", "(Lcom/intellij/collaboration/auth/services/OAuthRequest;Ljava/util/concurrent/CompletableFuture;)V", "getRequest", "()Lcom/intellij/collaboration/auth/services/OAuthRequest;", "getResult", "()Ljava/util/concurrent/CompletableFuture;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.collaborationTools.auth.base"})
    protected static final class OAuthRequestWithResult<T extends Credentials> {
        @NotNull
        private final OAuthRequest<T> request;
        @NotNull
        private final CompletableFuture<T> result;

        public OAuthRequestWithResult(@NotNull OAuthRequest<T> request, @NotNull CompletableFuture<T> result) {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            this.request = request;
            this.result = result;
        }

        @NotNull
        public final OAuthRequest<T> getRequest() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<T> getResult() {
            return this.result;
        }

        @NotNull
        public final OAuthRequest<T> component1() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<T> component2() {
            return this.result;
        }

        @NotNull
        public final OAuthRequestWithResult<T> copy(@NotNull OAuthRequest<T> request, @NotNull CompletableFuture<T> result) {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            return new OAuthRequestWithResult<T>(request, result);
        }

        public static /* synthetic */ OAuthRequestWithResult copy$default(OAuthRequestWithResult oAuthRequestWithResult, OAuthRequest oAuthRequest, CompletableFuture completableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                oAuthRequest = oAuthRequestWithResult.request;
            }
            if ((n & 2) != 0) {
                completableFuture = oAuthRequestWithResult.result;
            }
            return oAuthRequestWithResult.copy(oAuthRequest, completableFuture);
        }

        @NotNull
        public String toString() {
            return "OAuthRequestWithResult(request=" + this.request + ", result=" + this.result + ")";
        }

        public int hashCode() {
            int result = this.request.hashCode();
            result = result * 31 + this.result.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OAuthRequestWithResult)) {
                return false;
            }
            OAuthRequestWithResult oAuthRequestWithResult = (OAuthRequestWithResult)other;
            if (!Intrinsics.areEqual(this.request, oAuthRequestWithResult.request)) {
                return false;
            }
            return Intrinsics.areEqual(this.result, oAuthRequestWithResult.result);
        }
    }
}

