/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleDsl;
import org.jetbrains.plugins.gradle.frameworkSupport.script.GradleScriptBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.script.GradleScriptElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010'\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010)\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010+\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010,\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010,\u001a\u00020\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0/2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010,\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u00101\u001a\u00020\u00152\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110/H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptBuilderImpl;", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptBuilder;", "gradleDsl", "Lorg/jetbrains/plugins/gradle/frameworkSupport/GradleDsl;", "<init>", "(Lorg/jetbrains/plugins/gradle/frameworkSupport/GradleDsl;)V", "getGradleDsl", "()Lorg/jetbrains/plugins/gradle/frameworkSupport/GradleDsl;", "lines", "Ljava/util/ArrayList;", "", "generate", "root", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$BlockElement;", "addArgumentElement", "", "element", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$ArgumentElement;", "indent", "", "isNewLine", "", "addPropertyElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$PropertyElement;", "addAssignElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$AssignElement;", "addPlusAssignElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$PlusAssignElement;", "addBlockElement", "addCallElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$CallElement;", "addCodeElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$CodeElement;", "addInfixCallElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$InfixCall;", "addIntElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$IntElement;", "addBooleanElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$BooleanElement;", "addStringElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$StringElement;", "addListElement", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement$Statement$Expression$ListElement;", "addNewLineElement", "add", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptElement;", "elements", "", "code", "hasTrailingBlock", "arguments", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleScriptBuilderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptBuilderImpl.kt\norg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptBuilderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1915#2,2:194\n1915#2,2:196\n*S KotlinDebug\n*F\n+ 1 GradleScriptBuilderImpl.kt\norg/jetbrains/plugins/gradle/frameworkSupport/script/GradleScriptBuilderImpl\n*L\n20#1:194,2\n22#1:196,2\n*E\n"})
public final class GradleScriptBuilderImpl
implements GradleScriptBuilder {
    @NotNull
    private final GradleDsl gradleDsl;
    @NotNull
    private final ArrayList<String> lines;

    public GradleScriptBuilderImpl(@NotNull GradleDsl gradleDsl) {
        Intrinsics.checkNotNullParameter((Object)((Object)gradleDsl), (String)"gradleDsl");
        this.gradleDsl = gradleDsl;
        this.lines = new ArrayList();
    }

    @Override
    @NotNull
    public GradleDsl getGradleDsl() {
        return this.gradleDsl;
    }

    @Override
    @NotNull
    public String generate(@NotNull GradleScriptElement.Statement.Expression.BlockElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.lines.clear();
        Iterable $this$forEach$iv = root.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleScriptElement.Statement it = (GradleScriptElement.Statement)element$iv;
            boolean bl = false;
            this.add(it, 0, true);
        }
        StringJoiner joiner = new StringJoiner("\n");
        Iterable $this$forEach$iv2 = this.lines;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CharSequence p0 = (CharSequence)element$iv;
            boolean bl = false;
            joiner.add(p0);
        }
        String string = joiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void addArgumentElement(GradleScriptElement.ArgumentElement element, int indent, boolean isNewLine) {
        String argumentNameSeparator = switch (WhenMappings.$EnumSwitchMapping$0[this.getGradleDsl().ordinal()]) {
            case 1 -> ": ";
            case 2 -> " = ";
            default -> throw new NoWhenBranchMatchedException();
        };
        if (element.getName() != null) {
            this.add(element.getName(), indent, isNewLine);
            this.add(argumentNameSeparator, indent, false);
        }
        this.add(element.getValue(), indent, false);
    }

    private final void addPropertyElement(GradleScriptElement.Statement.PropertyElement element, int indent, boolean isNewLine) {
        String propertyDefinition = switch (WhenMappings.$EnumSwitchMapping$0[this.getGradleDsl().ordinal()]) {
            case 1 -> "def";
            case 2 -> "var";
            default -> throw new NoWhenBranchMatchedException();
        };
        this.add(propertyDefinition, indent, isNewLine);
        this.add(" ", indent, false);
        this.add(element.getName(), indent, false);
        this.add(" = ", indent, false);
        this.add(element.getValue(), indent, false);
    }

    private final void addAssignElement(GradleScriptElement.Statement.AssignElement element, int indent, boolean isNewLine) {
        this.add(element.getLeft(), indent, isNewLine);
        this.add(" = ", indent, false);
        this.add(element.getRight(), indent, false);
    }

    private final void addPlusAssignElement(GradleScriptElement.Statement.PlusAssignElement element, int indent, boolean isNewLine) {
        this.add(element.getName(), indent, isNewLine);
        this.add(" += ", indent, false);
        this.add(element.getValue(), indent, false);
    }

    private final void addBlockElement(GradleScriptElement.Statement.Expression.BlockElement element, int indent, boolean isNewLine) {
        this.add("{", indent, isNewLine);
        for (GradleScriptElement.Statement statement : element.getStatements()) {
            this.add(statement, indent + 1, true);
        }
        this.add("}", indent, true);
    }

    private final void addCallElement(GradleScriptElement.Statement.Expression.CallElement element, int indent, boolean isNewLine) {
        this.add(element.getName(), indent, isNewLine);
        if (this.hasTrailingBlock(element.getArguments())) {
            if (element.getArguments().size() > 1) {
                this.add("(", indent, false);
                this.add(CollectionsKt.dropLast(element.getArguments(), (int)1), indent);
                this.add(")", indent, false);
            }
            this.add(" ", indent, false);
            this.add(((GradleScriptElement.ArgumentElement)CollectionsKt.last(element.getArguments())).getValue(), indent, false);
        } else if (this.getGradleDsl() == GradleDsl.GROOVY && isNewLine && !((Collection)element.getArguments()).isEmpty()) {
            this.add(" ", indent, false);
            this.add(element.getArguments(), indent);
        } else {
            this.add("(", indent, false);
            this.add(element.getArguments(), indent);
            this.add(")", indent, false);
        }
    }

    private final void addCodeElement(GradleScriptElement.Statement.Expression.CodeElement element, int indent, boolean isNewLine) {
        for (String line : element.getText()) {
            this.add(line, indent, isNewLine);
        }
    }

    private final void addInfixCallElement(GradleScriptElement.Statement.Expression.InfixCall element, int indent, boolean isNewLine) {
        this.add(element.getLeft(), indent, isNewLine);
        this.add(" ", indent, false);
        this.add(element.getName(), indent, false);
        this.add(" ", indent, false);
        this.add(element.getRight(), indent, false);
    }

    private final void addIntElement(GradleScriptElement.Statement.Expression.IntElement element, int indent, boolean isNewLine) {
        this.add(String.valueOf(element.getValue()), indent, isNewLine);
    }

    private final void addBooleanElement(GradleScriptElement.Statement.Expression.BooleanElement element, int indent, boolean isNewLine) {
        this.add(String.valueOf(element.getValue()), indent, isNewLine);
    }

    private final void addStringElement(GradleScriptElement.Statement.Expression.StringElement element, int indent, boolean isNewLine) {
        boolean isUseDoubleQuotes = switch (WhenMappings.$EnumSwitchMapping$0[this.getGradleDsl().ordinal()]) {
            case 1 -> StringsKt.contains$default((CharSequence)element.getValue(), (char)'$', (boolean)false, (int)2, null);
            case 2 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
        String escapedString = StringsKt.replace$default((String)StringsKt.replace$default((String)element.getValue(), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
        String string = isUseDoubleQuotes ? "\"" + StringsKt.replace$default((String)escapedString, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\"" : "'" + StringsKt.replace$default((String)escapedString, (String)"'", (String)"\\'", (boolean)false, (int)4, null) + "'";
        this.add(string, indent, isNewLine);
    }

    private final void addListElement(GradleScriptElement.Statement.Expression.ListElement element, int indent, boolean isNewLine) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getGradleDsl().ordinal()]) {
            case 1: {
                this.add("[", indent, isNewLine);
                this.add(element.getElements(), indent);
                this.add("]", indent, false);
                break;
            }
            case 2: {
                this.add("listOf(", indent, isNewLine);
                this.add(element.getElements(), indent);
                this.add(")", indent, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void addNewLineElement(int indent, boolean isNewLine) {
        this.add("", indent, isNewLine);
    }

    private final void add(GradleScriptElement element, int indent, boolean isNewLine) {
        GradleScriptElement gradleScriptElement = element;
        if (gradleScriptElement instanceof GradleScriptElement.ArgumentElement) {
            this.addArgumentElement((GradleScriptElement.ArgumentElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.NewLineElement) {
            this.addNewLineElement(indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.PropertyElement) {
            this.addPropertyElement((GradleScriptElement.Statement.PropertyElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.AssignElement) {
            this.addAssignElement((GradleScriptElement.Statement.AssignElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.PlusAssignElement) {
            this.addPlusAssignElement((GradleScriptElement.Statement.PlusAssignElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.IntElement) {
            this.addIntElement((GradleScriptElement.Statement.Expression.IntElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.BooleanElement) {
            this.addBooleanElement((GradleScriptElement.Statement.Expression.BooleanElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.StringElement) {
            this.addStringElement((GradleScriptElement.Statement.Expression.StringElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.ListElement) {
            this.addListElement((GradleScriptElement.Statement.Expression.ListElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.CodeElement) {
            this.addCodeElement((GradleScriptElement.Statement.Expression.CodeElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.InfixCall) {
            this.addInfixCallElement((GradleScriptElement.Statement.Expression.InfixCall)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.CallElement) {
            this.addCallElement((GradleScriptElement.Statement.Expression.CallElement)element, indent, isNewLine);
        } else if (gradleScriptElement instanceof GradleScriptElement.Statement.Expression.BlockElement) {
            this.addBlockElement((GradleScriptElement.Statement.Expression.BlockElement)element, indent, isNewLine);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void add(List<? extends GradleScriptElement> elements, int indent) {
        Iterator iterator = ((Iterable)elements).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            GradleScriptElement argument = (GradleScriptElement)iterator.next();
            if (i != 0) {
                this.add(", ", indent, false);
            }
            this.add(argument, indent, false);
        }
    }

    private final void add(String code, int indent, boolean isNewLine) {
        if (isNewLine || this.lines.isEmpty()) {
            boolean bl = StringsKt.isBlank((CharSequence)code) ? this.lines.add(code) : this.lines.add(StringsKt.repeat((CharSequence)"    ", (int)indent) + code);
        } else {
            ArrayList<String> arrayList = this.lines;
            int n = CollectionsKt.getLastIndex((List)this.lines);
            arrayList.set(n, arrayList.get(n) + code);
        }
    }

    private final boolean hasTrailingBlock(List<GradleScriptElement.ArgumentElement> arguments) {
        GradleScriptElement.ArgumentElement argumentElement = (GradleScriptElement.ArgumentElement)CollectionsKt.lastOrNull(arguments);
        if (argumentElement == null) {
            return false;
        }
        GradleScriptElement.ArgumentElement last = argumentElement;
        return last.getValue() instanceof GradleScriptElement.Statement.Expression.BlockElement && last.getName() == null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradleDsl.values().length];
            try {
                nArray[GradleDsl.GROOVY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleDsl.KOTLIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

