/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.core.AbstractServerCommunicatorKt;
import com.intellij.settingsSync.core.InvalidVersionIdException;
import com.intellij.settingsSync.core.ServerState;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.core.SettingsSyncLocalSettings;
import com.intellij.settingsSync.core.SettingsSyncPushResult;
import com.intellij.settingsSync.core.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.core.SettingsSynchronizerKt;
import com.intellij.settingsSync.core.UpdateResult;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\bH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J \u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00102\u0006\u0010\u0012\u001a\u00020\fH$J$\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0011H$J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\fH$J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH$J\u0016\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0005J'\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\"\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/settingsSync/core/AbstractServerCommunicator;", "Lcom/intellij/settingsSync/core/SettingsSyncRemoteCommunicator;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "myTemporary", "", "setTemporary", "", "isTemporary", "requestSuccessful", "handleRemoteError", "", "e", "", "readFileInternal", "Lkotlin/Pair;", "Ljava/io/InputStream;", "filePath", "writeFileInternal", "versionId", "content", "getLatestVersion", "deleteFileInternal", "currentSnapshotFilePath", "sendSnapshotFile", "Lcom/intellij/settingsSync/core/SettingsSyncPushResult;", "inputStream", "knownServerVersion", "force", "sendSnapshotFile$intellij_settingsSync_core", "checkServerState", "Lcom/intellij/settingsSync/core/ServerState;", "receiveUpdates", "Lcom/intellij/settingsSync/core/UpdateResult;", "push", "snapshot", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "expectedServerVersionId", "createFile", "deleteFile", "isFileExists", "intellij.settingsSync.core"})
public abstract class AbstractServerCommunicator
implements SettingsSyncRemoteCommunicator,
Disposable {
    private boolean myTemporary;

    @Override
    public void setTemporary(boolean isTemporary) {
        this.myTemporary = isTemporary;
    }

    protected void requestSuccessful() {
    }

    @NotNull
    protected abstract String handleRemoteError(@NotNull Throwable var1);

    @NotNull
    protected abstract Pair<InputStream, String> readFileInternal(@NotNull String var1) throws IOException;

    @Nullable
    protected abstract String writeFileInternal(@NotNull String var1, @Nullable String var2, @NotNull InputStream var3) throws IOException, InvalidVersionIdException;

    @Nullable
    protected abstract String getLatestVersion(@NotNull String var1) throws IOException;

    protected abstract void deleteFileInternal(@NotNull String var1) throws IOException;

    @VisibleForTesting
    @Nullable
    protected final Pair<String, Boolean> currentSnapshotFilePath() throws IOException, SecurityException {
        try {
            boolean crossIdeSyncEnabled = this.isFileExists("cross-ide-sync-enabled");
            if (!this.myTemporary && crossIdeSyncEnabled != SettingsSyncLocalSettings.Companion.getInstance().isCrossIdeSyncEnabled()) {
                AbstractServerCommunicatorKt.access$getLOG$p().info("Cross-IDE sync status on server is: " + SettingsSynchronizerKt.enabledOrDisabled(crossIdeSyncEnabled) + ". Updating local settings with it.");
                SettingsSyncLocalSettings.Companion.getInstance().setCrossIdeSyncEnabled(crossIdeSyncEnabled);
            }
            if (crossIdeSyncEnabled) {
                return new Pair((Object)"settings.sync.snapshot.zip", (Object)true);
            }
            String string = ApplicationNamesInfo.getInstance().getProductName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return new Pair((Object)(string2 + "/settings.sync.snapshot.zip"), (Object)false);
        }
        catch (Throwable e) {
            if (e instanceof IOException || e instanceof SecurityException) {
                throw e;
            }
            AbstractServerCommunicatorKt.access$getLOG$p().warn("Couldn't check if cross-ide-sync-enabled exists", e);
            return null;
        }
    }

    @VisibleForTesting
    @NotNull
    public final SettingsSyncPushResult sendSnapshotFile$intellij_settingsSync_core(@NotNull InputStream inputStream, @Nullable String knownServerVersion, boolean force) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Object snapshotFilePath = null;
        String defaultMessage = "Unknown during checking cross-ide-sync-enabled";
        try {
            Object object = this.currentSnapshotFilePath();
            if (object == null || (object = (String)object.getFirst()) == null) {
                return new SettingsSyncPushResult.Error(defaultMessage);
            }
            snapshotFilePath = object;
            String versionToPush = null;
            if (force) {
                versionToPush = this.getLatestVersion((String)snapshotFilePath);
            } else if (knownServerVersion != null) {
                versionToPush = knownServerVersion;
            } else {
                String serverVersion = this.getLatestVersion((String)snapshotFilePath);
                if (serverVersion == null) {
                    versionToPush = null;
                } else {
                    return SettingsSyncPushResult.Rejected.INSTANCE;
                }
            }
            String pushedVersion = this.writeFileInternal((String)snapshotFilePath, versionToPush, inputStream);
            return new SettingsSyncPushResult.Success(pushedVersion);
        }
        catch (Throwable e) {
            String string = e.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
            return new SettingsSyncPushResult.Error(string);
        }
    }

    @Override
    @NotNull
    public ServerState checkServerState() {
        try {
            Object object = this.currentSnapshotFilePath();
            if (object == null || (object = (String)object.getFirst()) == null) {
                return new ServerState.Error("Unknown error during checkServerState");
            }
            Object snapshotFilePath = object;
            String latestVersion = this.getLatestVersion((String)snapshotFilePath);
            AbstractServerCommunicatorKt.access$getLOG$p().debug("Latest version info: " + latestVersion);
            this.requestSuccessful();
            String string = latestVersion;
            if (string == null) {
                return ServerState.FileNotExists.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)string, (Object)SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId())) {
                return ServerState.UpToDate.INSTANCE;
            }
            return ServerState.UpdateNeeded.INSTANCE;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            return new ServerState.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UpdateResult receiveUpdates() {
        AbstractServerCommunicatorKt.access$getLOG$p().info("Receiving settings snapshot from the cloud config server...");
        try {
            Pair<String, Boolean> pair = this.currentSnapshotFilePath();
            if (pair == null) {
                return new UpdateResult.Error("Unknown error during receiveUpdates");
            }
            Pair<String, Boolean> pair2 = pair;
            String snapshotFilePath = (String)pair2.component1();
            boolean isCrossIdeSync = (Boolean)pair2.component2();
            Pair<InputStream, String> pair3 = this.readFileInternal(snapshotFilePath);
            InputStream stream = (InputStream)pair3.component1();
            String version = (String)pair3.component2();
            this.requestSuccessful();
            if (stream == null) {
                AbstractServerCommunicatorKt.access$getLOG$p().info(snapshotFilePath + " not found on the server");
                return UpdateResult.NoFileOnServer.INSTANCE;
            }
            File file = FileUtil.createTempFile((String)"settings.sync.snapshot", (String)(UUID.randomUUID().toString() + ".zip"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File tempFile = file;
            try {
                FileUtil.writeToFile((File)tempFile, (byte[])stream.readAllBytes());
                Path path = tempFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                SettingsSnapshot snapshot = SettingsSnapshotZipSerializer.INSTANCE.extractFromZip(path);
                if (snapshot == null) {
                    AbstractServerCommunicatorKt.access$getLOG$p().info("cannot extract snapshot from tempFile " + tempFile.toPath() + ". Implying there's no snapshot");
                    UpdateResult updateResult = UpdateResult.NoFileOnServer.INSTANCE;
                    return updateResult;
                }
                UpdateResult updateResult = snapshot.isDeleted() ? (UpdateResult)UpdateResult.FileDeletedFromServer.INSTANCE : (UpdateResult)new UpdateResult.Success(snapshot, version, isCrossIdeSync);
                return updateResult;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            return new UpdateResult.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot, boolean force, @Nullable String expectedServerVersionId) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AbstractServerCommunicatorKt.access$getLOG$p().info("Pushing setting snapshot to the cloud config server...");
        try {
            path = SettingsSnapshotZipSerializer.INSTANCE.serializeToZip(snapshot);
        }
        catch (Throwable e) {
            AbstractServerCommunicatorKt.access$getLOG$p().warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = "Couldn't prepare zip file";
            }
            return new SettingsSyncPushResult.Error(string);
        }
        Path zip = path;
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(zip, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            SettingsSyncPushResult pushResult = this.sendSnapshotFile$intellij_settingsSync_core(inputStream, expectedServerVersionId, force);
            this.requestSuccessful();
            SettingsSyncPushResult e = pushResult;
            return e;
        }
        catch (InvalidVersionIdException ive) {
            AbstractServerCommunicatorKt.access$getLOG$p().info("Rejected: version doesn't match the version on server: " + ive.getMessage());
            SettingsSyncPushResult e = SettingsSyncPushResult.Rejected.INSTANCE;
            return e;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            SettingsSyncPushResult settingsSyncPushResult = new SettingsSyncPushResult.Error(message);
            return settingsSyncPushResult;
        }
        finally {
            try {
                PathKt.delete$default((Path)zip, (boolean)false, (int)1, null);
            }
            catch (Throwable e) {
                AbstractServerCommunicatorKt.access$getLOG$p().warn(e);
            }
        }
    }

    @Override
    public void createFile(@NotNull String filePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.writeFileInternal(filePath, null, new ByteArrayInputStream(byArray));
    }

    @Override
    public void deleteFile(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(null);
        this.deleteFileInternal(filePath);
    }

    @Override
    public boolean isFileExists(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.getLatestVersion(filePath) != null;
    }
}

