/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.Processors;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingKt;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePathsKt;
import com.intellij.util.indexing.impl.storage.IndexStorageLayoutLocator;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.CompareIndices;
import com.jetbrains.performancePlugin.commands.CompareIndicesKt;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.commands.StoredIndexedFileResolver;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import com.jetbrains.performancePlugin.utils.indexes.CurrentIndexedFileResolver;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001[B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J<\u0010&\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'\u0012\u0004\u0012\u00020(0\u00172\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J.\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00112\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002JV\u00103\u001a\u00020 \"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\f\u00106\u001a\b\u0012\u0004\u0012\u00020.0\u00112\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020%H\u0002J\u008a\u0001\u00108\u001a\u00020 \"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'2\f\u00106\u001a\b\u0012\u0004\u0012\u00020.0\u00112\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\u001c\u0010<\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\u0006\u00101\u001a\u0002022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u008a\u0001\u0010=\u001a\u00020 \"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'2\f\u00106\u001a\b\u0012\u0004\u0012\u00020.0\u00112\u001c\u0010<\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\u0006\u00101\u001a\u0002022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0080\u0001\u0010>\u001a\u00020 \"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'2\u001c\u0010<\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\f\u00106\u001a\b\u0012\u0004\u0012\u00020.0\u00112\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H40\u001b2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H40\u001b2\u0006\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020%H\u0002J&\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H50B\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H50CH\u0002JB\u0010D\u001a\u0014\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020F0E\"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\u0006\u0010!\u001a\u00020\u000e2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'H\u0002J|\u0010G\u001a\u00020 \"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\u0006\u0010H\u001a\u00020.2\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\u001c\u0010<\u001a\u0018\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H5\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'2\u0006\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020%H\u0002J`\u0010I\u001a\u00020 \"\u0004\b\u0000\u00104\"\u0004\b\u0001\u001052\u0006\u0010H\u001a\u00020.2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50'2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50B2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50B2\u0006\u0010$\u001a\u00020%H\u0002J \u0010L\u001a\u00020M2\u000e\u00107\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010N\u001a\u00020\u0003H\u0002J \u0010L\u001a\u00020M2\u000e\u00107\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010H\u001a\u00020.H\u0002J \u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u00112\u0006\u0010H\u001a\u00020.2\b\b\u0002\u0010Q\u001a\u00020\u0003H\u0002J \u0010R\u001a\b\u0012\u0004\u0012\u00020P0\u00112\u0006\u0010H\u001a\u00020.2\b\b\u0002\u0010Q\u001a\u00020\u0003H\u0002J0\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020\u00032\u000e\u00107\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010H\u001a\u00020.2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010U\u001a\u00020M2\u0006\u0010V\u001a\u00020W2\u000e\u00107\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020W0\u00112\u0006\u0010V\u001a\u00020WH\u0002J\u0014\u0010Y\u001a\u00020\u0003*\u00020\u00032\u0006\u0010Z\u001a\u00020\u0003H\u0002R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R-\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00170\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u0018\u0010\u0013R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0015\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\\"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "getStoredIndicesDirectory", "Ljava/nio/file/Path;", "getFailureDiagnosticDirectory", "ignoredFilesPatterns", "", "getIgnoredFilesPatterns", "()Ljava/util/List;", "ignoredFilesPatterns$delegate", "Lkotlin/Lazy;", "ignoredPatternsForReporting", "Lkotlin/Pair;", "getIgnoredPatternsForReporting", "ignoredPatternsForReporting$delegate", "fileTypesWithNoStubTree", "", "getFileTypesWithNoStubTree", "()Ljava/util/Set;", "fileTypesWithNoStubTree$delegate", "compareIndexes", "", "storedIndexDir", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "findFileBasedIndexExtension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lcom/intellij/openapi/Disposable;", "id", "Lcom/intellij/util/indexing/ID;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resolveFiles", "Lcom/jetbrains/performancePlugin/commands/CompareIndices$FileDescriptor;", "storedIndexedFileResolver", "Lcom/jetbrains/performancePlugin/commands/StoredIndexedFileResolver;", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "compareCurrentAndStoredIndexData", "K", "V", "resolvedFiles", "extension", "compareForwardIndexes", "currentIndex", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "storedIndex", "compareInvertedIndexes", "checkNoKeysAreMissing", "allStoredKeys", "allCurrentKeys", "toMap", "", "Lcom/intellij/util/indexing/ValueContainer;", "openStoredIndex", "Lcom/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex;", "Lcom/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex$IndexerIdHolder;", "compareFileData", "fileDescriptor", "assertForwardIndexDataAreTheSameForFile", "expectedData0", "actualData0", "isKnownError", "", "fileNameOrIndexData", "createAttachmentsForActualFile", "Lcom/intellij/openapi/diagnostic/Attachment;", "pathPrefix", "createAttachmentsForExpectedFile", "buildFileDataMismatchMessage", "reason", "doesFileHaveProvidedIndex", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileAndAllRelevantSiblings", "withIndent", "indent", "FileDescriptor", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCompareIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareIndices.kt\ncom/jetbrains/performancePlugin/commands/CompareIndices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,724:1\n1#2:725\n1300#3,2:726\n1315#3,4:728\n1480#3,5:743\n1220#3,2:748\n1249#3,4:750\n1220#3,2:754\n1249#3,4:756\n1266#3,4:762\n1266#3,4:768\n1915#3,2:774\n1915#3,2:776\n1586#3:778\n1661#3,3:779\n1586#3:782\n1661#3,3:783\n1586#3:792\n1661#3,3:793\n832#3:796\n862#3,2:797\n1586#3:799\n1661#3,3:800\n832#3:803\n862#3,2:804\n1915#3,2:806\n1915#3,2:808\n832#3:810\n862#3,2:811\n1807#3,3:813\n507#4,7:732\n466#4:760\n415#4:761\n466#4:766\n415#4:767\n491#4,7:816\n129#5:739\n158#5,3:740\n37#6,2:772\n18#6:788\n1276#7,2:786\n3938#8:789\n4474#8,2:790\n*S KotlinDebug\n*F\n+ 1 CompareIndices.kt\ncom/jetbrains/performancePlugin/commands/CompareIndices\n*L\n191#1:726,2\n191#1:728,4\n268#1:743,5\n383#1:748,2\n383#1:750,4\n449#1:754,2\n449#1:756,4\n571#1:762,4\n572#1:768,4\n618#1:774,2\n632#1:776,2\n642#1:778\n642#1:779,3\n649#1:782\n649#1:783,3\n135#1:792\n135#1:793,3\n135#1:796\n135#1:797,2\n143#1:799\n143#1:800,3\n143#1:803\n143#1:804,2\n143#1:806,2\n148#1:808,2\n158#1:810\n158#1:811,2\n278#1:813,3\n226#1:732,7\n571#1:760\n571#1:761\n572#1:766\n572#1:767\n455#1:816,7\n226#1:739\n226#1:740,3\n609#1:772,2\n691#1:788\n680#1:786,2\n691#1:789\n691#1:790,2\n*E\n"})
public final class CompareIndices
extends AbstractCommand {
    @NotNull
    private final Lazy ignoredFilesPatterns$delegate;
    @NotNull
    private final Lazy ignoredPatternsForReporting$delegate;
    @NotNull
    private final Lazy fileTypesWithNoStubTree$delegate;

    public CompareIndices(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
        this.ignoredFilesPatterns$delegate = LazyKt.lazy(CompareIndices::ignoredFilesPatterns_delegate$lambda$0);
        this.ignoredPatternsForReporting$delegate = LazyKt.lazy(CompareIndices::ignoredPatternsForReporting_delegate$lambda$0);
        this.fileTypesWithNoStubTree$delegate = LazyKt.lazy(CompareIndices::fileTypesWithNoStubTree_delegate$lambda$0);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Path storedIndexDir = this.getStoredIndicesDirectory();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CompareIndices._execute$lambda$0(project2, actionCallback, this, storedIndexDir));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final Path getStoredIndicesDirectory() {
        String property;
        String string = property = System.getProperty("compare.indices.command.stored.indexes.directory");
        if (string == null) {
            boolean bl = false;
            String string2 = "Path to stored indices is not specified";
            throw new IllegalStateException(string2.toString());
        }
        String it = string;
        boolean bl = false;
        Path path = Paths.get(it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"let(...)");
        return path;
    }

    private final Path getFailureDiagnosticDirectory() {
        String property = System.getProperty("compare.indices.command.failure.diagnostic.directory");
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = FileUtil.createTempDirectory((String)"compare-indices", (String)"failure").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    private final List<String> getIgnoredFilesPatterns() {
        Lazy lazy = this.ignoredFilesPatterns$delegate;
        return (List)lazy.getValue();
    }

    private final List<Pair<String, String>> getIgnoredPatternsForReporting() {
        Lazy lazy = this.ignoredPatternsForReporting$delegate;
        return (List)lazy.getValue();
    }

    private final Set<String> getFileTypesWithNoStubTree() {
        Lazy lazy = this.fileTypesWithNoStubTree$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void compareIndexes(Path storedIndexDir, ProgressIndicator indicator, Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ToDirectoryWritingErrorCollector it;
        boolean bl;
        Object object;
        Object object2;
        void $this$associateWithTo$iv$iv;
        Path failureDiagnosticDirectory = this.getFailureDiagnosticDirectory();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
        indicator.setText(IndexingBundle.message((String)"index.content.diagnostic.reading", (Object[])new Object[0]));
        IndexContentDiagnostic storedIndexContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(storedIndexDir));
        StoredIndexedFileResolver storedIndexedFileResolver = new StoredIndexedFileResolver(storedIndexContentDiagnostic);
        Path path = failureDiagnosticDirectory.resolve("files-resolution-errors");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        ToDirectoryWritingErrorCollector filesErrorCollector = new ToDirectoryWritingErrorCollector("resolve-files", path, 100);
        List<FileDescriptor> resolvedFiles = this.resolveFiles(storedIndexedFileResolver, filesErrorCollector, indicator, project);
        if (filesErrorCollector.getNumberOfErrors() > 0) {
            throw new IllegalArgumentException("Some files cannot be resolved. See <failure-diagnostics-dir>/files-resolution-errors");
        }
        CompareIndicesKt.access$getLOG$p().info("Stored index directory contains: " + StoreIndices.Companion.dumpDirectory(storedIndexDir));
        List idsToCompare = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()), CompareIndices::compareIndexes$lambda$0), CompareIndices::compareIndexes$lambda$1));
        CompareIndicesKt.access$getLOG$p().info("Comparing indexes concurrently");
        Iterable $this$associateWith$iv = idsToCompare;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object t : $this$associateWithTo$iv$iv) {
            object2 = (ID)t;
            Object t2 = t;
            object = destination$iv$iv;
            bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Path path2 = failureDiagnosticDirectory.resolve("errors-for-" + it.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            ToDirectoryWritingErrorCollector toDirectoryWritingErrorCollector = new ToDirectoryWritingErrorCollector(string, path2, 100);
            object.put(t2, toDirectoryWritingErrorCollector);
        }
        Map errorCollectors = destination$iv$iv;
        AtomicInteger finishedCounter = new AtomicInteger();
        ConcurrentTasksProgressManager comparisonTaskProgressManager = new ConcurrentTasksProgressManager(indicator, idsToCompare.size());
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(idsToCompare, indicator, arg_0 -> CompareIndices.compareIndexes$lambda$3(comparisonTaskProgressManager, finishedCounter, idsToCompare, errorCollectors, this, resolvedFiles, storedIndexDir, project, arg_0));
        Map $this$filterValues$iv = errorCollectors;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (ToDirectoryWritingErrorCollector)entry.getValue();
            bl = false;
            if (!(it.getNumberOfErrors() > 0)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv2;
        boolean $i$f$map = false;
        result$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean bl2 = false;
        object2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object2.next();
            object = destination$iv$iv2;
            boolean bl3 = false;
            object.add((ID)it2.getKey());
        }
        List failedIndexes = (List)destination$iv$iv2;
        if (!((Collection)failedIndexes).isEmpty()) {
            throw new RuntimeException("Comparison has failed for indexes [" + CollectionsKt.joinToString$default((Iterable)failedIndexes, null, null, null, (int)0, null, CompareIndices::compareIndexes$lambda$6, (int)31, null) + "]. Details are saved to " + failureDiagnosticDirectory);
        }
        CompareIndicesKt.access$getLOG$p().info("Success. All indices are equal: " + CollectionsKt.joinToString$default((Iterable)idsToCompare, null, null, null, (int)0, null, CompareIndices::compareIndexes$lambda$7, (int)31, null));
    }

    private final Pair<FileBasedIndexExtension<?, ?>, Disposable> findFileBasedIndexExtension(ID<?, ?> id, Path storedIndexDir, CoroutineScope coroutineScope) {
        Pair pair;
        if (Intrinsics.areEqual((Object)id.getName(), (Object)"Stubs")) {
            SerializationManagerImpl storedSerializationManager = new SerializationManagerImpl(storedIndexDir.resolve("rep.names"), true, coroutineScope);
            Map nameStorageDump = storedSerializationManager.dumpNameStorage();
            CompareIndicesKt.access$getLOG$p().info("stored stub element name storage " + nameStorageDump);
            StubForwardIndexExternalizer stubForwardIndexExternalizer = StubForwardIndexExternalizer.createFileLocalExternalizer();
            Intrinsics.checkNotNullExpressionValue((Object)stubForwardIndexExternalizer, (String)"createFileLocalExternalizer(...)");
            StubForwardIndexExternalizer stubForwardIndexExternalizer2 = stubForwardIndexExternalizer;
            FileBasedIndexExtension storedStubUpdatingIndex = (FileBasedIndexExtension)new StubUpdatingIndex(stubForwardIndexExternalizer2, (SerializationManagerEx)storedSerializationManager);
            pair = TuplesKt.to((Object)storedStubUpdatingIndex, (Object)storedSerializationManager);
        } else {
            Object object = FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(arg_0 -> CompareIndices.findFileBasedIndexExtension$lambda$1(arg_0 -> CompareIndices.findFileBasedIndexExtension$lambda$0(id, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)object);
            FileBasedIndexExtension usualExtension = (FileBasedIndexExtension)object;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable emptyDisposable = disposable;
            pair = TuplesKt.to((Object)usualExtension, (Object)emptyDisposable);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileDescriptor> resolveFiles(StoredIndexedFileResolver storedIndexedFileResolver, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Iterable iterable = CurrentIndexedFileResolver.INSTANCE.getAllToBeIndexedFilesInProject(project, indicator).values();
        Collection collection = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet allCurrentFiles = (HashSet)destination$iv;
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.resolving.files", new Object[0]));
        indicator.setIndeterminate(false);
        List<FileDescriptor> fileDescriptors = Collections.synchronizedList(new ArrayList());
        AtomicInteger finished = new AtomicInteger();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(CollectionsKt.toList((Iterable)storedIndexedFileResolver.getOriginalIndexedFiles()), indicator, arg_0 -> CompareIndices.resolveFiles$lambda$1(this, errorCollector, indicator, finished, storedIndexedFileResolver, allCurrentFiles, fileDescriptors, project, arg_0));
        Intrinsics.checkNotNull(fileDescriptors);
        return fileDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <K, V> void compareCurrentAndStoredIndexData(List<FileDescriptor> resolvedFiles, FileBasedIndexExtension<K, V> extension, Path storedIndexDir, ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object[] objectArray = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.index", objectArray));
        indicator.setText2(PerformanceTestingBundle.message("compare.indexes.preparing.indexes", new Object[0]));
        indicator.setIndeterminate(true);
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        ActionsKt.runReadAction(() -> CompareIndices.compareCurrentAndStoredIndexData$lambda$0(fileBasedIndex2, indexId, project));
        UpdatableIndex updatableIndex = fileBasedIndex2.getIndex(indexId);
        Intrinsics.checkNotNullExpressionValue((Object)updatableIndex, (String)"getIndex(...)");
        UpdatableIndex currentIndex = updatableIndex;
        VfsAwareMapReduceIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> storedIndex = this.openStoredIndex(storedIndexDir, extension);
        try {
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            indicator.setText2("");
            if (!(extension.needsForwardIndexWhenSharing() || !(extension instanceof SingleEntryFileBasedIndexExtension))) {
                boolean bl = false;
                String string = "Index " + indexId.getName() + " is SingleEntryFileBasedIndexExtension and does not need forward index. This is a wrong index because SingleEntryFileBasedIndexExtension by its nature effectively consists of only the forward index.";
                throw new IllegalStateException(string.toString());
            }
            if (extension.needsForwardIndexWhenSharing()) {
                this.compareForwardIndexes(extension, resolvedFiles, currentIndex, (UpdatableIndex)storedIndex, errorCollector, indicator, project);
            }
            if (!(extension instanceof SingleEntryFileBasedIndexExtension)) {
                this.compareInvertedIndexes(extension, resolvedFiles, (UpdatableIndex)storedIndex, currentIndex, errorCollector, indicator, project);
            }
        }
        finally {
            storedIndex.dispose();
        }
    }

    private final <K, V> void compareForwardIndexes(FileBasedIndexExtension<K, V> extension, List<FileDescriptor> resolvedFiles, UpdatableIndex<K, V, FileContent, ?> currentIndex, UpdatableIndex<K, V, FileContent, ?> storedIndex, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object object = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.forward.index", (Object[])object));
        object = ((Iterable)resolvedFiles).iterator();
        int n = 0;
        while (object.hasNext()) {
            int finished = n++;
            FileDescriptor resolvedFile = (FileDescriptor)object.next();
            indicator.setFraction((double)finished / (double)resolvedFiles.size());
            indicator.setText2(resolvedFile.getCurrentFile().getUrl());
            this.compareFileData(resolvedFile, currentIndex, storedIndex, extension, errorCollector, project);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void compareInvertedIndexes(FileBasedIndexExtension<K, V> extension, List<FileDescriptor> resolvedFiles, UpdatableIndex<K, V, FileContent, ?> storedIndex, UpdatableIndex<K, V, FileContent, ?> currentIndex, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        void $this$associateByTo$iv$iv;
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object[] objectArray = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.inverted.index", objectArray));
        indicator.setText2(PerformanceTestingBundle.message("compare.indexes.comparing.inverted.index.collecting.keys", new Object[0]));
        indicator.setIndeterminate(true);
        HashSet allStoredKeys = new HashSet();
        errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$0(storedIndex, allStoredKeys, project));
        HashSet allCurrentKeys = new HashSet();
        errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$1(currentIndex, allCurrentKeys, project));
        this.checkNoKeysAreMissing(extension, storedIndex, resolvedFiles, allStoredKeys, allCurrentKeys, errorCollector, project);
        Iterable $this$associateBy$iv = resolvedFiles;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object entry : $this$associateByTo$iv$iv) {
            void it;
            FileDescriptor fileDescriptor = (FileDescriptor)entry;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getOriginalFilePath().getOriginalFileSystemId(), entry);
        }
        Map originalFileIdToFileDescriptor = destination$iv$iv;
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Iterator iterator2 = ((Iterable)allStoredKeys).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Object storedKey = iterator2.next();
            indicator.setFraction((double)index / (double)allStoredKeys.size());
            Map storedFileIdToValue = new LinkedHashMap();
            errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$3(storedIndex, storedKey, storedFileIdToValue, this));
            if (storedFileIdToValue.isEmpty()) continue;
            Map currentFileIdToValue = new LinkedHashMap();
            errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$4(currentIndex, storedKey, currentFileIdToValue, this));
            if (currentFileIdToValue.isEmpty()) continue;
            for (Map.Entry entry : storedFileIdToValue.entrySet()) {
                FileDescriptor fileDescriptor;
                int currentFileId;
                Object currentValue;
                int storedFileId = ((Number)entry.getKey()).intValue();
                Object storedValue = entry.getValue();
                if ((FileDescriptor)originalFileIdToFileDescriptor.get(storedFileId) == null || IndexDataComparer.INSTANCE.areValuesTheSame(extension, storedValue, currentValue = currentFileIdToValue.get(currentFileId = FileBasedIndexImpl.getFileId((VirtualFile)fileDescriptor.getCurrentFile()))) || !this.getIgnoredPatternsForReporting().isEmpty() && this.isKnownError(extension, fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath())) continue;
                errorCollector.runCatchingError((Function0)new Function0(this, storedKey, extension, fileDescriptor, project, storedValue, currentValue){
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ K $storedKey;
                    final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
                    final /* synthetic */ FileDescriptor $fileDescriptor;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ V $storedValue;
                    final /* synthetic */ V $currentValue;
                    {
                        this.this$0 = $receiver;
                        this.$storedKey = $storedKey;
                        this.$extension = $extension;
                        this.$fileDescriptor = $fileDescriptor;
                        this.$project = $project;
                        this.$storedValue = $storedValue;
                        this.$currentValue = $currentValue;
                    }

                    public final Void invoke() {
                        String message = CompareIndices.access$buildFileDataMismatchMessage(this.this$0, "Values mismatch for key " + IndexDataPresenter.INSTANCE.getPresentableIndexKey(this.$storedKey), this.$extension, this.$fileDescriptor, this.$project);
                        ArrayList<E> attachments = new ArrayList<E>();
                        ((Collection)attachments).add(new Attachment("expected-value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(this.$storedValue)));
                        ((Collection)attachments).add(new Attachment("actual-value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(this.$currentValue)));
                        CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForActualFile$default(this.this$0, this.$fileDescriptor, null, 2, null));
                        Collection $this$toTypedArray$iv = attachments;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Attachment[] attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
                        throw new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length));
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void checkNoKeysAreMissing(FileBasedIndexExtension<K, V> extension, UpdatableIndex<K, V, FileContent, ?> storedIndex, List<FileDescriptor> resolvedFiles, Set<? extends K> allStoredKeys, Set<? extends K> allCurrentKeys, ErrorCollector errorCollector, Project project) {
        Set missingKeys = SetsKt.minus(allStoredKeys, (Iterable)allCurrentKeys);
        if (!((Collection)missingKeys).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = resolvedFiles;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FileDescriptor fileDescriptor = (FileDescriptor)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getOriginalFilePath().getOriginalFileSystemId(), element$iv$iv);
            }
            Map originalFileIdToFileDescriptor = destination$iv$iv;
            for (Object missingKey : missingKeys) {
                Map storedFileIdToValue = new LinkedHashMap();
                errorCollector.runCatchingError(() -> CompareIndices.checkNoKeysAreMissing$lambda$1(storedIndex, missingKey, storedFileIdToValue, this, originalFileIdToFileDescriptor));
                if (storedFileIdToValue.isEmpty()) continue;
                FileDescriptor fileDescriptor = (FileDescriptor)originalFileIdToFileDescriptor.get(storedFileIdToValue.entrySet().iterator().next().getKey());
                if (!this.getIgnoredPatternsForReporting().isEmpty() && this.isKnownError(extension, IndexDataPresenter.INSTANCE.getPresentableIndexKey(missingKey))) continue;
                FileDescriptor fileDescriptor2 = fileDescriptor;
                Intrinsics.checkNotNull((Object)fileDescriptor2);
                if (this.isKnownError(extension, fileDescriptor2)) continue;
                errorCollector.runCatchingError((Function0)new Function0(missingKey, storedFileIdToValue, originalFileIdToFileDescriptor, this, extension, project){
                    final /* synthetic */ K $missingKey;
                    final /* synthetic */ Map<Integer, V> $storedFileIdToValue;
                    final /* synthetic */ Map<Integer, FileDescriptor> $originalFileIdToFileDescriptor;
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
                    final /* synthetic */ Project $project;
                    {
                        this.$missingKey = $missingKey;
                        this.$storedFileIdToValue = $storedFileIdToValue;
                        this.$originalFileIdToFileDescriptor = $originalFileIdToFileDescriptor;
                        this.this$0 = $receiver;
                        this.$extension = $extension;
                        this.$project = $project;
                    }

                    public final Void invoke() {
                        StringBuilder stringBuilder;
                        FileBasedIndexExtension<K, V> fileBasedIndexExtension = this.$extension;
                        K k = this.$missingKey;
                        Attachment[] attachmentArray = this.$storedFileIdToValue;
                        Map<Integer, FileDescriptor> object2 = this.$originalFileIdToFileDescriptor;
                        CompareIndices compareIndices = this.this$0;
                        Project project = this.$project;
                        StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.append("Index " + fileBasedIndexExtension.getName().getName() + ": key is unknown to actual index data: " + IndexDataPresenter.INSTANCE.getPresentableIndexKey(k)).append('\n');
                        $this$invoke_u24lambda_u240.append("The key must be present in the index for the following files: ").append('\n');
                        Iterator<Map.Entry<Integer, V>> iterator2 = attachmentArray.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            FileDescriptor fileDescriptor;
                            int storedFileId = ((Number)iterator2.next().getKey()).intValue();
                            if (object2.get(storedFileId) == null) continue;
                            $this$invoke_u24lambda_u240.append(CompareIndices.access$withIndent(compareIndices, CompareIndices.access$buildFileDataMismatchMessage(compareIndices, "Key is not available in the actual index for the file", fileBasedIndexExtension, fileDescriptor, project), "  ")).append('\n');
                            $this$invoke_u24lambda_u240.append('\n');
                        }
                        String message = stringBuilder.toString();
                        ArrayList<E> attachments = new ArrayList<E>();
                        ((Collection)attachments).add(new Attachment("key.txt", IndexDataPresenter.INSTANCE.getPresentableIndexKey(this.$missingKey)));
                        int nextMismatchedFileId = 1;
                        for (Map.Entry entry : this.$storedFileIdToValue.entrySet()) {
                            FileDescriptor fileDescriptor;
                            int storedFileId = ((Number)entry.getKey()).intValue();
                            V storedValue = entry.getValue();
                            if (this.$originalFileIdToFileDescriptor.get(storedFileId) == null) continue;
                            String pathPrefix = "file-and-value-" + nextMismatchedFileId++ + "/";
                            ((Collection)attachments).add(new Attachment(pathPrefix + "value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(storedValue)));
                            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.access$createAttachmentsForActualFile(this.this$0, fileDescriptor, pathPrefix));
                        }
                        Collection collection = attachments;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = collection;
                        attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
                        throw new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length));
                    }
                });
            }
        }
    }

    private final <V> Map<Integer, V> toMap(ValueContainer<V> $this$toMap) {
        HashMap map = new HashMap();
        $this$toMap.forEach((arg_0, arg_1) -> CompareIndices.toMap$lambda$1((arg_0, arg_1) -> CompareIndices.toMap$lambda$0(map, arg_0, arg_1), arg_0, arg_1));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized <K, V> VfsAwareMapReduceIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> openStoredIndex(Path storedIndexDir, FileBasedIndexExtension<K, V> extension) {
        String propertyName = "index_root_path";
        String oldValue = System.setProperty(propertyName, ((Object)storedIndexDir.toAbsolutePath()).toString());
        try {
            VfsAwareMapReduceIndex vfsAwareMapReduceIndex = new VfsAwareMapReduceIndex(extension, IndexStorageLayoutLocator.getLayout(extension));
            return vfsAwareMapReduceIndex;
        }
        finally {
            SystemProperties.setProperty((String)propertyName, (String)oldValue);
        }
    }

    private final <K, V> void compareFileData(FileDescriptor fileDescriptor, UpdatableIndex<K, V, FileContent, ?> currentIndex, UpdatableIndex<K, V, FileContent, ?> storedIndex, FileBasedIndexExtension<K, V> extension, ErrorCollector errorCollector, Project project) {
        Map map = (Map)errorCollector.runCatchingError(() -> CompareIndices.compareFileData$lambda$0(storedIndex, fileDescriptor));
        if (map == null) {
            return;
        }
        Map storedData = map;
        Map map2 = (Map)errorCollector.runCatchingError(() -> CompareIndices.compareFileData$lambda$1(currentIndex, fileDescriptor));
        if (map2 == null) {
            return;
        }
        Map currentData = map2;
        if ((Unit)errorCollector.runCatchingError(() -> CompareIndices.compareFileData$lambda$2(this, fileDescriptor, extension, storedData, currentData, project)) == null) {
            return;
        }
    }

    private final <K, V> void assertForwardIndexDataAreTheSameForFile(FileDescriptor fileDescriptor, FileBasedIndexExtension<K, V> extension, Map<K, ? extends V> expectedData0, Map<K, ? extends V> actualData0, Project project) {
        Map expectedData = null;
        Map actualData = null;
        if (Intrinsics.areEqual((Object)extension.getName(), (Object)StubUpdatingIndex.INDEX_ID) && CollectionsKt.contains((Iterable)this.getFileTypesWithNoStubTree(), (Object)fileDescriptor.getOriginalFilePath().getFileType())) {
            SerializedStubTree serializedStubTree;
            Map.Entry it;
            Map map;
            Object k;
            Map.Entry it$iv$iv;
            boolean bl;
            Map map2;
            Iterable $this$associateByTo$iv$iv$iv;
            Map $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = expectedData0;
            boolean $i$f$mapValues = false;
            Map map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv$iv;
                bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.SerializedStubTree");
                serializedStubTree = ((SerializedStubTree)v).withoutStub();
                map.put(k, serializedStubTree);
            }
            expectedData = destination$iv$iv$iv;
            $this$mapValues$iv = actualData0;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            destination$iv$iv$iv = destination$iv$iv;
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl3 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.SerializedStubTree");
                serializedStubTree = ((SerializedStubTree)v).withoutStub();
                map.put(k, serializedStubTree);
            }
            actualData = destination$iv$iv$iv;
        } else {
            expectedData = expectedData0;
            actualData = actualData0;
        }
        if (IndexDataComparer.INSTANCE.areIndexedDataOfFileTheSame(extension, expectedData, actualData)) {
            return;
        }
        if (this.getIgnoredPatternsForReporting().isEmpty() || !this.isKnownError(extension, fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath())) {
            String message = this.buildFileDataMismatchMessage("Indexed data maps do not match for " + fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath(), extension, fileDescriptor, project);
            Attachment expectedDataAttachment = expectedData.isEmpty() ? new Attachment("expected-data-is-empty.txt", "") : new Attachment("expected-data.txt", IndexDataPresenter.INSTANCE.getPresentableKeyValueMap(expectedData));
            Attachment actualDataAttachment = actualData.isEmpty() ? new Attachment("actual-data-is-empty.txt", "") : new Attachment("actual-data.txt", IndexDataPresenter.INSTANCE.getPresentableKeyValueMap(actualData));
            Object[] objectArray = new Attachment[]{expectedDataAttachment, actualDataAttachment};
            ArrayList attachments = CollectionsKt.arrayListOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForActualFile$default(this, fileDescriptor, null, 2, null));
            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForExpectedFile$default(this, fileDescriptor, null, 2, null));
            Collection $this$toTypedArray$iv = attachments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Attachment[0]);
            throw new RuntimeExceptionWithAttachments(message, (Attachment[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    private final boolean isKnownError(FileBasedIndexExtension<?, ?> extension, String fileNameOrIndexData) {
        String fileExtension = FilesKt.getExtension((File)new File(fileNameOrIndexData));
        Iterable $this$forEach$iv = this.getIgnoredPatternsForReporting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)extension.getName().getName()) || !Intrinsics.areEqual((Object)it.getSecond(), (Object)fileExtension)) continue;
            CompareIndicesKt.access$getLOG$p().info("Reporting index mismatch of " + fileNameOrIndexData + " in " + extension.getName().getName() + " extension is ignored");
            return true;
        }
        return false;
    }

    private final boolean isKnownError(FileBasedIndexExtension<?, ?> extension, FileDescriptor fileDescriptor) {
        String fileExtension = fileDescriptor.getCurrentFile().getExtension();
        Iterable $this$forEach$iv = this.getIgnoredPatternsForReporting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)extension.getName().getName()) || !Intrinsics.areEqual((Object)it.getSecond(), (Object)fileExtension)) continue;
            CompareIndicesKt.access$getLOG$p().info("Reporting index mismatch of " + fileExtension + " in " + extension.getName().getName() + " extension is ignored");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> createAttachmentsForActualFile(FileDescriptor fileDescriptor, String pathPrefix) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.findFileAndAllRelevantSiblings(fileDescriptor.getCurrentFile());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CoreAttachmentFactory.createAttachment((String)(pathPrefix + "actual-file/" + file.getName()), (VirtualFile)file));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List createAttachmentsForActualFile$default(CompareIndices compareIndices, FileDescriptor fileDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return compareIndices.createAttachmentsForActualFile(fileDescriptor, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> createAttachmentsForExpectedFile(FileDescriptor fileDescriptor, String pathPrefix) {
        List list;
        VirtualFile expectedFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(fileDescriptor.getOriginalFilePath().getOriginalFileUrl());
        if (expectedFile != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.findFileAndAllRelevantSiblings(expectedFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CoreAttachmentFactory.createAttachment((String)(pathPrefix + "expected-file/" + file.getName()), (VirtualFile)file));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List createAttachmentsForExpectedFile$default(CompareIndices compareIndices, FileDescriptor fileDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return compareIndices.createAttachmentsForExpectedFile(fileDescriptor, string);
    }

    private final String buildFileDataMismatchMessage(String reason, FileBasedIndexExtension<?, ?> extension, FileDescriptor fileDescriptor, Project project) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFileDataMismatchMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildFileDataMismatchMessage_u24lambda_u240.append("Index mismatch " + extension.getName().getName() + " for " + fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath() + ": " + reason).append('\n');
        $this$buildFileDataMismatchMessage_u24lambda_u240.append("File of expected data:").append('\n');
        $this$buildFileDataMismatchMessage_u24lambda_u240.append(this.withIndent(fileDescriptor.getOriginalFilePath().toString(), "  ")).append('\n');
        $this$buildFileDataMismatchMessage_u24lambda_u240.append("File of actual data:").append('\n');
        IndexedFilePath actualIndexedFilePath = IndexedFilePaths.INSTANCE.createIndexedFilePath(fileDescriptor.getCurrentFile(), project);
        $this$buildFileDataMismatchMessage_u24lambda_u240.append(this.withIndent(actualIndexedFilePath.toString(), "  ")).append('\n');
        if (this.doesFileHaveProvidedIndex(fileDescriptor.getCurrentFile(), extension, project)) {
            $this$buildFileDataMismatchMessage_u24lambda_u240.append("  Index " + extension.getName().getName() + " of this file is provided by index infrastructure extension").append('\n');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doesFileHaveProvidedIndex(VirtualFile file, FileBasedIndexExtension<?, ?> extension, Project project) {
        boolean bl;
        block1: {
            void $this$any$iv;
            int fileId = FileBasedIndex.getFileId((VirtualFile)file);
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()), arg_0 -> CompareIndices.doesFileHaveProvidedIndex$lambda$0(project, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor it = (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor)element$iv;
                boolean bl2 = false;
                if (!it.hasIndexForFile(file, fileId, extension)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final List<VirtualFile> findFileAndAllRelevantSiblings(VirtualFile file) {
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"class")) {
            return CollectionsKt.listOf((Object)file);
        }
        v0 = file.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getNameWithoutExtension(...)");
        fullClassName = v0;
        baseClassName = StringsKt.substringBefore$default((String)fullClassName, (String)"$", null, (int)2, null);
        v1 = file.getParent();
        if (v1 == null) {
            return CollectionsKt.listOf((Object)file);
        }
        parent = v1;
        parent.refresh(false, true);
        $this$orEmpty$iv = parent.getChildren();
        $i$f$orEmpty = false;
        v2 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            v2 = new VirtualFile[]{};
        }
        $this$orEmpty$iv = v2;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var11_11 = ((void)$this$filterTo$iv$iv).length;
        for (var10_10 = 0; var10_10 < var11_11; ++var10_10) {
            it = element$iv$iv = $this$filterTo$iv$iv[var10_10];
            $i$a$-filter-CompareIndices$findFileAndAllRelevantSiblings$1 = false;
            if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"class")) ** GOTO lbl-1000
            if (Intrinsics.areEqual((Object)it.getNameWithoutExtension(), (Object)fullClassName)) ** GOTO lbl-1000
            v3 = it.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getNameWithoutExtension(...)");
            if (StringsKt.startsWith$default((String)v3, (String)(baseClassName + "$"), (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String withIndent(String $this$withIndent, String indent) {
        return SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> CompareIndices.withIndent$lambda$0(indent, arg_0), (int)30, null);
    }

    private static final void _execute$lambda$0(Project $project, ActionCallbackProfilerStopper $actionCallback, CompareIndices this$0, Path $storedIndexDir) {
        String string = PerformanceTestingBundle.message("comparing.indexes", new Object[0]);
        new Task.Modal($project, $actionCallback, this$0, $storedIndexDir, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            final /* synthetic */ CompareIndices this$0;
            final /* synthetic */ Path $storedIndexDir;
            {
                this.$project = $project;
                this.$actionCallback = $actionCallback;
                this.this$0 = $receiver;
                this.$storedIndexDir = $storedIndexDir;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!StubForwardIndexExternalizer.USE_SHAREABLE_STUBS) {
                    this.$actionCallback.reject("Index comparison available only with with -Didea.uses.shareable.serialized.stubs=true");
                    return;
                }
                try {
                    CompareIndices.access$compareIndexes(this.this$0, this.$storedIndexDir, indicator, this.$project);
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CompareIndicesKt.access$getLOG$p().error(e);
                    ActionCallback actionCallback = this.$actionCallback.reject(e.getMessage());
                    Intrinsics.checkNotNull((Object)actionCallback);
                }
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredFilesPatterns_delegate$lambda$0() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("compare.indices.list.of.files.to.ignore.from.comparison");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String listPath = string;
        Path path = Paths.get(listPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List patterns = (List)destination$iv$iv;
        CompareIndicesKt.access$getLOG$p().info("The following files will be ignored from indexes comparison:\n" + CollectionsKt.joinToString$default((Iterable)patterns, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredPatternsForReporting_delegate$lambda$0() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("compare.indices.list.of.patterns.to.ignore.from.reporting");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String fileWithPatterns = string;
        List patternsList = new ArrayList();
        Path path = Paths.get(fileWithPatterns, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null));
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            List attrs = StringsKt.split$default((CharSequence)it2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            patternsList.add(new Pair(attrs.get(0), attrs.get(1)));
        }
        CompareIndicesKt.access$getLOG$p().info("The following patterns will be ignored from failure reporting: ");
        $this$forEach$iv = patternsList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it3 = (Pair)element$iv;
            boolean bl = false;
            CompareIndicesKt.access$getLOG$p().info("Files ." + it3.getFirst() + " in index " + it3.getSecond());
        }
        return patternsList;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set fileTypesWithNoStubTree_delegate$lambda$0() {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        String string = System.getProperty("compare.indices.file.types.with.no.stub.tree", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String[] stringArray = new String[]{","};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    private static final boolean compareIndexes$lambda$0(FileBasedIndexExtension it) {
        return it.dependsOnFileContent() && !Intrinsics.areEqual((Object)it.getName().getName(), (Object)"HashFragmentIndex");
    }

    private static final ID compareIndexes$lambda$1(FileBasedIndexExtension it) {
        return it.getName();
    }

    private static final boolean compareIndexes$lambda$3(ConcurrentTasksProgressManager $comparisonTaskProgressManager, AtomicInteger $finishedCounter, List $idsToCompare, Map $errorCollectors, CompareIndices this$0, List $resolvedFiles, Path $storedIndexDir, Project $project, ID id) {
        SubTaskProgressIndicator subTaskProgressIndicator = $comparisonTaskProgressManager.createSubTaskIndicator(1);
        Intrinsics.checkNotNullExpressionValue((Object)subTaskProgressIndicator, (String)"createSubTaskIndicator(...)");
        SubTaskProgressIndicator subIndicator = subTaskProgressIndicator;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Map<ID<? extends Object, ? extends Object>, ToDirectoryWritingErrorCollector>)$errorCollectors, (ID<? extends Object, ? extends Object>)id, this$0, (List<FileDescriptor>)$resolvedFiles, $storedIndexDir, subIndicator, $project, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Map<ID<? extends Object, ? extends Object>, ToDirectoryWritingErrorCollector> $errorCollectors;
            final /* synthetic */ ID<? extends Object, ? extends Object> $id;
            final /* synthetic */ CompareIndices this$0;
            final /* synthetic */ List<FileDescriptor> $resolvedFiles;
            final /* synthetic */ Path $storedIndexDir;
            final /* synthetic */ SubTaskProgressIndicator $subIndicator;
            final /* synthetic */ Project $project;
            {
                this.$errorCollectors = $errorCollectors;
                this.$id = $id;
                this.this$0 = $receiver;
                this.$resolvedFiles = $resolvedFiles;
                this.$storedIndexDir = $storedIndexDir;
                this.$subIndicator = $subIndicator;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runBlocking;
                        ResultKt.throwOnFailure((Object)$result);
                        Pair pair = (Pair)ActionsKt.runReadAction(() -> compareIndexes.1.1.invokeSuspend$lambda$0(this.this$0, this.$id, this.$storedIndexDir, (CoroutineScope)$this$runBlocking));
                        FileBasedIndexExtension extension = (FileBasedIndexExtension)pair.component1();
                        Disposable disposable = (Disposable)pair.component2();
                        try {
                            ToDirectoryWritingErrorCollector errorCollector = (ToDirectoryWritingErrorCollector)MapsKt.getValue(this.$errorCollectors, this.$id);
                            CompareIndices.access$compareCurrentAndStoredIndexData(this.this$0, this.$resolvedFiles, extension, this.$storedIndexDir, (ProgressIndicator)this.$subIndicator, errorCollector, this.$project);
                        }
                        catch (Exception e) {
                            CompareIndicesKt.access$getLOG$p().warn("Index comparison for " + this.$id.getName() + " has failed", (Throwable)e);
                        }
                        finally {
                            Object object;
                            Object object2 = $this$runBlocking;
                            try {
                                void $this$invokeSuspend_u24lambda_u241 = object2;
                                boolean bl = false;
                                Disposer.dispose((Disposable)disposable);
                                object = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable bl) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                            }
                            object2 = object;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                            if (throwable != null) {
                                Object it = object = throwable;
                                boolean bl = false;
                                CompareIndicesKt.access$getLOG$p().warn((Throwable)it);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Pair invokeSuspend$lambda$0(CompareIndices this$0, ID $id, Path $storedIndexDir, CoroutineScope $$this$runBlocking) {
                Intrinsics.checkNotNull((Object)$id);
                return CompareIndices.access$findFileBasedIndexExtension(this$0, $id, $storedIndexDir, $$this$runBlocking);
            }
        }), (int)1, null);
        CompareIndicesKt.access$getLOG$p().info("Index comparison has finished for " + $finishedCounter.incrementAndGet() + " / " + $idsToCompare.size());
        return true;
    }

    private static final CharSequence compareIndexes$lambda$6(ID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final CharSequence compareIndexes$lambda$7(ID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final boolean findFileBasedIndexExtension$lambda$0(ID $id, FileBasedIndexExtension ex) {
        return Intrinsics.areEqual((Object)ex.getName(), (Object)$id);
    }

    private static final boolean findFileBasedIndexExtension$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VirtualFile resolveFiles$lambda$1$1(StoredIndexedFileResolver $storedIndexedFileResolver, IndexedFilePath $originalFilePath, Project $project) {
        Intrinsics.checkNotNull((Object)$originalFilePath);
        return $storedIndexedFileResolver.findFileInCurrentProject($originalFilePath, $project);
    }

    private static final boolean resolveFiles$lambda$1(CompareIndices this$0, ErrorCollector $errorCollector, ProgressIndicator $indicator, AtomicInteger $finished, StoredIndexedFileResolver $storedIndexedFileResolver, HashSet $allCurrentFiles, List $fileDescriptors, Project $project, IndexedFilePath originalFilePath) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = this$0.getIgnoredFilesPatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)originalFilePath.getPortableFilePath(), (String)it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        VirtualFile virtualFile = (VirtualFile)$errorCollector.runCatchingError(() -> CompareIndices.resolveFiles$lambda$1$1($storedIndexedFileResolver, originalFilePath, $project));
        if (virtualFile == null) {
            return true;
        }
        VirtualFile currentFile = virtualFile;
        $indicator.setFraction((double)$finished.incrementAndGet() / (double)$storedIndexedFileResolver.getOriginalIndexedFiles().size());
        $indicator.setText2(currentFile.getUrl());
        if ($allCurrentFiles.contains(currentFile)) {
            Intrinsics.checkNotNull((Object)$fileDescriptors);
            Collection collection = $fileDescriptors;
            Intrinsics.checkNotNull((Object)originalFilePath);
            collection.add(new FileDescriptor(originalFilePath, currentFile));
        }
        return true;
    }

    private static final Unit compareCurrentAndStoredIndexData$lambda$0(FileBasedIndexImpl $fileBasedIndex, ID $indexId, Project $project) {
        $fileBasedIndex.ensureUpToDate($indexId, $project, GlobalSearchScope.allScope((Project)$project));
        return Unit.INSTANCE;
    }

    private static final boolean compareInvertedIndexes$lambda$0$0(UpdatableIndex $storedIndex, HashSet $allStoredKeys, Project $project) {
        return $storedIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)$allStoredKeys), GlobalSearchScope.allScope((Project)$project), null);
    }

    private static final boolean compareInvertedIndexes$lambda$1$0(UpdatableIndex $currentIndex, HashSet $allCurrentKeys, Project $project) {
        return $currentIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)$allCurrentKeys), GlobalSearchScope.allScope((Project)$project), null);
    }

    private static final boolean compareInvertedIndexes$lambda$3$0$0(Map $storedFileIdToValue, CompareIndices this$0, ValueContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        $storedFileIdToValue.putAll(this$0.toMap(container));
        return true;
    }

    private static final boolean compareInvertedIndexes$lambda$3$0(UpdatableIndex $storedIndex, Object $storedKey, Map $storedFileIdToValue, CompareIndices this$0) {
        InvertedIndex invertedIndex = (InvertedIndex)$storedIndex;
        Object object = $storedKey;
        Intrinsics.checkNotNull((Object)object);
        return IndexingKt.withDataOf((InvertedIndex)invertedIndex, (Object)object, arg_0 -> CompareIndices.compareInvertedIndexes$lambda$3$0$0($storedFileIdToValue, this$0, arg_0));
    }

    private static final boolean compareInvertedIndexes$lambda$4$0$0(Map $currentFileIdToValue, CompareIndices this$0, ValueContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        $currentFileIdToValue.putAll(this$0.toMap(container));
        return true;
    }

    private static final boolean compareInvertedIndexes$lambda$4$0(UpdatableIndex $currentIndex, Object $storedKey, Map $currentFileIdToValue, CompareIndices this$0) {
        InvertedIndex invertedIndex = (InvertedIndex)$currentIndex;
        Object object = $storedKey;
        Intrinsics.checkNotNull((Object)object);
        return IndexingKt.withDataOf((InvertedIndex)invertedIndex, (Object)object, arg_0 -> CompareIndices.compareInvertedIndexes$lambda$4$0$0($currentFileIdToValue, this$0, arg_0));
    }

    private static final boolean compareInvertedIndexes$lambda$0(UpdatableIndex $storedIndex, HashSet $allStoredKeys, Project $project) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$0$0($storedIndex, $allStoredKeys, $project));
    }

    private static final boolean compareInvertedIndexes$lambda$1(UpdatableIndex $currentIndex, HashSet $allCurrentKeys, Project $project) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$1$0($currentIndex, $allCurrentKeys, $project));
    }

    private static final boolean compareInvertedIndexes$lambda$3(UpdatableIndex $storedIndex, Object $storedKey, Map $storedFileIdToValue, CompareIndices this$0) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$3$0($storedIndex, $storedKey, $storedFileIdToValue, this$0));
    }

    private static final boolean compareInvertedIndexes$lambda$4(UpdatableIndex $currentIndex, Object $storedKey, Map $currentFileIdToValue, CompareIndices this$0) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$4$0($currentIndex, $storedKey, $currentFileIdToValue, this$0));
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkNoKeysAreMissing$lambda$1$0$0(Map $storedFileIdToValue, CompareIndices this$0, Map $originalFileIdToFileDescriptor, ValueContainer container) {
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Map map = this$0.toMap(container);
        Map map2 = $storedFileIdToValue;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            int it = ((Number)entry$iv.getKey()).intValue();
            boolean bl = false;
            if (!$originalFileIdToFileDescriptor.containsKey(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        map2.putAll(result$iv);
        return true;
    }

    private static final boolean checkNoKeysAreMissing$lambda$1$0(UpdatableIndex $storedIndex, Object $missingKey, Map $storedFileIdToValue, CompareIndices this$0, Map $originalFileIdToFileDescriptor) {
        InvertedIndex invertedIndex = (InvertedIndex)$storedIndex;
        Object object = $missingKey;
        Intrinsics.checkNotNull((Object)object);
        return IndexingKt.withDataOf((InvertedIndex)invertedIndex, (Object)object, arg_0 -> CompareIndices.checkNoKeysAreMissing$lambda$1$0$0($storedFileIdToValue, this$0, $originalFileIdToFileDescriptor, arg_0));
    }

    private static final boolean checkNoKeysAreMissing$lambda$1(UpdatableIndex $storedIndex, Object $missingKey, Map $storedFileIdToValue, CompareIndices this$0, Map $originalFileIdToFileDescriptor) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.checkNoKeysAreMissing$lambda$1$0($storedIndex, $missingKey, $storedFileIdToValue, this$0, $originalFileIdToFileDescriptor));
    }

    private static final boolean toMap$lambda$0(HashMap $map, int fileId, Object value) {
        if (value != null) {
            ((Map)$map).put(fileId, value);
        }
        return true;
    }

    private static final boolean toMap$lambda$1(Function2 $tmp0, int p0, Object p1) {
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }

    private static final Map compareFileData$lambda$0$0(UpdatableIndex $storedIndex, FileDescriptor $fileDescriptor) {
        return $storedIndex.getIndexedFileData($fileDescriptor.getOriginalFilePath().getOriginalFileSystemId());
    }

    private static final Map compareFileData$lambda$1$0(UpdatableIndex $currentIndex, FileDescriptor $fileDescriptor) {
        return $currentIndex.getIndexedFileData(FileBasedIndex.getFileId((VirtualFile)$fileDescriptor.getCurrentFile()));
    }

    private static final Map compareFileData$lambda$0(UpdatableIndex $storedIndex, FileDescriptor $fileDescriptor) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.compareFileData$lambda$0$0($storedIndex, $fileDescriptor));
    }

    private static final Map compareFileData$lambda$1(UpdatableIndex $currentIndex, FileDescriptor $fileDescriptor) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.compareFileData$lambda$1$0($currentIndex, $fileDescriptor));
    }

    private static final Unit compareFileData$lambda$2(CompareIndices this$0, FileDescriptor $fileDescriptor, FileBasedIndexExtension $extension, Map $storedData, Map $currentData, Project $project) {
        this$0.assertForwardIndexDataAreTheSameForFile($fileDescriptor, $extension, $storedData, $currentData, $project);
        return Unit.INSTANCE;
    }

    private static final FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor doesFileHaveProvidedIndex$lambda$0(Project $project, FileBasedIndexInfrastructureExtension it) {
        return it.createFileIndexingStatusProcessor($project);
    }

    private static final CharSequence withIndent$lambda$0(String $indent, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $indent + it;
    }

    public static final /* synthetic */ String access$buildFileDataMismatchMessage(CompareIndices $this, String reason, FileBasedIndexExtension extension, FileDescriptor fileDescriptor, Project project) {
        return $this.buildFileDataMismatchMessage(reason, extension, fileDescriptor, project);
    }

    public static final /* synthetic */ String access$withIndent(CompareIndices $this, String $receiver, String indent) {
        return $this.withIndent($receiver, indent);
    }

    public static final /* synthetic */ List access$createAttachmentsForActualFile(CompareIndices $this, FileDescriptor fileDescriptor, String pathPrefix) {
        return $this.createAttachmentsForActualFile(fileDescriptor, pathPrefix);
    }

    public static final /* synthetic */ void access$compareIndexes(CompareIndices $this, Path storedIndexDir, ProgressIndicator indicator, Project project) {
        $this.compareIndexes(storedIndexDir, indicator, project);
    }

    public static final /* synthetic */ void access$compareCurrentAndStoredIndexData(CompareIndices $this, List resolvedFiles, FileBasedIndexExtension extension, Path storedIndexDir, ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        $this.compareCurrentAndStoredIndexData(resolvedFiles, extension, storedIndexDir, indicator, errorCollector, project);
    }

    public static final /* synthetic */ Pair access$findFileBasedIndexExtension(CompareIndices $this, ID id, Path storedIndexDir, CoroutineScope coroutineScope) {
        return $this.findFileBasedIndexExtension(id, storedIndexDir, coroutineScope);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices$FileDescriptor;", "", "originalFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getOriginalFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.performanceTesting"})
    private static final class FileDescriptor {
        @NotNull
        private final IndexedFilePath originalFilePath;
        @NotNull
        private final VirtualFile currentFile;

        public FileDescriptor(@NotNull IndexedFilePath originalFilePath, @NotNull VirtualFile currentFile) {
            Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
            Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
            this.originalFilePath = originalFilePath;
            this.currentFile = currentFile;
        }

        @NotNull
        public final IndexedFilePath getOriginalFilePath() {
            return this.originalFilePath;
        }

        @NotNull
        public final VirtualFile getCurrentFile() {
            return this.currentFile;
        }

        @NotNull
        public final IndexedFilePath component1() {
            return this.originalFilePath;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.currentFile;
        }

        @NotNull
        public final FileDescriptor copy(@NotNull IndexedFilePath originalFilePath, @NotNull VirtualFile currentFile) {
            Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
            Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
            return new FileDescriptor(originalFilePath, currentFile);
        }

        public static /* synthetic */ FileDescriptor copy$default(FileDescriptor fileDescriptor, IndexedFilePath indexedFilePath, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                indexedFilePath = fileDescriptor.originalFilePath;
            }
            if ((n & 2) != 0) {
                virtualFile = fileDescriptor.currentFile;
            }
            return fileDescriptor.copy(indexedFilePath, virtualFile);
        }

        @NotNull
        public String toString() {
            return "FileDescriptor(originalFilePath=" + this.originalFilePath + ", currentFile=" + this.currentFile + ")";
        }

        public int hashCode() {
            int result = this.originalFilePath.hashCode();
            result = result * 31 + this.currentFile.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileDescriptor)) {
                return false;
            }
            FileDescriptor fileDescriptor = (FileDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.originalFilePath, (Object)fileDescriptor.originalFilePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentFile, (Object)fileDescriptor.currentFile);
        }
    }
}

