/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.MeasureVfsMassUpdateCommandKt;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/performancePlugin/commands/MeasureVfsMassUpdateCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createFiles", "extension", "numberOfFiles", "projectPath", "Ljava/nio/file/Path;", "modifyFilesContent", "pathForFiles", "deleteFiles", "path", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nMeasureVfsMassUpdateCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasureVfsMassUpdateCommand.kt\ncom/jetbrains/performancePlugin/commands/MeasureVfsMassUpdateCommand\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,141:1\n27#2:142\n87#2,2:143\n28#2,3:145\n98#2:148\n90#2,6:149\n27#2:155\n87#2,2:156\n28#2,3:158\n98#2:161\n90#2,6:162\n27#2:168\n87#2,2:169\n28#2,3:171\n98#2:174\n90#2,6:175\n*S KotlinDebug\n*F\n+ 1 MeasureVfsMassUpdateCommand.kt\ncom/jetbrains/performancePlugin/commands/MeasureVfsMassUpdateCommand\n*L\n56#1:142\n56#1:143,2\n56#1:145,3\n56#1:148\n56#1:149,6\n63#1:155\n63#1:156,2\n63#1:158,3\n63#1:161\n63#1:162,6\n69#1:168\n69#1:169,2\n69#1:171,3\n69#1:174\n69#1:175,6\n*E\n"})
public final class MeasureVfsMassUpdateCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%measureVfsMassUpdate";

    public MeasureVfsMassUpdateCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String string = context.getProject().getBasePath();
        Intrinsics.checkNotNull((Object)string);
        Path path = Paths.get(string + "/src", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path pathForFiles = path;
        String[] stringArray = new String[]{" "};
        List arguments = StringsKt.split$default((CharSequence)this.extractCommandArgument(PREFIX), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposer = disposable;
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("The action should be either CREATE or MODIFY or DELETE or REFRESH");
        }
        switch ((String)arguments.get(0)) {
            case "CREATE": {
                if (arguments.size() < 3) {
                    throw new IllegalArgumentException("CREATE takes two parameters, a file extension and a number of files");
                }
                String extension = (String)arguments.get(1);
                Integer n = StringsKt.toIntOrNull((String)((String)arguments.get(2)));
                if (n == null) {
                    throw new IllegalArgumentException("Third parameter must be a valid number");
                }
                int numberOfFiles = n;
                SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder("massCreateFiles");
                Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
                SpanBuilder $this$use$iv = spanBuilder;
                boolean $i$f$use = false;
                Span span = $this$use$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
                Span $this$useWithoutActiveScope$iv$iv = span;
                boolean $i$f$useWithoutActiveScope = false;
                try {
                    Scope it$iv;
                    Span span$iv = $this$useWithoutActiveScope$iv$iv;
                    boolean bl = false;
                    AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                    Throwable throwable = null;
                    try {
                        it$iv = (Scope)autoCloseable;
                        boolean bl2 = false;
                        Span it = span$iv;
                        boolean bl3 = false;
                        this.createFiles(extension, numberOfFiles, pathForFiles);
                        it$iv = Unit.INSTANCE;
                    }
                    catch (Throwable bl2) {
                        throwable = bl2;
                        throw bl2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    Scope scope = it$iv;
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
                return Unit.INSTANCE;
            }
            case "MODIFY": {
                MeasureVfsMassUpdateCommandKt.access$ensureCreateHasBeenRun(pathForFiles);
                SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder("massModifyFiles");
                Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
                SpanBuilder $this$use$iv = spanBuilder;
                boolean $i$f$use = false;
                Span span = $this$use$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
                Span $this$useWithoutActiveScope$iv$iv = span;
                boolean $i$f$useWithoutActiveScope = false;
                try {
                    Scope it$iv;
                    Span span$iv = $this$useWithoutActiveScope$iv$iv;
                    boolean bl = false;
                    AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                    Throwable throwable = null;
                    try {
                        it$iv = (Scope)autoCloseable;
                        boolean bl4 = false;
                        Span it = span$iv;
                        boolean bl5 = false;
                        this.modifyFilesContent(pathForFiles);
                        it$iv = Unit.INSTANCE;
                    }
                    catch (Throwable bl4) {
                        throwable = bl4;
                        throw bl4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    Scope scope = it$iv;
                    break;
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
            }
            case "DELETE": {
                MeasureVfsMassUpdateCommandKt.access$ensureCreateHasBeenRun(pathForFiles);
                SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder("massDeleteFiles");
                Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
                SpanBuilder $this$use$iv = spanBuilder;
                boolean $i$f$use = false;
                Span span = $this$use$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
                Span $this$useWithoutActiveScope$iv$iv = span;
                boolean $i$f$useWithoutActiveScope = false;
                try {
                    Unit unit;
                    Span span$iv = $this$useWithoutActiveScope$iv$iv;
                    boolean bl = false;
                    AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                    Throwable throwable = null;
                    try {
                        Scope it$iv = (Scope)autoCloseable;
                        boolean bl6 = false;
                        Span it = span$iv;
                        boolean bl7 = false;
                        this.deleteFiles(pathForFiles);
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    Unit unit2 = unit;
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
                return Unit.INSTANCE;
            }
            case "REFRESH": {
                if (arguments.size() < 2) {
                    throw new IllegalArgumentException("REFRESH takes MassVfsRefreshSpan.spanName as a parameter");
                }
                Span span = PerformanceTestSpan.TRACER.spanBuilder((String)arguments.get(1)).startSpan();
                Mutex mutex = MutexKt.Mutex((boolean)true);
                VirtualFileManager.getInstance().addAsyncFileListener(arg_0 -> MeasureVfsMassUpdateCommand.doExecute$lambda$3(span, mutex, disposer, arg_0), disposer);
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                Object object = Mutex.DefaultImpls.lock$default((Mutex)mutex, null, $completion, (int)1, null);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            default: {
                throw new IllegalArgumentException("The action should be either CREATE or MODIFY or DELETE or REFRESH");
            }
        }
        return Unit.INSTANCE;
    }

    private final void createFiles(String extension, int numberOfFiles, Path projectPath) {
        int filesPerFolder = 1000;
        int foldersPerParent = 100;
        for (int i = 0; i < numberOfFiles; ++i) {
            int currentFolderNum = i / filesPerFolder % foldersPerParent;
            int parentFolderNum = i / (filesPerFolder * foldersPerParent);
            String classSuffix = StringsKt.padStart((String)String.valueOf(i), (int)String.valueOf(numberOfFiles).length(), (char)'0');
            Path folderPath = projectPath.resolve("TempFolderParent" + parentFolderNum).resolve("TempFolderChild" + currentFolderNum);
            Files.createDirectories(folderPath, new FileAttribute[0]);
            Intrinsics.checkNotNull((Object)folderPath);
            Path path = folderPath.resolve("TempClass" + classSuffix + "." + extension);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            PathsKt.writeText$default((Path)path, (CharSequence)("class TempClass" + classSuffix + " {}\n"), null, (OpenOption[])openOptionArray, (int)2, null);
        }
    }

    private final void modifyFilesContent(Path pathForFiles) {
        Files.walk(pathForFiles, new FileVisitOption[0]).filter(arg_0 -> MeasureVfsMassUpdateCommand.modifyFilesContent$lambda$1(MeasureVfsMassUpdateCommand::modifyFilesContent$lambda$0, arg_0)).forEach(arg_0 -> MeasureVfsMassUpdateCommand.modifyFilesContent$lambda$3(MeasureVfsMassUpdateCommand::modifyFilesContent$lambda$2, arg_0));
    }

    private final void deleteFiles(Path path) {
        Files.list(path).filter(arg_0 -> MeasureVfsMassUpdateCommand.deleteFiles$lambda$1(MeasureVfsMassUpdateCommand::deleteFiles$lambda$0, arg_0)).forEach(arg_0 -> MeasureVfsMassUpdateCommand.deleteFiles$lambda$3(MeasureVfsMassUpdateCommand::deleteFiles$lambda$2, arg_0));
    }

    private static final AsyncFileListener.ChangeApplier doExecute$lambda$3(Span $span, Mutex $mutex, Disposable $disposer, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        return new AsyncFileListener.ChangeApplier($span, $mutex, $disposer){
            final /* synthetic */ Span $span;
            final /* synthetic */ Mutex $mutex;
            final /* synthetic */ Disposable $disposer;
            {
                this.$span = $span;
                this.$mutex = $mutex;
                this.$disposer = $disposer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterVfsChange() {
                try {
                    this.$span.end();
                    Mutex.DefaultImpls.unlock$default((Mutex)this.$mutex, null, (int)1, null);
                }
                finally {
                    Disposer.dispose((Disposable)this.$disposer);
                }
            }
        };
    }

    private static final boolean modifyFilesContent$lambda$0(Path it) {
        return !Files.isDirectory(it, new LinkOption[0]) && StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"TempClass", (boolean)false, (int)2, null);
    }

    private static final boolean modifyFilesContent$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit modifyFilesContent$lambda$2(Path file) {
        Intrinsics.checkNotNull((Object)file);
        PathsKt.appendText$default((Path)file, (CharSequence)"\n// Modified", null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void modifyFilesContent$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean deleteFiles$lambda$0(Path it) {
        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"TempFolder", (boolean)false, (int)2, null);
    }

    private static final boolean deleteFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit deleteFiles$lambda$2(Path it) {
        FileUtil.delete((Path)it);
        return Unit.INSTANCE;
    }

    private static final void deleteFiles$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/MeasureVfsMassUpdateCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

