/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.FileIconUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.BitUtil;
import com.intellij.util.PsiIconUtil;
import com.intellij.util.ui.EDT;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    private static boolean forceDeferredIconsInTests = false;
    public static final int FLAGS_LOCKED = 2048;
    private static final Function1<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        PsiElement element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        LastComputedIconCache.put((UserDataHolder)element, (Icon)icon, (int)((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = NotNullLazyValue.createValue(() -> {
        IconManager iconManager = IconManager.getInstance();
        return iconManager.createEmptyIcon(iconManager.getPlatformIcon(PlatformIcons.Public));
    });

    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)this;
        if (!psiElement.isValid()) {
            return null;
        }
        if (ElementBase.shouldDeferIcon()) {
            Icon baseIcon = LastComputedIconCache.get((UserDataHolder)psiElement, (int)flags);
            if (baseIcon == null) {
                baseIcon = (Icon)AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            if (baseIcon == null) {
                return null;
            }
            ElementIconRequest param = (ElementIconRequest)ReadAction.compute(() -> new ElementIconRequest(psiElement, psiElement.getProject(), flags));
            return IconManager.getInstance().createDeferredIcon(baseIcon, (Object)param, ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    private static boolean shouldDeferIcon() {
        if (!Registry.is((String)"psi.deferIconLoading", (boolean)true)) {
            return false;
        }
        if (EDT.isCurrentThreadEdt()) {
            return true;
        }
        return !ApplicationManager.getApplication().isUnitTestMode() || forceDeferredIconsInTests;
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return (Icon)AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if (!(element instanceof ElementBase)) {
            throw new AssertionError((Object)(element.getClass().getName() + " is not ElementBase"));
        }
        Icon icon = PsiIconUtil.getIconFromProviders((PsiElement)element, (int)flags);
        if (element instanceof PsiFileSystemItem) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file != null && icon == null) {
                icon = FileIconUtil.INSTANCE.getIconFromProviders(file, flags, element.getProject());
            }
            if (file != null && icon != null) {
                icon = FileIconUtil.INSTANCE.patchIconByIconPatchers(icon, file, flags, element.getProject());
            }
            if (icon instanceof RowIcon) {
                return icon;
            }
            if (icon != null) {
                return IconManager.getInstance().createLayeredIcon((Iconable)element, icon, flags);
            }
            return ((ElementBase)element).getElementIcon(flags);
        }
        if (icon == null) {
            return ((ElementBase)element).getElementIcon(flags);
        }
        if (icon instanceof RowIcon) {
            return icon;
        }
        return IconManager.getInstance().createLayeredIcon((Iconable)element, icon, flags);
    }

    @Nullable
    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file;
        Icon baseIcon;
        Icon icon = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (baseIcon != null && this instanceof PsiElement && (file = ((PsiElement)this).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon((Iconable)file, baseIcon, flags);
        }
        return baseIcon;
    }

    @Nullable
    protected Icon getBaseIcon() {
        PsiFile file;
        if (this instanceof PsiElement && (file = ((PsiElement)this).getContainingFile()) != null && !ElementBase.isNativeFileType(file.getFileType())) {
            try {
                return file.getFileType().getIcon();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.NodePlaceholder);
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(@Nullable Icon icon, @Iconable.IconFlags int flags) {
        if (icon != null && BitUtil.isSet((int)flags, (int)1)) {
            return IconManager.getInstance().createRowIcon(new Icon[]{icon, (Icon)VISIBILITY_ICON_PLACEHOLDER.getValue()});
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(new Icon[]{baseIcon, visibilityIcon});
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet((int)flags, (int)1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element = (PsiElement)this;
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet((int)flags, (int)2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element instanceof ItemPresentation && (baseIcon = ((ItemPresentation)element).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon((Iconable)this, baseIcon, elementFlags);
        }
        if (element instanceof PsiFileSystemItem) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            Icon baseIcon2 = null;
            if (file == null && element instanceof PsiFile) {
                baseIcon2 = ((PsiFile)element).getFileType().getIcon();
            } else if (file != null) {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    baseIcon2 = ((CoreAwareIconManager)iconManager).getIcon(file, flags & 0xFFFFFFFD, element.getProject());
                } else {
                    Icon icon = baseIcon2 = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
                }
            }
            if (baseIcon2 == null) {
                return null;
            }
            return IconManager.getInstance().createLayeredIcon((Iconable)this, baseIcon2, elementFlags);
        }
        return null;
    }

    public static int transformFlags(PsiElement element, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear((int)_flags, (int)2);
        boolean bl = isLocked = BitUtil.isSet((int)_flags, (int)2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    @ApiStatus.Internal
    @TestOnly
    public static void withForcedDeferredIcons(@NotNull Runnable runnable) {
        if (runnable == null) {
            ElementBase.$$$reportNull$$$0(3);
        }
        forceDeferredIconsInTests = true;
        try {
            runnable.run();
        }
        finally {
            forceDeferredIconsInTests = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withForcedDeferredIcons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer == request.myPointer;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.myPointer);
            result = 31 * result + this.myFlags;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

