/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.AttachmentHandlerKt;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.OldAttachmentPruner;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.io.Sanitize_nameKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u0004\u0018\u00010\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J3\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010$\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016J\u001e\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190)H\u0002J+\u0010*\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020-H\u0002R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/openapi/diagnostic/AttachmentHandler;", "Ljava/util/logging/Handler;", "logPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "baseDir", "kotlin.jvm.PlatformType", "pruner", "Lcom/intellij/openapi/diagnostic/OldAttachmentPruner;", "publish", "", "record", "Ljava/util/logging/LogRecord;", "writeEwas", "ewas", "", "Lcom/intellij/openapi/diagnostic/ExceptionWithAttachments;", "t", "", "writeSingleEwa", "ewa", "writeEwa", "attachmentsDir", "prefix", "", "attachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/diagnostic/ExceptionWithAttachments;Ljava/lang/String;[Lcom/intellij/openapi/diagnostic/Attachment;)V", "writeIndexedEwaStacktrace", "dir", "prepareDir", "prepareDirName", "writeStacktrace", "stacktraceFile", "flush", "close", "uniqueName", "base", "used", "", "writeAttachments", "(Ljava/nio/file/Path;[Lcom/intellij/openapi/diagnostic/Attachment;Ljava/lang/String;)V", "inferErrorAbbreviation", "", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nAttachmentHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentHandler.kt\ncom/intellij/openapi/diagnostic/AttachmentHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1#2:280\n777#3:281\n873#3,2:282\n*S KotlinDebug\n*F\n+ 1 AttachmentHandler.kt\ncom/intellij/openapi/diagnostic/AttachmentHandler\n*L\n203#1:281\n203#1:282,2\n*E\n"})
public final class AttachmentHandler
extends Handler {
    private final Path baseDir;
    @NotNull
    private final OldAttachmentPruner pruner;

    public AttachmentHandler(@NotNull Path logPath) {
        Intrinsics.checkNotNullParameter(logPath, "logPath");
        Path path = this.baseDir = logPath.getParent().resolve("attachments");
        Intrinsics.checkNotNullExpressionValue(path, "baseDir");
        this.pruner = new OldAttachmentPruner(path);
    }

    @Override
    public void publish(@NotNull LogRecord record) {
        Path dirWithLoggedAttachments;
        Path path;
        Intrinsics.checkNotNullParameter(record, "record");
        if (!this.isLoggable(record)) {
            return;
        }
        Throwable throwable = record.getThrown();
        if (throwable == null) {
            return;
        }
        Throwable t = throwable;
        Collection collection = ExceptionUtil.findCauseAndSuppressed(t, ExceptionWithAttachments.class);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNullExpressionValue(collection2, "ifEmpty(...)");
        List ewas = (List)collection2;
        if (Intrinsics.areEqual(CollectionsKt.singleOrNull(ewas), t)) {
            Object t2 = CollectionsKt.single(ewas);
            Intrinsics.checkNotNullExpressionValue(t2, "single(...)");
            path = this.writeSingleEwa((ExceptionWithAttachments)t2, t);
        } else {
            path = dirWithLoggedAttachments = this.writeEwas(ewas, t);
        }
        if (dirWithLoggedAttachments != null) {
            AttachmentHandlerKt.access$getLog$p().info("Saving attachments of [" + record.getLoggerName() + "] " + t.getClass().getName() + " to " + dirWithLoggedAttachments);
        }
    }

    private final Path writeEwas(List<ExceptionWithAttachments> ewas, Throwable t) {
        Path path = this.prepareDir(t);
        if (path == null) {
            return null;
        }
        Path attachmentsDir = path;
        int index = 1;
        for (ExceptionWithAttachments ewa : ewas) {
            Attachment[] attachmentArray = ewa.getAttachments();
            if (attachmentArray.length == 0) {
                boolean bl = false;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(attachmentArray, "ifEmpty(...)");
            Attachment[] attachments = attachmentArray;
            this.writeEwa(attachmentsDir, ewa, "" + index + '-', attachments);
            ++index;
        }
        if (index == 1) {
            try {
                Files.deleteIfExists(attachmentsDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        Path path2 = attachmentsDir.resolve("stacktrace.txt");
        Intrinsics.checkNotNullExpressionValue(path2, "resolve(...)");
        this.writeStacktrace(path2, t);
        return attachmentsDir;
    }

    private final Path writeSingleEwa(ExceptionWithAttachments ewa, Throwable t) {
        Attachment[] attachmentArray = ewa.getAttachments();
        if (attachmentArray.length == 0) {
            boolean bl = false;
            return null;
        }
        Intrinsics.checkNotNullExpressionValue(attachmentArray, "ifEmpty(...)");
        Attachment[] attachments = attachmentArray;
        Path path = this.prepareDir(t);
        if (path == null) {
            return null;
        }
        Path attachmentsDir = path;
        this.writeEwa(attachmentsDir, ewa, "", attachments);
        return attachmentsDir;
    }

    private final void writeEwa(Path attachmentsDir, ExceptionWithAttachments ewa, String prefix, Attachment[] attachments) {
        this.writeIndexedEwaStacktrace(attachmentsDir, ewa, prefix);
        this.writeAttachments(attachmentsDir, attachments, prefix);
    }

    private final void writeIndexedEwaStacktrace(Path dir, ExceptionWithAttachments ewa, String prefix) {
        if (ewa instanceof Throwable) {
            Path stacktraceFile = dir.resolve(prefix + "stacktrace.txt");
            Intrinsics.checkNotNull(stacktraceFile);
            this.writeStacktrace(stacktraceFile, (Throwable)((Object)ewa));
        } else {
            try {
                Path path = dir.resolve(prefix + "ewa.txt");
                Object object = ewa.toString();
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                object = Files.write(path, byArray, new OpenOption[0]);
            }
            catch (IOException iOException) {
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final Path prepareDir(Throwable t) {
        String dirName = this.prepareDirName(t);
        Path attachmentsDir = this.baseDir.resolve(dirName);
        try {
            Files.createDirectories(this.baseDir, new FileAttribute[0]);
            this.pruner.pruneOldAttachmentGroups();
            Files.createDirectories(attachmentsDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            return null;
        }
        return attachmentsDir;
    }

    private final String prepareDirName(Throwable t) {
        ZonedDateTime now = ZonedDateTime.now();
        String errorAbbr = this.inferErrorAbbreviation(t);
        return "attachments-" + AttachmentHandlerKt.access$getDateFormat$p().format(now) + '-' + errorAbbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeStacktrace(Path stacktraceFile, Throwable t) {
        try {
            Closeable closeable = new PrintWriter(Files.newBufferedWriter(stacktraceFile, new OpenOption[0]));
            Throwable throwable = null;
            try {
                PrintWriter it = (PrintWriter)closeable;
                boolean bl = false;
                t.printStackTrace(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private final String uniqueName(String base, Set<String> used) {
        CharSequence charSequence;
        CharSequence charSequence2 = base;
        if (StringsKt.isBlank(charSequence2)) {
            boolean bl = false;
            charSequence = "attachment";
        } else {
            charSequence = charSequence2;
        }
        String name = (String)charSequence;
        if (used.add(name)) {
            return name;
        }
        int i = 1;
        String candidate;
        while (!used.add(candidate = name + '.' + i)) {
            ++i;
        }
        return candidate;
    }

    private final void writeAttachments(Path dir, Attachment[] attachments, String prefix) {
        HashSet usedNames = new HashSet();
        for (Attachment attachment : attachments) {
            CharSequence charSequence;
            if (attachment == null) continue;
            CharSequence charSequence2 = attachment.getName();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = "attachment";
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNullExpressionValue(charSequence, "ifEmpty(...)");
            String base = Sanitize_nameKt.sanitizeFileName$default((String)charSequence, null, false, null, 14, null);
            String fileName = this.uniqueName(prefix + base, usedNames);
            Path file = dir.resolve(fileName);
            try {
                Files.write(file, attachment.getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String inferErrorAbbreviation(Object t) {
        CharSequence charSequence;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        CharSequence charSequence2;
        CharSequence charSequence3;
        String string = t.getClass().getSimpleName();
        if (string == null) {
            string = "";
        }
        if (StringsKt.isBlank(charSequence3 = (CharSequence)string)) {
            boolean bl = false;
            charSequence2 = "error";
        } else {
            charSequence2 = charSequence3;
        }
        String simple = (String)charSequence2;
        if (simple.length() <= 3) {
            return StringsKt.take(Sanitize_nameKt.sanitizeFileName$default(simple, null, false, null, 14, null), 48);
        }
        boolean endsWithException = StringsKt.endsWith$default(simple, "Exception", false, 2, null);
        boolean endsWithError = StringsKt.endsWith$default(simple, "Error", false, 2, null);
        String core = endsWithException ? StringsKt.removeSuffix(simple, (CharSequence)"Exception") : (endsWithError ? StringsKt.removeSuffix(simple, (CharSequence)"Error") : simple);
        Object object = core;
        Regex regex = AttachmentHandlerKt.access$getUppercaseMatcher$p();
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        CharSequence charSequence4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parts2 = (List)destination$iv$iv;
        String acronym = !((Collection)parts2).isEmpty() ? CollectionsKt.joinToString$default(parts2, "", null, null, 0, null, AttachmentHandler::inferErrorAbbreviation$lambda$2, 30, null) : simple;
        String withSuffix = endsWithException ? acronym + 'E' : (endsWithError ? acronym + 'E' : acronym);
        charSequence4 = withSuffix;
        if (StringsKt.isBlank(charSequence4)) {
            boolean bl = false;
            charSequence = simple;
        } else {
            charSequence = charSequence4;
        }
        return StringsKt.take(Sanitize_nameKt.sanitizeFileName$default((String)charSequence, null, false, null, 14, null), 48);
    }

    private static final CharSequence inferErrorAbbreviation$lambda$2(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = String.valueOf(it.charAt(0));
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        return string2;
    }
}

