/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HtmlChunk {
    @Contract(pure=true)
    @Nullable
    public Icon findIcon(@NotNull @NonNls String id) {
        if (id == null) {
            HtmlChunk.$$$reportNull$$$0(0);
        }
        return null;
    }

    @ApiStatus.Experimental
    @Contract(pure=true)
    @NotNull
    public HtmlChunk applyStyles(@NotNull @NotNull Map<@NotNull @NonNls String, @NotNull String> styles) {
        if (styles == null) {
            HtmlChunk.$$$reportNull$$$0(1);
        }
        HtmlChunk htmlChunk = this;
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(2);
        }
        return htmlChunk;
    }

    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(3);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.singletonList(this));
    }

    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull Element element) {
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(4);
        }
        Element element2 = element.child(this);
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(5);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public Element code() {
        Element element = this.wrapWith("code");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(6);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public Element bold() {
        Element element = this.wrapWith("b");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(7);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public Element italic() {
        Element element = this.wrapWith("i");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(8);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public Element strikethrough() {
        Element element = this.wrapWith("s");
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(9);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element tag(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(10);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public static Element icon(@NotNull @NonNls String id, @NotNull Icon icon) {
        if (id == null) {
            HtmlChunk.$$$reportNull$$$0(11);
        }
        if (icon == null) {
            HtmlChunk.$$$reportNull$$$0(12);
        }
        return new IconElement(id, icon);
    }

    @Contract(pure=true)
    @NotNull
    public static Element div() {
        Element element = Element.DIV;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(13);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element div(@NotNull @NonNls String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(14);
        }
        Element element = Element.DIV.style(style);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(15);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span() {
        Element element = Element.SPAN;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(16);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span(@NonNls @NotNull String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(17);
        }
        Element element = Element.SPAN.style(style);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(18);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element br() {
        Element element = Element.BR;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(19);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element li() {
        Element element = Element.LI;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(20);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element ul() {
        Element element = Element.UL;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(21);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element hr() {
        Element element = Element.HR;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(22);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element p() {
        Element element = Element.P;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(23);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element head() {
        Element element = Element.HEAD;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(24);
        }
        return element;
    }

    @NotNull
    public static Element styleTag(@NonNls @NotNull String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(25);
        }
        Element element = HtmlChunk.tag("style").addRaw(style);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(26);
        }
        return element;
    }

    @NotNull
    public static Element font(@NonNls @NotNull String color) {
        if (color == null) {
            HtmlChunk.$$$reportNull$$$0(27);
        }
        Element element = HtmlChunk.tag("font").attr("color", color);
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(28);
        }
        return element;
    }

    @NotNull
    public static Element font(int size) {
        Element element = HtmlChunk.tag("font").attr("size", String.valueOf(size));
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(29);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element body() {
        Element element = Element.BODY;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(30);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static Element html() {
        Element element = Element.HTML;
        if (element == null) {
            HtmlChunk.$$$reportNull$$$0(31);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp() {
        HtmlChunk htmlChunk = Nbsp.ONE;
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(32);
        }
        return htmlChunk;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        return new Nbsp(count);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk text(@NotNull @Nls String text) {
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(33);
        }
        return text.isEmpty() ? HtmlChunk.empty() : new Text(text);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk empty() {
        Empty empty = Empty.INSTANCE;
        if (empty == null) {
            HtmlChunk.$$$reportNull$$$0(34);
        }
        return empty;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static HtmlChunk template(@NotNull @Nls String template, Map.Entry<String, HtmlChunk> ... substitutions) {
        String[] parts2;
        if (template == null) {
            HtmlChunk.$$$reportNull$$$0(35);
        }
        if ((parts2 = template.split("\\$", -1)).length % 2 != 1) {
            throw new IllegalArgumentException("Invalid template (must have even number of '$' characters): " + template);
        }
        HtmlBuilder builder = new HtmlBuilder();
        Map<String, HtmlChunk> chunkMap = Stream.of(substitutions).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (int i = 0; i < parts2.length; ++i) {
            String part = parts2[i];
            if (i % 2 == 0) {
                builder.append(part);
                continue;
            }
            if (part.isEmpty()) {
                builder.append("$");
                continue;
            }
            builder.append(Objects.requireNonNull(chunkMap.get(part), part));
        }
        HtmlChunk htmlChunk = builder.toFragment();
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(36);
        }
        return htmlChunk;
    }

    @NotNull
    public static HtmlChunk template(@NotNull @Nls String template, @NotNull @NonNls String variable, @NotNull HtmlChunk substitution) {
        if (template == null) {
            HtmlChunk.$$$reportNull$$$0(37);
        }
        if (variable == null) {
            HtmlChunk.$$$reportNull$$$0(38);
        }
        if (substitution == null) {
            HtmlChunk.$$$reportNull$$$0(39);
        }
        return HtmlChunk.template(template, new AbstractMap.SimpleImmutableEntry<String, HtmlChunk>(variable, substitution));
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk raw(@NotNull @Nls String rawHtml) {
        if (rawHtml == null) {
            HtmlChunk.$$$reportNull$$$0(40);
        }
        return rawHtml.isEmpty() ? HtmlChunk.empty() : new Raw(rawHtml);
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull @Nls String text) {
        if (target == null) {
            HtmlChunk.$$$reportNull$$$0(41);
        }
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(42);
        }
        return HtmlChunk.link(target, HtmlChunk.text(text));
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull HtmlChunk text) {
        if (target == null) {
            HtmlChunk.$$$reportNull$$$0(43);
        }
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(44);
        }
        return new Element("a", UnmodifiableHashMap.empty().with("href", target), Collections.singletonList(text));
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk htmlEntity(@NotNull @NlsSafe String htmlEntity) {
        if (htmlEntity == null) {
            HtmlChunk.$$$reportNull$$$0(45);
        }
        if (!htmlEntity.startsWith("&") && !htmlEntity.endsWith(";")) {
            throw new IllegalArgumentException("Not an entity: " + htmlEntity);
        }
        return HtmlChunk.raw(htmlEntity);
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return false;
    }

    public abstract void appendTo(@NotNull StringBuilder var1);

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        String string = builder.toString();
        if (string == null) {
            HtmlChunk.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk fragment(HtmlChunk ... chunks) {
        if (chunks == null) {
            HtmlChunk.$$$reportNull$$$0(47);
        }
        if (chunks.length == 0) {
            return HtmlChunk.empty();
        }
        HtmlChunk htmlChunk = Arrays.stream(chunks).collect(HtmlChunk.toFragment());
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(48);
        }
        return htmlChunk;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment() {
        Collector<HtmlChunk, HtmlBuilder, HtmlChunk> collector = Collector.of(HtmlBuilder::new, HtmlBuilder::append, HtmlBuilder::append, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
        if (collector == null) {
            HtmlChunk.$$$reportNull$$$0(49);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment(HtmlChunk separator) {
        Collector<HtmlChunk, HtmlBuilder, HtmlChunk> collector = Collector.of(HtmlBuilder::new, (hb, c) -> {
            if (!hb.isEmpty()) {
                hb.append(separator);
            }
            hb.append((HtmlChunk)c);
        }, (hb1, hb2) -> {
            if (!hb1.isEmpty()) {
                hb1.append(separator);
            }
            return hb1.append((HtmlBuilder)hb2);
        }, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
        if (collector == null) {
            HtmlChunk.$$$reportNull$$$0(50);
        }
        return collector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styles";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 14: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 33: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawHtml";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlEntity";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applyStyles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWith";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "code";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "bold";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "italic";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "strikethrough";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "span";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "br";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "li";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "ul";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "hr";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "p";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "head";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "styleTag";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "font";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "body";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "nbsp";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "template";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "fragment";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "toFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyStyles";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapWith";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tag";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "icon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "span";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "styleTag";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "font";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "template";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "raw";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "link";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "htmlEntity";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "fragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Element
    extends HtmlChunk {
        private static final Element HEAD = Element.tag("head");
        private static final Element BODY = Element.tag("body");
        private static final Element HTML = Element.tag("html");
        private static final Element BR = Element.tag("br");
        private static final Element UL = Element.tag("ul");
        private static final Element LI = Element.tag("li");
        private static final Element HR = Element.tag("hr");
        private static final Element P = Element.tag("p");
        private static final Element DIV = Element.tag("div");
        private static final Element SPAN = Element.tag("span");
        private final String myTagName;
        private final UnmodifiableHashMap<String, String> myAttributes;
        private final List<HtmlChunk> myChildren;

        private Element(String name, UnmodifiableHashMap<String, String> attributes, List<HtmlChunk> children) {
            this.myTagName = name;
            this.myAttributes = attributes;
            this.myChildren = children;
        }

        @Override
        @NotNull
        public HtmlChunk applyStyles(@NotNull @NotNull Map<@NotNull @NonNls String, @NotNull String> styles) {
            String style;
            if (styles == null) {
                Element.$$$reportNull$$$0(0);
            }
            String myClass = this.myAttributes.get("class");
            UnmodifiableHashMap<String, String> newAttributes = this.myAttributes;
            if (myClass != null && (style = styles.get(myClass)) != null) {
                String existingStyle = (newAttributes = newAttributes.without("class")).get("style");
                if (existingStyle != null) {
                    style = existingStyle.endsWith(";") ? existingStyle + " " + style : existingStyle + "; " + style;
                }
                newAttributes = newAttributes.with("style", style);
            }
            ArrayList<HtmlChunk> newChildren = null;
            for (HtmlChunk child : this.myChildren) {
                HtmlChunk updated = child.applyStyles(styles);
                if (updated == child) continue;
                if (newChildren == null) {
                    newChildren = new ArrayList<HtmlChunk>(this.myChildren);
                }
                newChildren.set(newChildren.indexOf(child), updated);
            }
            if (newChildren != null) {
                return new Element(this.myTagName, newAttributes, newChildren);
            }
            return newAttributes == this.myAttributes ? this : new Element(this.myTagName, newAttributes, this.myChildren);
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Element.$$$reportNull$$$0(1);
            }
            builder.append('<').append(this.myTagName);
            this.myAttributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                builder.append(' ').append((String)entry.getKey());
                if (entry.getValue() != null) {
                    builder.append("=\"").append(StringUtil.escapeXmlEntities((String)entry.getValue())).append('\"');
                }
            });
            if (this.myChildren.isEmpty()) {
                builder.append("/>");
            } else {
                builder.append(">");
                for (HtmlChunk child : this.myChildren) {
                    child.appendTo(builder);
                }
                builder.append("</").append(this.myTagName).append(">");
            }
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name, @NotNull String value) {
            if (value == null) {
                Element.$$$reportNull$$$0(2);
            }
            return new Element(this.myTagName, this.myAttributes.with(name, value), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name, int value) {
            return new Element(this.myTagName, this.myAttributes.with(name, Integer.toString(value)), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name) {
            return new Element(this.myTagName, this.myAttributes.with(name, null), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element style(@NonNls String style) {
            Element element = this.attr("style", style);
            if (element == null) {
                Element.$$$reportNull$$$0(3);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element setClass(@NonNls String className) {
            Element element = this.attr("class", className);
            if (element == null) {
                Element.$$$reportNull$$$0(4);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element addText(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(5);
            }
            Element element = this.child(Element.text(text));
            if (element == null) {
                Element.$$$reportNull$$$0(6);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element addRaw(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(7);
            }
            Element element = this.child(Element.raw(text));
            if (element == null) {
                Element.$$$reportNull$$$0(8);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element children(HtmlChunk ... chunks) {
            if (chunks == null) {
                Element.$$$reportNull$$$0(9);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Arrays.asList(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.length);
            newChildren.addAll(this.myChildren);
            Collections.addAll(newChildren, chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element children(@NotNull List<? extends HtmlChunk> chunks) {
            if (chunks == null) {
                Element.$$$reportNull$$$0(10);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, new ArrayList<HtmlChunk>(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.size());
            newChildren.addAll(this.myChildren);
            newChildren.addAll(chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element child(@NotNull HtmlChunk chunk) {
            if (chunk == null) {
                Element.$$$reportNull$$$0(11);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Collections.singletonList(chunk));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + 1);
            newChildren.addAll(this.myChildren);
            newChildren.add(chunk);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Override
        @Nullable
        public Icon findIcon(@NotNull String id) {
            if (id == null) {
                Element.$$$reportNull$$$0(12);
            }
            for (HtmlChunk child : this.myChildren) {
                Icon icon = child.findIcon(id);
                if (icon == null) continue;
                return icon;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            return Objects.equals(this.myTagName, element.myTagName) && Objects.equals(this.myAttributes, element.myAttributes) && Objects.equals(this.myChildren, element.myChildren);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.myTagName);
            result = 31 * result + Objects.hashCode(this.myAttributes);
            result = 31 * result + Objects.hashCode(this.myChildren);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "style";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addText";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addRaw";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyStyles";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "attr";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addRaw";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "child";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class IconElement
    extends Element {
        @NotNull
        private final String myId;
        @NotNull
        private final Icon myIcon;

        private IconElement(@NotNull String id, @NotNull Icon icon) {
            if (id == null) {
                IconElement.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                IconElement.$$$reportNull$$$0(1);
            }
            super("icon", UnmodifiableHashMap.empty().with("src", id), Collections.emptyList());
            this.myId = id;
            this.myIcon = icon;
        }

        @Override
        @Nullable
        public Icon findIcon(@NotNull String id) {
            if (id == null) {
                IconElement.$$$reportNull$$$0(2);
            }
            if (id.equals(this.myId)) {
                return this.myIcon;
            }
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IconElement element = (IconElement)o;
            return this.myId.equals(element.myId) && this.myIcon.equals(element.myIcon);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myId.hashCode();
            result = 31 * result + this.myIcon.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk$IconElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Nbsp
    extends HtmlChunk {
        private static final HtmlChunk ONE = new Nbsp(1);
        private final int myCount;

        private Nbsp(int count) {
            this.myCount = count;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Nbsp.$$$reportNull$$$0(0);
            }
            builder.append(StringUtil.repeat("&nbsp;", this.myCount));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Nbsp && this.myCount == ((Nbsp)o).myCount;
        }

        public int hashCode() {
            return this.myCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Nbsp", "appendTo"));
        }
    }

    private static final class Text
    extends HtmlChunk {
        private final String myContent;

        private Text(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Text.$$$reportNull$$$0(0);
            }
            builder.append(StringUtil.escapeXmlEntities(this.myContent).replaceAll("\n", "<br/>"));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Text && Objects.equals(this.myContent, ((Text)o).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Text", "appendTo"));
        }
    }

    private static final class Empty
    extends HtmlChunk {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Empty.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/HtmlChunk$Empty", "appendTo"));
        }
    }

    private static final class Raw
    extends HtmlChunk {
        private static final Pattern CLASS = Pattern.compile("class=([\"'])([A-Za-z\\-_0-9]+)\\1");
        private final String myContent;

        private Raw(String content) {
            this.myContent = content;
        }

        @Override
        @NotNull
        public HtmlChunk applyStyles(@NotNull @NotNull Map<@NotNull @NonNls String, @NotNull String> styles) {
            if (styles == null) {
                Raw.$$$reportNull$$$0(0);
            }
            Matcher matcher = CLASS.matcher(this.myContent);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String style = styles.get(matcher.group(2));
                if (style != null) {
                    matcher.appendReplacement(result, "style=\"" + style + "\"");
                    continue;
                }
                matcher.appendReplacement(result, matcher.group());
            }
            if (result.length() == 0) {
                Raw raw = this;
                if (raw == null) {
                    Raw.$$$reportNull$$$0(1);
                }
                return raw;
            }
            matcher.appendTail(result);
            return new Raw(result.toString());
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Raw.$$$reportNull$$$0(2);
            }
            builder.append(this.myContent);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Raw && Objects.equals(this.myContent, ((Raw)o).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/HtmlChunk$Raw";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk$Raw";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyStyles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyStyles";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class Fragment
    extends HtmlChunk {
        private final List<? extends HtmlChunk> myContent;

        Fragment(List<? extends HtmlChunk> content) {
            this.myContent = content;
        }

        @Override
        @NotNull
        public HtmlChunk applyStyles(@NotNull @NotNull Map<@NotNull @NonNls String, @NotNull String> styles) {
            if (styles == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            ArrayList<? extends HtmlChunk> newChildren = null;
            for (HtmlChunk htmlChunk : this.myContent) {
                HtmlChunk updated = htmlChunk.applyStyles(styles);
                if (updated == htmlChunk) continue;
                if (newChildren == null) {
                    newChildren = new ArrayList<HtmlChunk>(this.myContent);
                }
                newChildren.set(newChildren.indexOf(htmlChunk), updated);
            }
            if (newChildren != null) {
                return new Fragment(newChildren);
            }
            Fragment fragment = this;
            if (fragment == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            return fragment;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Fragment.$$$reportNull$$$0(2);
            }
            for (HtmlChunk htmlChunk : this.myContent) {
                htmlChunk.appendTo(builder);
            }
        }

        @Override
        @Nullable
        public Icon findIcon(@NotNull String id) {
            if (id == null) {
                Fragment.$$$reportNull$$$0(3);
            }
            for (HtmlChunk htmlChunk : this.myContent) {
                Icon icon = htmlChunk.findIcon(id);
                if (icon == null) continue;
                return icon;
            }
            return null;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Fragment && Objects.equals(this.myContent, ((Fragment)o).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/HtmlChunk$Fragment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/HtmlChunk$Fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyStyles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyStyles";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTo";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

