/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public final class HashSetQueue<T>
extends AbstractCollection<T>
implements Queue<T> {
    private final ObjectOpenHashSet<QueueEntry<T>> set = new ObjectOpenHashSet();
    private final QueueEntry<T> TOMB = new QueueEntry<T>(this.cast(new Object()));

    public HashSetQueue() {
        ((QueueEntry)this.TOMB).next = (((QueueEntry)this.TOMB).prev = (QueueEntry)this.TOMB);
    }

    @Override
    public boolean offer(@NotNull T t) {
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(0);
        }
        return this.add(t);
    }

    @Override
    public boolean add(@NotNull T t) {
        QueueEntry<T> newLast;
        boolean added;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(1);
        }
        if (!(added = this.set.add(newLast = new QueueEntry<T>(t)))) {
            return false;
        }
        QueueEntry oldLast = ((QueueEntry)this.TOMB).prev;
        oldLast.next = (QueueEntry)newLast;
        ((QueueEntry)newLast).prev = oldLast;
        ((QueueEntry)newLast).next = (QueueEntry)this.TOMB;
        ((QueueEntry)this.TOMB).prev = (QueueEntry)newLast;
        return true;
    }

    @Override
    @NotNull
    public T remove() {
        T poll = this.poll();
        if (poll == null) {
            throw new NoSuchElementException();
        }
        T t = poll;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(2);
        }
        return t;
    }

    @Override
    public T poll() {
        T peek = this.peek();
        if (peek != null) {
            this.remove(peek);
        }
        return peek;
    }

    @Override
    @NotNull
    public T element() {
        T peek = this.peek();
        if (peek == null) {
            throw new NoSuchElementException();
        }
        T t = peek;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Override
    public T peek() {
        return (T)(((QueueEntry)this.TOMB).next == this.TOMB ? null : ((QueueEntry)this.TOMB).next.t);
    }

    public T find(@NotNull T t) {
        QueueEntry<T> existing;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(4);
        }
        return (T)((existing = this.findEntry(t)) == null ? null : ((QueueEntry)existing).t);
    }

    private QueueEntry<T> findEntry(@NotNull T t) {
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(5);
        }
        return (QueueEntry)this.set.get(new QueueEntry<T>(t));
    }

    @Override
    public boolean remove(Object o) {
        T t = this.cast(o);
        QueueEntry<T> entry = this.findEntry(t);
        if (entry == null) {
            return false;
        }
        QueueEntry prev = ((QueueEntry)entry).prev;
        QueueEntry next = ((QueueEntry)entry).next;
        prev.next = next;
        next.prev = prev;
        this.set.remove(entry);
        return true;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.find(this.cast(o)) != null;
    }

    private T cast(Object o) {
        return (T)o;
    }

    @Override
    @NotNull
    public PositionalIterator<T> iterator() {
        return new PositionalIterator<T>(){
            private QueueEntry<T> cursor;
            private long count;
            {
                this.cursor = HashSetQueue.this.TOMB;
            }

            @Override
            public boolean hasNext() {
                return this.cursor.next != HashSetQueue.this.TOMB;
            }

            @Override
            public T next() {
                this.cursor = this.cursor.next;
                ++this.count;
                return this.cursor.t;
            }

            @Override
            public void remove() {
                if (this.cursor == HashSetQueue.this.TOMB) {
                    throw new NoSuchElementException();
                }
                HashSetQueue.this.remove(this.cursor.t);
            }

            @Override
            @NotNull
            public PositionalIterator.IteratorPosition<T> position() {
                return new MyIteratorPosition(this.cursor, this.count, HashSetQueue.this.TOMB);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/HashSetQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/HashSetQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class QueueEntry<T> {
        @NotNull
        private final T t;
        private QueueEntry<T> next;
        private QueueEntry<T> prev;

        QueueEntry(@NotNull T t) {
            if (t == null) {
                QueueEntry.$$$reportNull$$$0(0);
            }
            this.t = t;
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof QueueEntry && this.t.equals(((QueueEntry)obj).t);
        }

        public String toString() {
            return this.t.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/HashSetQueue$QueueEntry", "<init>"));
        }
    }

    public static interface PositionalIterator<T>
    extends Iterator<T> {
        @NotNull
        public IteratorPosition<T> position();

        public static interface IteratorPosition<T>
        extends Comparable<IteratorPosition<T>> {
            public T peek();

            public IteratorPosition<T> next();
        }
    }

    private static final class MyIteratorPosition<T>
    implements PositionalIterator.IteratorPosition<T> {
        private final QueueEntry<T> cursor;
        private final long count;
        private final QueueEntry<T> TOMB;

        /*
         * WARNING - void declaration
         */
        private MyIteratorPosition(@NotNull QueueEntry<T> cursor, long count, @NotNull QueueEntry<T> queueEntry) {
            void TOMB;
            if (cursor == null) {
                MyIteratorPosition.$$$reportNull$$$0(0);
            }
            if (queueEntry == null) {
                MyIteratorPosition.$$$reportNull$$$0(1);
            }
            this.cursor = cursor;
            this.count = count;
            this.TOMB = TOMB;
        }

        @Override
        public T peek() {
            if (this.cursor == this.TOMB) {
                throw new IllegalStateException("Iterator is before the first element. Must call .next() first.");
            }
            return (T)((QueueEntry)this.cursor).t;
        }

        @Override
        public PositionalIterator.IteratorPosition<T> next() {
            return ((QueueEntry)this.cursor).next == this.TOMB ? null : new MyIteratorPosition<T>(((QueueEntry)this.cursor).next, this.count + 1L, this.TOMB);
        }

        @Override
        public int compareTo(@NotNull PositionalIterator.IteratorPosition<T> o) {
            if (o == null) {
                MyIteratorPosition.$$$reportNull$$$0(2);
            }
            return Long.compare(this.count, ((MyIteratorPosition)o).count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cursor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "TOMB";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/HashSetQueue$MyIteratorPosition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

